 
// File BCPLX_BCPLXHDR
 
// Header file for cross-reference utility for BCPL programs
 
// Adapted from University of Cambridge program
// R.D. Eager UKC  MCMLXXXIV
 
 
GET "LIBHDR"
 
// Parameter decoder error codes
 
MANIFEST $(
par.ok   = 0            // No errors
par.err  = -1           // Format error in parameter string
par.amb  = -2           // Ambiguous keyword
par.unk  = -3           // Unknown keyword
par.xs   = -4           // Too many parameters
par.dup  = -5           // Duplicated parameter
par.mis  = -6           // Missing keyword
$)
 
// AE operators and symbols
 
MANIFEST $(
s.null=0;        s.let=1;         s.proc=2;        s.lab=3
s.global=4;      s.manifest=5;    s.static=6;      s.for=7
s.external=8;    s.be=9;          s.and=10;        s.name=11
s.get=12;        s.string=13;     s.colon=14;      s.lparen=15
s.case=16;       s.end=17;        s.semicol=18;    s.rsect=19
s.eq=20
$)
 
// Tunable MANIFESTs
 
MANIFEST $(
linesize     = 132   // Width of page for output
getsize      =   4   // Number of GET files which may be open at once
fsize        =   8   // Number of words needed to hold a filename
$)
 
GLOBAL $(
 
// Routines and functions
 
nextsymb:100;    rch:101;         rdtag:102;       performget:103
readnumb:104;    ioerror:105;     rdstrch:106;     newvec:107
strtonum:108;    addref:109;      prtree:110;      matchstrings:111
error:112;       match:113;       paramdecode:114; cmpstr:115
 
// Variables
 
warnings_:124
symb:125;        ch:126;          wordv:127;       wordsize:128
charv:129;       ptr:130;         treevec:131;     treep:132
getv:133;        getp:134;        gett:135;        sourcestream:136
linecount:137;   nametree:138;    wordnode:139;    word:140
pattern:141;     fileno:142;      nextfile:143;    matchall_:144
oldtype:145;     nlpending_:146;  all_refs_:147;   getfiles:148
sourceconad:149; source_ptr:150;  getnamev:151;    getfile_max_reached_:152
real_rdch:153;   con_rdch:154;    libuser:155;     errorstream:156
e_wrch:157;      compiler_:158
$)
 
MANIFEST $(   // Subsystem error codes
e.fnf         = 218   // File not found
e.ift         = 267   // Invalid file type
$)
 
// End of file BCPLX_BCPLXHDR
 
