 
// File main.b
 
// Version:  V4.0   (also alter MANIFESTs below)
 
// BCPL compiler - phase 1 - system interface

// Copyright (C) R.D. Eager  University of Kent   MCMLXXXVI
 
// History:
//  V1.0   - Initial version
//  V1.1   - Correction to code for CASE labels, to handle CASE vector
//           overflow correctly.
//         - Correction  to  ADDNAME,  to  handle  name  vector overflow
//           correctly.
//         - Correction  to  DECLSTAT,  to  handle  global  name  vector
//           overflow correctly.
//  V1.2   - Correction to constant folder; function 'type.manifest' had
//           a   missing  '!'  causing  MANIFEST  constants  not  to  be
//           recognised.
//         - Addition to constant folder, to ensure that non-commutative
//           operations     involving     MANIFEST     operands      are
//           folded. Previously, they were not.
//         - Corrections  to  constant  folder  and EVALCONST, to detect
//           division by zero at compile time.
//  V2.0   - Addition of support for Motorola M68000 code generator.
//         - Removal of '*V' escape.
//  V2.1   - Correction  to  code  handling environment strings, to copy
//           strings to separate vectors.
//  V3.0   - 'charcode' reset to 'hostcode' while reading GET strings.
//         - Removal of GOTOs from 'nextsymb'.
//         - Improved code in 'nextsymb' for reading based numbers after
//           '#'.
//         - Correction to string reading code  in  'nextsymb',  to  use
//           'charcode' function for translation.
//         - Removal  of '<>' construction (binding semicolon); not part
//           of BCPL standard.
//         - Modification to 'trans', to generate BLAB OCODE for a  BCPL
//           label;  this  aids  some  code  generators.  New supporting
//           routine 'compblab' also added.
//         - Layout of 'trans' cleaned up  considerably;  GOTOs  removed
//           and RETURNs altered to BREAKs.
//         - 'transdyndefs'   and  'transstatdefs'  modified  to  reduce
//           recursion and thereby reduce usage of stack space and time.
//         - 'evalconst' substantially altered to reduce its size.
//         - 'compentry' altered to use 'charcode' for  procedure  names
//           put into output OCODE.
//         - Improved  code  in  'nextsymb'  for  handling  strings  and
//           character   constants,    including    *Xnn    and    *Onnn
//           constructions.
//         - Revised code in 'nextsymb' for reading comments.
//  V4.0   - Compilation  option  flag  'f'  withdrawn;  this is now the
//           default anyway.
//         - Source code generally tidied up to make it more readable.
//         - Manifest  constants now used for size of items stacked on a
//           GET, and for size of the circular input trace buffer.
//         - Error  messages  renumbered  to  make  them  a  dense,  low
//           numbered set.
//         - Some error messages made more meaningful.
//         - 'performget' renamed to 'pushget'; code in 'nextsymb' which
//           handles  end  of  file  in GET files removed to new routine
//           'popget'.
//         - 'nextsymb' modified to handle comments of the form |*...*|.
//         - Addition of  routine  'rnexp'  to  replace  many  calls  on
//           'nextsymb' and 'rexp'.
//         - 'rexp'  extensively  modified to correct treatment of n-way
//           relationals, and to remove GOTOs.
//         - DEFAULT  labels inside inner blocks now faulted in the same
//           way as CASE labels.
//         - Correction to error reporting of CASE  and  DEFAULT  labels
//           which  are not inside SWITCHONS; previously, the same error
//           was given twice.
//         - Most  recursion  removed  from  'declnames', 'rdblockbody',
//           'decldyn', 'nolabels' and 'scanlabels'.
//         - 'statdefs' routine replaced by a single 'statdefs_' flag.
//         - 'transfor' modified to eliminate redundant forward jump  if
//           the loop is guaranteed to execute at least once.
//         - 'compblab'  renamed  to  'complabx';  's.blab'  renamed  to
//           's.labx'.  's.labx'  now  compiled  for  CASE  and  DEFAULT
//           labels in addition to proper labels.
//         - Addition of 'complabr' routine and 's.labr' OCODE.  This is
//           compiled  for  all  jumps that may be backwards or forwards
//           (apart from 's.labx' labels).  All other labels are  always
//           referenced   forward,   so   codegenerators  may  use  this
//           information to aid optimisation.
//         - Code for IF, UNLESS and TEST improved when  the  controlled
//           statement is a single LOOP, BREAK or ENDCASE.
//           (this code commented out pending improvement to OCODE).
//         - 'checkdistinct'  now called at the end of GLOBAL, EXTERNAL,
//           STATIC and MANIFEST  declarations;  previously,  no  proper
//           check was made for multiple declarations.
//         - 'decllabels'  renamed  to  'transblock',  and  'trans' call
//           incorporated into it.
//         - 's.mark' OCODE introduced; generated instead  of  's.stack'
//           when  reserving  save space before loading parameters for a
//           procedure call.
//         - Addition of 'makelist' function to build variable size tree
//           nodes,  in  order to save space; modification of many other
//           routines to handle this.
//         - Addition of code to drive VAX-11 (VMS) codegenerator, as an
//           option.
//         - Addition  of  'multichar'  routine,  to  simplify   lexical
//           analysis of multi-character symbols.
//         - Addition  of  preset tree nodes 'zeronode' and 'querynode',
//           to save some unnecessary duplication of these heavily  used
//           values.
//         - Change  in  treatment  of 'small' numbers, so that they are
//           represented by themselves in the  tree,  instead  of  by  a
//           pointer  to  an 's.number' node.  The meaning of 'small' is
//           machine dependent.
//         - 's.segend'  and  's.setgl'  OCODEs  now  emitted  for  some
//           codegenerators, instead of 's.global'.
//         - 'Tree size ...' message now includes  amount  of  remaining
//           space.
//         - 'plist'  now uses a vector instead of a table to record the
//           output state.
//         - Addition  of  'report'  routine  (and  other  changes   and
//           rearrangements),   to   make   main   code   more   machine
//           independent.
//         - Undeclared  names  now  declared  as  global  0  to  reduce
//           unwanted error messages.
//         - Addition  of  code to drive 2900 (VME) codegenerator, as an
//           option.
//         - Minor correction to 'rbexp', to cater  for  small  negative
//           constants correctly.
//         - Minor  correction  to 'trans', to handle small constants in
//           MANIFEST   declarations   correctly   when   checking   for
//           selectors.
//         - 'charcode'   now   set   to   'host_code'  for  2900  (VME)
//           compilations.
//         - Correction to constant folder in 'recast_subtree'.
//         - Correction  to  forbid CASE labels in enclosed FOR loops as
//           well as in enclosed blocks.
//         - Correction  to  'formtree'  and  'rdextdefs' in handling of
//           different host character codes.
 

MANIFEST $(   // Alter these if changes are made
version = 4   // Major version number
edit    = 0   // Edit number within major version
$)
 
 
/* Exit status:-
    0 - Successful compilation
    1 - Filing or parameter error
  254 - Compiler error
  255 - Compilation failed
*/
 
GET "syn.h"

STATIC $( flags = ?; param_pos = ? $)

LET start(argc, argv, envp) BE
$( LET treesize = ?
   AND deleteocode_ = TRUE
   AND ocodename = ?
   AND lu = VEC maxstrlength/bytesperword
   AND res = ?
   AND real_rdch = rdch
   AND argp = 1

   // Set default options

   domapstore_ := FALSE
   ppdebug_, pptrace_ := FALSE, FALSE
   prsource_, verbose_ := FALSE, FALSE
   treelist_, enablecode_, noget_, fold_const_ := FALSE, FALSE, FALSE, TRUE
   treesize, dvect, globdeclt, caset := 8000, 2400, 100, 150
   reportmax, total_reports, syntax_errors_ := maxreports, 0, FALSE

   sourcename, ocodename := 0, 0
   codegen := cg.vaxunix

   GET "libuser.h"   // Define default pathname for library GET files

   FOR i = 0 TO libuser%0 DO lu%i := libuser%i
   libuser := lu

   check_environment("BCPLIB", libuser, envp)   // See if user specified a different one

   WHILE argp LE argc DO
   $( LET s = argv!argp

      argp := argp + 1

      TEST s%0 > 1 & s%1 = '-' THEN
      $( flags := s
         param_pos := 1
         rdch := s_rdch           // Takes input from FLAGS string
         $( ch := rdch()
    
         sw:
            SWITCHON ch INTO
            $( CASE endstreamch: BREAK
               CASE '-':
               CASE'*S':
               CASE'*N':         ENDCASE
               CASE 'b':         selectoutput(journal)
                                 writef("%S: version: V%N.%N*N", argv!0, version, edit)
                                 selectoutput(sysout)
                                 ENDCASE
               CASE 'p':         ppdebug_ := TRUE; ENDCASE
               CASE 't':         treelist_ := TRUE; ENDCASE
               CASE 'm':         domapstore_ := TRUE; ENDCASE
               CASE 'n':         noget_ := TRUE; ENDCASE
               CASE 'c':         enablecode_ := TRUE; ENDCASE
               CASE 'e':         pptrace_ := TRUE; ENDCASE
               CASE 'l':         treesize := readn()
                                 ch := terminator
                                 GOTO sw
               CASE 'a':         reportmax := readn()
                                 ch := terminator
                                 GOTO sw
               CASE 'u':         fold_const_ := FALSE; ENDCASE
               CASE 'v':         codegen := cg.vaxunix; ENDCASE
               CASE 'i':         codegen := cg.emas2900; ENDCASE
               CASE 'w':         codegen := cg.m68k; ENDCASE
               CASE 'r':         codegen := cg.vaxvms; ENDCASE
               CASE 'q':         codegen := cg.vme2900; ENDCASE
               CASE 'z':         codegen := cg.z80; ENDCASE
               CASE 'd':         dvect := readn()
                                 ch := terminator
                                 GOTO sw
               CASE 'g':         globdeclt := readn()
                                 ch := terminator
                                 GOTO sw
               CASE 'k':         caset := readn()
                                 ch := terminator
                                 GOTO sw
               CASE 'o':         IF argp > argc THEN error(sourcename, "No file for *'o*' flag")
                                 ocodename := argv!argp
                                 argp := argp + 1
                                 ENDCASE
               CASE 's':         verbose_ := TRUE; ENDCASE
               DEFAULT:          error(sourcename, "Flag *'%C*' not recognised", ch)
            $)
         $) REPEAT
         rdch := real_rdch   // Restore RDCH
      $)
      OR
      $( IF sourcename NE 0 THEN error(sourcename, "More than one input file")
         sourcename := s
      $)
   $)

   IF treesize > maxtreesize THEN error(sourcename, "Invalid value for *'l*' flag")

   // Set up source file

   IF sourcename = 0 THEN sourcename := "-"
   TEST sourcename%0 = 1 & sourcename%1 = '-' THEN
      sourcestream := sysin
   OR
   $( sourcestream := findinput(sourcename)
      IF sourcestream = 0 THEN error(sourcename, "Cannot open *'%S*'", sourcename)
   $)
   selectinput(sourcestream)

   // Set up OCODE file

   TEST ocodename = 0 THEN
      ocode := sysout
   OR
   $( ocode := findoutput(ocodename)
      IF ocode = 0 THEN error(sourcename, "Cannot open workfile *'%S*'", ocodename)
   $)

   set_target_options(codegen)

   aptovec(comp, treesize)

   IF domapstore_ THEN mapstore()

   advise("Phase 1 complete*N")
   IF total_reports NE 0 THEN
      writef("*N%N error%S*N", total_reports, total_reports = 1 -> "", "s")
   selectoutput(ocode)
   endwrite()

   res := total_reports = 0 -> 0, 255
   stop(res)
$)

AND set_target_options(codegen) BE
$( SWITCHON codegen INTO
   $( CASE cg.emas2900:
         target_bitsperword := 32
         minselectoroffset := -262144
         maxselectoroffset := 262143
         backstack_ := FALSE
         precallsize := 9
         savespacesize := 2
         charcode := host_code
         globlist_ := TRUE
         ENDCASE

      CASE cg.vme2900:
         target_bitsperword := 32
         minselectoroffset := -262144
         maxselectoroffset := 262143
         backstack_ := FALSE
         precallsize := 9
         savespacesize := 2
         charcode := host_code
         globlist_ := TRUE
         ENDCASE

      CASE cg.vaxunix:
         target_bitsperword := 32
         minselectoroffset := -262144
         maxselectoroffset := 262143
         backstack_ := TRUE
         precallsize := 9
         savespacesize := 2
         charcode := host_code
         globlist_ := TRUE
         ENDCASE

      CASE cg.vaxvms:
         target_bitsperword := 32
         minselectoroffset := -262144
         maxselectoroffset := 262143
         backstack_ := FALSE
         precallsize := 9
         savespacesize := 2
         charcode := host_code
         globlist_ := FALSE
         ENDCASE

      CASE cg.z80:
         target_bitsperword := 16
         minselectoroffset := -32768
         maxselectoroffset := 32767
         backstack_ := FALSE
         precallsize := 9
         savespacesize := 2
         charcode := host_code
         globlist_ := TRUE
         ENDCASE

      CASE cg.m68k:
         target_bitsperword := 32
         minselectoroffset := -262144
         maxselectoroffset := 262143
         backstack_ := FALSE
         precallsize := 9
         savespacesize := 3
         charcode := host_code
         globlist_ := TRUE
         ENDCASE
   $)
$)

AND s_rdch() = VALOF   // Read from FLAGS string
$( IF param_pos > flags%0 RESULTIS endstreamch
   param_pos := param_pos + 1
   RESULTIS flags%(param_pos - 1)
$)

AND advise(m, a, b, c) BE
$( IF verbose_ THEN
      writef(m, a, b, c)
$)

AND host_code(ch) = ch

AND ebcdic_code(ch) = VALOF
$( LET astoeb = (TABLE #x00,#x01,#x02,#x03,#x9c,#x09,#x86,#x7f,
                       #x97,#x8d,#x8e,#x0b,#x0c,#x0d,#x0e,#x0f,
                       #x10,#x11,#x12,#x13,#x9d,#x85,#x08,#x87,
                       #x18,#x19,#x92,#x8f,#x1c,#x1d,#x1e,#x1f,
                       #x80,#x81,#x82,#x83,#x84,#x0a,#x17,#x1b,
                       #x88,#x89,#x8a,#x8b,#x8c,#x05,#x06,#x07,
                       #x90,#x91,#x16,#x93,#x94,#x95,#x96,#x04,
                       #x98,#x99,#x9a,#x9b,#x14,#x15,#x9e,#x1a,
                       #x20,#xa0,#xa1,#xa2,#xa3,#xa4,#xa5,#xa6,
                       #xa7,#xa8,#x5b,#x2e,#x3c,#x28,#x2b,#x21,
                       #x26,#xa9,#xaa,#xab,#xac,#xad,#xae,#xaf,
                       #xb0,#xb1,#x5d,#x24,#x2a,#x29,#x3b,#x5e,
                       #x2d,#x2f,#xb2,#xb3,#xb4,#xb5,#xb6,#xb7,
                       #xb8,#xb9,#x7c,#x2c,#x25,#x5f,#x3e,#x3f,
                       #xba,#xbb,#xbc,#xbd,#xbe,#xbf,#xc0,#xc1,
                       #xc2,#x60,#x3a,#x23,#x40,#x27,#x3d,#x22,
                       #xc3,#x61,#x62,#x63,#x64,#x65,#x66,#x67,
                       #x68,#x69,#xc4,#xc5,#xc6,#xc7,#xc8,#xc9,
                       #xca,#x6a,#x6b,#x6c,#x6d,#x6e,#x6f,#x70,
                       #x71,#x72,#xcb,#xcc,#xcd,#xce,#xcf,#xd0,
                       #xd1,#x7e,#x73,#x74,#x75,#x76,#x77,#x78,
                       #x79,#x7a,#xd2,#xd3,#xd4,#xd5,#xd6,#xd7,
                       #xd8,#xd9,#xda,#xdb,#xdc,#xdd,#xde,#xdf,
                       #xe0,#xe1,#xe2,#xe3,#xe4,#xe5,#xe6,#xe7,
                       #x7b,#x41,#x42,#x43,#x44,#x45,#x46,#x47,
                       #x48,#x49,#xe8,#xe9,#xea,#xeb,#xec,#xed,
                       #x7d,#x4a,#x4b,#x4c,#x4d,#x4e,#x4f,#x50,
                       #x51,#x52,#xee,#xef,#xf0,#xf1,#xf2,#xf3,
                       #x5c,#x9f,#x53,#x54,#x55,#x56,#x57,#x58,
                       #x59,#x5a,#xf4,#xf5,#xf6,#xf7,#xf8,#xf9,
                       #x30,#x31,#x32,#x33,#x34,#x35,#x36,#x37,
                       #x38,#x39,#xfa,#xfb,#xfc,#xfd,#xfe,#xff)

   RESULTIS astoeb%ch
$)

AND report(mes, a, line, info, infopar) BE
$( LET o = output()

   reportcount := reportcount + 1

   selectoutput(sysout)

   writef("%S: *"%S*", ", argv!0, sourcename)
   writef(mes, a)
   writef(" near line %N*N", line)
   info(infopar)

   IF reportcount GE reportmax THEN writes("Abort*N")

   selectoutput(o)

   IF reportcount GE reportmax THEN longjump(abort_p, abort_l)
$)

AND message(prefix, mes, a, b, c) BE
$( writef("%S: ", argv!0)
   IF prefix NE 0 THEN writef("*"%S*", ", prefix)
   writef(mes, a, b, c)
$)

AND error(prefix, mes, a, b, c) BE
$( message(prefix, mes, a, b, c)
   newline()
   stop(1)
$)
 
AND check_environment(s, ptr, envp) BE
$( LET p, l = 0, s%0

   WHILE envp!p NE 0 DO
   $( LET e = envp!p

      IF e%0 < l + 1 THEN   // Cannot match - too short
      $( p := p + 1
         LOOP
      $)

      FOR i = 1 TO l DO
      $( UNLESS s%i = e%i BREAK   // Failed to match
         IF i NE l LOOP
         l := l + 1
         UNLESS e%l = '=' BREAK   // Keyword too long

         // Item found - remove prefix

         p := e%0 - l   // Length of value part
         ptr%0 := p
         FOR i = 1 TO p DO   // Copy value down into start of area
            ptr%i := e%(i + l)
         RETURN
      $)
      p := p + 1   // Move to next environment string
   $)
$)

 .

GET "syn.h"

LET pushget() BE
$( LET path_present_ = ?
   AND savecharcode = charcode

   charcode := host_code
   nextsymb()
   charcode := savecharcode

   UNLESS symb = s.string DO synreport(5)

   IF noget_ RETURN

   IF getp GE gett THEN
   $( writef("*NGET file *'%S*' nested too deep*N", wordv)
      stop(1)
   $)

   getv!getp := sourcestream
   getv!(getp + 1) := linecount
   getv!(getp + 2) := ch
   getp := getp + getitemsize
   linecount := 1
   sourcestream := findget(wordv)
   path_present_ := wordv%0 > 0 & wordv%1 = '/'

   IF sourcestream = 0 THEN UNLESS path_present_ DO   // File not found - try in library if no username given
   $( LET ulen = libuser%0
      AND v = VEC maxstrlength/bytesperword + 1

      FOR i = 1 TO ulen DO
        v%i := libuser%i

      IF libuser%ulen NE '/' THEN   // Add terminating '/' if necessary
      $( ulen := ulen + 1
         v%ulen := '/'
      $)

      FOR i = 1 TO wordv%0 DO
         v%(ulen + i) := wordv%i

      v%0 := ulen + wordv%0

      sourcestream := findget(v)
   $)
   IF sourcestream = 0 THEN error(sourcename, "Cannot open GET file *'%S*'", wordv)
   selectinput(sourcestream)
   rch()
$)

AND popget() BE
$( endread()
   getp := getp - getitemsize
   sourcestream := getv!getp
   selectinput(sourcestream)
   linecount := getv!(getp+1)
   ch := getv!(getp+2)
$)

AND findget(s) = VALOF
$( LET v = VEC maxstrlength/bytesperword + 1
   AND res = ?

   FOR i = 1 TO s%0 DO
   $( LET c = s%i
      IF 'A' LE c LE 'Z' THEN c := c - 'A' + 'a'   // Convert to lower case
      v%i := c
   $)
   v%0 := s%0

   res := findinput(v)
   IF res = 0 THEN res := findinput(s)   // Not found - try upper case name

   RESULTIS res
$)

AND smallnumber(n) = 0 < n <= 255

// End of file main.b

