
// D - Optimisation statistics handler

GET "b2.h"

STATIC $( stab = ? $)   // Address of statistics table

MANIFEST $( statsize = 28 $)   // Size of statistics table

LET init_statistics() BE TEST NOT metering_ THEN RETURN OR
$( stab := TABLE ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,
                 ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,
                 ?, ?, ?, ?, ?, ?, ?, ?              // Must match STATSIZE

   FOR i = 0 TO statsize DO stab!i := 0
$)

AND add_statistic(n) BE TEST NOT metering_ THEN RETURN OR
$( LET p = stab + n

   IF NOT incode_ RETURN

   IF n < statsize THEN !p := !p + 1
$)

AND print_statistics() BE TEST NOT metering_ THEN RETURN OR
$( writes("*N*T*TOptimisation statistics*N*
            **T*T-----------------------*N*N")

   FOR i = 0 TO statsize - 1 DO
   $( LET s = title(i)

      writef("*T%S", s)
      FOR j = s%0 TO 40 DO wrch('*S')
      wrch(':')
      writed(stab!i, 6)
      newline()
   $)

   newline(); newline()
$)

AND title(n) = NOT metering_ -> 0, VALOF
$( SWITCHON n INTO
   $( DEFAULT:   RESULTIS ""

      CASE 00:   RESULTIS "Long const optimisations in COMPD"
      CASE 01:   RESULTIS "Constant optimisations in COMPS"
      CASE 02:   RESULTIS "SP adjustments using TSTL"
      CASE 03:   RESULTIS "Address optimisations in LOADLV"
      CASE 04:   RESULTIS "Direct XORL2s"
      CASE 05:   RESULTIS "Direct INCLs"
      CASE 06:   RESULTIS "Direct DECLs"
      CASE 07:   RESULTIS "Direct ADDL2s"
      CASE 08:   RESULTIS "Direct SUBL2s"
      CASE 09:   RESULTIS "Direct SUBL3s"
      CASE 10:   RESULTIS "Direct MULL2s"
      CASE 11:   RESULTIS "Direct DIVL2s"
      CASE 12:   RESULTIS "Direct DIVL3s"
      CASE 13:   RESULTIS "Direct BISL2s"
      CASE 14:   RESULTIS "Direct BICL2s"
      CASE 15:   RESULTIS "Direct ASHLs"
      CASE 16:   RESULTIS "Direct EXTZV shifts"
      CASE 17:   RESULTIS "Constant recaptures"
      CASE 18:   RESULTIS "Variable recaptures"
      CASE 19:   RESULTIS "In-register INCLs"
      CASE 20:   RESULTIS "In-register DECLs"
      CASE 21:   RESULTIS "Recaptures in conditional expressions"
      CASE 22:   RESULTIS "Redundant RESULTIS jumps removed"
      CASE 23:   RESULTIS "Recaptures in STORE"
      CASE 24:   RESULTIS "Recaptures in conditional jumps"
      CASE 25:   RESULTIS "Byte const optimisations in COMPD"
      CASE 26:   RESULTIS "MINUS-multiply optimisations"
      CASE 27:   RESULTIS "Masked jump optimisations"
   $)
$)

