
// File bcpl.b

// Version:  V4.0   (also alter MANIFESTs below)

// Steering program for BCPL compiler on DEC VAX-11 under UNIX

// Copyright (C) R.D. Eager   University of Kent   MCMLXXXV

// History:
//  V1.0   - Initial version.
//  V2.0   - Converted for Berkeley VM-UNIX.
//  V2.1   - Modified to adapt workspace to number of arguments given; also
//           changes to stop codes so that they are all now > 100.
//  V2.2   - '-p' flag now disables '-O'.
//  V3.0   - Modified to handle 'ranlib' libraries.
//  V3.1   - Modified to support '-n' flag to 'b2', to pass name of source
//           file for use in error messages.
//         - Correction to code handling environment strings, to copy strings
//           to separate vectors.
//  V3.2   - Correction to initialisation loop for 'libpath'.
//  V4.0   - Addition of '-C' flag to enable linkage with C routines.

MANIFEST $(   // Alter these if changes are made
version = 4   // Major version number
edit    = 0   // Edit number within major version
$)

/* Exit status:-
   0 - Success
 100 - 'execve' failed
 101 - Failed to create subprocess
 102 - Fatal error in subprocess
 103 - Output file would overwrite potential input file
 104 - No file for 'o' flag
 105 - No directory for 't' flag
 106 - No file for 'C' flag
 200 - Compilation failed
*/

GET "bcpl.h"

EXTERNAL $(
access : "_access"
getpid : "_getpid"
$)

STATIC $(
tmp0        = ?   // Temporary file name
tmp1        = ?   // Temporary file name
compath     = ?   // Pathname for compiler
libpath     = ?   // Pathname for library files
$)

LET start(argc, argv, envp) BE
$( LET v0 = VEC strsize
   AND v1 = VEC strsize
   AND namecopy = VEC strsize
   AND b1flags = VEC strsize
   AND b2flags = VEC strsize
   AND pass1 = VEC pathsize
   AND pass2 = VEC pathsize
   AND preludename = VEC pathsize
   AND postludename = VEC pathsize
   AND libname = VEC pathsize
   AND cp = VEC pathsize
   AND lp = VEC pathsize
   AND argp = 1
   AND bcount, ccount, lcount = 0, 0, 0
   AND xocount = 0
   AND sflag_ = FALSE
   AND jflag_ = FALSE
   AND profiling_ = FALSE
   AND dflag_ = FALSE
   AND dvalue = ?
   AND virtual_ = FALSE
   AND tracing_ = TRUE
   AND verbose_ = FALSE
   AND lflag_ = FALSE
   AND wflag_ = FALSE
   AND debugopt_ = FALSE
   AND outfile = 0
   AND lib = ?
   AND assource = ?
   AND res = ?
   AND next = ?
   AND blist = ?
   AND clist = ?
   AND bsuffix = ?
   AND llist = ?
   AND av = ?

   tmp0, tmp1 := 0, 0   // Initialise for MYSTOP

   GET "libuser.h"   // Default pathnames of compiler and library files

   // Make writeable copies of pathnames

   FOR i = 0 TO compath%0 DO cp%i := compath%i
   compath := cp
   FOR i = 0 TO libpath%0 DO lp%i := libpath%i
   libpath := lp

   check_environment("BCPLCOMP", compath, envp)
   IF compath%(compath%0) = '/' THEN compath%0 := compath%0 - 1
   concat(compath, "/b1", pass1)
   concat(compath, "/b2", pass2)

   check_environment("BCPLIB", libpath, envp)
   IF libpath%(libpath%0) = '/' THEN libpath%0 := libpath%0 - 1
   concat(libpath, "/bcplep.o", preludename)
   concat(libpath, "/bcplst.o", postludename)

   /* Allocate space for the names and suffixes.  Extra arguments are needed
   for some calls; the additional 15 are ample.  */

   av := getvec(argc + 15 - 1)
   blist := getvec(argc - 1)
   llist := getvec(argc - 1)
   clist := getvec(argc - 1)
   bsuffix := getvec(argc/bytesperword - 1)

   old_stop := stop
   stop := mystop

   b1flags%0, b1flags%1 := 1, '-'
   b2flags%0, b2flags%1 := 1, '-'

   loading_ := TRUE
   IF debugging_ THEN dbflag_ := FALSE
   failed_ := FALSE
   tflag_ := FALSE

   WHILE argp LE argc DO
   $( LET a = argv!argp

      TEST a%0 > 1 & a%1 = '-' THEN   // Command flags
      $( SWITCHON a%2 INTO
         $( CASE 'S':   sflag_ := TRUE   // Drop through

            CASE 'c':   loading_ := FALSE
                        ENDCASE

            CASE 'o':   TEST argp < argc THEN
                        $( argp := argp + 1
                           outfile := argv!argp
                           $( LET suffix = getsuf(outfile)

                              IF suffix = 'b' \/ suffix = 'o' THEN
                              $( error("Would overwrite %S", outfile)
                                 stop(103)
                              $)
                           $)
                        $)
                        OR
                        $( error("No file for *'o*' flag")
                           stop(104)
                        $)
                        ENDCASE

            CASE 'C':   TEST argp < argc THEN
                        $( argp := argp + 1
                           clist!ccount := argv!argp
                           ccount := ccount + 1
                        $)
                        OR
                        $( error("No file for *'C*' flag")
                           stop(106)
                        $)
                        ENDCASE

            CASE 'p':   profiling_ := TRUE
                        ENDCASE

            CASE 'O':   tracing_ := FALSE
                        ENDCASE

            CASE 'd':   dflag_ := TRUE
                        dvalue := a
                        ENDCASE

            CASE 'g':   debugopt_ := TRUE
                        ENDCASE

            CASE 'v':   verbose_ := TRUE
                        ENDCASE

            CASE 'V':   virtual_ := TRUE
                        ENDCASE

            CASE 'b':   writef("%S: version: V%N.%N*N", argv!0, version, edit)
                        ENDCASE

            CASE 'J':   jflag_ := TRUE
                        ENDCASE

            CASE 'L':   lflag_ := TRUE
                        ENDCASE

            CASE 'W':   wflag_ := TRUE
                        ENDCASE

            CASE 't':   TEST argp < argc THEN
                        $( argp := argp + 1
                           tempdir := argv!argp
                           tflag_ := TRUE
                        $)
                        OR
                        $( error("No directory for *'t*' flag")
                           stop(105)
                        $)
                        ENDCASE

            CASE 'D':   IF debugging_ THEN
                        $( dbflag_ := TRUE
                           ENDCASE
                        $)

            DEFAULT:    GOTO passarg   // Some other flag - pass through unchanged
         $)
      $)
      OR TEST a%0 > 1 & a%1 = '+' THEN   // Compiler flags
      $( LET flags = b1flags

         FOR i = 2 TO a%0 DO
         $( LET c = a%i

            IF c = 'o' THEN LOOP   // Not allowed - too confusing

            TEST c = ':' THEN flags := b2flags
            OR
            $( LET j = flags%0 + 1

               flags%0 := j
               flags%j := c
            $)
         $)
      $)
      OR
   passarg:
      $( LET suffix = getsuf(a)

         IF suffix = 'b' \/ suffix = 's' THEN
         $( blist!bcount := a
            setsuf(a, 'o')
            bsuffix%bcount := suffix   // Save original suffix
            bcount := bcount + 1
         $)
         IF nodup(llist, lcount,  a) THEN
         $( llist!lcount := a
            lcount := lcount + 1
            IF getsuf(a) = 'o' THEN
            $( xocount := xocount + 1
               setsuf(a, suffix)   // Restore possible 'b' or 's' suffix
            $)
         $)
      $)
      argp := argp + 1
   $)

   IF debugopt_ & NOT tracing_ THEN
   $( tracing_ := TRUE
      writef("%S: -g disables -O*N", argv!0)
   $)

   IF profiling_ & NOT tracing_ THEN
   $( tracing_ := TRUE
      writef("%S: -p disables -O*N", argv!0)
   $)

   IF b1flags%0 = 1 THEN
      b1flags%0, b1flags%2 := 2, '-'
   IF b2flags%0 = 1 THEN
      b2flags%0, b2flags%2 := 2, '-'

   IF debugging_ THEN
      IF dbflag_ THEN
      $( writef("compath = '%S'*N", compath)
         writef("libpath = '%S'*N", libpath)
         writef("b1 flags = *'%S*'*N", b1flags)
         writef("b2 flags = *'%S*'*N", b2flags)

         writes("*NCompile list:*N*N")
         FOR i = 0 TO bcount - 1 DO
            writef("%S %C*N", blist!i, bsuffix%i)

         writes("*NLoad list:*N*N")
         FOR i = 0 TO lcount - 1 DO
         $( LET a = getsuf(llist!i)
            AND sufset = FALSE

            IF a = 'b' \/ a = 's' THEN
            $( setsuf(llist!i, 'o')
               sufset := TRUE
            $)
            writef("%S*N", llist!i)
            IF sufset THEN setsuf(llist!i, bsuffix%i)
         $)

         writes("*NC program list:*N*N")
         FOR i = 0 TO ccount - 1 DO
            writef("%S*N", clist!i)

         newline()
      $)

   lib := tracing_ -> "/libD.a", "/libO.a"
   concat(libpath, lib, libname)

   IF bcount = 0 GOTO nocom   // Load only - nothing to compile

   tmp0 := mktemp(v0, 0)
   tmp1 := mktemp(v1, 1)

   FOR i = 0 TO bcount - 1 DO
   $( LET p = blist!i
      AND sourcename = VEC pathsize

      FOR i = 0 TO p%0 DO sourcename%i := p%i

      IF bcount > 1 THEN writef("%S:*N", p)
      TEST getsuf(p) = 's' THEN
      $( assource := p
         GOTO assemble
      $)
      OR assource := tmp1

      av!0 := "b1"
      av!1 := p
      av!2 := "-o"
      av!3 := tmp0
      av!4 := b1flags
      next := 5
      IF verbose_ THEN
      $( av!next := "-s"
         next := next + 1
      $)
      av!next := 0   // Terminator

      res := callsys(pass1, av)
      IF res NE 0 THEN
      $( failed_ := TRUE
         LOOP
      $)

      IF sflag_ THEN
      $( setsuf(p, 's')
         assource := p
      $)

      av!0 := "b2"
      av!1 := tmp0
      av!2 := b2flags
      av!3 := "-o"
      av!4 := assource
      av!5 := "-n"
      av!6 := sourcename
      next := 7
      IF profiling_ THEN
      $( av!next := "-p"
         next := next + 1
      $)
      IF tracing_ THEN
      $( av!next := "-t"
         next := next + 1
      $)
      IF debugopt_ THEN
      $( av!next := "-d"
         next := next + 1
      $)
      av!next := 0   // Terminator

      res := callsys(pass2, av)
      IF res NE 0 THEN
      $( failed_ := TRUE
         LOOP
      $)

   assemble:
      FOR i = 0 TO assource%0 DO namecopy%i := assource%i
      setsuf(p, 'o')
      av!0 := "as"
      av!1 := namecopy
      av!2 := "-o"
      av!3 := p
      next := 4
      IF virtual_ THEN
      $( av!next := "-V"
         next := next + 1
      $)
      IF jflag_ THEN
      $( av!next := "-J"
         next := next + 1
      $)
      IF dflag_ THEN
      $( av!next := dvalue
         next := next + 1
      $)
      IF lflag_ THEN
      $( av!next := "-L"
         next := next + 1
      $)
      IF wflag_ THEN
      $( av!next := "-W"
         next := next + 1
      $)
      IF tflag_ THEN
      $( av!next := "-t"
         next := next + 1
         av!next := tempdir
         next := next + 1
      $)
      av!next := 0   // Terminator

      res := callsys("/bin/as", av)
      IF res NE 0 THEN failed_ := TRUE
   $)

nocom:
   IF failed_ THEN loading_ := FALSE

   IF lcount NE 0 & loading_ THEN
   $( av!0 := "ld"
      av!1 := "-X"
      av!2 := "-e"
      av!3 := "_bcplep"
      av!4 := preludename
      next := 5
      IF outfile NE 0 THEN
      $( av!next := "-o"
         next := next + 1
         av!next := outfile
         next := next + 1
      $)
      FOR i = 0 TO lcount - 1 DO
      $( av!next := llist!i
         next := next + 1
      $)
      av!next := libname
      next := next + 1
      av!next := postludename
      next := next + 1
      FOR i = 0 TO ccount - 1 DO
      $( av!next := clist!i
         next := next + 1
      $)
      av!next := "-lc"
      next := next + 1
      av!next := 0   // Terminator

      res := callsys("/bin/ld", av)
      IF res NE 0 THEN failed_ := TRUE

      IF bcount = 1 & xocount = 1 & NOT failed_ THEN
      $( setsuf(blist!0, 'o')
         deletefile(blist!0)
      $)
   $)
   stop(failed_ -> 1, 0)
$)

AND error(s, n) BE
$( LET o = output()

   selectoutput(sysout)

   writef("%S: ", argv!0)
   writef(s, n)
   newline()

   selectoutput(o)
   loading_, failed_ := FALSE, TRUE
$)

AND getsuf(s) = VALOF
$( LET n = s%0

   RESULTIS n > 2 & s%(n - 1) = '.' -> s%n, 0
$)

AND setsuf(s, suffix) BE
$( LET n = s%0

   IF n > 2 & s%(n - 1) = '.' THEN s%n := suffix
$)

AND nodup(list, lcount,  s) = VALOF
$( IF getsuf(s) NE 'o' RESULTIS TRUE
   FOR i = 0 TO lcount - 1 DO
      IF match(list!i, s) RESULTIS FALSE
   RESULTIS TRUE
$)

AND match(a, b) = VALOF
$( LET la, lb = a%0, b%0

   IF la NE lb RESULTIS FALSE

   FOR i = 1 TO la DO
      UNLESS a%i = b%i RESULTIS FALSE
   RESULTIS TRUE
$)

AND concat(s1, s2, s) BE
$( LET l1, l2 = s1%0, s2%0

   FOR i = 1 TO l1 DO s%i := s1%i
   FOR i = 1 TO l2 DO s%(l1 + i) := s2%i
   s%0 := l1 + l2
$)

AND callsys(name, argv) = VALOF
$( LET pid, status = ?, ?

   IF debugging_ THEN
   $( IF dbflag_ THEN
      $( LET p = 0

         writef("callsys: %S*N", name)
         WHILE argv!p NE 0 DO
         $( writef(" %S", argv!p)
            p := p + 1
         $)
         newline()
         RESULTIS 0
      $)
   $)

   pid := fork()

   IF pid = 0 THEN   // Child process
   $( execve(name, argv, envp)
      error("can*'t find %S*N", name)
      stop(100)
   $)

   IF pid = -1 THEN   // Failed to fork
   $( error("no more processes*N")
      stop(101)
   $)

   $( LET t = wait(@status)

      IF t NE pid LOOP

      t := status & #XFF
      IF t NE 0 & t NE 14 THEN   // Not alarm clock
      $( IF t NE 2 THEN   // Not interrupt
         $( error("fatal error in %S*N", name)
            stop(102)
         $)
         stop(0)
      $)
      RESULTIS ((status >> 8) & #XFF)
   $) REPEAT
$)

AND mktemp(s, f) = VALOF
$( LET dir = tflag_ -> tempdir, "/tmp"
   AND n = ?
   AND pid = getpid()
   AND dtab = (TABLE 10000, 1000, 100, 10, 1)

   IF debugging_ THEN
      IF dbflag_ THEN writef("pid = %N*N", pid)

   IF dir%(dir%0) = '/' THEN dir%0 := dir%0 - 1
   concat(dir, "/btm", s)
   n := s%0 + 1
   s%n := 'a' + f
   n := n + 1
   FOR i = 0 TO 4 DO
   $( LET digit = (pid/dtab!i) + '0'

      s%(n + i) := digit
      pid := pid REM dtab!i
   $)
   n := n + 4

   s%0 := n

   IF debugging_ THEN
      IF dbflag_ DO writef("Temp file name %N: %S*N", f, s)

   RESULTIS s
$)

AND mystop(n) BE
$( IF tmp0 NE 0 THEN deletefile(tmp0)
   IF tmp1 NE 0 THEN deletefile(tmp1)

   old_stop(n)
$)

AND check_environment(s, ptr, envp) BE
$( LET p, l = 0, s%0

   WHILE envp!p NE 0 DO
   $( LET e = envp!p

      IF e%0 < l + 1 THEN   // Cannot match - too short
      $( p := p + 1
         LOOP
      $)

      FOR i = 1 TO l DO
      $( UNLESS s%i = e%i BREAK   // Failed to match
         IF i NE l LOOP
         l := l + 1
         UNLESS e%l = '=' BREAK   // Keyword too long

         // Item found - remove prefix

         p := e%0 - l   // Length of value part
         ptr%0 := p
         FOR i = 1 TO p DO   // Copy value down into start of area
            ptr%i := e%(i + l)
         RETURN
      $)
      p := p + 1   // Move to next environment string
   $)
$)

// End of file bcpl.b

