
// File conting.b

SECTION "_conting"
NEEDS "_bcpldbs"

GET "rtshdr"

MANIFEST $(   // Offsets of items in signal context area
sc_onstack    = SLCT 32:00:00   // sigstack state to restore
sc_mask       = SLCT 32:00:01   // signal mask to restore
sc_sp         = SLCT 32:00:02   // sp to restore
sc_pc         = SLCT 32:00:03   // pc to restore
sc_ps         = SLCT 32:00:04   // psl to restore
$)

LET contingency(signo, code, sigcontext,  p) BE
$( LET v1 = VEC 2
   AND v2 = VEC 2
   AND pc = sc_pc::sigcontext
   AND pp = p!3 >> 2
   LET fp = pp!3
   AND psw = pp!1 & #xffff
   AND sp = (sigcontext<<2) + 20
   AND mes = ?
   AND bcore = "bcore"
   AND diagout = ?

   IF signo = 2 THEN stop(255)   // Interrupt

   IF sv.errflag THEN
   $( selectoutput(journal)
      writes("*NDiagnostics fail - looping*N")
      stop(255)
   $)

   sv.errflag := TRUE

   IF signo = 7 & pc = 0 THEN   // XFC instruction at address 0 - jump to zero
      signo := 0

   mes := sigreason(signo)

   diagout := findoutput(bcore)   // Try to open dump file
   TEST diagout NE 0 THEN
   $( selectoutput(journal)
      writef("*N%S - dump in %S*N", mes, bcore)
      selectoutput(diagout)
   $)
   OR selectoutput(journal)

   writef("*N*N%S - on %S at %S*N", mes, date(v1), timeofday(v2))

   UNLESS signo = 3 DO   // Not for a quit signal
      mapregs(p, (p!3>>2)!2, fp, sp, pc, psw)

   IF signo = 0 THEN find_cause(pc)   // Try to diagnose jump to zero

   backtrace()

   postmortem(fp >> 2, sp >> 2, pc)

   mapglobals(1, globalsize)

   mapstatics()

   UNLESS signo = 3 DO mapcode(pc)   // Not for a quit signal

   mapstore()

   UNLESS userpostmortem = 0 DO userpostmortem(0)

   stop(255)
$)

AND find_cause(link) BE
$( LET iad = link - 6   // Try for longword displacement first
   AND length = ?
   AND disp, gno = ?, ?

   UNLESS 0 LE link LE sv.highcode RETURN   // Outside text area

   TEST 0%iad = i.jsb & 0%(iad + 1) = m.relpcldef THEN
      length := 4
   OR
   $( iad := iad + 2   // Try for a word displacement
      TEST 0%iad = i.jsb & 0%(iad + 1) = m.relpcwdef THEN
         length := 2
      OR
         RETURN
   $)

   iad := iad + 2   // Move to displacement part

   FOR i = length - 1 TO 0 BY -1 DO
      disp := (disp << 8) \/ 0%(iad + i)   // Get 2- or 4-word displacement

   IF length = 2 & (disp & #X80000) NE 0 THEN   // Sign-extend word displacements
      disp := disp \/ #XFFFF0000

   iad := iad + disp + length   // Point to routine cell

   IF 0 LE iad LE sv.highcode RETURN   // Inside text area!

   gno := (iad >> 2) - @start + 1   // Get true global number

   writes("*N*NPossibly caused by jump to ")
   TEST 0 LE gno LE globalsize THEN
      writef("undefined global number %N*N*N", gno)
   OR
      writes("corrupt routine entry point, label or STATIC*N*N")
$)

 .

SECTION "_skelcon"

GET "libhdr"

LET sigreason(n) = VALOF SWITCHON n INTO
$( CASE 00:  RESULTIS "Jump to zero"
   CASE 01:  RESULTIS "Hangup"
   CASE 02:  RESULTIS "Interrupt"
   CASE 03:  RESULTIS "Quit"
   CASE 04:  RESULTIS "Illegal instruction"
   CASE 05:  RESULTIS "Trace trap"
   CASE 06:  RESULTIS "Signal 6"
   CASE 07:  RESULTIS "XFC instruction"
   CASE 08:  RESULTIS "Arithmetic exception"
   CASE 10:  RESULTIS "Bus error"
   CASE 11:  RESULTIS "Segmentation violation"
   CASE 12:  RESULTIS "Bad argument to system call"
   CASE 13:  RESULTIS "Broken pipe"
   CASE 14:  RESULTIS "Alarm clock"
   CASE 15:  RESULTIS "Software termination"
   CASE 16:  RESULTIS "Urgent condition on socket"
   CASE 18:  RESULTIS "Stop from keyboard"
   CASE 19:  RESULTIS "Continue after stop"
   CASE 20:  RESULTIS "Child status has changed"
   CASE 21:  RESULTIS "Background read from control terminal"
   CASE 22:  RESULTIS "Background write from control terminal"
   CASE 23:  RESULTIS "I/O possible on a descriptor"
   CASE 24:  RESULTIS "CPU time limit exceeded"
   CASE 25:  RESULTIS "File size limit exceeded"
   CASE 26:  RESULTIS "Virtual time alarm"
   CASE 27:  RESULTIS "Profiling timer alarm"

   DEFAULT:  RESULTIS "Unknown signal"
$)

// End of file conting.b

