#
# BCPL library - date.s
# Date and time-of-day string functions
#
	.text
	.globl	_bcplgi
	.globl	_gettimeofday
	.globl	_ctime
#
	.globl	_date
	.globl	_tod
_date:
_tod:
#
	jbr	4f			# skip chain
#
6:	clrl	r0			# marker for DATE
	jbr	1f			# join common code
7:	movl	$1,r0			# marker for TIMEOFDAY
1:	pushl	fp			# standard entry sequence
	addl3	$248,sp,fp
	movq	(sp)+,-4(fp)
	addl2	$232,sp			# date vector pointer on top of stack
	pushl	r0			# DATE/TIMEOFDAY marker
#
# Get system time in r0
#
	subl2	$8,sp			# make space for timezone
	movl	sp,r0			# save its address
	subl2	$8,sp			# make space for time value
	movl	sp,r1			# save its address
	pushl	r0
	pushl	r1
	calls	$2,_gettimeofday
	movl	(sp)+,r0		# seconds since epoch
	addl2	$12,sp			# lose rest of fields
#
# Convert to character string
#
	pushl	r0			# stack system time
	pushl	sp			# stack address of it
	calls	$1,_ctime		# returns string pointer in r0
	tstl	(sp)+			# remove time
#
# Extract the relevant fields, re-formatting where necessary
#
	movl	r0,r6			# use safer register
	movl	(sp)+,r8		# DATE/TIMEOFDAY marker
	movl	(sp),r3			# BCPL address of vector
	ashl	$2,r3,r3		# convert to byte address
	jlbs	r8,2f			# j if TIMEOFDAY code needed
#
# Code for DATE
#
	movb	$9,(r3)+		# length byte
	addl3	$8,r6,r1		# source of DD
	movc3	$2,(r1),(r3)
	movb	$'-,(r3)+		# separator
	addl3	$4,r6,r1		# source of MMM
	movc3	$3,(r1),(r3)
	movb	$'-,(r3)+		# separator
	addl3	$22,r6,r1
	movc3	$2,(r1),(r3)		# source of YY
	jbr	3f			# join common exit code
#
# Code for TIMEOFDAY
#
2:	movb	$8,(r3)+		# length byte
	addl3	$11,r6,r1		# source of HH:MM:SS
	movc3	$8,(r1),(r3)
#
# Common exit code
#
3:	movl	(sp)+,r0		# return vector address
	movl	(sp)+,fp		# standard exit code
	rsb
#
# Global initialisation
#
4:	jsb	_bcplgi
	.long	DATE/4,6b
	.long	TOD/4,7b
	.long	-1
	jbr	5f			# avoid loader alignment problems
	.align	2
5:
#
# End of file date.s
#
