
// File endtoin.b

SECTION "_endtoin"
NEEDS "_bcplios"

GET "rtshdr"

LET endtoinput() = VALOF
$( LET res = ?
   AND scb = sv.curout
   AND flags = ?

   IF scb = 0 THEN   // No output selected
   $( result2 := e.badf
      RESULTIS 0
   $)

   selectoutput(0)   // Return SCB to deselected chain

   flags := scb_flags::scb
   IF (flags & f_unix) = 0 THEN   // Not a standard UNIX stream
   $( result2 := e.badf
      RESULTIS 0
   $)

   IF (flags & f_tty) NE 0 THEN   // Cannot do this to a terminal stream
   $( result2 := e.badf
      RESULTIS 0
   $)

   // Flush the buffer unless it is empty

   result2 := e.ok

   IF scb_cursor::scb NE 0 THEN
   $( LET res = write(scb_fd::scb, scb_bufadd::scb << 2, scb_cursor::scb)

      IF res < 0 THEN
      $( result2 := berrno()
         IF result2 = e.intr THEN   // Re-try interrupted system call
         $( result2 := e.ok   // Reset
            LOOP
         $)
         RESULTIS 0
      $)
      BREAK
   $) REPEAT

   res := lseek(scb_fd::scb, 0, 0)
   IF res < 0 THEN
   $( result2 := berrno()
      RESULTIS 0
   $)

   scb_read::scb    := io.stdread
   scb_write::scb   := io.wrongdir
   scb_dir::scb     := dir_read
   scb_cursor::scb  := 0
   scb_count::scb   := 0
   scb_lastch::scb  := '*N'   // Pseudo zeroth character
   scb_blkread::scb := io.blkread
   scb_blkwrite::scb:= io.wrongdir

   RESULTIS scb
$)

// End of file endtoin.b

