
// File getvec.b

SECTION "_getvec"

GET "rtshdr"

STATIC $( blklist = ? $)

MANIFEST $(
quantum      = 256   // Must be multiple of 2
sizebits     = #xfffffffe
freebit      = 1
$)

LET getvec(n) = VALOF   // Called once only - then redirected to getblk
$( LET p = sbrk(quantum*bytesperword)

   IF p < 0 RESULTIS 0
   p := (p >> 2) + 1   // Convert to BCPL address - ignore first word to preserve even size
   blklist, p!0, p!(quantum - 2) := p, (quantum - 2) \/ freebit, 0
   getvec := getblk   // The real space allocation routine
   RESULTIS getvec(n)
$)

AND getblk(n) = VALOF   // The real getvec
$( LET p, q = 0, blklist

   n := n + 2   // Allow for secret word and zeroth word

   n := (n + 1) & sizebits   // Round to multiple of 2

   $( p := q

      // Chain through used blocks, looking for an unused one

      WHILE (!p & freebit) = 0 DO
      $( TEST !p = 0 THEN   // No space left - try to get more
         $( LET x = sbrk(quantum*bytesperword)

            IF x < 0 RESULTIS 0
            !p := quantum \/ freebit
            p!quantum := 0
            RESULTIS getvec(n - 2)
         $)
         OR
            p := p + !p
      $)

      q := p   // Chain to the end of this free area
      UNTIL (!q & freebit) = 0 DO
         q := q + (!q & NOT freebit)
   $) REPEATUNTIL q - p GE n   // Exit if large enough block found

   // Split block unless it is an exact fit

   UNLESS p + n = q DO
      p!n := (q - p - n) \/ freebit

   !p := n

   RESULTIS p + 1   // Return pointer, avoiding secret word
$)

AND freevec(p) BE
$( p := p - 1   // Point to true start of block

   !p := !p \/ freebit
$)

// End of file getvec.b

