
// File postmor.b

// BCPL library - stack unwinder
// Must be compiled without automatic NEEDS directives to avoid the
// references in NAME.FROM.LINK (GETBYTE, PUTBYTE, etc.) being loaded when
// they are not actually required.

SECTION "_postmor"
NEEDS "_level"
NEEDS "_writef"
NEEDS "_writes"
NEEDS "_bcpldbs"

GET "rtshdr"

LET postmortem(fp, sp, pc) BE    // FP and SP are word addresses
$( UNLESS sv.errflag DO
   $( fp := level() >> 2
      sp := fp - 1   // Pretend POSTMORTEM has no locals
      pc := postmortem   // As good a value as any
   $)
 
   $( LET items.per.line = 6
      AND no.online = ?
      AND max = 40   // Temporary
      AND atsp = @sp
 
      writes("*N*NPostmortem of the stack:*N")
 
      WHILE fp LE (stackbase >> 2) DO
      $( IF fp < (#X7FF00000 >> 2) THEN   // Unlikely value
         $( writes("Stack is irretrievably corrupt*N")
            RETURN
         $)
         writes("*NFunction <")
         sv.writefn(name.from.link(fp, atsp), 1, max)
         writef("> with %S", sp GE fp - 1 -> "no locals", "locals:-")
         no.online := items.per.line
 
         FOR i = 2 TO fp - sp DO
         $( IF no.online = items.per.line THEN
            $( no.online := 0
               newline()
            $)
            IF i > 21 DO   // Only print up to first 20 locals
            $( writes(". . . .")
               BREAK
            $)
            no.online := no.online + 1
            sv.writeval(fp!(-i))
         $)
         writef("*Ncalled from location %X8 in*N", fp!0)
         sp := fp + 1
         fp := fp!(-1) >> 2
      $)
      writes("*NEntry sequence*N*N")
   $)
$)
 
AND address.from.link(atlink) = VALOF
$( LET iad = !atlink - 6   // Tentative address of call (longword displacement)
   AND length = 4
   AND disp = 0
   AND pcmode = ?

   TEST 0%iad = i.jsb & 0%(iad + 1) = m.relpcldef THEN
      length, pcmode := 4, TRUE
   OR
   $( iad := iad + 2   // Try for a word displacement
      TEST 0%iad = i.jsb & 0%(iad + 1) = m.relpcwdef THEN
         length, pcmode := 2, TRUE
      OR
      $( iad := iad + 1   // Try for a byte displacement
         TEST 0%iad = i.jsb & 0%(iad + 1) = m.relfpbdef THEN
            length, pcmode := 1, FALSE
         OR RESULTIS 0   // Not, apparently, a call
      $)
   $)

   IF NOT pcmode THEN   // Perhaps a call from APTOVEC - in which case, take the routine
                        // address from local 2
   $( UNLESS 0%(iad + 2) = #XF8 RESULTIS 0

      UNLESS (aptovec NE 0) & (aptovec < iad < aptovec + 70) RESULTIS 0   // Not within APTOVEC

      $( LET oldfp = atlink!(-1) >> 2

         RESULTIS oldfp!(-2)
      $)
   $)

   iad := iad + 2   // Move to displacement part

   FOR i = length - 1 TO 0 BY -1 DO
      disp := (disp << 8) \/ 0%(iad + i)   // Get 2- or 4-byte displacement

   IF length = 2 & (disp & #X8000) NE 0 THEN   // Sign-extend word displacements
      disp := disp \/ #XFFFF0000

   iad := iad + disp + length   // Point to routine cell

   RESULTIS !(iad >> 2)
$)

AND name.from.link(atlink, atsp) = VALOF
$( LET ep = address.from.link(atlink)
   LET name = ?
 
   // Check for special cases in machine code library
   // Note that some routines remove their parameters from the stack;
   // the notional SP is adjusted here to compensate.
 
   IF ep NE 0 THEN
   $( IF ep = getbyte THEN
      $( !atsp := !atsp - 2
         RESULTIS "getbyte"
      $)
      IF ep = putbyte THEN
      $( !atsp := !atsp - 3
         RESULTIS "putbyte"
      $)
      IF ep = translate THEN
      $( !atsp := !atsp - 3
         RESULTIS "translate"
      $)
      IF ep = longjump RESULTIS "longjump"
      IF ep = aptovec THEN
      $( !atsp := atlink - 1   // Hide private locals and vector of APTOVEC
         RESULTIS "aptovec"
      $)
   $)
 
   name := ep = 0 -> 0, sv.nfentry(ep)
   RESULTIS name = 0 -> "????????", name
$)
 
// End of file postmor.b

