
// File rewind.b

SECTION "_rewind"
NEEDS "_bcplios"

GET "rtshdr"

LET rewind() = VALOF
$( LET res = ?
   AND scb = sv.curin
   AND flags = ?

   IF scb = 0 THEN   // No input selected
   $( result2 := e.badf
      RESULTIS 0
   $)

   selectinput(0)   // Return SCB to deselected chain

   flags := scb_flags::scb
   IF (flags & f_unix) = 0 THEN   // Not a standard UNIX stream
   $( result2 := e.badf
      RESULTIS 0
   $)

   IF (flags & f_tty) NE 0 THEN   // Cannot rewind terminal stream
   $( result2 := e.badf
      RESULTIS 0
   $)

   res := lseek(scb_fd::scb, 0, 0)
   IF res < 0 THEN
   $( result2 := berrno()
      RESULTIS 0
   $)

   scb_cursor::scb   := 0
   scb_count::scb    := 0
   scb_lastch::scb   := '*N'   // Pseudo zeroth character

   IF (scb_flags::scb & f_unread) NE 0 THEN   // Pending UNRDCH - clear
   $( scb_flags::scb := scb_flags::scb & NOT f_unread
      scb_read::scb  := scb_sread::scb
   $)

   RESULTIS scb
$)

// End of file rewind.b

