
// File: COM.H

// Common header file for BCPL compiler - phase 1

// Copyright (C) R.D. Eager   October 1989

GET "LIBHDR"


MANIFEST $(   // Operators and symbols
s.number            =   1
s.name              =   2
s.string            =   3
s.true              =   4
s.false             =   5
s.valof             =   6
s.lv                =   7
s.rv                =   8
s.vecap             =   9
s.fnap              =  10
s.mult              =  11
s.div               =  12
s.rem               =  13
s.plus              =  14
s.minus             =  15
s.query             =  16
s.neg               =  17
s.seqlist           =  18
s.abs               =  19
s.eq                =  20
s.ne                =  21
s.ls                =  22
s.gr                =  23
s.le                =  24
s.ge                =  25

s.not               =  30
s.lshift            =  31
s.rshift            =  32
s.logand            =  33
s.logor             =  34
s.eqv               =  35
s.neqv              =  36
s.cond              =  37
s.comma             =  38
s.table             =  39
s.and               =  40
s.valdef            =  41
s.vecdef            =  42
s.commalist         =  43
s.fndef             =  44
s.rtdef             =  45

s.extdef            =  47
s.needs             =  48
s.section           =  49
s.ass               =  50
s.rtap              =  51
s.goto              =  52
s.resultis          =  53
s.colon             =  54
s.test              =  55
s.for               =  56
s.if                =  57
s.unless            =  58
s.while             =  59
s.until             =  60
s.repeat            =  61
s.repeatwhile       =  62
s.repeatuntil       =  63

s.loop              =  65
s.break             =  66
s.return            =  67
s.finish            =  68
s.endcase           =  69
s.switchon          =  70
s.case              =  71
s.default           =  72
s.deflist           =  73
s.let               =  74
s.manifest          =  75
s.global            =  76
s.local             =  77
s.label             =  78
s.static            =  79
s.code              =  80
s.external          =  81
s.slctr             =  82

s.slctap            =  84
s.byteap            =  85
$)

MANIFEST $(   // Selectors for items in tree nodes
h1                  =   0
h2                  =   1
h3                  =   2
h4                  =   3
h5                  =   4
h6                  =   5
$)

MANIFEST $( // Code generator types
cg.z80              =   1   // Zilog Z80 code generator
cg.vaxvms           =   2   // DEC VAX code generator (VMS)
$)

MANIFEST $(   // Compiler error codes
cerr_syn_message    =   0   // Error in 'syn_message'
cerr_trn_message    =   1   // Error in 'trn_message'
$)

MANIFEST $(   // Global bases
xg                  = firstfreeglobal    // System dependent globals
cg                  = xg+005             // Common globals
sg                  = cg+028             // Globals for SYN module
tg                  = sg+064             // Globals for TRN module
$)

GLOBAL $(   // Globals used by more than one module
abort_l             : cg+000
abort_p             : cg+001
backstack_          : cg+002
caset               : cg+003
charcode            : cg+004
compileae           : cg+005
compiler_error      : cg+006
domapstore_         : cg+007
dvect               : cg+008
fold_const_         : cg+009
globdeclt           : cg+010
globlist_           : cg+011
host_code           : cg+012
list2               : cg+013
maxselectoroffset   : cg+014
minselectoroffset   : cg+015
ocode               : cg+016
plist               : cg+017
precallsize         : cg+018
querynode           : cg+019
report              : cg+020
reportcount         : cg+021
reportmax           : cg+022
savespacesize       : cg+023
smallnumber         : cg+024
target_bitsperword  : cg+025
treeprintvec        : cg+026
zeronode            : cg+027
$)

MANIFEST $(   // Tunable MANIFESTs
treeprintmax        =  30   // Maximum depth of tree listing
ocountmax           =  50   // Threshold for splitting OCODE lines
$)

// End of file: COM.H


