
// File: MAIN.B

// Version:  D3.0   (also alter MANIFESTs below)

// BCPL compiler - phase 1 - system interface

// Copyright (C) R.D. Eager   October 1989

// History:
//  D3.0   - Major new version.
//         - Command interface revised to use CLI routines.

MANIFEST $(   // Alter these if changes are made
version = 3   // Major version number
edit    = 0   // Edit number within major version
$)


GET "SYN.H"
GET "SYS.H"

/* VMS symbol definitions */

GET "CLIMSGDEF.H"
GET "DSCDEF.H"
GET "SSDEF.H"

/* VMS library routines */

EXTERNAL $(
CLI$GET_VALUE
CLI$PRESENT
STR$TRIM
$)

STATIC $(
assemble_   = ?       // Controls whether generated code is assembled
cgname      = ?       // Name of code generator to be used
codegen     = ?       // Selection index for code generator to be used
inhibitgen_ = ?       // Controls whether code generator is to be called
listing     = ?       // Stream pointer for listing file
optimise_   = ?       // Controls whether tracing code is generated
profile_    = ?       // Controls whether profiling code is generated
second_     = FALSE   // Set to TRUE iff second VMS message to be displayed
treesize    = ?       // Space allocated for syntax tree (words)
verbose_    = ?       // Controls whether additional info messages are output
xref_       = ?       // Controls whether a cross ref listing is to be produced
$)

LET start() BE
$( LET control = VEC maxstrlength/bytesperword
   AND cgparam = ""
   AND dir = 0
   AND ext = 0
   AND jtstring = VEC 7/bytesperword
   AND listname = VEC maxstrlength/bytesperword
   AND outname = VEC maxstrlength/bytesperword
   AND sourcename = VEC maxstrlength/bytesperword
   AND ocodename = VEC maxstrlength/bytesperword

   jtstring%0,  outname%0 := 0, 0

   set_defaults()

   /* Get target system */

   $( LET cg = VEC maxstrlength/bytesperword

      get_value("TARGET", cg)

      TEST matchstrings(cg, "VMS") THEN
         codegen := cg.vaxvms OR
      TEST matchstrings(cg, "Z80") THEN
      $( LET colon = 0
         AND ok_ = TRUE

         FOR i = 1 TO cg%0 DO
            IF cg%i = ':' THEN
            $( colon := i
               BREAK
            $)

         TEST colon = 0 THEN table := #X0000 OR
         $( jtstring%0 := 7   // Always 7 bytes
            jtstring%1 := 'Z'
            jtstring%2 := '#'
            jtstring%3 := 'X'
            FOR i = 4 TO 7 DO
            $( LET c = jtstring%i
               UNLESS '0' LE c LE '9' \/
                      'A' LE c LE 'F' DO
                  ok_ := FALSE
            $)
            TEST ok_ THEN
               cgparam := jtstring
            OR
            $( message(journal, bcpl_ivflagval, v << 2, 0)
               cgparam := "#X0000"
            $)
         $)
         ENDCASE
      $)
      OR stop(ss$_abort)   // Should never happen
   $)

   /* Get any flags */

   IF present("FLAGS") THEN
   $( LET fv = VEC maxstrlength/bytesperword

      get_value("FLAGS", fv)

      FOR i = 1 TO fv%0 DO
      $( LET ch = fv%i

         LET readval(s, ati) = VALOF
         $( LET n = 0
            AND i = !ati
            AND ch = ?

            $( i := i + 1
               IF i > s%0 BREAK
               ch := s%i
               UNLESS '0' LE ch LE '9' BREAK
               n := n*10 + ch - '0'
            $) REPEAT

            UNLESS i > s%0 DO i := i - 1
            !ati := i
            RESULTIS n
         $)

         SWITCHON ch INTO
         $( CASE'*S':     ENDCASE
            CASE 'A':     reportmax := readval(fv, @i)
                          IF reportmax > maxreportmax THEN
                          $( message(journal, bcpl_ivflagval, v << 2,
                                maxreportmax)
                             reportmax := maxreportmax
                          $)
                          ENDCASE
            CASE 'B':     assemble_ := FALSE; ENDCASE
            CASE 'C':     enablecode_ := TRUE; ENDCASE
            CASE 'D':     dvect := readval(fv, @i)
                          IF dvect > maxdvect THEN
                          $( message(journal, bcpl_ivflagval, v << 2, maxdvect)
                             dvect := maxdvect
                          $)
                          ENDCASE
            CASE 'E':     pptrace_ := TRUE; ENDCASE
            CASE 'G':     globdeclt := readval(fv, @i)
                          IF globdeclt > maxglobdeclt THEN
                          $( message(journal, bcpl_ivflagval, v << 2,
                                maxglobdeclt)
                             globdeclt := maxglobdeclt
                          $)
                          ENDCASE
            CASE 'K':     caset := readval(fv, @i)
                          IF caset > maxcaset THEN
                          $( message(journal, bcpl_ivflagval, v << 2, maxcaset)
                             caset := maxcaset
                          $)
                          ENDCASE
            CASE 'L':     treesize := readval(fv, @i)
                          IF treesize > maxtreesize THEN
                          $( message(journal, bcpl_ivflagval, v << 2,
                                maxtreesize)
                             treesize := maxtreesize
                          $)
                          ENDCASE
            CASE 'M':     domapstore_ := TRUE; ENDCASE
            CASE 'N':     noget_ := TRUE; ENDCASE
            CASE 'O':     inhibitgen_ := TRUE; ENDCASE
            CASE 'P':     ppdebug_ := TRUE; ENDCASE
            CASE 'T':     treelist_ := TRUE; ENDCASE
            CASE 'U':     fold_const_ := FALSE; ENDCASE
            DEFAULT :     message(journal, bcpl_unkflag, v << 2)
         $)
      $)
   $)

   /* Handle boolean qualifiers */

   IF present("OPTIMIZE") = cli$_present THEN optimise_ := TRUE
   IF present("VERBOSE") = cli$_present THEN verbose_ := TRUE
   IF present("PROFILE") = cli$_present THEN profile_ := TRUE

   /* Open the source file */

   get_value("P1", sourcename)
   FOR i = p TO 1 BY -1 DO
   $( LET c = sourcename%i

      IF c = ']' LOGOR c = ':' THEN
      $( dir := i
         BREAK
      $)

      IF c = '.' THEN
      $( ext := i
         BREAK
      $)
   $)

   /* Add default extension of '.B' if necessary */

   IF ext = 0 THEN
   $( ext := p + 1
      sourcename%ext := '.'
      sourcename%(ext + 1) := 'B'
      sourcename%0 := ext + 1
   $)

   $( LET sourcestream = findio(sourcename, findinput, bcpl_openin)

      selectinput(sourcestream)
   $)

   /* Open the OCODE file */

   $( s_writef(ocodename, "BCP%X8OCD.TMP", process_id)
      ocode := findio(ocodename, findoutput, bcpl_openout)
   $)

   /* Generate default names for listing and output files */

   FOR i = 1 TO sourcename%0 DO
   $( LET c = sourcename%(dir + i)

      outname%i   := c
      listname%i  := c
   $)

   $( LET l = sourcename%0

      outname%l         := 'V'          // Output filename
      outname%(l + 1)   := 'A'
      outname%(l + 2)   := 'L'
      outname%0         := l + 2

      listname%l        := 'L'          // Listing filename
      listname%(l + 1)  := 'I'
      listname%(l + 2)  := 'S'
      listname%0        := l + 2
   $)

   /* Open the listing file if required */

   $( LET lp = present("LISTING")

      IF lp = cli$_negated THEN prsource_ := FALSE
      IF lp = cli$????????????????????
   TEST present("LISTING") = cli$_present THEN
   $( prsource_ := TRUE
      listing := findio(listname, findoutput, bcpl_openout)
      selectoutput(listing)
      writef("*N*N*N*T*T*
              *University of Kent BCPL compiler - version D%N.%N*N*
              **N*N*N", version, edit)
   $)
   OR
   $( listing := sysout
      selectoutput(listing)
   $)

***Handle OBJECT qualifier

   /* Set code generator specific values */

   set_target_options(codegen)

   /* Set up the code generator command string */

   s_writef("%S %S %S/%S%C%C%C%C", control, cgname, ocodename, outname,
        cgparam,
        verbose_ -> 'V', ':',
        optimise_ -> ':', 'T',
        profile_ -> 'P', ':',
        assemble_ -> ':', 'N')

   IF verbose_ THEN message(journal, bcpl_version, version, edit)

   aptovec(comp, treesize)

   IF domapstore_ THEN mapstore()

   IF verbose_ THEN
      message(journal, bcpl_ph1comp, 0)

   IF prsource_ THEN
      message(listing, bcpl_ph1comp, 0)

   selectoutput(ocode)
   endwrite()

   IF total_reports NE 0 THEN
   $( deletefile(ocodename)
      fail(bcpl_enddiags, total_reports, (total_reports = 1 -> "", "s") << 2)
   $)

   TEST inhibitgen_ THEN
      stop(0)
   OR
     docommand(control)                // Call the code generator
$)

AND get_value(key, result) BE
$( LET key_d = VEC dsc$k_s_bln/bytesperword - 1
   AND res_d = VEC dsc$k_s_bln/bytesperword - 1
   AND status = ?
   AND len = ?

   key_d%dsc$w_length := key%0
   key_d%(dsc$w_length+1) := 0
   key_d%dsc$b_dtype := dsc$k_dtype_t
   key_d%dsc$b_class := dsc$k_class_s
   key_d!(dsc$a_pointer/bytesperword) := (key << 2) + 1

   res_d%dsc$w_length := maxstrlength/bytesperword
   res_d%(dsc$w_length+1) := 0
   res_d%dsc$b_dtype := dsc$k_dtype_t
   res_d%dsc$b_class := dsc$k_class_s
   res_d!(dsc$a_pointer/bytesperword) := (result << 2) + 1

   cli$get_value(key_d << 2, res_d << 2)

   str$trim(res_d << 2, res_d << 2, @len << 2)
   result%0 := len
$)

AND message(stream, n, a, b, c) BE
/* Obtains the message specified by 'n', and outputs it with specified
parameters. */
$( LET m = getmessage(n, 0)
   AND v = VEC maxstrlength/bytesperword
   AND args = VEC 2
   AND o = output()

   /* Put arguments into ascending address order */

   args!0 := a
   args!1 := b
   args!2 := c

   selectoutput(stream)
   IF a NE 0 THEN
   $( faostring(m, v, args)
      m := v
   $)
   IF second_ THEN
   $( m%1 := '-'
      second_ := FALSE
   $)
   writes(m); newline()

   selectoutput(o)
$)

AND present(key) = VALOF
$( LET key_d = VEC dsc$k_s_bln/bytesperword - 1
   AND status = ?

   key_d%dsc$w_length := key%0
   key_d%(dsc$w_length+1) := 0
   key_d%dsc$b_dtype := dsc$k_dtype_t
   key_d%dsc$b_class := dsc$k_class_s
   key_d!(dsc$a_pointer/bytesperword) := (key << 2) + 1

   status := cli$present(key_d << 2)

   RESULTIS (status & 1) NE 0
$)

AND s_writef(s, format, a, b, c, d, e, f, g, h, i, j, k) = VALOF
/* Version of 'writef' that writes to the string 's' instead of to
a stream. */
$( LET t = @a
   AND step = @b - @a
   AND save_wrch = wrch

   STATIC $( ocount = ?; ovec = ? $)

   LET s_wrch(ch) = VALOF
   $( ocount := ocount + 1
      ovec%ocount := ch
      RESULTIS 1
   $)

   wrch := s_wrch
   ocount, ovec := 0, s

   FOR p = 1 TO format%0 DO
   $( LET k = format%p

      TEST k = '%' THEN
      $( LET q, n = !t, 0
         AND type = format%(p + 1)
         AND f = ?

         p := p + 1
         SWITCHON type INTO
         $( DEFAULT   :  wrch(type); ENDCASE

            CASE 'S': CASE 's':  f := writes;   GOTO l
            CASE 'C': CASE 'c':  f := wrch;     GOTO l
            CASE 'X': CASE 'x':  f := writehex; GOTO m
            CASE 'I': CASE 'i':  f := writed;   GOTO m
            CASE 'N': CASE 'n':  f := writed;   GOTO l
                   m:  p := p + 1
                       n := format%p
                       IF 'a' LE n LE 'z' THEN n := n - 'a' + 'A'
                       n := '0' LE n LE '9' -> n - '0', n - 'A' + 10
                   l:  IF f(q, n) = 0 RESULTIS 0
            CASE '$':  t := t + step
         $)
      $)
      OR IF wrch(k) = 0 RESULTIS 0
   $)
   wrch := save_wrch
   s%0 := ocount

   RESULTIS 1
$)

AND set_defaults() BE
/* Set up default parameter values */
$( domapstore_, inhibitgen_, ppdebug_, pptrace_ := FALSE, FALSE, FALSE, FALSE
   optimise_, profile_, verbose_, xref_ := FALSE, FALSE, FALSE, FALSE
   prsource_ := NOT interactive
   treelist_, enablecode_ := FALSE, FALSE
   noget_, fold_const_ := FALSE, TRUE
   treesize, dvect, globdeclt, caset := 8000, 2400, 100, 150
   reportmax, total_reports, syntax_errors_ := maxreports, 0, FALSE

   codegen := cg.vaxvms
   assemble_, optimise_ := TRUE, FALSE
$)

AND advise(m, a, b, c) BE IF verbose_ \/ prsource_ THEN
/* Outputs the advisory message specified by 'm', with possible parameters
'a', 'b' and 'c'. */
$( LET mes = ?

   SWITCHON m INTO
   $( CASE adv_treesize:                // Tree size value
         mes := bcpl_treesiz
         ENDCASE

      CASE adv_freespace:               // Free space value
         mes := bcpl_freespa
         ENDCASE

      DEFAULT:
         RETURN
   $)
   IF verbose_ THEN
      message(journal, mes, a, b, c)

   IF prsource_ THEN
      message(listing, mes, a, b, c)
$)

AND compiler_error(class, subclass, line, info) BE
$( LET mes = ?
   AND value = ?

   SWITCHON class INTO
   $( CASE cerr_syn_message:           // Error in 'syn_message'
         mes := bcpl_compilerr
         value := 1
         ENDCASE

      CASE cerr_trn_message:           // Error in 'trn_message'
         mes := bcpl_compilerr
         value := 2
         selectoutput(listing)
         plist(info, 0, treeprintmax)
         newline()
         ENDCASE

      DEFAULT:                          // Unidentified error
         mes := bcpl_compilerr
         value := 3
         subclass := class
         line := 0
         ENDCASE
   $)
   backtrace()
   message(journal, bcpl_plsnotify, 0)
   second_ := TRUE
   fail(mes, value, subclass, line)
$)

AND ebcdic_code(ch) = /* astoeb%ch */ ch

AND fail(n, a, b, c) BE
/*  Outputs  the  message specified by 'n', with parameters 'a', 'b' and
'c', then stops with status 'n'. */
$( message(journal, n, a, b, c)

   stop(n \/ #X10000000)
$)

AND findio(file, r, err_code) = VALOF
/* Opens 'file' using routine 'r', yielding a stream pointer. Does not
return if there is any error; instead, an error is indicated using the
supplied error code 'err_code'. */
$( LET strp = r(file)

   IF strp = 0 THEN
   $( message(journal, err_code, file << 2)
      second_ := TRUE
      fail(result2, 0)
   $)

   RESULTIS strp
$)


AND gch() = VALOF
/* Yields the next input character, forced to upper case. */
$( LET k = rdch()

   IF k = '*T' RESULTIS '*S'

   RESULTIS 'a' <= k <= 'z' -> k - ('a'-'A'), k
$)

AND host_code(ch) = ch

AND report(mes, a, line, info, infopar) BE
$( LET o = output()

   reportcount := reportcount + 1

   selectoutput(sysout)

   FOR i = 0 TO 1 DO
   $( newline()
      writef(mes, a)
      writef(" near line %N*N", line)
      info(infopar)

      IF reportcount GE reportmax THEN writes("Abort*N")

      UNLESS prsource_ BREAK

      selectoutput(listing)
   $)

   selectoutput(o)

   IF reportcount GE reportmax THEN longjump(abort_p, abort_l)
$)

AND set_target_options(codegen) BE
/* Set up code generator-specific values. These affect certain compile-time
checks, and also the actual OCODE generated. */
$( SWITCHON codegen INTO
   $( CASE cg.vaxvms:
         target_bitsperword := 32
         minselectoroffset := -262144
         maxselectoroffset := 262143
         backstack_ := TRUE
         precallsize := 9
         savespacesize := 2
         charcode := host_code
         globlist_ := TRUE
         cgname := "BCPLCG"
         ENDCASE

      CASE cg.z80:
         target_bitsperword := 16
         minselectoroffset := -32768
         maxselectoroffset := 32767
         backstack_ := FALSE
         precallsize := 9
         savespacesize := 2
         charcode := host_code
         globlist_ := TRUE
         cgname := "BCPLZ80CG"
         ENDCASE
   $)
$)

 .


GET "syn.h"
GET "sys.h"

LET push_get() BE
$( LET directory_quoted_ = ?
   AND savecharcode = charcode
   AND libuser = ?
   AND sourcestream = ?
   AND name = ?
   AND v = VEC maxstrlength/bytesperword

   GET "libuser.h"                      // Define default username for library GET files

   charcode := host_code
   nextsymb()                           // Read the string describing the GET file
   charcode := savecharcode

   UNLESS symb = s.string DO syn_report(5)

   IF noget_ RETURN

   IF getp GE gett THEN
      fail(bcpl_getneslim, wordv << 2)

   getv!getp := input()
   getv!(getp + 1) := linecount
   getv!(getp + 2) := ch
   getp := getp + getitemsize
   linecount := 1
   directory_quoted_ := VALOF
   $( FOR i = 1 TO wordv%0 DO
         IF wordv%i = '[' RESULTIS TRUE
      RESULTIS FALSE
   $)
   name := wordv
   sourcestream := findinput(wordv)
   IF sourcestream = 0 & result2 = rms_filnotfnd THEN
      UNLESS directory_quoted_ DO       // File not found - try in library if no directory name given
      $( LET ulen = libuser%0

         FOR i = 1 TO ulen DO
            v%i := libuser%i

         FOR i = 1 TO wordv%0 DO
            v%(ulen + i) := wordv%i

         v%0 := ulen + wordv%0

         name := v
         sourcestream := findinput(v)
      $)

   IF sourcestream = 0 THEN
   $( message(journal, bcpl_openin, name << 2)
      second_ := TRUE
      fail(result2, 0)
   $)
   selectinput(sourcestream)
   rch()
$)

AND pop_get() BE
$( endread()
   getp := getp - getitemsize
   selectinput(getv!getp)
   linecount := getv!(getp+1)
   ch := getv!(getp+2)
$)

AND smallnumber(n) = 0 < n <= 255

// End of file: MAIN.B


