
// File b2.h

// Header file for BCPL code generator for DEC VAX-11 under VAX/VMS

// Copyright R.D. Eager   University of Kent   MCMLXXXVIII


GET "libhdr"

MANIFEST $(   // Compilation options for the codegenerator
debugging            = TRUE  // Set to TRUE during development and testing
metering_            = FALSE // Set to TRUE iff optimisation statistics are to be collected
$)

// Variables

GLOBAL $(
autoneeds            : 100   // Controls whether automatic NEEDS directives are generated for library references
tracing              : 101   // Controls whether tracing code is to be generated
profiling            : 102   // Controls whether profiling code is to be generated
conststrings         : 103   // Controls whether strings go into constant area
debug                : 104   // Controls inclusion of interactive debugging code
comments             : 105   // Number of comments to user
optimising           : 106   // TRUE iff optimisation to be done
labv                 : 107   // Vector of label addresses
labmap               : 108   // Base of static label bitmap
incompd              : 109   // Flag used in constant optimisation
hwglobal             : 110   // Highest global used
globrefmap           : 111   // Base of global reference bitmap
regloaded            : 112   // TRUE iff last call of MOVETOR actually generated code
incode_              : 113   // TRUE iff current point in code can be reached at runtime
ssp                  : 114   // Simulated stack pointer
ssf                  : 115   // Real value of stack front in simulation
tempv                : 116   // Base of simulated portion of stack
pendingop            : 117   // Pending OCODE operation
op                   : 118   // Current OCODE operation
arg1                 : 119   // Top item on simulated stack
arg2                 : 120   // Next-to-top item on simulated stack
globaln              : 121   // Number of GLOBALs to be initialised in current segment
slaves_a             : 122   // Vector of register slaves (address part)
slaves_v             : 123   // Vector of register slaves (value part)
slaves_k             : 124   // Vector of register slaves (constant part)
slaves_l             : 125   // Vector of register slaves (lock part)
globname             : 126   // Name of global vector
paramno              : 127   // Unique label generator
curarea              : 128   // Flag for current object area
cursect              : 129   // Label prefix generator (A, B, C, ...)
loadp                : 130   // Location counter
prev_ssp             : 131   // Used for communication between actions for STACK and RTRN
printstats           : 132   // TRUE iff optimisation statistics to be printed
staticchain          : 133   // Number of last label used in STATIC name chain
labt                 : 134   // Vector of label types
redlab               : 135   // Oldest current forward label reference
localno              : 136   // Unique local label generator
hwlabel              : 137   // Highest label generated by phase 1 seen so far
sectname             : 138   // Name of section being compiled
$)

// Routines

GLOBAL $(
compbranchlocal      : 141
nextlocal            : 142
complocal            : 143
inrange              : 144
compbranch           : 145
compbitbranch        : 146
genjumps             : 147
checklabrefs         : 148
cgbitjump            : 149
setarea              : 150
setbit               : 151
cgsave               : 152
complab              : 153
cgcall               : 154
clear_slaves         : 156
regusedby            : 157
cgswitch             : 158
discardslaves        : 159
cgreturn             : 160
compl                : 161
cgsection_or_needs   : 162
makeupper            : 163
compw                : 164
movetor              : 165
compwl               : 166
compilererror        : 167
asf                  : 168
con_rdch             : 169
cggoto               : 170
movetoanyr           : 171
invop                : 172
clear_bitmap         : 173
nextparam            : 174
numberis             : 175
slave                : 176
unslave              : 177
slaved               : 178
isfree               : 179
compn                : 180
nextreg              : 181
loadlv               : 182
cgen                 : 183
ioerror              : 184
trans                : 185
report               : 186
comment              : 187
cgputbyte            : 188
gencode              : 189
readop               : 190
readl                : 191
initstack            : 192
cgselect             : 193
clear_locks          : 194
moveconstant         : 195
cgpendingop          : 196
loadt                : 197
store                : 198
cgapply              : 199
freereg              : 200
storein              : 201
storei               : 202
cgbranch             : 203
check_locks          : 204
readnum              : 205
e_wrch               : 206
findslave            : 207
local                : 208
cgrv                 : 209
stack                : 210
cgstring             : 211
cgcode               : 212
cgentry              : 213
plant_profile        : 214
set_sf               : 215
comps                : 216
compd                : 217
compt                : 218
compq                : 219
lock                 : 220
unlock               : 221
locked               : 222
init_statistics      : 223
add_statistic        : 224
print_statistics     : 225
$)

// Selectors for items on simulated stack

MANIFEST $(
h1                   = 0     // Type of item
h2                   = 1     // Offset of item
h3                   = 2     // SSP for item
$)

// Types of item on simulated stack, in register slaves and as instruction modes

MANIFEST $(
k.glob               = 0     // Item in global vector
k.loc                = 1     // Local variable
k.numb               = 3     // Constant
k.reg                = 4     // Item in a register
k.fp                 = 5     // Item is value in FP plus a constant
k.gv                 = 6     // Item is address of global vector plus a constant
k.temp               = 8     // Item on stack - not local variable
k.none               = 9     // Item not one of above
k.abs                = 10    // @#n
k.autodec            = 11    // -(Rn)
k.autoinc            = 12    // (Rn)+
k.blab               = 13    // Branch label
k.extern             = 14    // External reference
k.lab                = 15    // Label
k.regdef             = 16    // (Rn)
k.stackdef           = 17    // Indirect item on simulated stack
k.imdl               = 18    // Address of a label
k.imglob             = 19    // Address of a global
k.stack              = 20    // Item on simulated stack
k.loclab             = 21    // Local label

k.index              = #X80000000
$)

// Types of register

MANIFEST $(
r.null               = -1    // Pseudo-register
r.r0                 = 0     // R0
r.r1                 = 1     // R1
r.r2                 = 2     // R2
r.r3                 = 3     // R3
r.r4                 = 4     // R4
r.r5                 = 5     // R5
r.r6                 = 6     // R6
r.r7                 = 7     // R7
r.r8                 = 8     // R8
r.r9                 = 9     // R9
r.r10                = 10    // R10
r.r11                = 11    // R11

r.ap                 = 12    // Argument pointer (also used as temporary)
r.fp                 = 13    // Frame pointer
r.sp                 = 14    // Stack pointer
r.pc                 = 15    // Program counter

numregs  = r.ap - r.r0 + 1   // Number of registers for allocation
$)

// Tunable MANIFESTs

MANIFEST $(
max.labels           = 1600  // Maximum number of compiler-generated labels
max.local.label      = 999   // Maximum number of local labels per segment
maxswitchlabels      = 300   // Maximum number of CASE labels in a SWITCHON
firstfreeglobal      = 100   // First global available for user programs
tempsize             = 3     // Size of an item in simulated stack
tempvsize            = 100   // Maximum number of items on simulated stack
slavesize            = 3     // Size of a register slave item
svsize               = 30    // Size of system vector
precallsize          = 9     // Size of linkage area for EXTERNAL precall sequence
$)

// Names of areas in object file

MANIFEST $(
a.none               = 0     // No area
a.code               = 1     // Code area
a.data               = 2     // Initialised data area
a.const              = 3     // Constant area
a.global             = 4     // Global vector
$)

// Types of label, recorded in label type vector

MANIFEST $(
l.null              = 0   // Unused entry
l.fwr               = 1   // A BRB instruction forward references this label
l.set               = 2   // This label has been set
l.chain             = 3   // This label has been set and chained to an M label
l.mset              = 4   // The M label has been set
l.mchain            = 5   // M label has been set, labelling jump to L label
l.static            = 6   // Static data label (not in code area)
$)

// Offsets of items in global vector

MANIFEST $(
gv.stop          =  4
$)

// OCODE operations

MANIFEST $(
s.none               = -1    // Pseudo-operation
s.end                = 0
s.true               = 4
s.false              = 5
s.rv                 = 8
s.fnap               = 10
s.mult               = 11
s.div                = 12
s.rem                = 13
s.plus               = 14
s.minus              = 15
s.query              = 16
s.neg                = 17
s.abs                = 19
s.eq                 = 20
s.ne                 = 21
s.ls                 = 22
s.gr                 = 23
s.le                 = 24
s.ge                 = 25
s.not                = 30
s.lshift             = 31
s.rshift             = 32
s.logand             = 33
s.logor              = 34
s.eqv                = 35
s.neqv               = 36
s.lp                 = 40
s.lg                 = 41
s.ln                 = 42
s.lstr               = 43
s.ll                 = 44
s.llp                = 45
s.llg                = 46
s.lll                = 47
s.needs              = 48
s.section            = 49
s.rtap               = 51
s.goto               = 52
s.finish             = 68
s.switchon           = 70
s.global             = 76
s.mc                 = 77
s.sp                 = 80
s.sg                 = 81
s.sl                 = 82
s.stind              = 83
s.slctap             = 84
s.jump               = 85
s.jt                 = 86
s.jf                 = 87
s.endfor             = 88
s.labx               = 89
s.lab                = 90
s.stack              = 91
s.store              = 92
s.rstack             = 93
s.entry              = 94
s.save               = 95
s.fnrn               = 96
s.rtrn               = 97
s.res                = 98
s.datalab            = 100
s.iteml              = 101
s.itemn              = 102
s.endproc            = 103
s.prcl               = 104   // VAX-11 specific; used to implement EXTERNALs
s.rtcall             = 105   // VAX-11 specific; used to implement EXTERNALs
s.fncall             = 106   // VAX-11 specific; used to implement EXTERNALs
s.slctst             = 107
s.labr               = 108
s.mark               = 109
s.getbyte            = 120
s.putbyte            = 121
$)

// Opcodes

MANIFEST $(
i.addl2              = 0
i.addl3              = 1
i.ashl               = 2
i.ashq               = 3
i.beql               = 4
i.bgeq               = 5
i.bgtr               = 6
i.bicl2              = 7
i.bicl3              = 8
i.bisl2              = 9
i.bisl3              = 10
i.bitl               = 11
i.blbc               = 12
i.blbs               = 13
i.bleq               = 14
i.blss               = 15
i.bneq               = 16
i.brb                = 17
i.brw                = 18
i.calls              = 19
i.casel              = 20
i.clrb               = 21
i.clrl               = 22
i.clrw               = 23
i.cmpl               = 24
i.cvtbl              = 25
i.cvtlb              = 26
i.cvtwl              = 27
i.decl               = 28
i.divl2              = 29
i.divl3              = 30
i.ediv               = 31
i.extzv              = 32
i.incl               = 33
i.insv               = 34
i.jmp                = 35
i.jsb                = 36
i.mcoml              = 37
i.mnegl              = 38
i.movb               = 39
i.movl               = 40
i.movq               = 41
i.movzbl             = 42
i.movzwl             = 43
i.mull2              = 44
i.mull3              = 45
i.pushl              = 46
i.rsb                = 47
i.subl2              = 48
i.subl3              = 49
i.tstl               = 50
i.xorl2              = 51
i.xorl3              = 52
$)

// Miscellaneous constants

MANIFEST $(
bitsperbyte          = bitsperword/bytesperword
$)

// End of file b2.h


