
// File b27.b

// 7 - Routine and function handling

GET "b2.h"

LET cgapply(op, k) BE
$( IF (ssp - k) GE 60 THEN
      report("too many parameters in a %S call", op = s.rtap -> "routine", "function")

   cgpendingop()

   store(0, ssp - 2)

   SWITCHON h1!arg1 INTO
   $( CASE k.glob:
      CASE k.lab:
      CASE k.loc:
         asf(60 - (ssp - k) + 2)
         comps(i.jsb, k.stackdef, arg1)
         ENDCASE

      DEFAULT:
      $( LET r = movetoanyr(arg1)

         asf(60 - (ssp - k) + 2)
         comps(i.jsb, k.regdef, r)
         ENDCASE
      $)
   $)

   clear_slaves()

   ssf := k
   stack(k)

   IF op = s.fnap THEN loadt(k.reg, r.r0)
$)

AND cgentry() BE
$( LET n = readnum()
   LET l = readl()
   AND v = VEC maxstrlength/bytesperword + 1

   FOR i = 1 TO n DO v%i := readnum()
   v%0 := n
   makeupper(v)

   writef(";*N; Entry point to *'%S*'*N;*N", v)

   complab(l, TRUE)

   IF tracing THEN
   $( LET ll = nextparam()
      AND m, a = 0, n

      checklabrefs(13)

      comps(i.jsb, k.extern, "BCP$ET")
      compwl(ll)
      setarea(a.const)
      compl(ll)
      FOR i = 1 TO n/bytesperword + 1 DO
      $( LET w = 0

         FOR j = 0 TO bitsperword - 1 BY bitsperbyte DO
         $( w := w \/ ((a & #XFF) << j)
            m := m + 1
            a := (m > n) -> 0, v%m
         $)
         compw(w)
      $)
      setarea(a.code)
   $)

   v%0 := n > 8 -> 8, n

   IF profiling THEN plant_profile()
$)

AND cgsave(n) BE
$( clear_slaves()
   comps(i.pushl, k.reg, r.fp)
   compt(i.addl3, k.numb, 62*bytesperword, k.reg, r.sp, k.reg, r.fp)
   compd(i.movq, k.autoinc, r.sp, k.loc, 1)
   IF n GE 60 THEN
      report("too many parameters declared in a routine or function")
   ssf := n
   initstack(n)
   ssf := 61
   op := readop()
   UNLESS op = s.stack \/ op = s.mark DO asf(n - 61)
$)

AND cgreturn() BE
$( cgpendingop()
   IF op = s.fnrn THEN
   $( movetor(r.r0, arg1)
      stack(ssp - 1)
   $)
   asf(2 - ssp)
   compd(i.movl, k.autoinc, r.sp, k.reg, r.fp)
   compn(i.rsb)
   incode_ := FALSE

   genjumps(50)

   UNLESS prev_ssp < 0 DO
   $( ssp := prev_ssp
      prev_ssp := -1
   $)
   initstack(ssp)
$)

AND cgcall(op) BE
$( LET k = readnum()
   AND v = VEC maxstrlength/bytesperword + 1
   LET l = readnum()
   AND offset = ?
   AND nargs = ?

   FOR i = 1 TO l DO
   $( LET c = readnum()

      v%i := c
   $)
   v%0 := l
   makeupper(v)

   cgpendingop()
   store(0, ssp - 1)
   nargs := ssp - k - precallsize

   FOR i = 0 TO nargs - 1 DO
      compd(i.movl, k.autoinc, r.sp, k.loc, k + i)

   asf(-precallsize + nargs)
   cgsection_or_needs(s.needs, v)
   compd(i.calls, k.numb, nargs, k.extern, v)

   clear_slaves()
   ssf := k
   stack(k)
   IF op = s.fncall THEN loadt(k.reg, r.r0)
$)

AND cgsection_or_needs(op, s) BE
$( makeupper(s)
   setarea(a.code)
   TEST op = s.section THEN
   $( sectname := getvec(s%0/bytesperword)
      IF sectname = 0 THEN report("insufficient virtual memory")

      FOR i = 0 TO s%0 DO sectname%i := s%i

      writef("%S::*N", s)
   $)
   OR
   $( IF sectname = 0 \/ (NOT match(s, sectname)) THEN
         writef("*T.EXTERNAL*T%S*N", s)
   $)
$)

AND match(s1, s2) = VALOF
$( LET l = s1%0

   IF l NE s2%0 RESULTIS FALSE

   FOR i = 1 TO l DO
      IF s1%i NE s2%i RESULTIS FALSE

   RESULTIS TRUE
$)

AND makeupper(s) BE
$( FOR i = 1 TO s%0 DO
   $( LET c = s%i

      IF 'a' LE c LE 'z' THEN s%i := c - ('a' - 'A')
   $)
$)

// End of file b27.b


