
// File b29.b

// 9 - Branch and jump handling

GET "b2.h"

LET cggoto() BE
$( cgpendingop()

   store(0, ssp - 2)

   SWITCHON h1!arg1 INTO
   $( DEFAULT:
         movetoanyr(arg1)   // Drop through

      CASE k.glob:
      CASE k.lab:
      CASE k.loc:
         comps(i.jmp, k.stackdef, arg1)
         ENDCASE
   $)
   stack(ssp - 1)
   incode_ := FALSE
   genjumps(40)
$)

AND cgbranch(b, l) BE
$( LET f = ?
   AND r = ?
   AND rand1, rand2 = arg1, arg2

   SWITCHON pendingop INTO
   $( DEFAULT:        cgpendingop()
                      store(0, ssp - 2)
                      IF local(arg1) THEN h1!arg1, h2!arg1 := k.autoinc, r.sp
                      comps(i.tstl, h1!arg1, h2!arg1)
                      stack(ssp - 1)
                      compbranch(b -> i.bneq, i.beql, k.blab, l)
                      RETURN

      CASE s.ne:      b := NOT b
      CASE s.eq:      f := b -> i.beql, i.bneq
                      ENDCASE

      CASE s.ls:      b := NOT b
      CASE s.ge:      f := b -> i.bgeq, i.blss
                      ENDCASE

      CASE s.le:      b := NOT b
      CASE s.gr:      f := b -> i.bgtr, i.bleq
                      ENDCASE
   $)
   store(0, ssp - 3)

   UNLESS h1!arg2 = k.reg DO
   $( r := findslave(h1!arg2, h2!arg2, 0)
      IF r NE r.null THEN
      $( h1!arg2, h2!arg2 := k.reg, r
         IF metering_ THEN add_statistic(24)
      $)
   $)
   UNLESS h1!arg1 = k.reg DO
   $( r := findslave(h1!arg1, h2!arg1, 0)
      IF r NE r.null THEN
      $( h1!arg1, h2!arg1 := k.reg, r
         IF metering_ THEN add_statistic(24)
      $)
   $)

   // It is essential that the call of STACK below should not generate code
   // which might alter the condition codes. Thus, any temporary items for
   // ARG1 or ARG2 are converted so that they are 'popped' from the stack
   // during the course of the test.

   IF local(arg1) & local(arg2) THEN rand1, rand2 := arg2, arg1   // For safety
   IF local(rand1) THEN h1!rand1, h2!rand1 := k.autoinc, r.sp
   IF local(rand2) THEN h1!rand2, h2!rand2 := k.autoinc, r.sp

   TEST numberis(0, rand1) THEN
      comps(i.tstl, h1!rand2, h2!rand2)
   OR TEST numberis(0, rand2) THEN
   $( f := invop(f)
      comps(i.tstl, h1!rand1, h2!rand1)
   $)
   OR
      compd(i.cmpl, h1!rand2, h2!rand2, h1!rand1, h2!rand1)

   stack(ssp - 2)
   checklabrefs(9)
   compbranch(f, k.blab, l)
$)

AND cgbitjump(rel, jump, l) BE
$( LET rand1, rand2 = arg1, arg2
   AND eqsw = rel = s.eq
   AND jtsw = jump = s.jt
   LET f = eqsw EQV jtsw -> i.beql, i.bneq

   IF h1!arg2 = k.numb THEN rand1, rand2 := arg2, arg1

   TEST numberis(1, rand1) THEN
   $( f := f = i.beql -> i.blbc, i.blbs
      compbitbranch(f, h1!rand2, h2!rand2, k.lab, l)
   $)
   OR
   $( compd(i.bitl, h1!rand1, h2!rand1, h1!rand2, h2!rand2)
      compbranch(f, k.lab, l)
   $)
   stack(ssp - 2)
$)

AND invop(op) = VALOF SWITCHON op INTO
   $( CASE i.beql:
      CASE i.bneq:  RESULTIS op
      CASE i.blss:  RESULTIS i.bgtr
      CASE i.bgtr:  RESULTIS i.blss
      CASE i.bleq:  RESULTIS i.bgeq
      CASE i.bgeq:  RESULTIS i.bleq
      DEFAULT    :  compilererror("bad op in INVOP - %N", op)
   $)

AND revop(op) = VALOF SWITCHON op INTO
   $( CASE i.beql:  RESULTIS i.bneq
      CASE i.bneq:  RESULTIS i.beql
      CASE i.blss:  RESULTIS i.bgeq
      CASE i.bgtr:  RESULTIS i.bleq
      CASE i.bleq:  RESULTIS i.bgtr
      CASE i.bgeq:  RESULTIS i.blss
      DEFAULT    :  compilererror("bad op in REVOP - %N", op)
   $)

AND cgcode(n) BE
$( LET v = VEC maxstrlength/bytesperword + 1

   checklabrefs(1000)

   FOR i = 1 TO n DO v%i := readnum()
   v%0 := n

   writes(v)
   IF v%n NE '*N' THEN newline()
$)

AND plant_profile() BE
$( LET p = nextparam()

   setarea(a.data)
   compl(p)
   compw(0)   // Allocate space for the profile counter

   setarea(a.code)
   checklabrefs(20)
   compd(i.movl, k.reg, r.r0, k.reg, r.r0)   // No-op (unique pattern marking profile code)
   comps(i.incl, k.lab, p)
$)

AND set_sf(newsf) BE
$( compt(i.subl3, k.numb, (newsf - 1)*bytesperword, k.reg, r.fp, k.reg, r.sp)
   ssf := newsf
$)

AND asf(n) BE UNLESS n = 0 DO
$( LET oldssf = ssf

   TEST ABS n = 1 THEN
   $( comps(i.tstl, n > 0 -> k.autodec, k.autoinc, r.sp)
      IF metering_ THEN add_statistic(2)
   $)
   OR
      compd(n > 0 -> i.subl2, i.addl2, k.numb, ABS n*bytesperword, k.reg, r.sp)

   IF n < 0 THEN
      FOR i = oldssf - 1 TO oldssf - n - 1 DO
         discardslaves(k.loc, i)

   ssf := oldssf + n
$)


/* Treatment of label references
 * --------- -- ----- ----------
 *
 * The VAX-11 has short range and long range unconditional branches, but
 * only short range conditional branches. This causes problems with
 * forward jumps.
 *
 * The basic strategy adopted is that a forward jump is assumed to be in
 * range until proved otherwise, and if necessary a transfer jump is generated
 * when the forward range is exceeded.
 *
 * The current state of each label is recorded in the 'labt' vector, and is one
 * of the following:
 *
 *    l.null    : unreferenced
 *    l.fwr     : a short forward reference ('brb' or conditional) exists
 *                to this label
 *    l.set     : the label has been set (and will be Lxnnn, where 'x' is
 *                a letter unique to the section of code (call of 'trans')
 *                and 'nnn' is the label number)
 *    l.chain   : a transfer jump has been generated for the label, which
 *                is revised to the name Mxnnn
 *    l.mset    : the Mxnnn label has been set (the final setting point)
 *    l.mchain  : a long backward jump has been made to the label. This
 *                may be used to optimise long backward jumps to the same
 *                label into shorter ones
 *    l.static  : label is not in a code area, and no special treatment
 *                is needed as it will never be branched to
 *
 * The setting point of the label is recorded in the 'labv' vector, and
 * takes various values depending on the corresponding contents of 'labt':
 *
 *    l.null    : nothing
 *    l.fwr     : load point of OLDEST (i.e. first) forward reference
 *    l.set     : load point of label
 *    l.chain   : load point of transfer jump
 *    l.mset    : load point of final setting
 *    l.mchain  : load point of long backward jump
 *
 * The oldest current forward reference is recorded in the global 'redlab',
 * which is of course the label most nearly out of range
 *
 * It is necessary periodically to check whether a label is going out of
 * range, and this is done by 'checklabrefs'. This takes as its parameter
 * the number of bytes we propose to generate next. Usually this will be the
 * maximum possible size of the next instruction, but sometimes it is the size
 * of a stylised sequence that should not be broken up.
 *
 * In addition, since it is best to generate transfer jumps while we are not
 * actually in code, the routine 'genjumps' is called after a jump (caused
 * by JUMP, GOTO, RTRN or FNRN). It takes a heuristic parameter that forces the
 * generation of transfer jumps for labels 'nearly' out of range - too bad if
 * they are just about to be set!
 *
 */

AND compbranch(op, type, l) BE
$( UNLESS l = 0 DO
   $( addlabref(l)
      TEST inrange(l, 0) THEN
         comps(op, type, l)
      OR
      $( LET lx = -1

         UNLESS op = i.brb DO
         $( lx := nextlocal()
            comps(revop(op), k.loclab, lx)
         $)
         comps(i.brw, type, l)
         IF lx GE 0 THEN complocal(lx)
      $)
      IF op = i.brb THEN
      $( incode_ := FALSE
         UNLESS l = redlab DO genjumps(40)
      $)
   $)
$)

AND compbranchlocal(op, type, l) BE
$( comps(op, type, l)
   IF op = i.brb THEN
   $( incode_ := FALSE
      genjumps(40)
   $)
$)

AND compbitbranch(op, x1, x2, type, lab) BE
$( compd(op, x1, x2, type, lab)
$)

AND checklabrefs(n) BE
/* Check if any label will go out of range in the next 'n' bytes; if so,
generate a transfer jump. */
$( setarea(a.code)

   UNLESS inrange(redlab, n) DO
   $( LET l = ?
      AND oldincode_ = incode_

      IF incode_ THEN
      $( l := nextparam()
         writef("*TBRB*TL%C%N*N", cursect, l)   // Not 'comps' lest recursive loop
         loadp := loadp + 2
      $)
      genjumps(n + 40)
      IF oldincode_ DO
      $( incode_ := oldincode_
         compl(l)
      $)
   $)
$)

AND genjumps(n) BE
/*  Generate transfer jumps for all labels within 'n' bytes of going out
of range. */
$( setarea(a.code)

   UNTIL inrange(redlab, n) DO
   $( LET n = redlab

      compl(n)
      writef("*TBRW*TM%C%N*N", cursect, n)
      labt!n := l.chain
      loadp := loadp + 3
   $)
$)

AND addlabref(l) BE
/* Add a forward reference to the label state. This is necessary only on
the first reference to an unset label. */
$( IF incode_ & labt!l = l.null THEN
   $( labt!l, labv!l := l.fwr, loadp
      IF redlab = 0 THEN redlab := l
   $)
$)

AND inrange(l, n) =
/*  Check  whether  the  next 'n' bytes of code are going to stay within
range of the label 'l'. This is true if 'l' is set close enough,  or  if
the  first  forward reference to it is close enough that a transfer jump
will not be needed in the next 'n' bytes. */
   labt!l = l.null \/
   loadp-labv!l+n LE 125 -> TRUE, FALSE

// End of file b29.b


