
// File b2c.b

// C - Code planting routines

GET "b2.h"

LET comp(mode, arg) BE
$( LET size = 1

   SWITCHON mode & #XFFFF INTO
   $( CASE k.reg:              writes(regname(arg)); ENDCASE

      CASE k.autodec:          wrch('-')
                               IF arg = r.sp THEN ssf := ssf + 1

      CASE k.regdef:           writef("(%S)", regname(arg)); ENDCASE

      CASE k.temp:             IF arg NE ssf - 1 THEN
                                  compilererror("bad ARG in COMP(TEMP) - %N", arg)
                               arg := r.sp   // Drop through

      CASE k.autoinc:          writef("(%S)+", regname(arg))
                               IF arg = r.sp THEN ssf := ssf - 1
                               ENDCASE

      CASE k.abs:              writef("@#%N", arg); size := 5; ENDCASE

      CASE k.numb:             writef("#%N", arg)
                               UNLESS 0 LE arg LE 63 DO size := 5
                               ENDCASE

      CASE k.stackdef:         wrch('@')

      CASE k.stack:            comp(h1!arg, h2!arg)
                               size := 0
                               ENDCASE

      CASE k.imdl:             wrch('#')

      CASE k.blab:
      CASE k.lab:              writef("L%C%N", cursect, arg)
                               size := 5
                               ENDCASE

      CASE k.loclab:           writef("LOC%N", arg)
                               ENDCASE

      CASE k.imglob:           wrch('#')

      CASE k.glob:             writef("%S+%N", globname, (arg + svsize)*bytesperword)
                               IF arg > hwglobal THEN hwglobal := arg
                               IF 0 < arg < firstfreeglobal THEN setbit(globrefmap, arg)
                               size := 5
                               ENDCASE

      CASE k.extern:           writef("G^%S", arg)
                               size := 5
                               ENDCASE

      CASE k.loc:              writef("%N(%S)", -arg*bytesperword, regname(r.fp))
                               size := 5
                               ENDCASE

      DEFAULT:                 compilererror("bad MODE in COMP - %N", mode)
   $)

   IF (mode & k.index) NE 0 THEN
   $( LET reg = (mode & NOT k.index) >> 16

      writef("[%S]", regname(reg))
      size := size + 1
   $)
   loadp := loadp + size
$)

AND compf(op) BE
$( LET s = VALOF SWITCHON op INTO
   $(
      CASE i.addl2 :  RESULTIS "ADDL2"
      CASE i.addl3 :  RESULTIS "ADDL3"
      CASE i.ashl  :  RESULTIS "ASHL"
      CASE i.ashq  :  RESULTIS "ASHQ"
      CASE i.beql  :  RESULTIS "BEQL"
      CASE i.bgeq  :  RESULTIS "BGEQ"
      CASE i.bgtr  :  RESULTIS "BGTR"
      CASE i.bicl2 :  RESULTIS "BICL2"
      CASE i.bicl3 :  RESULTIS "BICL3"
      CASE i.bisl2 :  RESULTIS "BISL2"
      CASE i.bisl3 :  RESULTIS "BISL3"
      CASE i.bitl  :  RESULTIS "BITL"
      CASE i.blbc  :  RESULTIS "BLBC"
      CASE i.blbs  :  RESULTIS "BLBS"
      CASE i.bleq  :  RESULTIS "BLEQ"
      CASE i.blss  :  RESULTIS "BLSS"
      CASE i.bneq  :  RESULTIS "BNEQ"
      CASE i.brb   :  RESULTIS "BRB"
      CASE i.brw   :  RESULTIS "BRW"
      CASE i.calls :  RESULTIS "CALLS"
      CASE i.casel :  RESULTIS "CASEL"
      CASE i.clrb  :  RESULTIS "CLRB"
      CASE i.clrl  :  RESULTIS "CLRL"
      CASE i.clrw  :  RESULTIS "CLRW"
      CASE i.cmpl  :  RESULTIS "CMPL"
      CASE i.cvtbl :  RESULTIS "CVTBL"
      CASE i.cvtlb :  RESULTIS "CVTLB"
      CASE i.cvtwl :  RESULTIS "CVTWL"
      CASE i.decl  :  RESULTIS "DECL"
      CASE i.divl2 :  RESULTIS "DIVL2"
      CASE i.divl3 :  RESULTIS "DIVL3"
      CASE i.ediv  :  RESULTIS "EDIV"
      CASE i.extzv :  RESULTIS "EXTZV"
      CASE i.incl  :  RESULTIS "INCL"
      CASE i.insv  :  RESULTIS "INSV"
      CASE i.jmp   :  RESULTIS "JMP"
      CASE i.jsb   :  RESULTIS "JSB"
      CASE i.mcoml :  RESULTIS "MCOML"
      CASE i.mnegl :  RESULTIS "MNEGL"
      CASE i.movb  :  RESULTIS "MOVB"
      CASE i.movl  :  RESULTIS "MOVL"
      CASE i.movq  :  RESULTIS "MOVQ"
      CASE i.movzbl:  RESULTIS "MOVZBL"
      CASE i.movzwl:  RESULTIS "MOVZWL"
      CASE i.mull2 :  RESULTIS "MULL2"
      CASE i.mull3 :  RESULTIS "MULL3"
      CASE i.pushl :  RESULTIS "PUSHL"
      CASE i.rsb   :  RESULTIS "RSB"
      CASE i.subl2 :  RESULTIS "SUBL2"
      CASE i.subl3 :  RESULTIS "SUBL3"
      CASE i.tstl  :  RESULTIS "TSTL"
      CASE i.xorl2 :  RESULTIS "XORL2"
      CASE i.xorl3 :  RESULTIS "XORL3"
      DEFAULT      :  compilererror("illegal OP in COMPF - %N", op)
   $)

   loadp := loadp + 1
   setarea(a.code)
   writef("*T%S*T", s)
$)

AND compn(op) BE IF incode_ THEN
$( compf(op)
   newline()
$)

AND comps(op, m1, a1) BE IF incode_ THEN
$( TEST op = i.pushl & m1 = k.numb & ((-32768 LE a1 LE -1) \/ (64 LE a1 LE 32767)) THEN
   $( moveconstant(a1, k.autodec, r.sp)
      IF metering_ THEN add_statistic(1)
   $)
   OR
   $( checklabrefs(7)
      compf(op)
      comp(m1, a1)
      newline()
      IF op = i.pushl THEN ssf := ssf + 1
   $)
$)

AND compd(op, m1, a1, m2, a2) BE IF incode_ THEN
$( TEST op = i.movl & m1 = k.numb & NOT incompd THEN
   $( incompd := TRUE
      moveconstant(a1, m2, a2)
      incompd := FALSE
      IF metering_ THEN add_statistic(0)
   $)
   OR TEST op = i.movb & m1 = k.numb & a1 = 0 THEN
   $( comps(i.clrb, m2, a2)
      IF metering_ THEN add_statistic(25)
   $)
   OR
   $( checklabrefs(13)
      compf(op)
      comp(m1, a1)
      wrch(',')
      comp(m2, a2)
      newline()
   $)
$)

AND compt(op, m1, a1, m2, a2, m3, a3) BE IF incode_ THEN
$( checklabrefs(19)
   compf(op)
   comp(m1, a1)
   wrch(',')
   comp(m2, a2)
   wrch(',')
   comp(m3, a3)
   newline()
$)

AND compq(op, m1, a1, m2, a2, m3, a3, m4, a4) BE IF incode_ THEN
$( checklabrefs(25)
   compf(op)
   comp(m1, a1)
   wrch(',')
   comp(m2, a2)
   wrch(',')
   comp(m3, a3)
   wrch(',')
   comp(m4, a4)
   newline()
$)

AND compl(l) BE
$( LET t = labt!l

   IF curarea NE a.code & t NE l.static THEN
      t, labt!l := l.static, l.static

   TEST t = l.static THEN
      writef("L%C%N:*N", cursect, l)
   OR TEST t = l.null \/ t = l.fwr THEN
   $( writef("L%C%N:*N", cursect, l)
      labt!l := l.set
      redlab := 0
      FOR i = 1 TO max.labels DO
         IF labt!i = l.fwr & labv!i < labv!redlab DO redlab := i
   $)
   OR
   $( writef("M%C%N:*N", cursect, l)
      labt!l := l.mset
   $)
   labv!l := loadp

   incode_ := TRUE
$)

AND complocal(l) BE
$( writef("LOC%N:*N", l)
   incode_ := TRUE
$)

AND compwl(l) BE
$( writef("*T.ADDRESS*TL%C%N*N", cursect, l)
$)

AND compw(n) BE
$( writef("*T.LONG*T^X%X8*N", n)
$)

AND cgstring(n) BE
$( LET wordlength = n/bytesperword + 1
   AND m, a = 0, n
   AND l = nextparam()

   IF incode_ THEN
   $( loadlv(k.lab, l)

      setarea(conststrings -> a.const, a.data)
      compl(l)
   $)

   FOR i = 1 TO wordlength DO
   $( LET w = 0

      FOR j = 0 TO bitsperword - 1 BY bitsperbyte DO
      $( w := w \/ ((a & #XFF) << j)
         m := m + 1
         a := (m > n) -> 0, readnum()
      $)
      IF incode_ THEN compw(w)
   $)
   IF incode_ THEN setarea(a.code)
$)

AND regname(r) = VALOF SWITCHON r INTO
$( CASE r.r0  :   RESULTIS "R0"
   CASE r.r1  :   RESULTIS "R1"
   CASE r.r2  :   RESULTIS "R2"
   CASE r.r3  :   RESULTIS "R3"
   CASE r.r4  :   RESULTIS "R4"
   CASE r.r5  :   RESULTIS "R5"
   CASE r.r6  :   RESULTIS "R6"
   CASE r.r7  :   RESULTIS "R7"
   CASE r.r8  :   RESULTIS "R8"
   CASE r.r9  :   RESULTIS "R9"
   CASE r.r10 :   RESULTIS "R10"
   CASE r.r11 :   RESULTIS "R11"
   CASE r.ap  :   RESULTIS "AP"
   CASE r.fp  :   RESULTIS "FP"
   CASE r.sp  :   RESULTIS "SP"
   CASE r.pc  :   RESULTIS "PC"

   DEFAULT    :   compilererror("bad register in REGNAME - X%X2", r)
$)

AND setarea(a) BE UNLESS curarea = a DO
$( LET s = VALOF SWITCHON a INTO
   $( CASE a.code  :   RESULTIS "CODE,CON,GBL,SHR,EXE,NOWRT"
      CASE a.const :   RESULTIS "STATIC,CON,LCL,NOSHR,NOEXE,WRT"
      CASE a.data  :   RESULTIS "STATIC,CON,LCL,NOSHR,NOEXE,WRT"
      CASE a.global:   RESULTIS "GLOBAL,OVR,GBL,NOSHR,NOEXE,WRT"

      DEFAULT      :   compilererror("bad A in SETAREA - %N", a)
   $)
   writef(";*N*T.PSECT*T%S,LONG*N;*N", s)
   curarea := a
$)

// End of file b2c.b


