
// File BLIB.B

// BCPL part of standard BCPL library on DEC VAX-11 under VMS

// Copyright R.D.Eager   University of Kent   MCMLXXXVIII


SECTION "BCP$BLIB"

GET "libhdr"
GET "rtshdr"
GET "libmsg"

LET writed(n, d) = VALOF
$( LET t = VEC 10/bytesperword
   AND i, k = 0, n

   IF (n NE 0) & ((n << 1) = 0) THEN
      RESULTIS writes("-2147483648")

   IF n < 0 THEN d, k := d - 1, -n

   $( t%i := k REM 10
      k, i := k/10, i + 1
   $) REPEATUNTIL k = 0

   FOR j = i + 1 TO d DO
      IF wrch('*S') = 0 RESULTIS 0

   IF n < 0 THEN
      IF wrch('-') = 0 RESULTIS 0

   FOR j = i - 1 TO 0 BY -1 DO
     IF wrch(t%j + '0') = 0 RESULTIS 0

   RESULTIS 1
$)

AND readnumber(radix) = VALOF
$( LET sum, neg_, sign = 0, FALSE, +1

   $( terminator := rdch()
      SWITCHON terminator INTO
      $( CASE '-' : neg_ := TRUE
         CASE '+' : terminator := rdch()
         DEFAULT  : BREAK
         CASE '*S':
         CASE '*T':
         CASE '*C':
         CASE '*N':
         CASE '*P':
      $)
   $) REPEAT

   $( LET c = '0' LE terminator LE '9' -> terminator - '0',
              'a' LE terminator LE 'z' -> terminator - 'a' + 10,
              'A' LE terminator LE 'Z' -> terminator - 'A' + 10,
                                          63

      IF c GE radix RESULTIS sum
      sum := sum*radix + c*sign
      IF neg_ & sum NE 0 THEN
      $( sum := -sum
         sign := -1
         neg_ := FALSE
      $)
      terminator := rdch()
   $) REPEAT
$)

AND writef(format, a, b, c, d, e, f, g, h, i, j, k) = VALOF
$( LET t = @a

   FOR p = 1 TO format%0 DO
   $( LET k = format%p

      TEST k = '%' THEN
      $( LET q, n = !t, 0
         AND type = format%(p + 1)
         AND f = ?

         p := p + 1
         SWITCHON type INTO
         $( DEFAULT   :  wrch(type); ENDCASE

            CASE 'S': CASE 's':  f := writes;   GOTO l
            CASE 'C': CASE 'c':  f := wrch;     GOTO l
            CASE 'O': CASE 'o':  f := writeoct; GOTO m
            CASE 'X': CASE 'x':  f := writehex; GOTO m
            CASE 'I': CASE 'i':  f := writed;   GOTO m
            CASE 'N': CASE 'n':  f := writed;   GOTO l
                   m:  p := p + 1
                       n := format%p
                       IF 'a' LE n LE 'z' THEN n := n - 'a' + 'A'
                       n := '0' LE n LE '9' -> n - '0', n - 'A' + 10
                   l:  IF f(q, n) = 0 RESULTIS 0
            CASE '$':  t := t - 1
         $)
      $)
      OR IF wrch(k) = 0 RESULTIS 0
   $)
   RESULTIS 1
$)

AND packstring(v, s) = VALOF
$( LET last_word = !v/bytesperword

   s!last_word := 0
   FOR i = 0 TO !v DO s%i := v!i
   RESULTIS last_word
$)

AND unpackstring(s, v) BE
   FOR i = 0 TO s%0 DO v!i := s%i

AND writeoct(n, p) = VALOF
$( IF p > 1 THEN
      IF writeoct(n >> 3, p - 1) = 0 RESULTIS 0
   RESULTIS wrch((n & #7) + '0')
$)

AND writehex(n, p) = VALOF
$( LET m = n & #X0F

   IF p > 1 THEN
      IF writehex(n >> 4, p - 1) = 0 RESULTIS 0
   RESULTIS wrch(m + (m < 10 -> '0', 'A' - 10))
$)

AND writes(s) = VALOF
$( FOR i = 1 TO s%0 DO IF wrch(s%i) = 0 RESULTIS 0
   RESULTIS 1
$)

AND writeo(n) = writeoct(n, 11)

AND writeh(n) = writehex(n, 8)

AND writen(n) = writed(n, 0)

AND newline() = wrch('*N')

AND newpage() = wrch('*P')

AND readn() = readnumber(10)

AND sv.absent(addr) BE
/* Handles calls to undefined globals. On entry, 'addr' is the return
link stacked by the illegal call (i.e., the address of the instruction
following that call). */
$( LET sigarray = VEC 3
   AND globno = global_number_from_address(addr)   // Number of global being called
                                                   // 'minint' if number cannot be deduced
   sigarray!0 := 3
   sigarray!1 := globno = minint -> bcplrtl_undefglob, bcplrtl_undefglobn
   sigarray!2 := addr
   sigarray!3 := globno

   TEST contingency NE 0 & contingency NE sv.undefglob THEN
   $( contingency(sigarray, 0, 0)
      stop(bcplrtl_retcon)
   $)
   OR stop(bcplrtl_undefglob)

$)

AND global_number_from_address(addr) = VALOF
$( LET iad = addr - 6                   // Try for longword displacement first
   AND length = ?
   AND disp = ?
   AND gno = ?

   UNLESS sv.lowcode LE addr LE sv.highcode RESULTIS minint
                                        // Outside code area

   TEST 0%iad = i.jsb & 0%(iad + 1) = m.relpcldef THEN
      length := 4
   OR
   $( iad := iad + 2                    // Try for a word displacment
      TEST 0%iad = i.jsb & 0%(iad + 1) = m.relpcwdef THEN
         length := 2
      OR
         RESULTIS minint
   $)

   iad := iad + 2                       // Move to displacement part

   FOR i = length - 1 TO 0 BY -1 DO
      disp := (disp << 8) \/ 0%(iad + i)   // Get 2- or 4-byte displacement

   IF length = 2 & (disp & #X8000) NE 0 THEN   // Sign-extend word displacement
      disp := disp \/ #XFFFF0000

   iad := iad + disp + length           // Point to routine cell

   IF sv.lowcode LE iad LE sv.highcode RESULTIS minint
                                        // Inside code area!

   gno := (iad >> 2) - @start + 1       // Get true global number

   RESULTIS -svsize LE gno LE globalsize -> gno, minint
$)

// End of file BLIB.B


