
// File DEBUG.B

// Debugging support routine for BCPL on DEC VAX-11 under VMS

// Copyright R.D.Eager   University of Kent   MCMLXXXVIII


SECTION "BCP$DEBUG"

GET "libhdr"
GET "rtshdr"
GET "libmsg"

MANIFEST $(   // Opcode and address mode values
m.autoincsp	= #X8E
m.autodecr12	= #X7C
m.relwr10	= #XCA
m.relwr9	= #XC9
$)

STATIC $(
user_wrch       = 0   // Copy of user 'wrch'
$)

LET contingency(sigarray, mecharray, p) BE
$( LET v1 = VEC 2
   AND v2 = VEC 2
   AND nsargs = sigarray!0
   AND condition_name = sigarray!1
   AND mes = ?
   AND mes2 = VEC maxstrlength/bytesperword
   AND mes3 = VEC maxstrlength/bytesperword
   AND mes4 = VEC maxstrlength/bytesperword
   AND diagout = journal
   AND dumpfile = "BCPLDEBUG.LIS"

   user_wrch := wrch   // Save for diagnostics

   wrch := sv.wrch   // Use real 'wrch', in case it was reassigned

   IF sv.errflag THEN
      condition_name := bcplrtl_diagfailoop

   sv.errflag := TRUE

   mes := getmessage(condition_name, 0)

   IF condition_name = bcplrtl_diagfailoop THEN
   $( selectoutput(journal)
      writes(mes); newline()
//    stop(bcplrtl_diagfailoop)
      stop(0)
   $)

   faostring(mes, mes2, sigarray + 2)
   mes := mes2

   TEST condition_name = bcplrtl_undefglobn & sigarray!3 NE minint THEN
   $( faostring(getmessage(bcplrtl_globno, 0), mes3, sigarray+3)
      IF mes3%1 = '%' THEN mes3%1 := '-'
   $) OR mes3 := 0

   IF interactive THEN
   $( diagout := findoutput(dumpfile)
      TEST diagout NE 0 THEN
      $( selectoutput(journal)
         writef("%S*N", mes)
         dumpfile := dumpfile << 2
         faostring(getmessage(bcplrtl_dumploc, 0), mes4, @dumpfile)
         IF mes4%1 = '%' THEN mes4%1 := '-'
         IF mes3 NE 0 THEN writef("%S*N", mes3)
         writef("%S*N", mes4)
      $)
      OR diagout := journal
   $)
   selectoutput(diagout)

   writef("*NProgram failure on %S at %S*N*N", date(v1), timeofday(v2))
   writef("%S*N", mes)

   IF mes3 NE 0 THEN writef("%S*N", mes3)

   IF mecharray NE 0 THEN
      mapregs(mecharray, p, p!2, p!3, (p + 31) << 2, sigarray!(nsargs - 1), sigarray!nsargs)
   backtrace()
   postmortem((p!3) >> 2, p + 31, sigarray!(nsargs - 1))
   mapglobals(1, globalsize)
// mapstatics()
   mapcode(sigarray!(nsargs-1))
   mapstore()

   UNLESS userpostmortem = 0 \/ userpostmortem = sv.undefglob DO
      userpostmortem(0)

   stop(condition_name \/ #x10000000)
$)

AND mapregs(mech, p, ap, fp, sp, pc, psl) BE
$( writes("*N*NMachine registers:*N*N")

   FOR i = 0 TO 16 DO
   $( LET value = VALOF SWITCHON i INTO
      $( CASE 00:
         CASE 01:   RESULTIS mech!(i+3)
         CASE 02:
         CASE 03:
         CASE 04:
         CASE 05:
         CASE 06:
         CASE 07:
         CASE 08:
         CASE 09:
         CASE 10:
         CASE 11:   RESULTIS p!(i + 3)
         CASE 12:   RESULTIS ap
         CASE 13:   RESULTIS fp
         CASE 14:   RESULTIS sp
         CASE 15:   RESULTIS pc
         CASE 16:   RESULTIS psl
      $)
      writef("*T%S*T%X8*N", regname(i), value)
   $)
   newline()
$)

AND regname(n) = VALOF
$( SWITCHON n INTO
   $( CASE 00:  RESULTIS "R0"
      CASE 01:  RESULTIS "R1"
      CASE 02:  RESULTIS "R2"
      CASE 03:  RESULTIS "R3"
      CASE 04:  RESULTIS "R4"
      CASE 05:  RESULTIS "R5"
      CASE 06:  RESULTIS "R6"
      CASE 07:  RESULTIS "R7"
      CASE 08:  RESULTIS "R8"
      CASE 09:  RESULTIS "R9"
      CASE 10:  RESULTIS "R10"
      CASE 11:  RESULTIS "R11"
      CASE 12:  RESULTIS "AP"
      CASE 13:  RESULTIS "FP"
      CASE 14:  RESULTIS "SP"
      CASE 15:  RESULTIS "PC"
      CASE 16:  RESULTIS "PSL"
   $)
$)

AND postmortem(fp, sp, pc) BE   // 'fp' and 'sp' are BCPL addresses, 'pc' is not
$( UNLESS sv.errflag DO
   $( fp := level() >> 2
      sp := fp - 1   // Pretend this routine has no locals
      pc := postmortem   // Any valid value
   $)

   $( LET items_per_line = 6
      AND no_online = ?
      AND max = interactive -> 50, 100
      AND atsp = @sp
      AND sb = stackbase >> 2

      writes("*N*NPostmortem of the stack:*N")

      $( IF fp LE (#X7FF00000 >> 2) THEN      // Unlikely value
         $( writes("Stack is irretrievably corrupt*N")
            RETURN
         $)

         writes("*NFunction <")
         write_function_name(name_from_link(fp, atsp), 1, max)
         writef("> with %S", sp GE fp - 1 -> "no locals", "locals:-")
         no_online := items_per_line

         FOR i = 2 TO fp - sp DO
         $( IF no_online = items_per_line THEN
            $( no_online := 0
               newline()
            $)
            IF i > 21 THEN   // Only print up to first 20 locals
            $( writes(". . . .")
               BREAK
            $)
            no_online := no_online + 1
            write_value(fp!(-i))
         $)
         writef("*Ncalled from location %X8 in*N", !fp)
         IF fp GE sb BREAK
         sp := fp + 1
         fp := fp!(-1) >> 2
      $) REPEAT
      writes("*NEntry sequence*N*N")
   $)
$)

AND backtrace() BE
$( LET trb = sv.traceb >> 2   // Address of trace buffer
   LET trp = (sv.tracep < 0 -> -sv.tracep, sv.tracep) + trb
   LET otrp = trp   // Copy
   AND trmk = 0
   AND linesize = interactive -> 72, 120
   AND cols_left = ?

   IF trb = 0 RETURN   // No trace buffer present
   FOR i = 0 TO sv.tbsize - 1 DO
      trmk := trmk \/ trb!i   // See if there's anything traced
   IF trmk = 0 RETURN   // No - give up

   cols_left := linesize
   writes("*N*NFunction trace:*N*N")

   $( trp := trp - 1   // Move to next item
      IF trp < trb THEN trp := trp + sv.tbsize   // Wrap around
      IF !trp = 0 LOOP   // Empty entry

      $( LET pt = !trp >> 2   // BCPL pointer to string
         LET size = pt%0 + 8   // Length of string plus the arrow

         IF size > linesize THEN size := linesize   // Do the best we can
         IF size > cols_left THEN
         $( newline()
            cols_left := linesize
         $)

         write_function_name(pt, 1, size - 8)
         writes("   <-   ")
         cols_left := cols_left - size
      $)
   $) REPEATUNTIL trp = otrp   // Gone all the way round
   newline(); newline()
$)

AND mapglobals(first, last) BE
$( LET atg0 = @start - 1
   LET wrchglob = @wrch - atg0

   IF last > globalsize THEN last := globalsize

   writef("*N*NValues set in GLOBAL vector, from %N to %N:*N", first, last)

   $( LET items_per_line = interactive -> 4, 8
      AND no_online = 0

      FOR i = first TO last DO
      $( LET value = atg0!i

         IF i = wrchglob & user_wrch NE 0 THEN value := user_wrch

         UNLESS value = 0 \/ value = sv.undefglob DO
         $( IF no_online = 0 THEN
            $( no_online := items_per_line
               newline()
            $)
            no_online := no_online - 1

            writef("G%I3,", i)
            write_value(value)
         $)
      $)
   $)
   newline(); newline()
$)

AND mapstatics() BE
$( IF sv.stchain = 0 RETURN   // No STATIC names present

   $( LET no.online = 0
      AND chain = sv.stchain >> 2   // Word address of first STATIC name entry

      writef("*N*NValues of STATIC variables:*N")

      UNTIL chain = 0 DO
      $( IF no.online = 0 THEN
         $( no.online := 2
            newline()
         $)
         no.online := no.online - 1

         write_function_name(chain + 2, 16, 16)
         wrch('=')
         write_value(!(chain!1 >> 2))
         UNLESS no.online = 0 DO writes("    ")

         chain := !chain >> 2 REPEATUNTIL sv.lowcode LE (chain << 2) LE sv.highcode   // Skip over inter-segment links
      $)
   $)
   newline(); newline()
$)

AND mapcode(pc) BE
$( LET p = pc >> 2   // Failing PC as a word address

   writes("*N*NDump of surrounding code:*N*N")

   FOR i = p - 6 TO p + 6 DO
   $( LET mark = (i = p) -> "********", "    "

      writef("%X8:    ", i << 2)
      TEST sv.lowcode LE i << 2 LE sv.highcode - 1 THEN
         writef("%S  %X8  %S*N", mark, !i, mark)
      OR
         writes("-- Not in code area*N")
   $)
   newline(); newline()
$)

AND mapstore() BE
$( TEST profile THEN
   $( LET hwcount = VALOF
      $( LET h = 0

         FOR ca = sv.lowcode TO sv.highcode - 1 DO   // Scan for unique pattern marking profile code
         $( IF 0%ca = i.movl &
               0%(ca+1) = m.r0reg &
               0%(ca+2) = m.r0reg &
               0%(ca+3) = i.incl THEN
            $( LET c = contents(ca + 4)

               IF h < c THEN h := c   // Accumulate 'high water' mark
               ca := ca + 6
            $)
         $)
         RESULTIS h
      $)

      heading()

      FOR ca = sv.lowcode TO sv.highcode - 1 DO
      $( IF is_function(ca) THEN
         $( LET name = name_from_entry(ca)

            IF name = 0 LOOP
            writef("*N%X8*S*S", ca)
            write_function_name(name, 1, 62)
            newline()
            LOOP
         $)

         IF 0%ca = i.movl &
            0%(ca+1) = m.r0reg &
            0%(ca+2) = m.r0reg &
            0%(ca+3) = i.incl THEN
         $( LET c = contents(ca+4)

            IF c NE -1 THEN
            $( writef("%X8*S%IB*S|*S", ca, c)
               FOR i = 1 to c*49/hwcount DO wrch('**')
               newline()
            $)

            ca := ca + 6
         $)
      $)
   $)
   OR
   $( LET first_ = TRUE

      FOR ca = sv.lowcode TO sv.highcode - 1 DO   // Scan the code area
      $( IF is_function(ca) THEN
         $( LET name = name_from_entry(ca)

            IF name = 0 LOOP

            IF first_ THEN
            $( heading()
               first_ := FALSE
            $)
            writef("%X8  ", ca)
            write_function_name(name, 1, 62)
            newline()
         $)
      $)
      newline()
   $)
   newline()
$)

AND heading() BE
   writes("*N*NMap of program code area:*N*N")

AND abort(n) BE
$( LET v1 = VEC 2
   AND V2 = VEC 2

   TEST  n < 0 THEN n := 1
   OR writef("*NBCPL Abort - User code = %N, on %S at %S*N",
             n, date(v1), timeofday(v2))

   backtrace()
   postmortem()                         // Need no params since sv.errflag is FALSE
   mapglobals(1, globalsize)
// mapstatics()
   mapstore()

   UNLESS userpostmortem = 0 \/ userpostmortem = sv.undefglob DO
      userpostmortem(n)

   IF n NE 0 THEN stop(n)
$)

AND write_function_name(address, min, max) BE
$( LET l = address%0
   LET j = (l < max) -> l, max

   FOR i = 1 TO j DO wrch(address%i)
   FOR i = j + 1 TO min DO wrch('*S')
$)

AND name_from_entry(ep) = VALOF
$( TEST 0%ep = i.jsb & 0%(ep + 1) = m.relpcw THEN ep := ep + 4
   OR TEST 0%ep = i.jsb & 0%(ep + 1) = m.relpcl THEN ep := ep + 6
   OR RESULTIS 0   // Not traced

   $( LET word = 0

      FOR i = 3 TO 0 BY -1 DO
         word := (word << 8) \/ 0%(ep + i)

      RESULTIS word >> 2   // BCPL address of string
   $)
$)

AND is_function(address) = VALOF
$( UNLESS sv.lowcode LE address < sv.highcode RESULTIS FALSE

   TEST 0%address = i.jsb &
        0%(address + 1) = m.relpcw THEN address := address + 8   // Skip over short trace call
   OR IF 0%address = i.jsb &
        0%(address + 1) = m.relpcl THEN address := address + 10  // Skip over long trace call

   IF 0%(address + 0) = i.movl &    // Check for profile code
      0%(address + 1) = m.r0reg &
      0%(address + 2) = m.r0reg &
      0%(address + 3) = i.incl THEN
   $( address := address + 4   // Point to mode byte
      TEST 0%address = m.relpcl THEN address := address + 5
      OR TEST 0%address = m.relpcw THEN address := address + 3
      OR RESULTIS FALSE
   $)

   IF 0%(address + 0) = i.pushl &   // PUSHL FP
      0%(address + 1) = m.fpreg &
      0%(address + 2) = i.addl3 &   // ADDL3 #248,SP,FP
      0%(address + 3) = m.imd &
      0%(address + 4) = 248 &
      0%(address + 5) = 0 &
      0%(address + 6) = 0 &
      0%(address + 7) = 0 &
      0%(address + 8) = m.spreg &
      0%(address + 9) = m.fpreg THEN RESULTIS TRUE

   RESULTIS FALSE
$)

AND write_value(value) BE
$( TEST sv.lowcode LE value < sv.highcode THEN
   $( TEST is_function(value) THEN
      $( LET name = name_from_entry(value)

         TEST name = 0 THEN writef("*S%X8*****S", value)
         OR
         $( wrch('*S')
            write_function_name(name, 8, 8)
            writes("   ")
         $)
      $) OR writef("*S%X8***S*S", value)   // Probably a label
   $)
   OR writef("*S%X8*S*S*S", value)
$)

AND contents(ad) = VALOF
$( LET length = 0%ad = m.relpcl -> 4,
                0%ad = m.relpcw -> 2, 0
   AND w = 0

   IF length = 0 RESULTIS -1

   FOR i = length TO 1 BY -1 DO
      w := (w << 8) \/ 0%(ad + i)

   IF length = 2 & (w & #X8000) NE 0 THEN
      w := w \/ #XFFFF0000   // Sign extend word displacements

   RESULTIS !(w >> 2)
$)

AND name_from_link(atlink, atsp) = VALOF
$( LET ep = address_from_link(atlink)
   AND name = ?

   // Check for special cases in machine code library

   IF ep = getbyte RESULTIS "GETBYTE"
   IF ep = putbyte RESULTIS "PUTBYTE"
   IF ep = longjump RESULTIS "LONGJUMP"
   IF ep = aptovec THEN
   $( !atsp := atlink - 1   // Hide private locals and vector of APTOVEC
      RESULTIS "APTOVEC"
   $)

   name := ep = 0 -> 0, name_from_entry(ep)

   RESULTIS name = 0 -> "????????", name
$)

AND address_from_link(atlink) = VALOF
$( LET iad = !atlink - 6   // Tentative address of call (longword displacement)
   AND length = 4
   AND disp = 0
   AND pcmode = ?

   TEST 0%iad = i.jsb & 0%(iad+1) = m.relpcldef THEN
      length, pcmode := 4, TRUE
   OR
   $( iad := iad + 2   // Try for a word displacement
      TEST 0%iad = i.jsb & 0%(iad+1) = m.relpcwdef THEN
         length, pcmode := 2, TRUE
      OR
      $( iad := iad + 1   // Try for a byte displacement
         TEST 0%iad = i.jsb & 0%(iad+1) = m.relfpbdef THEN
            length, pcmode := 1, FALSE
         OR RESULTIS 0   // Not, apparently, a call
      $)
   $)

   IF NOT pcmode THEN   // Perhaps a call from APTOVEC - in which case,
                        // take the routine address from local 2
   $( UNLESS 0%(iad+2) = #XF8 RESULTIS 0

      UNLESS (aptovec NE 0) &
             (aptovec NE sv.undefglob) &
             (aptovec < iad < aptovec + 70) RESULTIS 0   // Not within APTOVEC

      $( LET oldfp = atlink!(-1) >> 2

         RESULTIS oldfp!(-2)
      $)
   $)

   iad := iad + 2   // Move to displacement part

   FOR i = length - 1 TO 0 BY -1 DO
      disp := (disp << 8) \/ 0%(iad + i)   // Get 2- or 4-byte displacement

   IF length = 2 & (disp & #X8000) NE 0 THEN   // Sign-extend word displacements
      disp := disp \/ #XFFFF0000

   iad := iad + disp + length   // Point to routine cell

   RESULTIS !(iad >> 2)
$)

// End of file DEBUG.B


