 
// File BCPLZ_BCPLZHDR
 
// Header file for BCPL code generator for Zilog Z80
 
 
/*  Selection  of operating system is done by setting exactly ONE of the
values below to TRUE; ALL others MUST be set to FALSE.  */

MANIFEST $(
sys.emas     = FALSE  // EMAS on ICL 2900 series
sys.vaxunix  = TRUE   // UNIX on DEC VAX-11 series
$)


GET "LIBHDR"
 
MANIFEST $( debugging = FALSE $)   // Set to TRUE during development and testing
 
// Variables
 
GLOBAL $(
maxgn                        : 100   // Number of globals in program
worksize                     : 101   // Size of work area (kb)
tracing_                     : 102   // Controls whether tracing code is to be generated
objfile                      : 104   // Name of object file
codelist_                    : 105   // Controls listing of code produced
ocode                        : 106   // Name of OCODE file
objcode                      : 107   // Stream pointer for object file
ocode_conad                  : 108   // Connect address of OCODE file
ocode_ptr                    : 109   // Pointer to next byte in connected OCODE file
comments                     : 110   // Number of comments to user
errorstream_                 : 111   // TRUE iff a separate output stream for errors has been specified
compiler_                    : 112   // TRUE iff called from phase 1
code_heading_done_           : 113   // TRUE iff heading for code listing has been printed
datasize                     : 114   // Size of data vector (words)
labsize                      : 115   // Size of label vector (words)
relocsize                    : 116   // Size of relocation vector (words)
progsize                     : 117   // Size of program vector (words)
hwlabel                      : 118   // Highest label number found so far in OCODE input
debug_                       : 119   // TRUE iff debugging support records to be generated
fixed_                       : 120   // TRUE iff fixed global vector to be used

progbuff                     : 121
progbuffp                    : 122
arg1                         : 123
arg2                         : 124
r_hl                         : 125
r_de                         : 126
r_bc                         : 127
programsize                  : 128
load                         : 129
stack                        : 130
store                        : 131
lowbyte                      : 132
highbyte                     : 133
movetor                      : 134
movetoanyr                   : 135
rdn                          : 136
rdl                          : 137
cgpendingop                  : 138
discardaddress               : 139
ssp                          : 140
incode                       : 141
procdepth                    : 142
reglist                      : 143
simstack                     : 144
movetoanybut                 : 145
loadindex                    : 146
code_ld                      : 147
datav                        : 148
datap                        : 149
labv                         : 150
storet                       : 151
comment                      : 152
entrypoint                   : 153
zstack                       : 154
pendingop                    : 155
relocbuff                    : 156
relocbuffp                   : 157

code_dec                     : 158
code_nop                     : 159
code_add                     : 160
code_and                     : 161
code_call                    : 162
code_cpl                     : 163
code_exdehl                  : 164
code_exx                     : 165
code_inc                     : 166
code_jp                      : 167
code_or                      : 168
code_pop                     : 169
code_push                    : 170
code_rr                      : 171
code_sbc                     : 172
code_xor                     : 173
code_dw                      : 174
code_rst                     : 175
code_srl                     : 176
code_set                     : 177
code_res                     : 178
code_bit                     : 179

isfree                       : 180
discardregs                  : 181
discardreg                   : 182
loadstring                   : 183
readop                       : 184
cgcode                       : 185
cgstind                      : 186
loadlvindex                  : 187
setlab                       : 188
cgentry                      : 189
cgapply                      : 190
cgsave                       : 191
cgdata                       : 192
cgswitch                     : 193
rdgn                         : 194
cgglobals                    : 195
nextparam                    : 196
align                        : 197
lookinregs                   : 198
cgcondjump                   : 199
cgreturn                     : 200
discardstack                 : 201
destackitem                  : 202
cgsectionentry               : 203
cgputbyte                    : 204

op                           : 205
cgparam                      : 206
zbytel                       : 207
zbytecopy                    : 208
code_heading                 : 209
ioerror                      : 210
report                       : 211
con_rdch                     : 212
cgen                         : 213
writeaddress                 : 214
flush_codelist               : 215
globals_in_segment           : 216
starting_codelist_           : 217
dsize                        : 218
parmx_                       : 219
init_codelist                : 220
setdmax                      : 221
parmz_                       : 222
namestack                    : 223
curprocname                  : 224
initstack                    : 225
tablebase                    : 226
cgdebugrecord                : 227
symbolbase                   : 228
diagon_                      : 229
cgnamerecord                 : 230
parmy_                       : 231
zbyte                        : 232
globalmax                    : 233
globalbase                   : 234
cgstore                      : 235
storeindex                   : 236
freereg                      : 237
cgbitjump                    : 238
loadhloffset                 : 239
special_                     : 240
k_ix                         : 241
k_iy                         : 242
$)

MANIFEST $(   // Subsystem error codes (EMAS only)
e.ift   = 267   // Invalid file type
$)
 
// Selectors for items on simulated stack and in register slaves
 
MANIFEST $(
h1    = 0                            // Type of item
h2    = 1                            // Offset of item
h3    = 2                            // SSP for item
h4    = 3                            // Register name
$)
 
// OCODE operations
 
MANIFEST $(
s.end            = 0
s.true           = 4
s.false          = 5
s.rv             = 8
s.fnap           = 10
s.mult           = 11
s.div            = 12
s.rem            = 13
s.plus           = 14
s.minus          = 15
s.query          = 16
s.neg            = 17
s.abs            = 19
s.eq             = 20
s.ne             = 21
s.ls             = 22
s.gr             = 23
s.le             = 24
s.ge             = 25
s.not            = 30
s.lshift         = 31
s.rshift         = 32
s.logand         = 33
s.logor          = 34
s.eqv            = 35
s.neqv           = 36
s.lp             = 40
s.lg             = 41
s.ln             = 42
s.lstr           = 43
s.ll             = 44
s.llp            = 45
s.llg            = 46
s.lll            = 47
s.needs          = 48
s.section        = 49
s.rtap           = 51
s.goto           = 52
s.finish         = 68
s.switchon       = 70
s.global         = 76
s.mc             = 77
s.sp             = 80
s.sg             = 81
s.sl             = 82
s.stind          = 83
s.slctap         = 84
s.jump           = 85
s.jt             = 86
s.jf             = 87
s.endfor         = 88
s.labx           = 89
s.lab            = 90
s.stack          = 91
s.store          = 92
s.rstack         = 93
s.entry          = 94
s.save           = 95
s.fnrn           = 96
s.rtrn           = 97
s.res            = 98
s.datalab        = 100
s.iteml          = 101
s.itemn          = 102
s.endproc        = 103
s.prcl           = 104   // Not supported on Z80; used to implement EXTERNALs
s.rtcall         = 105   // Not supported on Z80; used to implement EXTERNALs
s.fncall         = 106   // Not supported on Z80; used to implement EXTERNALs
s.slctst         = 107
s.labr           = 108
s.mark           = 109
s.getbyte        = 120
s.putbyte        = 121
$)
 
// Condition codes

MANIFEST $(
c.none           = 150
c.z              = #B001
c.nz             = #B000
c.c              = #B011
c.nc             = #B010
c.p              = #B110
c.m              = #B111
$)

MANIFEST $(
k.arith          = 160
k.bc             = 161
k.de             = 164
k.hl             = 167
k.a              = 170
k.b              = 162
k.c              = 163
k.d              = 165
k.e              = 166
k.h              = 168
k.l              = 169
k.lab            = 172
k.i.lab          = 173
k.i.hl           = 176
k.nn             = 178
k.n              = 179
$)

// Tunable manifests

MANIFEST $(
itemsize         = 3
simstacksize     = 60
namesize         = 32   // Maximum size of a routine/function name (including length)
namestacksize    = 5
$)

// Machine constants

MANIFEST $(
zstacksize              = 3
reglistsize             = 12
regitemsize             = 4
target.bytesperword     = 2
$)

// Types of item on simulated stack and in register slaves

MANIFEST $(
loc              = 0
glob             = 1
numb             = 2
lab              = 3
lvloc            = 4
lvglob           = 5
lvlab            = 6
reg              = 7
stck             = 8
$)

// Addresses of the jump table for linkage to section "ARITH"

MANIFEST $(
a.return         = #X0009
a.finish         = #X0048
a.apply          = #X0003
a.setlink        = #X0006
a.cgt            = #X0039
a.clt            = #X003C
a.linsch         = #X003F
a.div            = #X000F
a.rem            = #X0012
a.mult           = #X000C
a.eq             = #X001B
a.lt             = #X0021
a.ge             = #X0024
a.abs            = #X0042
a.lshift         = #X0015
a.rshift         = #X0018
a.lvix           = #X0027
a.lviy           = #X002A
a.six            = #X0033
a.siy            = #X0036
a.lix            = #X002D
a.liy            = #X0030
a.ne             = #X001E
a.trace          = #X0045

tablesize        = #X0050
$)

MANIFEST $(
k.ix             = #XDD
k.iy             = #XFD
k.none           = 255
$)

// Code listing modes

MANIFEST $(
m.data           = 0
m.code           = 1
$)
 
// End of file BCPLZ_BCPLZHDR
 
