 
// File bz1.b
 
// Version: V7.1   (also alter MANIFESTs below)
 
// BCPL code generator for Zilog Z80
 
// Originally written by I.D. Wilson, University of Cambridge

// Extensively modified by R.D. Eager, University of Kent   MCMLXXXVI

 
// History:
//  E1.0   - Initial EMAS version
//  E1.1   - Correction to code which prints out sizes of code and  data
//           areas in compiled program.
//  E1.2   - Addition  of PARMX option to compile calls to globals -1 to
//           -8 into RST instructions.
//         - Addition of code listing facilities.
//         - Addition of PARMZ option to flag all references  to  locals
//           and  globals with offsets greater than 127 (the 'expensive'
//           ones).
//  E1.3   - Correction to ensure  that  code  and  data  are  correctly
//           aligned.
//  E1.4   - Addition  of  code  to improve handling of 1-bit, 2-bit and
//           8-bit logical shifts.
//  E1.5   - Correction to code for 'minus' in  'cgpendingop';  previous
//           code reversed operands!
//  E1.6   - Correction  to  code  of  'scan'; to return to caller after
//           's.global' OCODE encountered.
//  E2.0   - Addition of routine names at each entry point, and calls to
//           extra trace routine; under control of PARM(NOTRACE)
//  E2.1   - Correction to code of 'cgapply', to avoid error message  on
//           global  calls  with  greater  than 3 parameters, when PARMX
//           selected and global number not in the range -1 to -8.
//  E2.2   - Alteration to 'cgrelocrecords',  to  generate  a  count  of
//           relocation records rather than a count of relocation bytes;
//           this is nonstandard but agrees with the Cambridge assembler
//           and link-editor.
//  E3.0   - Addition of TABLEBASE parameter to  specify  base  of  jump
//           table.
//  E3.1   - Better arrangement for implementation of TABLEBASE.
//         - Correction to RST number when PARM(PARMX) selected.
//  E3.2   - Correction  to code of 'cgswitch', to generate correct code
//           for single-case SWITCHONs.
//  E4.0   - Addition of code to support diagnostic (types 6, 7  and  8)
//           records in the object file, if PARM(DEBUG) selected.
//         - Parameter  to  first SECTION directive now placed in module
//           record in object file.
//         - Addition of names at entry points now under the control  of
//           PARM(NODIAG); trace calling code still under the control of
//           PARM(NOTRACE).
//  E4.1   - Correction  to code of 'cgsectionentry', to produce correct
//           length of blank module name  if  no  SECTION  directive  is
//           present.
//  E5.0   - Addition of PARMY option, to force the generation of a jump
//           table for all SWITCHON commands.
//         - Improvement  to  'cglogop'  routine;  calls   new   routine
//           'cglogbyte' for half-word operations on constants.
//  E6.0   - Addition  of  PARM(FIXED) option; this allows globals to be
//           located at the end of the jump table, and accessed directly
//           instead of via register IY.  This is smaller and faster, at
//           the expense of less flexibility in the size of  the  global
//           vector.
//  E6.1   - All calls on 'getbyte' and 'putbyte' converted to use the %
//           operator.
//         - Some constant '2's converted to 'target.bytesperword'.
//         - Correction to 'freereg', to avoid address error when second
//           parameter is zero.
//         - Improvement  to  'movetor'  and 'loadlvindex', to use 'srl'
//           rather than 'and a' and 'rr'.
//         - Improvement to 'movetor' and 'loadreg', to make use of  the
//           register exchange instruction 'ex de,hl' where possible.
//         - Improvement  to  'cgreturn',  so  that  a result in 'de' is
//           moved to 'hl' by use of the 'ex de,hl' instruction.
//         - Improvement to logical operations, to use 'set', 'res'  and
//           'bit' where possible.
//  E6.2   - Lower case strings accepted by 's.mc' OCODE.
//  E6.3   - Correction  to  'cgbitjump',  to check for cases other than
//           when the operand is a number.
//  E6.4   - Correction   to   'movetor',  to  remove  optimisation  for
//           'ex de,hl'.  This optimisation may corrupt a  wanted  value
//           in HL.
//  E6.5   - Optimisation  to  the  % operator added.  This only affects
//           certain small constant operands (e.g. a%1, b%2).
//  E6.6   - 's.blab' renamed to 's.labx'.
//         - 's.labr'  and 's.mark' OCODEs added; treated as 's.lab' and
//           's.stack' respectively.
//  E6.7   - Addition  of  code  to  reverse use of IX and IY registers,
//           controlled by PARM(ZERO).
//  E6.8   - 'diagon' now disabled by 'opt' in PARM decode.
//         - 'cgapply' fixed for HL load after simstack reset.
//         - Error which inverted sense of PARM(ZERO) corrected.
//  V7.0   - First UNIX version (4.2BSD on VAX-11).
//  V7.1   - Correction  to  avoid  code  listing  header  being sent to
//           object file.

 
// Segment 1

MANIFEST $(   // Alter these if changes are made
version = 7   // Major version number
edit    = 1   // Edit number within major version
$)
 
 
/* Exit status:
    0 - Normal termination (possibly with warnings)
    1 - Filing or parameter error
  255 - Errors in translation
*/
 
GET "bz.h"
 
STATIC $( flags = ?; param_pos = ?; sourcename = ? $)
 
LET start() BE
$( LET argp = 1
   AND on = VEC maxstrlength/bytesperword + 1
   AND real_rdch = rdch
   AND ch, res = ?, ?
   AND ocodestream = ?
 
   ocode, sourcename, objfile := 0, 0, 0

   // Set default options

   worksize, globalmax := 60000, 400
   tablebase := #X4000
   diagon_, tracing_, debug_ := FALSE, FALSE, FALSE
   special_, codelist_, fixed_ := FALSE, FALSE, FALSE
   parmx_, parmy_, parmz_ := FALSE, FALSE, FALSE
 
   WHILE argp LE argc DO
   $( LET s = argv!argp

      argp := argp + 1

      TEST s%0 > 1 & s%1 = '-' THEN
      $( flags := s
         param_pos := 1
         rdch := s_rdch      // Takes input from 'flags'

         $( ch := rdch()

            SWITCHON ch INTO
            $( CASE endstreamch:   BREAK
               CASE  '-':
               CASE '*S':
               CASE '*N':          ENDCASE
               CASE  'b':          selectoutput(journal)
                                   writef("Version: V%N.%N*N", version, edit)
                                   selectoutput(sysout)
                                   ENDCASE
               CASE  'T':          $( LET t = readnumber(16)

                                      UNLESS #X0000 LE t LE #XFF00 THEN
                                         error(sourcename, "Invalid value for table base parameter")

                                      tablebase := t
                                      BREAK
                                   $)
               CASE  'D':          diagon_ := TRUE; ENDCASE
               CASE  'w':          $( LET w = readnumber(10)

                                      UNLESS 5000 LE w LE 200000 THEN
                                         error(0, "Invalid value for -w flag")
                                      worksize := w
                                      BREAK
                                   $)
               CASE  'G':          $( LET g = readnumber(10)

                                      UNLESS 0 LE g LE 4000 THEN
                                         error(0, "Invalid value for -G flag")
                                      globalmax := g
                                      BREAK
                                   $)
               CASE  'o':          IF argp > argc THEN error(sourcename, "No file for *'o*' flag")
                                   objfile := argv!argp
                                   argp := argp + 1
                                   ENDCASE
               CASE  'n':          IF argp > argc THEN error(sourcename, "No file for *'n*' flag")
                                   sourcename := argv!argp
                                   argp := argp + 1
                                   ENDCASE
               CASE  't':          tracing_ := TRUE; ENDCASE
               CASE  'g':          debug_ := TRUE; ENDCASE
               CASE  'f':          fixed_ := TRUE; ENDCASE
               CASE  's':          special_ := TRUE; ENDCASE
               CASE  'x':          parmx_ := TRUE; ENDCASE
               CASE  'y':          parmy_ := TRUE; ENDCASE
               CASE  'z':          parmz_ := TRUE; ENDCASE
               CASE  'c':          codelist_ := TRUE; ENDCASE
               CASE  '?':
               DEFAULT:            error(ocode, "Flag *'%c*' not recognoed", ch)
            $)
         $) REPEAT
         rdch := real_rdch   // Restore 'rdch'
      $)
      OR
      $( IF ocode NE 0 THEN error(0, "More than one input file")
         ocode := s
         IF sourcename = 0 THEN sourcename := ocode
      $)
   $)

   // Set up OCODE file

   IF ocode = 0 THEN ocode := "-"
   IF sourcename = 0 THEN sourcename := ocode
   TEST ocode%0 = 1 & ocode%1 = '-' THEN
      ocodestream := sysin
   OR
   $( ocodestream := findinput(ocode)
      IF ocodestream = 0 THEN error(ocode, "Cannot open *'%s*'", ocode)
   $)
   selectinput(ocodestream)

   worksize := (worksize + bytesperword - 1)/bytesperword   // Convert to words

   // Set up object file

   TEST objfile = 0 THEN
      objcode := sysout
   OR
   $( objcode := findoutput(objfile)
      IF objcode = 0 THEN error(ocode, "Cannot open output file *'%s*'", objfile)
   $)
   selectoutput(objcode)
 
   TEST NOT special_ THEN
      k_ix, k_iy := k.ix, k.iy
   OR
      k_ix, k_iy := k.iy, k.ix

   globalbase := tablebase + tablesize
 
   stop(ABS(aptovec(cgen, worksize)))
$)
 
AND s_rdch() = VALOF
$( IF param_pos > flags%0 RESULTIS endstreamch

   param_pos := param_pos + 1
   RESULTIS flags%(param_pos - 1)
$)

AND message(prefix, mes, a, b, c, d, e, f, g, h, i, j, k) BE
$( writef("%S: ", argv!0)
   IF prefix NE 0 THEN writef("*"%S*", ", prefix)
   writef(mes, a, b, c, d, e, f, g, h, i, j, k)
$)

AND error(prefix, mes, a, b, c, d, e, f, g, h, i, j, k) BE
$( message(prefix, mes, a, b, c, d, e, f, g, h, i, j, k)
   newline()
   stop(1)
$)

AND report(mes, a, b, c, d, e, f, g, h, i, j, k) BE
$( selectoutput(sysout)
   message(sourcename, mes, a, b, c, d, e, f, g, h, i, j, k)
   newline()
   stop(255)
$)
 
AND comment(mes, a, b, c, d, e, f, g, h, i, j, k) BE
$( LET o = output()
   AND s = VEC maxstrlength/bytesperword + 1
   AND prefix = "Warning - "
   LET l = prefix%0

   selectoutput(sysout)

   FOR i = 1 TO l do s%i := prefix%i

   FOR i = 1 TO mes%0 DO s%(i + l) := mes%i
   s%0 := l + mes%0

   message(sourcename, s, a, b, c, d, e, f, g, h, i, j, k)
   newline()

   comments := comments + 1

   selectoutput(o)
$)

// End of file bz1.b

