
// Segment 4


GET "bz.h"

STATIC $(
casek    = 0
casel    = 0
$)

LET loadindex(indexr, r, pind) BE
/* Analogous to 'storeindex', but generates code to load register
'r' from offset 'ind'.  */
TEST fixed_ & indexr = k_iy THEN         // Fixed global reference
   code_ld(h4!r, k.arith, pind*target.bytesperword + globalbase)
OR
$( LET ind = pind*target.bytesperword - 128

   TEST ind > 127 THEN
   $( code_call(indexr = k_ix -> a.lix, a.liy)
      flush_codelist(m.data)
      setdmax(2)
      code_dw(k.nn, ind)
      flush_codelist(m.code)
      code_pop(h4!r)
      IF parmz_ THEN
         comment("use of %S offset %N in routine/function %S", indexr = k_ix -> "local", "global",
                    pind, curprocname())
   $)
   OR
   $( code_ld(lowbyte(r), indexr, ind)
      code_ld(highbyte(r), indexr, ind + 1)
   $)
$)

AND loadlvindex(indexr, r, ind) BE
/*  Load  the BCPL address of the local/global variable at offset
'ind' into register 'r'.  */
TEST fixed_ & indexr = k_iy THEN         // Fixed global reference
$( code_ld(h4!r, k.nn, ind*target.bytesperword + globalbase)
   code_srl(highbyte(r))
   code_rr(lowbyte(r))
$)
OR
$( ind := ind*target.bytesperword - 128

   code_call(indexr = k_ix -> a.lvix, a.lviy)
   flush_codelist(m.data)
   setdmax(2)
   code_dw(k.nn, ind)
   flush_codelist(m.code)
   code_pop(h4!r)
$)

AND setlab(l) BE
/* Set the compiler generated label 'l' at this point.  */
$( LET p = labv!l

   TEST p < 0 THEN
      report("in compiler - label %N set twice", l)
   OR
   $( LET lb = programsize & #XFF
      AND hb = (programsize >> 8) & #XFF

      UNTIL p = 0 DO
      $( LET a = (progbuff%p << 8) + progbuff%(p+1)

         progbuff%p := lb
         progbuff%(p+1) := hb
         p := a
      $)

      labv!l := -programsize
   $)
$)

AND cgentry(n, l) BE
/* Generate code to deal with a procedure entry.   The  procedure
is set at label 'l', with 'n' characters in its name.  */
$( LET v = VEC maxstrlength/bytesperword + 1

   v%0 := n
   FOR i = 1 TO n DO
      v%i := rdn()
   FOR i = n + 1 TO n > 7 -> n - 1, 7 DO v%i := '*S'

   IF codelist_ THEN
   $( flush_codelist(m.code)
      writef(" ;*N ; Entry point to %S*N ;*N", v)
   $)

   IF procdepth > 0 THEN
   $( LET ptr = namestack + (procdepth - 1)*namesize

      FOR i = 0 TO n DO ptr%i := v%i
   $)

   align(2)

   IF diagon_ THEN
   $( flush_codelist(m.data)
      setdmax(4)
      zbyte(7)
      FOR i = 1 TO 7 DO zbyte(v%i)
      flush_codelist(m.code)
   $)

   setlab(l)

   cgdebugrecord(6, programsize, v)

$)

AND curprocname() = VALOF
$( IF procdepth LE 0 RESULTIS ""
   RESULTIS namestack + (procdepth - 1)*namesize
$)

AND cgapply(op,stacksize) BE
/*  Apply a function or routine.  On return, the new stacksize is
given by 'stacksize'.  */
$( LET sb = stacksize + 2
   AND se = stacksize + 4

   cgpendingop()

   IF parmx_ & (ssp - sb > 4) & h1!arg1 = glob & -8 LE h2!arg1 LE -1 THEN
      comment("too many parameters in special routine/function call from routine/function %S", curprocname())

   store(se + 1, ssp - 2)   // Store non-register parameters (4 upwards)

   FOR t = simstack TO arg2 BY itemsize DO   // Store local items
   $( IF h3!t GE stacksize BREAK
      IF h1!t = reg THEN storet(t)
   $)

   // Assign args to registers

   FOR t = arg2 TO simstack BY -itemsize DO
   $( LET s = h3!t
      LET r = s - sb

      IF s < sb BREAK
      IF s LE se THEN movetor(reglist + r*4, t)
   $)

   IF h3!simstack > sb THEN
      loadindex(k_ix, r_hl, sb)

   discardregs()

   TEST parmx_ & (h1!arg1 = glob) & (-8 LE h2!arg1 LE -1) THEN
      code_rst(-h2!arg1 - 1)
   OR
   $( code_exx()
      movetor(r_hl, arg1)
      code_ld(k.bc, k.nn, stacksize*2)
      code_call(a.apply)
   $)

   discardregs()
   stack(stacksize)
   IF op = s.fnap THEN
   $( h1!r_hl, h2!r_hl, h3!r_hl := loc, ssp, ssp
      load(reg, r_hl)
   $)
$)

AND cgsectionentry() BE
/* Generate the standard code for the entry to  a  BCPL  section.
Deals with SECTION and NEEDS directives.  */
$( LET named_ = FALSE

   incode := TRUE
   align(2)

   IF op = s.section THEN
   $( LET n = rdn()
      AND modulename = VEC maxstrlength/bytesperword

      FOR i = 1 TO n DO modulename%i := rdn()

      IF n > 6 THEN n := 6
      IF n < 6 THEN
         FOR i = n + 1 TO 6 DO modulename%i := '*S'   // Pad with spaces
      modulename%0 := 6

      op := readop()

      selectoutput(objcode)
      cgnamerecord(modulename)
      selectoutput(sysout)
      named_ := TRUE
   $)

   WHILE op = s.needs DO
   $( LET n = rdn()

      FOR i = 1 TO n DO rdn()   // Throw away name

      op := readop()
   $)

   IF NOT named_ THEN
   $( selectoutput(objcode)
      cgnamerecord("      ")
      selectoutput(sysout)
   $)

   setdmax(4)
   zbyte(#X42)   // The characters B C P L
   zbyte(#X43)
   zbyte(#X50)
   zbyte(#X4C)

   setdmax(2)

   zbyte(0); zbyte(0)   // Will hold length eventually

   incode := FALSE
$)

AND cgsave(n) BE
/* Set up a new stack frame for a function or routine.  */
$( LET r = r_hl

   discardregs()
   discardstack()
   initstack(2)
   IF tracing_ THEN code_call(a.trace)
   code_call(a.setlink)

   FOR i = 3 TO (n > 5 -> 5, n)
   $( h1!r, h2!r, h3!r := loc, i - 1, i - 1
      load(reg, r)
      r := r + regitemsize
   $)

   FOR i = 6 TO n DO load(loc, ssp)
   store(0, ssp)
$)

AND cgdata(dtype, dval) BE
/* Add a word of data (or a label) to the end of the program.  */
$( datap!0 := dtype
   datap!1 := dval
   datap := datap + 2

   IF datap GE datav + datasize THEN
      report("out of space for data items")
$)

AND cgswitch(svec, s) BE
/*  Routine to generate code for a SWITCHON. The method used is either a
jump table or a binary chop; whichever is more space-efficient.  If  the
option 'parmy_' is used, a jump table is always compiled.
*/
$( LET n = s/2
   AND d = rdl()   // Default label
   casek, casel := svec, svec + n

   FOR i = 1 TO n DO
   $( LET c = rdn()
      LET l = rdl()
      LET j = i - 1

      UNTIL j = 0 DO
      $( IF c > casek!j BREAK
          casek!(j + 1) := casek!j
          casel!(j + 1) := casel!j
          j := j - 1
      $)

      casek!(j + 1), casel!(j + 1) := c, l
   $)

   /*  The  cases have now been sorted into ascending order; now compile
   the appropriate code depending on whether  the  range  is  sparse  or
   dense.  */

   cgpendingop()
   store(0, ssp - 2)
   movetor(r_hl, arg1)
   stack(ssp - 1)

   TEST (((casek!n - casek!1)*2 + 20) < (n*4 + n/8)) \/ parmy_ THEN
      labvecswitch(1, n, d)
   OR
   TEST n NE 1 THEN
   $( bintreeswitch(1, n, d)
      code_jp(c.none, k.lab, d)
   $)
   OR
   $( code_ld(k.b, k.n, 1)   // Number of CASEs
      code_call(a.linsch)
      flush_codelist(m.data)
      setdmax(4)

      code_dw(k.nn, casek!1)
      code_dw(k.lab, casel!1)
      flush_codelist(m.code)
   $)
$)

/*  Routine to generate code for a jump table SWITCHON. The jump address
is held at offset '(case-mincase)*2' in the table.  */

AND labvecswitch(a,b,d) BE
$( LET l = nextparam()
   AND p = a

   code_ld(k.de, k.nn, casek!b)
   code_call(a.cgt)
   code_jp(c.c, k.lab, d)

   code_ld(k.de, k.nn, casek!a)
   code_call(a.clt)
   code_jp(c.c, k.lab, d)

   // Cases of CASE being outside range MINCASE-MAXCASE have now been
   // handled; it is now in the correct range to be looked up in a table.

   code_sbc(k.hl, k.de)
   code_add(k.hl, k.hl)
   code_ld(k.de, k.lab, l)
   code_add(k.hl, k.de)
   code_ld(k.e, k.i.hl)
   code_inc(k.hl)
   code_ld(k.d, k.i.hl)
   code_exdehl()
   code_jp(c.none, k.i.hl)

   setlab(l)
   flush_codelist(m.data)
   setdmax(2)

   FOR k = casek!a TO casek!b DO
      TEST casek!p = k THEN
      $( code_dw(k.lab, casel!p)
         p := p + 1
      $)
      OR
         code_dw(k.lab, d)

   flush_codelist(m.code)

   incode := FALSE
$)

AND bintreeswitch(a, b, d) BE
/* Switch on 'hl', using a binary chop method.  Used when a  jump  table
would take up too much space.  */
$( TEST b - a > 8 THEN
   $( LET m = nextparam()
      AND t = (a + b)/2

      code_ld(k.de, k.nn, casek!t)
      code_call(a.cgt)
      code_jp(c.c, k.lab, m)
      bintreeswitch(a, t, d)
      code_jp(c.none, k.lab, d)
      setlab(m)
      incode := TRUE
      bintreeswitch(t + 1, b, d)
   $)
   OR
      UNLESS a = b DO
      $( code_ld(k.b, k.n, b - a + 1)   // Number of cases to consider
         code_call(a.linsch)   // Linear search
         flush_codelist(m.data)
         setdmax(4)
   
         FOR i = a TO b DO
         $( code_dw(k.nn, casek!i)
            code_dw(k.lab, casel!i)
         $)
         flush_codelist(m.code)
      $)
$)

 .
