
// Segment 6

GET "bz.h"

LET cgglobals(n) BE
/* End of a BCPL section; puts out all globals, length of  the  section,
debug information, and other such useful data.  */
$( incode := TRUE

   align(2)

   IF codelist_ THEN flush_codelist(m.data)

   dsize := 0

   setdmax(2)

   FOR i = 0 TO datap - datav - 2 BY 2 DO
      SWITCHON datav!i INTO
      $( CASE s.datalab:
            setlab(datav!(i + 1))
            cgdebugrecord(8, symbolbase + datav!(i + 1), programsize)
            ENDCASE
  
         CASE s.iteml:
            code_dw(k.lab, datav!(i + 1))
            dsize := dsize + 1
            ENDCASE
  
         CASE s.itemn:
            code_dw(k.nn, datav!(i + 1))
            dsize := dsize + 1
            ENDCASE
   
         DEFAULT:
            report("in compiler - bad DATA type in CGGLOBALS - %N", datav!i)
      $)

   setdmax(4)

   code_dw(k.nn, maxgn*target.bytesperword)
   code_dw(k.nn, 0)

   globals_in_segment := n

   FOR i = 1 TO n DO
   $( LET gn = rdn()
      LET gl = rdl()

      IF parmx_ & (-8 LE gn LE -1) THEN
         report("definition of global %N is illegal", gn)

      code_dw(k.nn, gn*target.bytesperword)
      code_dw(k.lab, gl)
   $)

   incode := FALSE
$)

AND nextparam() = VALOF
/* Return the next compiler generated label parameter.  */
$( cgparam := cgparam - 1
   IF cgparam < hwlabel THEN
      report("too many *'labels*' in program")
   RESULTIS cgparam
$)

AND align(n) BE
/* Align the compiled code to an 'n' byte boundary.  */
$( LET b = programsize REM n

   UNLESS b = 0 DO
      FOR i = b TO n - 1 DO code_nop()
$)

AND rdn() = readnumber(10)

AND rdl() = VALOF
/* Return a label number from the OCODE stream.  */
$( LET a = 0
   AND c = rdch()
   AND n = ?

   WHILE c = '*S' \/ c = '*N' DO c := rdch()

   UNLESS c = 'L' DO report("no L where label expected")

   n := readnumber(10)
   IF n GE cgparam THEN
      report("too many *'labels*' in program")

   IF n > hwlabel THEN hwlabel := n   // Keep 'high water' mark

   RESULTIS n
$)

AND rdgn() = VALOF
/*  Return  the next global number from the OCODE stream.  'maxgn' holds
the maximum global number referenced, for putting out at the end of  the
section, and for checks if 'fixed_' is TRUE.  */
$( LET g = rdn()

   IF g > maxgn THEN maxgn := g   // Keep 'high water' mark
   RESULTIS g
$)

AND movetoanybut(r, x) = VALOF
/* Generate code to move item 'x' to any register except 'r'.  */
$( LET k, n, r1 = h1!x, h2!x, 0

   IF k = reg THEN
      UNLESS n = r DO
      $( freereg(n, x)
         RESULTIS n
      $)

   FOR r2 = r_hl TO r_bc BY regitemsize DO
      UNLESS r2 = r DO
      $( IF isfree(r2) & h1!r2 = k & h2!r2 = n THEN
         $( h1!x, h2!x := reg, r2
            RESULTIS r2
         $)
      $)

   r1 := nextbutr(r)
   movetor(r1, x)
   RESULTIS r1
$)

AND nextbutr(r) = VALOF
/*  Return the next free register, ignoring register 'r'.  The algorithm
is similar to that for 'movetoanyr'.  */
$( FOR r1 = r_hl TO r_bc BY regitemsize UNLESS r1 = r DO
      IF h1!r1 = k.none & isfree(r1) THEN RESULTIS r1

   FOR r1 = r_hl TO r_bc BY regitemsize UNLESS r1 = r DO
      IF isfree(r1) RESULTIS r1

   FOR x = simstack TO arg1 BY itemsize DO
      IF h1!x = reg THEN
         UNLESS h2!x = r DO
         $( LET r = h2!x

            freereg(r, 0)
            RESULTIS r
         $)
$)

 .
