
// Segment 7

GET "bz.h"

LET code_add(a, b) BE   // Warning - only uses HL; parameter A is a dummy
   IF gencode() THEN
      zbyte(#X09 \/ (register(b) << 4))

AND code_and(a, b) BE
   IF gencode() THEN
      code_stype(#XA0, a, b)

AND code_bit(a, b) BE
   IF gencode() THEN
   $( zbyte(#XCB)
      zbyte(#X40 \/ (a << 3) \/ register(b))
   $)

AND code_call(a) BE
   IF gencode() THEN
   $( a := a + tablebase
      zbyte(#XCD)
      zbyte(a & #XFF)
      zbyte((a >> 8) & #XFF)
   $)

AND code_cpl() BE
   IF gencode() THEN
      zbyte(#X2F)

AND code_dec(r) BE
   IF gencode() THEN
      zbyte(#X0B \/ (register(r) << 4))

AND code_exdehl() BE
   IF gencode() THEN
      zbyte(#XEB)

AND code_exx() BE
   IF gencode() THEN
      zbyte(#XD9)

AND code_inc(r) BE
   IF gencode() THEN
      zbyte(#X03 \/ (register(r) << 4))

AND code_jp(cc, a, b) BE
$( IF gencode() THEN
   $( TEST a = k.i.hl THEN zbyte(#XE9)
      OR
      TEST (cc = c.p \/ cc = c.m) THEN absjump(cc, b)
      OR
      TEST a = k.arith THEN
      $( zbyte(#XC3)
         b := b + tablebase
         zbyte(b & #XFF)
         zbyte((b >> 8) & #XFF)
      $)
      OR
      $( LET l = labv!b

         TEST l < 0 THEN   // Label already set
         $( LET ll = -l - programsize

            TEST ll GE -126 THEN reljump(cc, ll, b)
            OR absjump(cc, b)
         $)
         OR
            absjump(cc, b)
      $)
   $)
$)

AND code_ld(a, b, c) BE
$( IF gencode() THEN
   $( TEST a = k.ix \/ a = k.iy THEN
      $( zbyte(a)
         zbyte(#X70 \/ register(c))
         zbyte(b)
      $)
      OR
      TEST a = k.i.lab \/ a = k.arith THEN
      $( TEST c = k.hl THEN
            zbyte(#X22)
         OR
         $( zbyte(#XED)
            zbyte(#X43 \/ (register(c) << 4))
         $)
         TEST a = k.i.lab THEN
            complab(b)
         OR
         $( zbyte(b & #XFF)
            zbyte((b >> 8) & #XFF)
         $)
      $)
      OR
      TEST b = k.ix \/ b = k.iy THEN
      $( zbyte(b)
         zbyte(#X46 \/ (register(a) << 3))
         zbyte(c)
      $)
      OR
      TEST b = k.nn THEN
      $( zbyte(#X01 \/ (register(a) << 4))
         zbyte(c & #XFF)
         zbyte((c >> 8) & #XFF)
      $)
      OR
      TEST b = k.i.lab \/ b = k.arith THEN
      $( TEST a = k.hl THEN
            zbyte(#X2A)
         OR
         $( zbyte(#XED)
            zbyte(#X4B \/ (register(a) << 4))
         $)
         TEST b = k.i.lab THEN
            complab(c)
         OR
         $( zbyte(c & #XFF)
            zbyte((c >> 8) & #XFF)
         $)
      $)
      OR
      TEST b = k.lab THEN
      $( zbyte(#X01 \/ (register(a) << 4))
         complab(c)
      $)
      OR
      TEST b = k.n THEN
      $( zbyte(#X06 \/ (register(a) << 3))
         zbyte(c)
      $)
      OR
      $( zbyte(#X40 \/ (register(a) << 3) \/ register(b))
      $)
   $)
$)

AND code_nop() BE
   IF incode THEN
      zbyte(#X00)

AND code_or(a, b) BE
   IF gencode() THEN
      code_stype(#XB0, a, b)

AND code_pop(r) BE
   IF gencode() THEN
      zbyte(#XC1 \/ (register(r) << 4))

AND code_push(r) BE
   IF gencode() THEN
      zbyte(#XC5 \/ (register(r) << 4))

AND code_res(a, b) BE
   IF gencode() THEN
   $( zbyte(#XCB)
      zbyte(#X80 \/ (a << 3) \/ register(b))
   $)

AND code_rr(r) BE
   IF gencode() THEN
   $( zbyte(#XCB)
      zbyte(#X18 \/ register(r))
   $)

AND code_rst(n) BE
   IF gencode() THEN
      zbyte(#XC7 \/ (n << 3))

AND code_sbc(a, b) BE
   IF gencode() THEN
      TEST a = k.a THEN
         zbyte(#X98 \/ register(b))
      OR
      $( zbyte(#XED)
         zbyte(#X42 \/ (register(b) << 4))
      $)

AND code_set(a, b) BE
   IF gencode() THEN
   $( zbyte(#XCB)
      zbyte(#XC0 \/ (a << 3) \/ register(b))
   $)

AND code_srl(r) BE
   IF gencode() THEN
   $( zbyte(#XCB)
      zbyte(#X38 \/ register(r))
   $)

AND code_xor(a, b) BE
   IF gencode() THEN
      code_stype(#XA8, a, b)

AND code_dw(a, b) BE
   IF incode THEN
   $( TEST a = k.lab THEN
         complab(b)
      OR
      $( zbyte(b & #XFF)
         zbyte((b >> 8) & #XFF)
      $)
   $)

AND gencode() = incode & procdepth > 0

AND register(r) = VALOF
/* Return the internal register representation of the register 'r'.  */
$( SWITCHON r INTO
   $( CASE k.a     : RESULTIS #B111
      CASE k.b     : RESULTIS #B000
      CASE k.c     : RESULTIS #B001
      CASE k.d     : RESULTIS #B010
      CASE k.e     : RESULTIS #B011
      CASE k.h     : RESULTIS #B100
      CASE k.l     : RESULTIS #B101

      CASE k.i.hl  : RESULTIS #B110
      CASE k.bc    : RESULTIS #B00
      CASE k.de    : RESULTIS #B01
      CASE k.hl    : RESULTIS #B10

      DEFAULT      : report("in compiler - bad R in REGISTER - %N", r)
   $)
$)

AND zbyte(b) BE
/* Buffer a byte of compiled code_  */
$( progbuff%progbuffp := b
   programsize := programsize + 1
   progbuffp := progbuffp + 1

   IF progbuffp > (progsize*bytesperword) THEN
      report("out of space for program code")
$)

AND reljump(cc, ll, l) BE
/* Generate code for a relative (backward) jump to  the  label  'l'  (at
'll') on condition 'cc'.  */
$( zbyte(cc = c.none -> #X18,
         cc = c.c    -> #X38,
         cc = c.nc   -> #X30,
         cc = c.z    -> #X28,
         cc = c.nz   -> #X20,
                        report("in compiler - bad CC in RELJUMP - %N", cc)  )
   zbyte(ll - 2)
$)

AND absjump(cc, l) BE
/* Compile an absolute jump on condition 'cc', to label 'l'.  */
$( zbyte(cc = c.none -> #XC3,
                        #XC2 \/ (cc << 3))
   complab(l)
$)

AND complab(l) BE
/* Compile code for a label reference to label 'l'.  */
$( LET ll = labv!l

   relocate(programsize)

   TEST ll < 0 THEN   // Label already declared
   $( ll := -ll
      zbyte(ll & #XFF)
      zbyte((ll >> 8) & #XFF)
   $)
   OR
   $( LET p = labv!l

      labv!l := progbuffp
      zbyte((p >> 8) & #XFF)
      zbyte(p & #XFF)
   $)
$)

AND relocate(address) BE
/*  Add  'address'  to  the  ones that need relocating at the end of the
module.  */
$( relocbuff!relocbuffp := address
   relocbuffp := relocbuffp + 1

   IF relocbuffp > relocsize THEN
      report("out of space for relocation items")
$)

AND code_stype(opcode, a, b) BE
/* Generate code for an 'S' type instruction.  */
$( TEST a = k.n THEN
   $( zbyte(opcode \/ #X46)
      zbyte(b)
   $)
   OR
      zbyte(opcode \/ register(a))
$)

 .
