; addtype.lsp               Gordon S. Novak Jr.           ; 02 Nov 00

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 16 Sep 99; 21 Sep 99; 14 Oct 99; 19 Oct 99; 26 Oct 99; 28 Oct 99; 09 Nov 99
; 11 Nov 99; 17 Oct 00; 26 Oct 00; 31 Oct 00; 02 Nov 00

(glispobjects

(pluginspec (list (msgspecs (listof msgspec))) )

(msgspec    (list (fnspec (cons (fnname symbol) (args (listof symbol))))
		  (adapterspecs (listof adapterspec))
		  (code-pattern anything) ) )

(adapterspec (cons (adaptername symbol)
		   (cons (howspec anything)
			 (props anything))) )

) ; glispobjects

(defvar accumspec)
(setq accumspec
  '( ( ( (update self value)
	 ((val  (fn item value) )
	  (pred (fn item 'boolean) default true) )
	 (if (pred item) (update (view self) (val item))) )
       ( (init self)
	 ()
	 (init self) )
       ( (final self)
	 ()
	 (final self) ) )) )

; 31 Oct 00
; Test whether all methods assumed for a plugin exist
(gldefun glmethodsexist ((ps pluginspec) (plugin gltype))
  (let (methodsig)
    (every #'(glambda (mspec)
	       (and (setq methodsig (glmsgarglist plugin (fnname mspec)))
		    (= (length methodsig) (length (args mspec)))))
	   (msgspecs ps) ) ))


; 16 Sep 99; 21 Sep 99; 31 Oct 00
; Clone an existing type.
; The new type will have its name substituted for the old type in the str.
; The specified type is made a super of the new type.
; returns new type symbol.
(defun glclonetype (type &optional (language 'lisp))
  (let ((name (glgensym type)))
    (eval (list 'glispobjects
		(list name
		      (subst name type
			     (gllangtype (car (glstr type)) language))
		      'supers (list type))))
    name))

; 17 Oct 00
; modify str for other languages
(defun gllangtype (str &optional (language 'lisp))
  (if (member (car str) '(list record crecord tuple))
      (case language
	(lisp str)
	((c c++ java pascal)
	  (cons 'crecord
		(cons name
		      (if (member (car str) '(record crecord))
			  (cddr str)
			(cdr str))))))
      str))

; 28 Oct 99; 17 Oct 00; 31 Oct 00
; Clone a set of types, substituting params into their structures
; entry is ((formals) ((type1 ...) ...))
; where the types are entry, collection, others.
; returns a list of the new types.
; (glclonetypes '((keytype)
;                 ((alistentry (list (key keytype)))
;                  (alist (listof alistentry) supers (alist-accumulator))))
;               '(symbol))
(defun glclonetypes (entry params &optional (language 'lisp))
  (let (subs result)
    (setq subs (mapcar #'(lambda (formal actual) (cons formal actual))
		    (car entry) params))
    (dolist (type (cadr entry))
      (push (cons (car type) (glgensym (car type))) subs) )
    (dolist (type (cadr entry))
      (eval (list 'glispobjects (sublis subs (gllangtype type language))))
      (push (sublis subs (car type)) result))
    (nreverse result) ))

; 17 Oct 00
; Test whether name is the name of a data field of structure str.
(defun glstrmember (name str)
  (let (result)
    (if (consp str)
	(case (car str)
	  ((atom symbol cons) (or (glstrmember name (cadr str))
				  (glstrmember name (caddr str))))
	  ((alist proplist list object atomobject listobject tuple)
	    (dolist (x (cdr str) result)
	      (setq result (or result (glstrmember name x))) ) )
	  ((record crecord)
	    (dolist (x (cddr str) result)
		    (setq result (or result (glstrmember name x)))))
	  (binding (glstrmember name (cadr str)))
	  (transparent (glstrmember name (glgetstr (cadr str))))
	  ((listof ^ units) nil)
	  (t (eq (car str) name)) ) ) ))

; 16 Sep 99; 19 Oct 99; 31 Oct 00
; cf. ap-make-carrier-type in windowio.lsp
; Add to an existing clone type to form a combined type.
; The first type (which should be a clone) is modified by:
;   1. adding to it the data of the second type (e.g. adder)
;   2. adding a view of the clone type as the second type
(defun gladdtype (type second)
  (let ((str (glstr type)) fields fieldsb (name (glgensym second)) tname)
    (setq fields (gldatanames (car (glstr second))))
    (setq fieldsb (mapcar #'(lambda (x) (cons (glgensym (car x)) x))
			  fields))
    (setf (car str) (gladdfields (car str)
			    (mapcar #'(lambda (x)
					(list (car x) (caddr x)))
				    fieldsb)))
    (setf (getf (cdr str) 'views)
	  (append (getf (cdr str) 'views)
		  (list (list name second name))))
    (setq tname (gentemp))
    (eval (list 'glispobjects
		(list name (list tname type)
		      'prop
		      (mapcar #'(lambda (x)
				  (list (second x)
					(list (list (first x) tname))))
			      fieldsb)
		      'supers (list second))))
    name
    ))

; 14 Oct 99
; Add fields to an existing type
(defun gladdfields (str fields)
  (case (car str)
    ((listof arrayof) (list (car str) (gladdfields (cadr str) fields)))
    (t (append str fields)) ) )

; 09 Nov 99
; Find the names of interface methods for a type
(defun glinterfaces (str)
  (let (propfntype quotelist)
    (and (setq propfntype (glcompprop str 'interfaces 'prop nil))
	 (consp (car propfntype))
	 (eq (caar propfntype) 'lambda)
	 (equal (cadr propfntype) '(listof symbol))
	 (consp (setq quotelist (caddar propfntype)))
	 (eq (car quotelist) 'quote)
	 (cadr quotelist) ) ))

; 11 Nov 99
; ? Add to a clone type the data and methods of a second type, e.g. adder.
(defun gladdtypeb (type second)
  (let ((super (car (glsupers type))) (methods (glinterfaces second)) )
    (gladddata type second)
))

; 26 Oct 00
; Get the argument list ((name type) ...) of a function
(defun glgetarglist (fn)
  (or (glarguments fn)
      (mapcar #'(lambda (x) (list (car x) (caddr x)))
	      (glarglist (second (gloriginalexpr fn))))))

; 26 Oct 00
; (glmsgarglist 'orer 'update)
; Get the argument list ((name type) ...) of a message to a type
(defun glmsgarglist (type msg &optional (proptype 'msg))
  (let* ((msglist (glpropdef type proptype msg))
	 (action (cadr msglist)) argl (context (list '())) newtype)
    (if (symbolp action)
	(glgetarglist action)
        (if (and (consp action)
		 (member (car action) '(lambda glambda)))
	    (progn
	      (setq argl (glarglist (second action)))  ; (name --- type)
	      (gladdstr (caar argl) nil type context)
	      (dolist (arg (cdr argl))
		(setq newtype (glevalstr (caddr arg) context))
		(gladdstr (car arg) nil newtype context) )
	      (nreverse (mapcar #'(lambda (x) (list (cadr x) (caddr x)))
				(car context))) )
	    (list (list 'self type)) ) ) ))

