; alist.lsp            Gordon S. Novak Jr.          ; 19 Jan 04
; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 03 Jan 00; 05 Jan 00; 06 Jan 00; 07 Jan 00; 12 Jan 00; 08 Feb 00; 10 Feb 00
; 11 Feb 00; 15 Feb 00; 17 Feb 00; 22 Feb 00; 24 Feb 00; 15 Mar 00; 20 Apr 00
; 28 Dec 00; 29 Dec 00; 02 Jan 01; 08 Feb 01; 20 Feb 01; 22 Feb 01; 27 Feb 01
; 01 Mar 01; 12 Mar 01; 07 Jun 01; 31 Jul 01; 13 Sep 01; 01 Nov 01; 13 Feb 03
; 18 Feb 03; 20 Feb 03; 11 Mar 03

; see also ctr.lsp

; Given a list of entries ((symbol number) ...)
; produce an alist of sum of numbers for each symbol
; (alsum '((a 3) (b 2) (c 1) (a 5) (c 7)))
(defun alsum (lst)                        ; handwritten version
  (let ((alist nil) entry)
    (dolist (item (identity lst))
      (setq entry
	    (or (assoc (car item) alist)
		(progn (push (list (car item) 0) alist)
		       (assoc (car item) alist))))
      (incf (cadr entry) (cadr item)) )
    alist))

; 05 Jan 00; 07 Jan 00; 10 Feb 00; 11 Feb 00; 15 Feb 00; 20 Apr 00; 29 Dec 00
; "object-oriented" version
; (glspecialize 'itacc '(myinputv myalcoll))  ; --> itacc0
; (itacc0 '((a 3) (b 2) (c 1) (a 5) (c 7)))
; (glspecialize 'itacc '(myinputvb mycollb))
; (glspecialize 'itacc '(myinputvc mycollc))
(gldefun itacc ((input anything) (omit (acct anything)))
  (let (acc item iter)
    (acc = (a (typeof acct)))
    (send acc init)
    (iter = (send input sequence))
    (while (not (send iter done))
      (item = (send iter next))
      (acc = (send acc update item)) )
    acc))

; 15 Feb 00; 19 Jan 04
(gldefun findupd ((coll anything) (item anything))
  (let (entry)
    (entry = (send coll find (send item key)))
    (if (null entry)
	(progn (coll = (send coll insert (send item key)))
	       (entry = (send coll find (send item key)))))
        ; should (send entry init)
    (send entry update item)
    coll ))

; 20 Feb 01; 22 Feb 01; 01 Mar 01; 13 Sep 01
; higher-order program version
; (glspecialize 'itaccb '(myinputv myspec1))
(gldefun itaccb (input (omit spec))
  (let (acc item iter)
    (acc = (a (acctype spec)))
    (init acc)
    (iter = (cast (funcall (sequence spec) input) (seqtype spec)))
    (while (not (done iter))
      (item = (cast (next iter) (itemtype spec)))
      (acc = (update acc item)) )
    acc))

; 20 Feb 01; 22 Feb 01; 27 Feb 01; 01 Mar 01; 12 Mar 01; 13 Sep 01
; 19 Jan 04
; higher-order program version
(gldefun findupdb (coll item)
  (let (entry)
    (entry = (find coll (funcall (key coll) item)))
    (if (null entry)
	(progn (coll = (insert coll (funcall (key coll) item)))
	       (entry = (find coll (funcall (key coll) item)))
	       (for v in (update-views entry) do
		    (init (funcall v entry)))))
    (for v in (update-views entry) do
      (update (funcall v entry) item))
    coll ))

; 01 Mar 01
(gldefun multi-update (coll item)
  (for v in (update-views coll) do
    (update (funcall v coll) item) )
  coll)

(gldefun multi-init (coll)
  (for v in (update-views coll) do
    (init (funcall v coll)) ) )

; 27 Feb 01
(gldefun myview2dtest ((item myinputitem)) (oddp (price item)))
(setf (glinline 'myview2dtest) t)

; 13 Feb 03
; higher-order program for adder update
; (glspecialize 'addr-update1 '(mydata3 myitem3 myspec3))
(gldefun addr-update1 ((data anything) (item anything) (omit (spec gltype)))
  (if (funcall (test spec) item)
      ((funcall (dataview spec) data) _+ (funcall (itemview spec) item))) )

; 13 Feb 03; 18 Feb 03
; higher-order program for adder update
(gldefun addr-update (self (data anything) (item anything)
			   (omit (spec anything)))
  (if (funcall (test spec) item)
      ((funcall (dataview spec) data) _+ (funcall (itemview spec) item))) )

; 11 Mar 03
; higher-order program for adder update
; (glspecialize 'addr-update1 '(mydata3 myitem3 myspec3))
(gldefun addr-update2 ((data anything) (item anything))
  (if (funcall (test data) item)
      ((funcall (dataview data) data) _+ (funcall (itemview data) item))) )

; 20 Feb 03
; higher-order program for listr update
(gldefun listr-update (self (data anything) (item anything)
			   (omit (spec anything)))
  (if (funcall (test spec) item)
      ((funcall (dataview spec) data) _+ (funcall (itemview spec) item))) )

; 11 Mar 03
; higher-order program for listr update
(gldefun listr-update2 ((data anything) (item anything))
  (if (funcall (test data) item)
      ((funcall (dataview data) data) _+ (funcall (itemview data) item))) )

; 18 Feb 03; 20 Feb 03
(gldefun t713 ((itm myitem3))
  (let ((dat (a mydata3)))
    (glsend dat update1 itm)
    (glsend dat update2 itm) ))

; 20 Feb 03
(gldefun t714 ((itm myitem3))
  (let ((dat (a mydata3)))
    (for op in '(update1 update2)
	 (glsendv dat op itm) )
    dat))

; 11 Mar 03
(gldefun t715 ((d mydata2a) (itm myitem3)) (update d itm))

; 11 Mar 03; 12 Mar 03
(gldefun t716 ((d mydata2) (itm myitem3))
  (for v in (viewnames d) (glsend (glsendv d v) update itm)) )

(glispobjects

(list-iterator (lst (listof anything))
  prop ((itemtype (nil)))
  msg ((done   ((null lst)))
       (next   ((if (known (itemtype self))
		    (cast (pop lst) (itemtype self))
		    (pop lst)))) ) )

(find-update-oo anything
  msg ((update findupd open t)) )

(find-update-oob anything
  msg ((update findupdb open t)) )

(update-oob anything
  msg ((init   multi-init   open t)
       (update multi-update open t)) )

(lisp-alist (listof (cons (key anything) (rest anything)))
  msg ((init   (nil) result (typeof self))
       (find   (glambda (self key) (assoc key self)))
       (insert (glambda (self key)
                 (cons (a (typeof (first self)) with key = key)
		       self)))) )

(myinput (listof myinputitem))

(myinputitem (list (name symbol) (price integer)) )

; 20 Apr 00
(myinputv (z myinput)   ; wrap input data to extract sequence
  prop ((sequence ((a mylist-iterator with lst = self)))))

(myalrec (z myinputitem)        ; wrapped input data item
  prop ((accdata ((price z)))
	(key     ((name z)))) )

(mylist-iterator (lst (listof myinputitem))   ; iterator, wraps item type
  prop   ((itemtype ('myalrec)))
  supers (list-iterator))

(myalcoll (listof myaldata)       ; collection type, inherits from alist and FU
  supers (lisp-alist find-update-oo) )

(myaldata (list (key symbol) (data integer))  ; wrapped alist data
  prop ((updates    ('(upd-view1))) )
  msg  ((init       ((send (view1 self) init) self))
	(upd-view1  (glambda (self item)
		      (if (pred1 self value)
		          (update (view1 self) (accdata item)))) )
	(pred1        true) )
  views ((view1 adder myview1))
  supers (alistelement) )      ; in ctr.lsp

(myview1 (z123 myaldata)       ; view of alist data for adder
  prop ((sum ((data z123))))
  supers (adder))


; 20 Feb 01; 27 Feb 01; 01 Mar 01; 07 Jun 01
; spec to specialize itaccb: higher-order program version
(myspec1 anything
  prop ((sequence     ('identity))
	(seqtype      ('list-iterator))
	(itemtype     ('myinputitem))
	(acctype      ('mycolld)) ) )

(mycolld (listof mydatad)       ; collection type, inherits from alist and FU
  prop  ((key          ('name)) )
  supers (lisp-alist find-update-oob) )

; wrapped alist data
(mydatad (list (key symbol) (data integer+) (prod integer*))
  prop  ((update-views ('(myview1d myview2d))) )
  views ((myview1d nil myview1d)              ; adderb
	 (myview2d nil myview2d)))            ; multiplierb

(myview1d (z12 mydatad)       ; view of alist data for adder
  prop ((sum ((data z12)))
	(itemview ('price))
	(test     ('true)))
  supers (adderb))

(myview2d (z13 mydatad)       ; view of alist data for adder
  prop ((sum ((prod z13)))
	(itemview ('price))
	(test     ('(glambda (item) (oddp (price item))))) )
                  ; or ('myview2dtest)
  supers (multiplierb))


; spec to specialize itaccb: higher-order program version
(myspec2 anything
  prop ((sequence     ('identity))
	(seqtype      ('list-iterator))
	(itemtype     ('myinputitem))
	(acctype      ('mycolle)) ) )

(mycolle (list (data integer+))
  prop  ((update-views ('(view1))) )
  views ((view1 adderb myview2e))
  supers (update-oob) )

(myview2e (z14 mycolle)       ; view of data for adder
  prop ((sum ((data z14)))
	(itemview ('price))
	(test     ('true)))
  supers (adderb))


; 22 Feb 00; 20 Apr 00
; second set of types to accumulate sum, product
(myinputvb (z myinput)
  prop ((sequence ((a mylist-iteratorb with lst = self)))))

(myalrecb (z myinputitem)
  prop ((data1 ((price z)))
	(data2 ((price z)))) )

(mylist-iteratorb (lst (listof myalrecb))
  supers (list-iterator))

(mycollb (list (summ adder) (prod multiplier))
  msg  ((init       ((send (view1 self) init)
		     (send (view2 self) init)
		     self))
	(update     (glambda (self item)
		      (send (view1 self) update (send item data1))
		      (send (view2 self) update (send item data2))
		      self) ) )
  views ((view1 adder myview1b)
	 (view2 multiplier myview2b)) )

(myview1b (z1234 mycollb)
  prop ((sum ((summ z1234))))
  supers (adder))

(myview2b (z2341 mycollb)
  prop ((sum ((prod z2341)) result multiplier))
  supers (multiplier))

; 22 Feb 00; 20 Apr 00
; third set of types to accumulate sum
(myinputvc (z myinput)
  prop ((sequence ((a mylist-iteratorc with lst = self)))) )

(myalrecc (z myinputitem)
  prop ((data1 ((price z))) ))

(mylist-iteratorc (lst (listof myalrecc))
  supers (list-iterator))

(mycollc (summ integer)
  msg  ((init       ((send (view1 self) init)
		      self))
	(update     (glambda (self item)
		      (send (view1 self) update (send item data1))
		      self) ) )
  views ((view1 adder myview1c)) )

(myview1c (z234 mycollc)
  prop ((sum ((summ z234))))
  supers (adder))

; list of integers, to be plugged into adder directly
; (glspecialize 'itacc '(myinputli 'adder))

(myinputli (listof integer)
  prop ((sequence (self) result myli-iterator)))

(myli-iterator (lst (listof integer))
  supers (list-iterator))

(myspec3 anything
  prop ((test     ('heavy))
	(dataview ('bar))
	(itemview ('weight)) ) )

(addr integer
  msg  ((update addr-update open t)) )

(addrspec (list (test symbol) (dataview symbol) (itemview symbol)))

(listr (listof anything)
  msg  ((update listr-update open t)) )

(listrspec (list (test symbol) (dataview symbol) (itemview symbol)))

(mydata3 (list (foo real) (bar addr) (fum listr))
  msg  ((update1 (glambda (dat itm)
		   (update (bar dat) dat itm
			   (cast '(heavy bar weight) 'addrspec))) )
	(update2 (glambda (dat itm)
		   (update (fum dat) dat itm
			   (cast '(true fum name) 'listrspec))))))
    ; didn't work:  (a listrspec test 'true dataview 'fum itemview 'name)

(myitem3 (list (name string) (weight integer))
  adj   ((heavy   (weight > 100)) )  )

(addr2 integer
  msg  ((update addr-update2 open t)) )

(listr2 (listof anything)
  msg  ((update listr-update2 open t)) )

(mydata2 (list (foo real) (bar addr2) (fum listr))
  prop ((view1 (self) result mydata2a)
	(view2 (self) result mydata2b)
	(viewnames ('(view1 view2)))) )

(mydata2a mydata2
  prop ((test      ('heavy))
	(dataview  ('bar))
	(itemview  ('weight)) )
  supers (addr2))

(mydata2b mydata2
  prop ((test      ('true))
	(dataview  ('fum))
	(itemview  ('name)) )
  supers (listr2))

) ; glispobjects
