; apdoc.lsp                  Gordon S. Novak Jr.            ; 02 Apr 09

; Copyright (c) 2009 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; Documentation of generic functions for use with automatic programming server

; 28 Jan 97; 03 Jan 2000


(setf (glinfo 'linked-list)
      '("A linked list is a data structure composed of element records,"
	"each of which contains one or more contents fields and a link"
	"field containing a pointer to the next element in the list."
	""
	"       -------       -------       -------"
	"       |  *--+------>|  *--+------>|  *--+------> ..."
	"       -------       -------       -------"
        "       |     |       |     |       |     |"
        "       |  A  |       |  B  |       |  C  |"
	"       -------       -------       -------"))

(setf (glinfo 'append)
      '("APPEND concatenates two linked lists, making a copy of the first list"
	"and reusing the second list."
	"(APPEND '(A B C) '(D E)) = (A B C D E)"))

(setf (glinfo 'nconc)
      '("NCONC concatenates two linked lists destructively."
	"The link pointer at the end of the first list is changed"
	"to point to the second list."
	"(NCONC '(A B C) '(D E)) = (A B C D E)"))

(setf (glinfo 'nreverse)
      '("NREVERSE destructively reverses the elements of a linked list"
	"by reversing the pointers in the existing list elements."
	"(NREVERSE '(A B C)) = (C B A)"))

(setf (glinfo 'length)
      '("LENGTH finds the length (number of elements) of a linked list."
	"(LENGTH '(A B C)) = 3"))

(setf (glinfo 'length-up-to)
      '("LENGTH-UP-TO finds the length (number of elements) of a linked list,"
	"but quits when a specified maximum is reached."
	"E.g., to answer the question 'Are there at least 10 people in Austin?'"
	"it isn't necessary to count them all."
	"(LENGTH-UP-TO '(A B C D E) 3) = 3"))

(setf (glinfo 'nthcdr)
      '("NTHCDR skips down N elements of a linked list, where N >= 0."
	"[Note that the order of arguments is different from Common Lisp.]"
	"(NTHCDR '(A B C D E) 2) = (C D E)"))

(setf (glinfo 'reverse)
      '("REVERSE makes a copy of a linked list in reverse order."
	"The original list is unchanged."
	"(REVERSE '(A B C)) = (C B A)"))

(setf (glinfo 'copy-list)
      '("COPY-LIST makes a copy of a linked list by copying each element."
	"(COPY-LIST '(A B C)) = (A B C)"))

(setf (glinfo 'last)
      '("LAST returns the last element of a linked list."
	"(LAST '(A B C)) = (C)"))

(setf (glinfo 'sorted-linked-list)
      '("A sorted linked list is a linked list in which the elements"
	"are ordered according to a sorting predicate on the contents"
	"of the records."))

(setf (glinfo 'remove-key)
      '("REMOVE-KEY destructively removes the first item from a linked list"
	"that has the specified key value."))

(setf (glinfo 'insert)
      '("INSERT places its argument record at the appropriate place"
	"in a sorted structure, modifying the existing structure."
	"The argument type is the record type of the structure."))

(setf (glinfo 'insert)
      '("INSERT inserts an item at the appropriate place in a"
	"sorted structure, modifying the existing structure."
	"The argument type is the type of the record value."))

(setf (glinfo 'insert-key)
      '("INSERT-KEY makes a new record containing the specified"
	"key value and inserts it at the appropriate place in a"
	"sorted structure, modifying the existing structure."
	"The argument type is the type of the key value."))

(setf (glinfo 'copy-tree)
      '("COPY-TREE makes a copy of a tree structure."))

(setf (glinfo 'member)
      '("MEMBER tests whether a specified key value occurs in a"
	"sorted structure.  The result is the element of the structure."))

(setf (glinfo 'size)
      '("SIZE returns the size (number of elements) of a structure."))
	"sorted structure.  The result is the element of the structure."))

(setf (glinfo 'sort)
      '("SORT destructively rearranges the elements of an ordered"
        "structure, by changing pointers,  so that the elements are"
	"ordered according to a specified sorting predicate."))

(setf (glinfo 'merge)
      '("MERGE destructively merges two sorted structures into one,"
	"changing the pointers in the element records to produce a"
	"single sorted structure of the same type."))

(setf (glinfo 'flatten)
      '("FLATTEN destructively converts a binary tree structure into"
	"a linear linked-list structure, reusing the same elements"
	"and linking them together using their 'right' pointers."
	"The left-this-right sorting order of the original tree is"
	"maintained, so that a sorted tree is converted to a sorted list."))

(setf (glinfo 'binary-tree)
      '("A binary tree is a tree structure formed from records of the"
	"same type.  Each record has some contents, and it has two"
	"pointer fields 'left' and 'right' that point to subtrees"
	"or are null."
	"                     ---------"
        "                     |   B   |"
	"                     ---------"
	"                     | * | * |"
	"                     -/-----\\-"
	"                     /       \\"
	"                    /         \\"
	"                   /           \\"
	"                  v             v"
	"              ---------      ---------"
        "              |   A   |      |   C   |"
	"              ---------      ---------"
        "              |   |   |      |   |   |"
	"              ---------      ---------"))

(setf (glinfo 'avl-tree)
      '("An AVL tree is an approximately height-balanced binary tree."
	"Search takes approximately O(log(n)) time because the tree is"
	"balanced.  Insertion is also fast, and the algorithm rebalances"
	"the tree as necessary." ""
	"The tree element requires, in addition to the application data,"
	"a BALANCE field (a small signed integer) and two pointer fields"
	"for the binary tree structure.  If the specified data does not"
	"contain such fields, the system will create an appropriate"
	"carrier record structure." ""
	"Ref: G. M. Adel'son-Vel'skii and E. M. Landis, Soviet Math. 3,"
	"1259-1263, 1962; D. Knuth, The Art of Computer Programming, vol. 3:"
	"Sorting and Searching, Addison-Wesley, 1973, section 6.2.3."))

(setf (glinfo 'data-structures)
      '("The Automatic Programming Server produces versions of generic"
	"procedures that are specialized for the user's data structures."
	"The first step is to describe your data to the system by"
	"entering a data description in the input box."
	"Click the mouse in the input box, and a cursor should appear."
	"The editor is an emacs subset."
	"When finished, click the mouse outside the input box."
	"Repeat the process as needed to define other data types."))

(setf (glinfo 'lisp-data-structures)
      '("For Lisp programs, you should specify the Lisp data structure"
	"that you wish to use.  The basic syntax of a data specification is:"
        "            (name type)"
	"A type is a basic type (integer, real, number, string, symbol,"
	"boolean, or anything) or a structuring operator applied to types."
	"The structuring operators are:"
	"   (cons type1 type2)"
	"   (list type1 ... typen)"
	"   (symbol (proplist prop1 ... propn))  where each prop is (name type)"
	"   (^  type)                            (a pointer to a named type)"
	"   (listof  type)"
	"   (arrayof  type)"
	""
	"An example data declaration for a person data structure is:"
	"   (person (list (name   string)"
        "                 (age    integer)"
        "                 (salary real)"
        "                 (spouse (^ person))))"))

(setf (glinfo 'other-data-structures)
      '("A single syntax is used for describing data structures in"
	"languages other than Lisp.  The syntax for describing a record is:"
	"   (name (field1 type1) ... (fieldn typen))"
	"Each type is either a basic type (integer, real, string, boolean, or"
	"anything), the name of another type, or a pointer to a type, denoted"
	"   (^ type)"
	""
	"An example declaration for a person data structure is:"
	"   (person (name   string)"
        "           (age    integer)"
        "           (salary real)"
        "           (spouse (^ person)))"
	"The system will generate a declaration for the structure in the"
	"target language."
	""
	"If the desired data is just a basic type, e.g. string,"
        "simply enter the basic type by itself."))

(setf (glinfo 'ap-server)
      '("The Automatic Programming Server creates specialized versions"
	"of generic programs and serves them to the user."
	"The system uses Views that describe how the user's data types"
	"correspond to abstract types known to the system."
	"Given a view, a generic program written in terms of the abstract"
	"type can be specialized to operate directly on the user's data."
	"Programs can be delivered in Lisp, C, C++, Java, or Pascal."
	""
	"To obtain programs, follow these steps:"
	"   1. Describe your data structure(s) to the system."
	"   2. Make a view of your data as abstract data."
	"   3. Select the programs you want."
	""
	"Source code for the generated programs is served to the user"
	"as a text file after the session terminates."))

(setf (glinfo 'views)
      '("Views describe how the user's data types correspond to abstract"
	"types known to the system.  There are two kinds of views:"
	""
	"Data structure views describe structures of data records,"
	"usually involving pointers.  These include linked list,"
	"sorted linked list, binary tree, and AVL tree.  If user data"
	"includes appropriate pointer fields, a view will be made using"
	"those fields.  If not, a carrier record will be defined to hold"
	"the data.  For example, if you want an AVL tree containing"
	"strings, you can simply specify 'string' as your data type."
	""
	"Mathematical views involve mathematical or geometric objects"
	"such as lines, circles, etc.  These views are made by connecting"
	"buttons on a diagram of the view to the corresponding fields"
	"of the user data."))
