; boxes.lsp              Gordon S. Novak Jr.            ; 05 Jan 16

; Copyright (c) 2016 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 06 Nov 97; 11 Nov 97; 13 Nov 97; 18 Nov 97; 25 Nov 97; 23 Dec 97; 24 Dec 97
; 26 Dec 97; 29 Dec 97; 30 Dec 97; 31 Dec 97; 02 Jan 98; 29 Jan 98; 03 Feb 98
; 05 Feb 98; 10 Feb 98; 12 Feb 98; 17 Feb 98; 19 Feb 98; 24 Feb 98; 26 Feb 98
; 03 Mar 98; 05 Mar 98; 06 Mar 98; 10 Mar 98; 12 Mar 98; 16 Mar 98; 17 Mar 98
; new version: 10 Nov 98; 12 Nov 98; 17 Nov 98; 19 Nov 98; 24 Nov 98; 01 Dec 98
; 03 Dec 98; 07 Dec 98; 08 Dec 98; 17 Dec 98; 18 Dec 98; 21 Dec 98; 22 Dec 98
; 23 Dec 98; 24 Dec 98; 28 Dec 98; 29 Dec 98; 30 Dec 98; 31 Dec 98; 07 Jan 99
; 11 Jan 98; 13 Jan 99; 15 Jan 99; 04 Feb 99; 25 Feb 99; 20 Apr 99; 03 Jan 00
; 10 Jan 01; 28 Feb 02; 19 Jan 04

; Simple case: only need to specify input type.
; (setq b1 (swbox-create 'itacc nil))
; (swbox-conclude (list b1 'input 'type) '(arrayof integer))
; (swbox-to-gl b1)
; (gldefun t41 ((l ITACC1)) (sum l))   ; (t41 '#(1 2 17 22))

; Add a view of the item and a selection
; (setq b2 (swbox-create 'itacc nil))
; (swbox-conclude (list b2 'input 'type) '(listof integer))
; (swbox-refine-conn b2 (swbox-conn b2 'itemview))
; (swbox-refine-comp (swbox-part b2 'iterator) 'filterfn)
; (swbox-to-gl b2)
; (swbp b2)

; A non-basic type
; (setq b3 (swbox-create 'itacc nil))
; (swbox-conclude (list b3 'input 'type) '(listof person))
; (swbox-refine-conn b3 (swbox-conn b3 'itemview))
; (swbox-refine-comp (swbox-part b3 'iterator) 'filterfn)
; (swbox-to-gl b3)

; Initial value for the accumulator
; (setq b4 (swbox-create 'itacc nil))
; (swbox-conclude (list b4 'input 'type) '(listof real))
; (swbox-set-value (swbox-part b4 'accumulator) 'initial-value 5.5)
; (swbox-to-gl b4)

; Histogram
; (setq b5 (swbox-create 'itacc nil))
; (swbox-conclude (list b5 'input 'type) '(listof integer))
; (swbox-specialize (swbox-part b5 'accumulator) 'histaccum)
; (swbox-set-value (swbox-part b5 'accumulator) 'low-value 400)
; (swbox-set-value (swbox-part b5 'accumulator) 'high-value 800)
; (swbox-set-value (swbox-part b5 'accumulator) 'step 10)
; (swbox-to-gl b5)

; AVL tree of words from a string
; (ld kwic)
; (ap-make-carrier-type 'avl-tree '((contents string)) 'lisp
;                       'avl-tree-of-string)
; (setq b6 (swbox-create 'itacc nil))
; (swbox-conclude (list b6 'input 'type) 'string-of-words)
; (swbox-to-gl b6)
; (gldefun t46 ((l ITACC6)) (sum l))
; (setq avlres (t46 "to be or not to be: that is NP complete."))
; (gldefun avlpr ((tr avl-tree-of-string)) (for x in tr (print (contents x))))
; (avlpr avlres)

; AVL tree of words from a file
; (setq b7 (swbox-create 'itacc nil))
; (swbox-conclude (list b7 'input 'type) 'file-of-words-generator)
; (swbox-refine-conn b7 (swbox-conn b7 'itemview))   ; string-downcase
; (swbox-to-gl b7)
; (gldefun t47 ((l ITACC7)) (sum l))
; (avlpr (t47 "/u/novak/test.file"))

; Box viewed as a linked list
; (viewas 'linked-list 'box)
; (setq b8 (swbox-create 'itacc nil))
; (swbox-conclude (list b8 'input 'type) 'box)
; (swbox-refine-conn b8 (swbox-conn b8 'seqview))  ; linked-list, 1 arg
; (swbox-refine-conn b8 (swbox-conn b8 'itemview)) ; size
; (swbox-to-gl b8)
; (gldefun t48 ((l ITACC8)) (sum l))
; (t48 mybox)

; length of list by viewing as 1
; (setq b9 (swbox-create 'itacc nil))
; (swbox-conclude (list b9 'input 'type) '(listof integer))
; (swbox-refine-conn b9 (swbox-conn b9 'itemview))  ; change to 1
; (swbox-to-gl b9)
; (gldefun t49 ((l ITACC9)) (sum l))
; (t49 '(1 17 23 47))

; count words by viewing string as 1
; (setq b10 (swbox-create 'itacc nil))
; (swbox-conclude (list b10 'input 'type) 'file-of-words-generator)
; (swbox-refine-conn b10 (swbox-conn b10 'itemview))  ; change to 1
; (swbox-to-gl b10)
; (gldefun t50 ((l ITACC10)) (sum l))
; (t50 "/u/novak/test.file")

; words from file to list
; (setq b11 (swbox-create 'itacc nil))
; (swbox-conclude (list b11 'input 'type) 'file-of-words-generator)
; (swbox-specialize (swbox-part b11 'accumulator) 'listaccum)
; (swbox-to-gl b11)
; (gldefun t51 ((l ITACC11)) (sum l))
; (t51 "/u/novak/test.file")

; word count on a file: do avl-string-count in ifa.lsp first.
; (setq b12 (swbox-create 'itacc nil))
; (swbox-conclude (list b12 'input 'type) 'file-of-words-generator)
; (swbox-refine-conn b12 (swbox-conn b12 'itemview))   ; string-downcase
; (swbox-specialize (swbox-part b12 'accumulator) 'avlstringcountaccum)
; (swbox-to-gl b12)
; (gldefun t52 ((l ITACC12)) (sum l))
; (setq res (t52 "/u/novak/test.file"))
; (gldefun avlcprint ((acc avl-string-count))
;   (for item in (avl-tree acc)
;     (format t "~A ~D~%" (contents item) (count item))))
; (avlcprint res)

; make a list of primes up to n
; (setq b13 (swbox-create 'itacc nil))
; (swbox-conclude (list b13 'input 'type) 'integer)
; (swbox-refine-comp (swbox-part b13 'iterator) 'filterfn)
; (swbox-specialize (swbox-part b13 'accumulator) 'listaccum)
; (swbox-to-gl b13)
; (gldefun t53 ((l ITACC13)) (sum l))
; (t53 100)

(setf (glfnresulttype 'string-downcase) 'string) ; needed for example

(defmacro glswspec           (x) `(get ,x 'glswspec))


(glispobjects

(boxspec (symbol
	  (proplist (glswspec
	   (proplist
	     (kind   symbol)
	     (parts  (listof (list (name symbol) (spec boxspec))))
	     (types  (listof (list (name symbol) (source typepath))))
	     (slots  (listof slot))
	     (conns  (listof swconn))
	     (rules  (listof rule))
	     (supers (listof boxspec))   ; generalizations of this box
	     (subs   (listof boxspec))   ; specializations of this box
	     (pattern boxpattern)
	     )) ) )
  msg   ((make-instance  (glambda (self) (gentemp (symbol-name self)))
			 result swbox)
	 ) )

(slot (cons (name symbol)
	    (facets (listof anything)))
  msg  ((facet      (glambda (self name)
		      (getf (facets self) name)))
	(set-facet  (glambda (self name value)
		      (setf (getf (facets self) name) value)))  ) )

(swconn (cons (name symbol)
	      (cons (from swport)
		    (cons (to swport) (props anything))))
  msg  ((facet     (glambda (self nm)
		     (getf (props self) nm)))
	(set-facet (glambda (self name value)
		     (setf (getf (props self) name) value)))  ) )

(swport (list (slot symbol) (box swbox)))

(swbox (symbol
	 (proplist
	   (spec           boxspec)                ; spec for this box
	   (partof         swbox)
	   (parts          (listof namebox))
	   (slots          (listof slot))
	   (conns          (listof swconn))
	   (justifications (listof justification))
	   (vars           (listof glnametype))
; agenda:  queue of user interactions that could be executed
; done:    specification of the box is complete
; a box could have data, code, equations
	     ))
  msg  ((slot          (glambda (self nm)
		         (that (slots self) with name == nm)))
	(slot!         (glambda (self nm)
			 (or (slot self nm)
			     (let ((s (a slot with name = nm)))
			       ((slots self) _+ s)
			       s))))
	(facet         swbox-facet open t)
	(set-facet     swbox-set-facet open t)
	(set-partof    swbox-set-partof) )
  )

(namebox (list (name symbol)
	       (box swbox)) )

(rule  (list (name      symbol)
	     (inputs    (listof anything))      ; box or (slot box)
	     (bindings  (listof rule-binding))
	     (predicate anything)
	     (action    anything))
       )

(rule-binding (list (var symbol)
		    (bind (transparent bsf))) )

; box-slot-facet
(bsf (list (box swbox) (slot symbol) (facet symbol)) )

(justification (list (rulename   symbol)
		     (premises   (listof bsf))
		     (conclusion bsf)) )

; 17 Dec 98
(boxpattern (list (bindings (listof (list (name symbol)
					  (path anything))))
		  (outpatterns (listof outpat))))

(outpat (list (name symbol) (kind symbol) (output anything)))

) ; glispobjects

(defvar *swcodegenn* 0)                ; sequence number for code generation
(glispglobals (*swcodegenn* integer))

(defmacro glswspec           (x) `(get ,x 'glswspec))

; 10 Nov 98
; Define a software spec
(defun defswspec (spec)
  (let (sups (name (car spec)) (props (cdr spec)))
    (setf (glswspec name) props)
    (if (setq sups (getf props 'supers))
	(mapc #'(lambda (x)
		  (pushnew name (getf (glswspec x) 'subs)))
	      sups)) ))

(defswspec
'(itacc  kind composite
   parts   ((iterator    iterator)
	    (accumulator accumulator))
   types   ((inputtype   (typeof input))
	    (itemtype    (itemtype iter))     ; ??? should be iterator?
	    (outputtype  (typeof output)))
   slots   ((input       abstract-type anything)
	    (output      abstract-type anything))
   conns   ((seqview     (input self)         (input iterator))
	    (itemview    (item iterator)      (input accumulator))
	    (final       (output accumulator) (output self)))
   pattern (((inputtype  (type (input self)))
	     (acctype    (type (accumulator (accumulator self))))
	     (itemcode   (code (code (itemview self))))
	     (filtercode (code (code (filterfn (iterator self))))) )
	    ((itacc type
		    ((input inputtype)
		      prop  ((accumulator (nil) result acctype)
			     (if itemcode (itemview ((quote itemcode))))
			     (if filtercode (filterfn ((quote filtercode)))))
		      supers (ifa-framework)))) )
   ))

(defswspec
'(iterator  kind iterator
   types    ((seqtype   (typeof input))
	     (itemtype  (typeof output)))
   slots    ((input     abstract-type (sequence anything))
	     (filterfn  abstract-type (function (typeof item) boolean))
	     (item      abstract-type anything))
   rules    ((rule102 (self)
		      ((t1 (self input type)))
		      t1
		      (swbox-conclude '(self item type)
				      (glloopitemtype t1))) )
   ))

(defswspec
'(accumulator  kind abstract
   types    ((inputtype    (typeof input))
	     (accumtype    (typeof accumulator))
	     (outputtype   (typeof output)))
   slots    ((input        abstract-type anything)
	     (output       abstract-type anything))
   rules    ((rule107 (self)
		      ((t1 (self input type)))
		      (eq t1 'integer)
		      (swbox-specialize 'self 'intaccum))
	     (rule108 (self)
		      ((t1 (self input type)))
		      (eq t1 'real)
		      (swbox-specialize 'self 'realaccum))
	     (rule109 (self)
		      ((t1 (self input type)))
		      (eq t1 'string)
		      (swbox-specialize 'self 'avlstringaccum)) )
   ))

(defswspec
'(intaccum  kind concrete
   slots    ((input         type integer)
	     (initial-value type integer default 0)
	     (accum         type integer-accumulator)
	     (output        type integer))
   supers   (accumulator)
   pattern (((accinit    (or (value (initial-value self))
			     (default (initial-value self)))))
	    ((accumulator type
	       (integer
		 prop  ((if accinit (initial-value (accinit))))
		 supers (integer-accumulator)))) )
   ))

(defswspec
'(countaccum  kind concrete
   slots    ((input         type anything)
	     (initial-value type integer default 0)
	     (accum         type count-accumulator)
	     (output        type integer))
   supers   (accumulator)
   pattern (((accinit    (or (value (initial-value self))
			     (default (initial-value self)))))
	    ((accumulator type
	       (integer
		 prop  ((if accinit (initial-value (accinit))))
		 supers (count-accumulator)))) )
   ))

(defswspec
'(realaccum  kind concrete
   slots    ((input         type real)
	     (initial-value type real default 0.0)
	     (accum         type real-accumulator)
	     (output        type real))
   supers   (accumulator)
   pattern (((accinit    (or (value (initial-value self))
			     (default (initial-value self)))))
	    ((accumulator type
	       (real
		 prop  ((if accinit (initial-value (accinit))))
		 supers (real-accumulator)))) )
   ))

(defswspec
'(histaccum  kind concrete
   slots    ((input        type number)
	     (low-value    type number default 0)
	     (high-value   type number default 1)
	     (step         type number default 1)
	     (accum        type histogram-accumulator)
	     (output       type histogram-accumulator))
   supers   (accumulator)
   pattern (((low          (or (value (low-value self))
			       (default (low-value self))))
	     (high         (or (value (high-value self))
			       (default (high-value self))))
	     (stepval      (or (value (step self))
			       (default (step self)))) )
	    ((accumulator type
	       ((arrayof integer)
		 prop  ((if low (low-value (low)))
			(if high (high-value (high)))
			(if stepval (step (stepval))) )
		 supers (histogram-accumulator)))) )
   ))

(defswspec
'(avlstringaccum  kind concrete
   slots    ((input         type string)
	     (initial-value type avl-tree-of-string default nil)
	     (accum         type avl-tree-of-string)
	     (output        type avl-tree-of-string))
   supers   (accumulator)
   pattern (()
	    ((accumulator type
	       (avl-tree-of-string
		 supers (avl-string-accumulator)))) )
   ))

(defswspec
'(avlstringcountaccum  kind concrete
   slots    ((input         type string)
	     (initial-value type avl-string-count default nil)
	     (accum         type avl-string-count)
	     (output        type avl-string-count))
   supers   (accumulator)
   pattern (()
	    ((accumulator type
	       (avl-string-count
		 supers (avl-string-count-accumulator)))) )
   ))

(defswspec
'(listaccum  kind concrete
   slots    ((input         type anything)
	     (initial-value type (listof anything) default ())
	     (accum         type (listof anything))
	     (output        type (listof anything)))
   supers   (list-accumulator)
   pattern (((accinit    (or (value (initial-value self))
			     (default (initial-value self)))))
	    ((accumulator type
	       ((listof anything)
		 prop  ((if accinit (initial-value (accinit))))
		 supers (list-accumulator)))) )
   ))

(defswspec
'(computation  kind concrete
   slots    ((input        abstract-type anything)
	     (code)
	     (output       abstract-type anything))
   supers   ()
   ))

; 15 Jan 99
(defswspec                    ; Find minimum and update
'(fminu  kind composite
   parts   ((iterator    iterator)
	    (update      computation))
   types   ((inputtype   (typeof input))
	    (itemtype    (itemtype iter))
	    (outputtype  (typeof output)))
   slots   ((input       abstract-type anything)
	    (output      abstract-type anything))
   conns   ((seqview     (input self)         (input iterator))
	    (itemview    (item iterator)      (input update))
	    (final       (output update) (output self)))
   pattern (((inputtype  (type (input self)))
	     (updatecode (code (code (update self))))
	     (itemcode   (code (code (itemview self))))
	     (filtercode (code (code (filterfn (iterator self))))) )
	    ((fminu type
		    ((input inputtype)
		      prop  (((if updatecode (updatefn ((quote updatecode)))))
			     (if itemcode (itemview ((quote itemcode))))
			     (if filtercode (filterfn ((quote filtercode)))))
		      supers (fminu-framework)))) )
   ))


(defvar *connrules*)
(glispglobals (*connrules* (listof rule)))
(setq *connrules*
      '((conntype ((fromslot frombox) (toslot tobox))
		  ((tfrom (frombox fromslot type))
		   (tto   (tobox toslot abstract-type)))
		  (and tfrom (swtypematch tfrom tto))
		  (swbox-conclude '(tobox toslot type) tfrom))
	))

; 03 Feb 98
(gldefun swbox-set-facet ((b swbox) (slotname symbol) (facetname symbol)
				    (value anything))
  (set-facet (slot! b slotname) facetname value))

; 29 Dec 98
(gldefun swbox-set-value ((b swbox) (slotname symbol) (value anything))
  (swbox-set-facet b slotname 'value value))

; 25 Nov 97; 23 Dec 97
(gldefun swbox-facet ((b swbox) (slotname symbol) (facetname symbol))
  (facet (slot b slotname) facetname))

; 21 Dec 98
(gldefun swbox-slot ((b swbox) (slotname symbol)) (slot b slotname))

; 21 Dec 98
(gldefun swbox-conn ((b swbox) (connname symbol))
  (that (conns b) with name == connname))

; 05 Mar 98; 19 Nov 98
(gldefun swboxp ((b swbox)) (and (symbolp b) (slots b)))

; 12 Feb 98; 12 Nov 98
; Test if b1 is a subbox of b2
(gldefun subboxp ((b1 swbox) (b2 swbox))
  (and b1 (or (eq b1 b2) (subboxp (partof b1) b2))) )

; 01 Dec 98
(gldefun swbp ((b swbox))
  (terpri)
  (prin1 b)
  (pprint (symbol-plist b))
  (terpri)
  (for sub in (parts b) (swbp (box sub))) )

; 12 Feb 98; 19 Jan 04
; Find least common ancestor of boxes b1 and b2
(gldefun swbox-ancestor ((b1 swbox) (b2 swbox))
  (if (subboxp b1 b2)
      b2
      (and (partof b2)
	   (swbox-ancestor b1 (partof b2)))) )

; 17 Feb 98; 16 Mar 98; 17 Nov 98; 24 Nov 98; 19 Jan 04
; Set the partof field of a box
(gldefun swbox-set-partof ((sub swbox) (box swbox) &optional (role symbol))
  (let ((pair namebox))
    (when box
      (swbox-remove-partof sub)
      ((partof sub) = box)
      (if (pair = (find-if #'(lambda (x) (eq (cadr x) sub)) (parts box)))
	  (if role ((name pair) = role))
	  ((parts box) _+ (list role sub)) )) ))

; 17 Feb 98; 17 Nov 98; 19 Jan 04
; Remove the partof field of a box
(gldefun swbox-remove-partof ((box swbox))
  (let ((parent swbox))
    (if (parent = (partof box))
	(progn ((partof box) = nil)
	       ((parts parent) =
                 (remove-if #'(lambda (x) (eq (cadr x) box))
			    (parts parent))) ) )))

; 05 Feb 98; 19 Feb 98; 05 Mar 98; 08 Dec 98
; Add a connection to a box
(gldefun swbox-add-conn ((box swbox) (from swbox) (fromport symbol)
				      (to swbox)   (toport symbol))
  (result swconn)
  (let (conn)
    (conn = (a swconn with
		 from = (a swport with slot = fromport  box = from)
		 to   = (a swport with slot = toport    box = to)))
    ((conns box) _+ conn)
    conn))

; 12 Feb 98; 19 Feb 98; 08 Dec 98; 23 Dec 98
; Remove a connection from a box
(gldefun swbox-remove-conn ((box swbox) (conn swconn))
  (let ((frombox swbox) (fromport symbol) (tobox swbox) (toport symbol)
	(topbox swbox))
    (frombox = (box (from conn)))
    (fromport = (slot (from conn)))
    (tobox = (box (to conn)))
    (toport = (slot (to conn)))
    ((conns box) _- conn)                       ; remove the connection
    (topbox = (swbox-ancestor frombox tobox))
    (for just in (justifications topbox)
      (if (and (eq (rulename just) 'conntype)
	       (member (list frombox fromport 'type)
		       (premises just) :test #'equal)
	       (equal (list tobox toport 'type) (conclusion just)))
	  (swbox-retract-facet tobox toport 'type))) ))

; 12 Feb 98
; Remove a facet value
(gldefun swbox-remove-facet ((b swbox) (slotname symbol) (facetname symbol))
  (swbox-set-facet b slotname facetname nil))

; 19 Feb 98; 05 Mar 98
; Find all connections to a box (to port if specified).
; dir may be input, output, or nil (both)
(gldefun swbox-find-conns ((box swbox) &optional (port symbol) (dir symbol))
  (result (listof swconn))
  (swbox-find-connsb box box port dir nil))

; 19 Jan 04
(gldefun swbox-find-connsb ((box swbox) (target swbox) (portname symbol)
			    (dir symbol) (prev (listof swconn)))
  (result (listof swconn))
  (let ((res prev))
    (for conn in (conns box)
	 (if (or (and (or (null dir) (eq dir 'output))
		      (eq target (box (from conn)))
		      (or (null portname)
			  (eq portname (slot (from conn)))))
		 (and (or (null dir) (eq dir 'input))
		       (eq target (box (to conn)))
		      (or (null portname)
			  (eq portname (slot (to conn))))) )
	     (res +_ conn)))
    (if (partof box)
        (swbox-find-connsb (partof box) target portname dir res)
        res) ) )

; 26 Feb 98; 03 Mar 98; 05 Mar 98; 31 Dec 98; 19 Jan 04
; Retract the value of a facet.  The facet is set to nil, and
; other facet values that depended on this one are also retracted.
(gldefun swbox-retract-facet ((b swbox) (slotname symbol) (facetname symbol))
  (let ((box b) retract remj (newretract (listof bsf)))
    (swbox-set-facet b slotname facetname nil)
    (retract = (a bsf with box = b slot = slotname facet = facetname))
    (while box do
      (newretract = nil)
      (for just in (justifications box)
	   (if (member retract (premises just) :test #'equal)
	       (progn (remj +_ just)
		      (newretract +_ (conclusion just)))
	       (if (equal retract (conclusion just))
		   (remj +_ just))) )	   
      ((justifications box) = (justifications box) - remj)
      (for ret in newretract do
	   (if (and (eq (slot ret) 'self)
		    (eq (facet ret) 'specialization))
	       (swbox-unspecialize (box ret))
	       (swbox-retract-facet (box ret) (slot ret) (facet ret)) ))
      (box = (partof box)) ) ))

; 06 Nov 97; 11 Nov 97; 13 Nov 97; 25 Nov 97; 26 Dec 97; 31 Dec 97; 02 Jan 98
; 03 Feb 98; 05 Feb 98; 12 Feb 98; 17 Feb 98; 12 Nov 98; 17 Nov 98; 24 Nov 98
; 08 Dec 98; 23 Dec 98
; Create a new software box that is an instance of a given spec
(gldefun swbox-create ((spec boxspec) (partof swbox) &optional (role symbol))
  (result swbox)
  (let ((box swbox) tmp)
    (box = (make-instance spec))
    (set-partof box partof role)
    (swbox-create-subs spec box)
    ((slots box) = (copy-tree (slots spec)))
    ((spec box) = spec)
    box))

; 08 Dec 98; 19 Jan 04
; Create sub-boxes and connections for a box
(gldefun swbox-create-subs ((spec boxspec) (box swbox))
  (let (alist subbox)
    (if (parts spec)
	(progn (for pair in (parts spec) do
		    (subbox = (swbox-create (spec pair) box))
		    (alist +_ (cons (name pair) subbox)) )
	       (for pair in alist
		    (set-partof (cdr pair) box (car pair)) )
	       ((conns box) = (sublis (cons (cons 'self box) alist)
				      (conns spec))) ) )))


; 08 Dec 98; 17 Dec 98
; Specialize an existing software box to be an instance of a given spec
(gldefun swbox-specialize ((box swbox) (spec boxspec))
  (result swbox)
  (let (alist subbox tmp)
    ((spec box) = spec)
    (swbox-create-subs spec box)
    ((slots box) = (copy-tree (slots spec)))
    box))

; 31 Dec 98
; Retract the specialization of a box by restoring it to its more
; abstract version
(gldefun swbox-unspecialize ((box swbox))
  (let ((spec boxspec) (absspec boxspec))
    (spec = (spec box))
    (absspec = (car (supers spec)))
    (swbox-specialize box absspec) ))

; 16 Mar 98; 19 Jan 04
(gldefun slot-direction ((slot slot))
  (if (or (eq (name slot) 'input)
	  (eq (facet slot 'direction) 'input))
      'input
      (if (or (eq (name slot) 'output)
	      (eq (facet slot 'direction) 'output))
	  'output)))

; 02 Jan 98
; Generate a GLISP-syntax arglist with types from a list ((var type) ...)
(defun glarglist-to-gl (l)
  (mapcan #'(lambda (vartype)
	      (list (gladdcolon (car vartype)) (cadr vartype)))
	  l))

; 06 Nov 97; 11 Nov 97; 13 Nov 97; 25 Nov 97; 23 Dec 97; 24 Dec 97; 26 Dec 97
; 31 Dec 97; 17 Feb 98; 03 Mar 98; 05 Mar 98; 10 Mar 98; 19 Nov 98; 01 Dec 98
; 23 Dec 98
; Process an event on a software box
; e.g. slot = input, facet = type, val = (listof integer)
(gldefun swbox-conclude ((target bsf) (val anything))
  (swbox-concludeb (box target) (slot target) (facet target) val) )

(gldefun swbox-concludeb ((b swbox) (slot symbol) (facet symbol) (val anything))
  (let (done tp oldval bx)
    (oldval = (swbox-facet b slot facet))
    (when (not (equal val oldval))
      (swbox-set-facet b slot facet val)
      (while (not done)
	(done = t)
	(for rule in (rules (spec b)) do
	     (if (not (swbox-rule-done b rule))
		 (if (try-rule (list b) rule)
		     (done = nil)))) )
  ; try to propagate types along connections
      (bx = b)
      (while bx do
	(for conn in (conns bx)
	  when (eq b (box (from conn))) do
	    (for rule in *connrules* do
		 (try-rule (list (from conn) (to conn)) rule)))
	(bx = (partof bx)) ) ) ))

; 13 Nov 97; 25 Nov 97; 26 Feb 98
; Test whether a rule has already been done for box b
(gldefun swbox-rule-done ((b swbox) (rule rule))
  (assoc (name rule) (justifications b)) )

; 25 Nov 97; 26 Dec 97; 26 Feb 98; 05 Mar 98; 06 Mar 98; 10 Mar 98; 19 Nov 98
; 01 Dec 98; 31 Dec 91; 19 Jan 04; 05 Jan 16
; Try a rule to see if it can be executed.
; bl is a list of boxes for binding to the inputs of the rule.
(gldefun try-rule ((bl (listof anything)) (r rule))
  (let (boxalist alist (fs bsf) code premises conclusion (tmp bsf))
    (mapc #'(lambda (input val)
	      (if (and (symbolp input) (swboxp val))
		  (push (cons input val) boxalist)
		  (if (and (consp input)         ; used for conn rule
			   (consp val))
		      (mapc #'(lambda (i v) (push (cons i v) boxalist))
			    input val))))
	  (inputs r) bl)
    (for binding in (bindings r) do
	 (fs = (sublis boxalist (bind binding)))
	 (v = (swbox-facet (box fs) (slot fs) (facet fs)))
	 (alist _+ (cons (var binding) (kwote v)))
	 (premises _+ (a bsf with box = (box fs)
			          slot = (slot fs)
				  facet = (facet fs))) )
    (if (eval (sublis alist (predicate r)))
	(progn (code = (sublis (append boxalist alist) (action r)))
	     (if (eq (car code) 'swbox-conclude)
		 (if (quotep (cadr code))
		     (progn (tmp = (cadadr code))
			    (if (null (swbox-facet (box tmp) (slot tmp)
						   (facet tmp)))
				(swbox-add-justification (name r) premises
							 tmp))
                            (eval code))  ; 05 Jan 16
		     (eval code))
		 (if (eq (car code) 'swbox-specialize)
		     (progn (tmp = (cadr (caddr code)))
			    (swbox-add-justification (name r) premises
						     (list (car bl) 'self 'specialization))
			    (eval code))
		     (eval code)))))
    ))

; 13 Nov 97
; Test whether a concrete type matches an abstract type
(defun swtypematch (concrete abstract)
  (let (itemtype)
    (or (gltypematch concrete abstract)
	(if (consp abstract)
	    (case (car abstract)
	      (sequence
	        (and (setq itemtype (glloopitemtype concrete))
		     (gltypematch itemtype (cadr abstract)) ) )
	      ) ) ) ))

; 24 Feb 98
; Add a justification for a conclusion
; Each premise or conclusion is (box slot facet)
; Justification appears in the box that is the least ancestor
;   of all mentioned boxes
(gldefun swbox-add-justification ((rule symbol) (premises (listof bsf))
					       (conclusion bsf))
  (let (parent)
    (parent = (box conclusion))
    (for p in premises do (parent = (swbox-ancestor parent (box p))))
    ((justifications parent) +_ (a justification with
				   rulename = rule
				   premises = premises
				   conclusion = conclusion)) ))

; 07 Dec 98; 08 Dec 98; 18 Dec 98; 19 Jan 04
; Find a specified part or type in swbox hierarchy.  self is the top box.
; spec = symbol: component of top box, or top box if self
;        (component spec)     : names component of spec
;        (facet (slot spec))  : e.g. type of a port of spec
(gldefun swbox-part ((self swbox) (spec anything))
  (result swbox)
  (if (symbolp spec)
      (if (eq spec 'self)
	  self
          (cadr (assoc spec (parts self))))
      (and (consp spec)
	   (or (and (setq subbox (swbox-part self (cadr spec)))
		    (cadr (assoc (car spec) (parts subbox))))
	       (and (consp (cadr spec)) (cdadr spec)
		    (setq subbox (swbox-part self (cadadr spec)))
		    (swbox-facet subbox (caadr spec) (car spec))))) ) )

; 07 Dec 98
; Find type of a specified port of a box.
(gldefun swbox-type ((box swbox) (port symbol))
  (swbox-facet box port 'type))

; 21 Dec 98; 23 Dec 98; 30 Dec 98
; Refine a connection by inserting a computation box
(gldefun swbox-refine-conn ((box swbox) (conn swconn))
  (let (nm newbox inconn outconn inpcodetype code codetype)
    (nm = (name conn))
    (swbox-remove-conn box conn)
    (newbox = (swbox-create 'computation box nm))
    (inconn = (swbox-add-conn box (box (from conn)) (slot (from conn))
		                    newbox 'input))
    (outconn = (swbox-add-conn box newbox 'output
		                     (box (to conn)) (slot (to conn))))
    (for rule in *connrules* do
	 (try-rule (list (from inconn) (to inconn)) rule))
    (inpcodetype = (list 'input (swbox-type newbox 'input)))
    (code = (vip (list inpcodetype)
		   (list (list 'output anything))))
    (codetype = (glcompexpr (list 'progn code) (list inpcodetype)))
    (set-facet newbox 'code 'code (list 'lambda (list 'input) code))
    (swbox-concludeb newbox 'output 'type (cadr codetype))
    newbox ))

; 24 Dec 98; 28 Dec 98; 30 Dec 98; 20 Apr 99
; Refine a computation attached to a box, e.g. filter for an iterator.
; nm is the name of the slot to be refined.
(gldefun swbox-refine-comp ((box swbox) (nm symbol))
  (let (newbox abtype ins out intypes outtypecode codetype)
    (newbox = (swbox-create 'computation box nm))
    (abtype = (swbox-facet box nm 'abstract-type))
    (when (and (consp abtype) (eq (car abtype) 'function))
      (ins = (butlast (cdr abtype) 1))
      (out = (car (last abtype)))
      (intypes = (mapcar #'(lambda (x) (swbox-find-type box x)) ins))
      (outtype = (or (swbox-find-type box out) 'anything))
      (code = (vip intypes (list (list 'output outtype))))
      (codetype = (glcompexpr (list 'progn code) intypes))
      (set-facet newbox 'code 'code (list 'lambda (mapcar #'car intypes)
					  code))
      (swbox-concludeb newbox 'input 'type (glxtrtype (car intypes)))
      (swbox-concludeb newbox 'output 'type (cadr codetype)) )
    newbox ))

; 24 Dec 98; 19 Jan 04
; Find the type of a specified slot, denoted by (typeof slot).
; Other forms are returned unchanged.
(gldefun swbox-find-type ((box swbox) (tp anything))
  (if (and (consp tp) (eq (car tp) 'typeof))
      (list (cadr tp) (swbox-facet box (cadr tp) 'type))
      tp))

; 07 Dec 98; 18 Dec 98; 24 Dec 98; 29 Dec 98; 19 Jan 04
; Create GLISP types from a box specification
(gldefun swbox-to-gl ((box swbox))
  (let ((pat boxpattern) (nm symbol) (result (listof symbol))
	 (subs (listof (cons (name symbol) (value anything)))) )
    (pat = (pattern (spec box)))
    (if pat
	(progn
	  (swbox-make-type-names box)
	  (for item in (bindings pat) do
	       (subs _+ (cons (name item)
			      (swbox-val box (cadr item)) )) )
	  (for genitem in (outpatterns pat) do
	       (nm = (swbox-facet box (name genitem) 'type))
	       (case (kind genitem)
		 (type (eval (list 'glispobjects
				   (swbox-gltype nm subs (output genitem))))) )
	       (result _+ nm) )
	  (for part in (parts box) do
	       (result = (append result (swbox-to-gl (box part)))) )
	  result) )))

; 29 Dec 98; 19 Jan 04
; Find a value from a part spec or the or of part specs.
(gldefun swbox-val ((box swbox) (spec anything))
  (if (and (consp spec)
	   (eq (car spec) 'or))
      (swbox-valb box (cdr spec))
      (swbox-part box spec)))

(gldefun swbox-valb ((box swbox) (spec anything))
  (and spec
       (or (swbox-val box (car spec))
	   (swbox-valb box (cdr spec)))))

; 29 Dec 98
; Make type names for all types defined by a box and its sub-boxes
(gldefun swbox-make-type-names ((box swbox))
  (let ((pat boxpattern))
    (pat = (pattern (spec box)))
    (for genitem in (outpatterns pat) do
      (unless (swbox-facet box (name genitem) 'type)
	(nm = (glmkatom (name genitem)))
	(swbox-set-facet box (name genitem) 'type nm)))
    (for part in (parts box) do (swbox-make-type-names (box part))) ))

; 24 Dec 98
; Make a glispobjects description given a pattern.
; subs is an alist of substitutions.
; pattern is a glispobjects pattern that may contain if items for prop's,
;   (if test (prop-pattern))
(defun swbox-gltype (name subs outpat)
  (let ()
    (cons name
      (cons (sublis subs (car outpat))
	(mapcar #'(lambda (x)
		    (if (atom x)
			x
		        (mapcan #'(lambda (item)
				    (if (atom item)
					(list item)
				        (if (eq (car item) 'if)
					    (and (sublis subs (cadr item))
						 (list (sublis subs
							       (caddr item))))
					    (list (sublis subs item)))))
				x)))
		(cdr outpat)))) ))




(setq testspec
      '(itacc ((inputtype (input self))
	       (seqtype (input iterator))
	       (itemtype (input accumulator))
	       (outputtype (output accumulator))
	       (acctype (specialization accumulator)) ) ) )


; 07 Dec 98
; Find a box in the middle between two boxes, if any
(gldefun swmidbox ((box swbox) (fromrole symbol) (torole symbol))
  (let ((frombox (swbox-part box (list fromrole 'self)))
	(tobox (swbox-part box (list torole 'self))) mid)
    (and frombox
	 (some #'(lambda (conn)
		   (and (eq (box (from conn)) frombox)
			(setq mid (box (to conn)))
			(not (eq mid tobox))
			(some #'(lambda (connb)
				  (and (eq (box (from connb)) midbox)
				       (eq (box (to connb)) tobox)))
			      (conns box))
			mid))
	       (conns box)) ) ))

; -------------------------------------------------------------------
; Function patterns
; These can allow generic code such as (draw <thing> <place>)
; by looking up an appropriate view of <thing> and using the view
; plus a code pattern to translate the call into compilable code.

; 04 Feb 99
; Find a function pattern for a given verb for an object type
(defun glfindfnpattern (type verb)
  (some #'(lambda (view) (assoc verb (glfnpatterns (cadr view))))
	(glviews type)))

(setf (glfnpatterns 'line-segment)
      '((draw ((ls line-segment) (w window))
	      (draw-line-xy w (p1x ls) (p1y ls) (p2x ls) (p2y ls)))))
(setf (glfnpatterns 'circle)
      '((draw ((c circle) (w window))
	      (draw-circle-xy w (centerx c) (centery c) (radius c)))))

; 04 Feb 99; 09 Feb 99
; Instantiate a function pattern verb applied to args, ((arg type) ...)
;   (glispobjects (stsz (list (start vector) (size vector))))
;   (mkv 'line-segment 'stsz)
;   (glinstfnpattern 'draw '((s stsz) (myw window)))
;   (gldefun t21 ((s stsz) (myw window)) ... code from above )
(defun glinstfnpattern (verb args)
  (let (pat argtype subs letvars var tmp code)
    (setq argtype (cadr (first args)))
    (when (setq pat (glfindfnpattern argtype verb))
      (mapc #'(lambda (arg formal)
		(setq var (if (or (symbolp (car arg))
				  (< (glnoccurs (car formal) (caddr pat)) 2))
			      (car arg)
			      (progn (setq tmp (glmkatom (car formal)))
				     (push (list tmp (car arg)) letvars)
				     tmp)))
		(push (if (eq arg (car args))
			  (cons (car formal)
				(list (cadr formal) var))
			  (cons (car formal) var))
		      subs))
	    args (cadr pat))
      (setq code (sublis subs (caddr pat)))
      (if letvars
	  (list 'let letvars code)
	  code) ) ))

; -------------------------------------------------------------------


; 29 Jan 98
; Find the initial value for 'summation' of a basic type
(defun glsuminit (str)
  (if (symbolp str)
      (case str
	    ((integer number) 0)
	    (real 0.0)
	    (string "")
            (character "")
	    (boolean nil)
	    (t (cadr (glgetdefault str 'self)))) ) )

; 29 Jan 98; 10 Feb 98
; Find the accumulator type for 'summation' of a basic type
(defun glsumtype (str)
  (if (symbolp str)
      (case str
	(character 'string)
	((integer real number) str)
	(t nil))))

; 12 Mar 98
; Set the available flag of a port to the current value
(gldefun swbox-set-avail ((p swport))
  (swbox-set-facet (box p) (slot p) 'avail *swcodegenn*))

; 12 Mar 98
; Test if the available flag of a port is the current value
(gldefun swbox-availp ((p swport))
  (eql (swbox-facet (box p) (slot p) 'avail) *swcodegenn*))

; 30 Dec 97; 02 Jan 98; 05 Feb 98; 16 Mar 98; 19 Jan 04
; Generate code using a code rule
; bl is a list of boxes for binding to the box arguments of the rule.
(gldefun swbox-gencode ((bl (listof swbox)) (r rule))
  (let (boxalist alist v (ok t) (b (car bl)) tmp)
    (boxalist = (mapcar #'cons (inputs r) bl))
    (for binding in (bindings r) do
	 (if (setq v (case (facet binding)
		       (subcode
			 (for pair in (parts (cdr (assoc (box binding)
							    boxalist)))
			      when (tmp =
					(swbox-gencode (list (box pair))
					      (swbox-coderule (box pair)
							      (slot binding))))
			      collect tmp))
		       (t (swbox-facet (cdr (assoc (box binding)
						   boxalist))
				       (slot binding) (facet binding)))))
	     (alist _+ (cons (var binding) v))
	     (ok = nil)) )
    (if ok (sublis alist (predicate r))) ))


; 02 Jan 98; 03 Feb 98; 05 Feb 98; 16 Mar 98; 17 Mar 98; 28 Feb 02
; Generate a function from a software box
(gldefun swbox-genfn ((b swbox))
  (let (args letvars codelst fnname newcode)
; Generate var names for all vars used by this box and sub-boxes
    (swbox-recvars b)
; Make a list of arg vars and types
    (args = (for slot in (slots b)
		   when ((kind slot) == 'port)
		    and ((slot-direction slot) == 'input)
		 collect
		   (list (facet slot 'code)
			 (facet slot 'type)) ) )
; Make a list of let vars and types
    (letvars = (swbox-vars b nil))
; Generate code for each contents box
    (codelst = (for subb in (parts b) collect
		   (swbox-gencode (list (box subb))
				  (swbox-coderule (box subb) 'contents))))
; create (gldefun fn (args) (let (letvars) (progn . code) result))
    (fnname = (gentemp (stringify 'fn)))
    (newcode = (list 'gldefun fnname (glarglist-to-gl args)
		       (list 'let (glarglist-to-gl letvars)
			     (lcprognify codelst)
			     (swbox-outcode b))))
    ((fncode b) = newcode)
    (eval fncode) ))

 
; 03 Feb 98; 12 Mar 98; 28 Feb 02
; Get the code for the output of a box
(gldefun swbox-outcode ((b swbox))
  (let (outport)
    (for slot in (slots b)
	 when ((kind slot) == 'port)
	  and (or ((facet slot 'direction) == 'output)
		  ((name slot) == 'output))
       do (outport = slot))
    (if outport (facet outport 'code) ) ))

; 02 Jan 98; 03 Feb 98; 05 Feb 98; 17 Mar 98; 28 Feb 02
; Generate a list of ((var type) ...) for the vars of box and its parts
(gldefun swbox-vars ((b swbox) (subvars (listof glvartype)))
  (result (listof glvartype))
  (let (code)
    (for subb in (parts b) do
      (subvars = (swbox-vars (box subb) subvars)) )
    (for slot in (slots b)
	 when ((kind slot) == 'var)
	  and (not (assoc (setq code (facet slot 'code)) subvars))
	 (subvars +_ (a glnametype with name = code
			type = (facet slot 'type))) )
    subvars) )

; 31 Dec 97; 03 Feb 98; 05 Feb 98
; Recursively make vars for boxes and propagate values
(gldefun swbox-recvars ((b swbox))
  (let ()
    (swbox-makevars b)
    (for s in (parts b) (swbox-recvars (box s)))
    (swbox-propagate b) ))

; 30 Dec 97; 31 Dec 97; 02 Jan 98; 03 Feb 98; 28 Feb 02
; Make variables for a software box.
(gldefun swbox-makevars ((b swbox))
  (let (varname specs newslot)
    (for slot in (slots (spec b))
	 when ((kind slot) == 'var)
	      or (((kind slot) == 'port) and (facet slot 'varname))
      do
	(newslot = (slot! b (name slot)))
	(unless (facet newslot 'code)
	  (varname = (gentemp
			 (stringify (or (facet newslot 'varname)
					(name slot)))))
	  (set-facet newslot 'code varname) ) ) ))

; 17 Mar 98
; Make a variable name for a slot
(gldefun swbox-slotvar ((b swbox) (s slot))
  (let (varname)
    (when (null (facet s 'var))
      (varname = (gentemp (stringify (or (facet s 'varname)
					   (name s)))))
      (set-facet s 'var varname)
      (swbox-addvar b (a glnametype with name = varname
			 type = (facet s 'type))) ) ))

; 17 Mar 98; 19 Jan 04
; Add a var to list of vars for a box
(gldefun swbox-addvar ((b swbox) (var glnametype))
  (if (null (partof b))
      ((vars b) _+ var)
      (swbox-addvar (partof b) var) ) )

; 31 Dec 97; 02 Jan 98; 05 Feb 98
; Propagate values along connections.  If a slot in a box has code,
; propagate that code to places it is connected to.
(gldefun swbox-propagate ((b swbox))
  (for conn in (connections b) do (swbox-propagate-conn conn)))

; 05 Feb 98; 12 Feb 98; 05 Mar 98; 19 Jan 04
; Propagate value along a connection.
; If type is known, propagate type also.
(gldefun swbox-propagate-conn ((conn swconn))
  (let ((frombox swbox) (fromport symbol) (tobox swbox) (toport symbol)
	cfrom cto fromtype)
    (frombox = (box (from conn)))
    (fromport = (slot (from conn)))
    (tobox = (box (to conn)))
    (toport = (slot (to conn)))
    (cfrom = (swbox-facet frombox fromport 'code))
    (cto = (swbox-facet tobox toport 'code))
    (if cfrom
	(if (and cto (symbolp cto)
		 (not (eq cfrom cto)))
	    (swbox-set-facet tobox toport 'code (list cto '= cfrom))
	    (if (null cto)
		(swbox-set-facet tobox toport 'code cfrom)))
        (if (and cto (symbolp cto))
	    (swbox-set-facet frombox fromport 'code cto)) )
    (fromtype = (swbox-facet frombox fromport 'type))
    (if fromtype
        (swbox-set-facet tobox toport 'type fromtype) ) ))

; 24 Dec 97; 26 Dec 97
; define a software framework
; (swdefswf '(name ports ... boxes ... conns ...))
(defun swdefswf (l)
  (let ((name  (car l))
	(slots (getf (cdr l) 'slots))
	(boxes (getf (cdr l) 'boxes))
	(conns (getf (cdr l) 'conns))
	       newconns tmp)
    (setf (get name 'slots) slots)
    (if boxes (setf (get name 'parts) boxes))
    (dolist (conn conns)
      (setq tmp (swf-fix-conns conn slots boxes))
      (setq newconns (append newconns (car tmp))) )
    (if newconns (setf (get name 'connections) newconns)) ))

; 24 Dec 97; 26 Dec 97
; Specify connections.  Connections may be of two types:
;   ((port box) (port box))
;   functional form: (box arg+) where arg is (box arg+) or (port box)
; Result is (connections port)
;     where connections = list of connections
;           port        = last port for recursive use
(defun swf-fix-conns (conn ports boxes)
  (let (tmp newconns portnames)
    (if (symbolp conn)
	(list nil (list 'output conn))
      (if (and (consp (car conn))
	       (consp (cadr conn))
	       (null (cddr conn)))
	  (list (list conn) nil)
          (if (and (or (eq (cadr conn) 'self)      ; test (port box) form
		       (assoc (cadr conn) boxes))
		   (null (cddr conn))
		   (symbolp (car conn)))   ; make sure it really is a port name
	      (list '() conn)
	      (progn
		(setq portnames (or (get (car conn) 'ports) '(input input2)))
		(dolist (arg (cdr conn))
		  (setq tmp (swf-fix-conns arg ports boxes))
		  (setq newconns (append newconns (car tmp)))
		  (push (list (list (pop portnames) (car conn))
			      (cadr tmp))
			newconns) )
		(list newconns (list 'output (car conn))) ) ) ) ) ))

; 26 Dec 97; 03 Feb 98
; Test swdefswf using input-filter-accumulate example
(defun test-swdefswf ()
  (swdefswf
   '(ifa ports (input output)
	 boxes ((input-sel selector)
		(iterator iterator)
		(item-test predicate)
		(item-sel selector)
		(accumulator data)
		(accumulate program))
	 conns ((accumulate accumulator (item-sel (output iterator)))
		(item-test (output iterator))
		(iterator (input-sel (input self))) )
	 defaults
	       ((input-sel identity-selector)
		(item-test true-predicate))
; constraints
	 ) ) )

; 05 Feb 98; 10 Feb 98; 12 Feb 98; 17 Feb 98; 19 Feb 98; 10 Mar 98
; 19 Jan 04
; Insert a computational box into a link in a software framework
; conn = connection (assumes direction is (from to))
(gldefun swbox-insert-comp ((box swbox) (conn swconn))
  (let ((frombox swbox) (fromport symbol) (tobox swbox) (toport symbol)
        newbox fromconn toconn code inpvar inptype varlist outtype)
    (frombox = (box (from conn)))
    (fromport = (slot (from conn)))
    (tobox = (box (to conn)))
    (toport = (slot (to conn)))
    (swbox-remove-conn box conn)                    ; remove the old connection
    (newbox = (swbox-create 'compute nil
			      (swbox-ancestor frombox tobox)))
    (fromconn = (swbox-add-conn box frombox fromport newbox 'input))
    (swbox-propagate-conn fromconn)
    (toconn = (swbox-add-conn box newbox 'output tobox toport))
    (inptype = (swbox-facet frombox fromport 'type))
    (inpvar = (or (swbox-codevar frombox fromport)
		    (gentemp (symbol-name (or inptype 'var)))))
    (swbox-set-facet newbox 'input 'code inpvar)
    (varlist = (list (list inpvar inptype)))
    (code = (vip varlist))
    (if (and code (not (eq code 'quit)))
	(progn (swbox-set-facet newbox 'computation 'code code)
	     (outtype = (cadr (glcompexpr code varlist)))
	     (if outtype
		 (progn (swbox-set-facet newbox 'computation 'type outtype)
	              (swbox-conclude (a bsf with box = newbox slot = 'output
					 facet = 'type)
				   outtype)
	              (swbox-propagate-conn toconn)))))
    ))

; 12 Feb 98
; Get code for a facet value iff it is a var
(gldefun swbox-codevar ((b swbox) (slotname symbol))
  (let ((code (swbox-facet b slotname 'code)))
    (and (symbolp code) code) ))

; 12 Mar 98
; Test whether all inputs of a box are available
(gldefun swbox-readyp ((b swbox))
  (let ((inputs (swbox-find-conns b nil 'input)))
    (every #'(glambda (conn) (swbox-availp (from conn)))
	   inputs) ))

; old stuff


; 02 Jan 98
(gldefun swbox-coderule ((b swbox) (codename symbol))  (result rule)
  (assoc codename (code (spec b))))

; 26 Dec 97
; Define structure of a basic software box
(defun swdefbox (l)
  (let ((boxname (car l)))
    (setq l (cdr l))
    (while (and l (cdr l))
      (setf (get boxname (car l)) (cadr l))
      (setq l (cddr l)) ) ))

; ******* fix form of rules to box-slot-facet
; boxspec for basic iterator
(swdefbox '(basic-iterator
	     slots ((input port abstract-type (sequence anything))
		    (seq   type abstract-type (sequence anything))
		    (item  var))
	     parts ((action anything))
	     connections (((item self) (input action)))
	     rules ((rule101 (self)
			     ((t1 (self input type)))
			     (swtypematch t1 '(sequence anything))
			     (swbox-conclude '(self seq type) t1))
		    (rule102 (self)
			     ((t1 (type (seq self))))
			     t1
			     (swbox-conclude '(self item type)
					      (glloopitemtype t1)))
		    )
	     code  ((contents   (self)
				((seq (code (input self)))
				 (item (code (item self)))
				 (inits (subcode (initialize self)))
				 (action (subcode (contents self))) )
				(progn (progn . inits)
				       (for item in seq do . action)) )
		    )
     ))

(swdefbox '(sum
	     slots ((input       port abstract-type number)
		    (accumulator var  varname acc))
	     rules ((rule110 (self)
			     ((t1 (type (input self))))
			     (or (swtypematch t1 'number)
				 (member t1 '(string character boolean)))
			     (swbox-conclude '(self accumulator type)
					     (glsumtype t1)))
		    (rule112 (self)
			     ((t1 (type (accumulator self))))
			     (glbasictypep t1)
			     (swbox-conclude '(self accumulator initial-value)
					     (glsuminit t1)) )
		    )
	     code  ((initialize (self)
				((var (code (accumulator self)))
				 (init (initial-value (accumulator self))) )
				(var = init) )
		    (contents   (self)
				((var (code (accumulator self)))
				 (val (code (input self))) )
				(var = var + val) )
		    (finalize   (self)
				((var (code (accumulator self))) )
				var)
		    )
	     ))

(swdefbox '(iterate-add
	     slots ((input  port abstract-type (sequence anything) varname seq)
		    (output port direction output))
	     parts ((adder sum)
		    (iterator (basic-iterator adder)))
	     connections (((input self) (input iterator))
			  ((accumulator adder) (output self)) )
	     ))

(swdefbox '(compute
	    slots ((input  port)
		   (computation code)
		   (output port direction output))
	    code  ((contents   (self)
			       ((comp (code (computation self))))
			       comp)
		   )
	    ))
