; chemgram.lsp               Gordon S. Novak Jr.           ; 21 Jan 11

; Copyright (c) 2011 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 18 Nov 03; 22 Dec 03; 15 Jan 04; 03 Feb 04; 10 Feb 04; 13 Feb 04; 16 Feb 04
; 17 Feb 04; 18 Feb 04; 19 Feb 04; 23 Feb 04; 25 Feb 04; 01 Mar 04; 15 Mar 04
; 16 Mar 04; 19 Mar 04; 22 Mar 04; 23 Mar 04; 29 Mar 04; 30 Mar 04; 31 Mar 04
; 01 Apr 04; 05 Apr 04; 06 Apr 04; 07 Apr 04; 08 Apr 04; 09 Apr 04; 12 Apr 04
; 15 Apr 04; 19 Apr 04; 20 Apr 04; 22 Apr 04; 23 Apr 04; 28 Apr 04; 20 Jan 05
; 16 May 06; 29 Jun 06; 09 Oct 06

; need to have constants e.g. "the speed of light"

; note: (initial velocity) defined as initial-velocity and as v1 ???

(defun loadnl () (ld equations) (ld atn) (ld gramcom) (ld chemgram)
  (ld physlaws) (ld units) (ld physan) (ld physprobs) )

; load stuff for laptop
(defun llb ()
  (loadf "glisp/eqnfix.lsp")
  (loadf "glisp/equations.lsp")
  (loadf "glisp/atn.lsp")
  (loadf "glisp/gramcom.lsp")
  (loadf "glisp/chemgram.lsp")
  (loadf "glisp/units.lsp")
  (loadf "glisp/physlaws.lsp")
  (loadf "glisp/physan.lsp")
  (loadf "glisp/physprobs.lsp")
  (loadf "glisp/mathsimp.lsp")
  (loadf "glisp/mathpat.lsp")
  (loadf "glisp/patmatch.lsp")
 )

; First load the files nl/atn.lsp and cs381k/gramcom.lsp
; these are at ftp.cs.utexas.ude/pub/novak/cs381k/

; (parse chemsent1)
; (phys '(what is the volume of a cone with radius 3 m and height = 4 m))
; (phys '(how does the volume of a cone vary if radius is doubled))

(setq chemsent1 '(Calculate the pH of a solution made by combining
			    40.0 milliliters of 0.14 molar HOCl and
			    10.0 milliliters of 0.56 molar NaOH))

; Note: lexicon parts-of-speech must be disjoint from grammar nonterminals.

; First we define a lexicon and grammar for this application.

(deflexicon
 '((propname (
 a1 a2
 acceleration angle angular-momentum ((angular momentum) angular-momentum)
 angular-speed ((angular speed) angular-speed)
 area area2 ((second area) area2)
 average-speed ((average speed) average-speed)
 bogo-bernoulli
 bottom bottom-area ((bottom area) bottom-area)
 c1 c2 c-factor ((speed relative to light) c-factor)
 capacitance ((centripetal acceleration) acceleration) charge
 circumference
 ((coefficient of friction) mu) (coefficient-of-friction mu)
 container-volume ((container volume) container-volume)
 cost current
 d d1 d2 ((first diameter) d1) ((second diameter) d2) dt1 dt2
 decibel (decibels decibel)
 deltax deltay  delta-temperature ((delta temperature) delta-temperature)
 ((change in temperature) delta-temperature)
 density diameter
 dielectric-constant ((dielectric constant) dielectric-constant)
 displaced-mass ((displaced mass) displaced-mass)
 displaced-volume ((displaced volume) displaced-volume)
 displaced-weight ((displaced weight) displaced-weight)
 distance
 delta-volume ((change in volume) delta-volume)
 dflux/dt ((change in magnetic flux per unit time) dflux/dt)
 doppler-frequency ((doppler frequency) doppler-frequency)
 efficiency
 elapsed-time ((elapsed time) elapsed-time)
 electric-field ((electric field) electric-field)
 emf ((electromotive force) emf) ((electro-motive force) emf)
 energy energy1 ((initial energy) energy1) energy2
 energy-change ((energy change) energy-change)
 ((change in internal energy) energy-change)
 equilibrium-temperature ((equilibrium temperature) equilibrium-temperature)
 escape-velocity ((escape velocity) escape-velocity)
 ((escape speed) escape-velocity)
 f f1 f2 field
 final-energy ((final energy) final-energy)
 final-amount ((final amount) final-amount)
 final-mass ((final mass) final-mass)
 final-rate ((final rate) final-rate)
 final-velocity ((final velocity) final-velocity)
 floating-volume ((floating volume) floating-volume)
 flow-rate ((flow rate) flow-rate) flux
 fluid-density ((fluid density) fluid-density)
 ((density of the fluid) fluid-density)
 focal-length ((focal length) focal-length)
 force
 force/length ((force per unit length) force/length)
 friction-force ((friction force) friction-force)
 (frictional-force friction-force)
 ((frictional force) friction-force) ((force constant) spring-constant)
 frequency (freq frequency)
 fundamental-frequency ((fundamental frequency) fundamental-frequency)
 ((gas constant) universal-gas-constant)
 gravity gravitation-constant ((gravitation constant) gravitation-constant)
 half-life ((half life) half-life)
 harmonic-number ((harmonic number) harmonic-number)
 harmonic-frequency ((harmonic frequency) harmonic-frequency)
 heat heat-exhausted ((heat exhausted) heat-exhausted)
 height
 horizontal-distance ((horizontal distance) horizontal-distance)
 horizontal-velocity ((horizontal velocity) horizontal-velocity)
 image-distance ((image distance) image-distance)
 image-height ((image height) image-height)
 impulse (inclination theta)
 index-of-refraction ((index of refraction) index-of-refraction)
 initial-energy ((initial energy) initial-energy)
 initial-amount ((initial amount) initial-amount)
 initial-mass ((initial mass) initial-mass)
 initial-rate ((initial rate) initial-rate)
 initial-velocity ((initial velocity) initial-velocity)
 intensity
 internal-energy ((internal energy) internal-energy)
 internal-resistance ((internal resistance) internal-resistance)
 item-volume ((item volume) item-volume)
 kinetic-energy (ke kinetic-energy) ((kinetic energy) kinetic-energy)
 latitude left length
 liquid-density ((liquid density) liquid-density)
 longitude loss-voltage ((loss voltage) loss-voltage)
 loss-power ((loss power) loss-power)
 m1 m2 magnetic-field ((magnetic field) magnetic-field)
 magnification magnitude maplat maplong mass
 mass/length ((mass per unit length) mass/length)
 mass-difference ((mass difference) mass-difference)
 ((change in mass) mass-difference)
 max-efficiency ((maximum efficiency) max-efficiency)
 molar-mass ((molar mass) molar-mass) ((mass per mole) molar-mass)
 moment-of-inertia momentum
 ((moment of inertia) moment-of-inertia) mu
 net-force ((net force) net-force)
 n-moles ((number of moles) n-moles)
 normal-force ((normal force) normal-force)
 number
 observed-time ((observed time) observed-time)
 observed-length ((observed length) observed-length)
 observer-speed ((observer speed) observer-speed)
 offset-first-max ((distance from central maximum) offset-first-max)
 period
 proportion-floating ((proportion floating) proportion-floating)
 proportion-below ((proportion below the surface) proportion-below)
 potential
 potential-energy (pe potential-energy) ((potential energy) potential-energy)
 perimeter period
 ph phi power pressure
 q q1 q2
 r r1 r2 radius rate resistance
 resistance/length ((resistance per unit length) resistance/length)
 resistivity resistor right
 satellite-velocity ((satellite velocity) satellite-velocity)
 screen-distance ((screen distance) screen-distance)
 ((distance to the screen) screen-distance)
 side side-area ((side area) side-area)
 slit-separation ((slit separation) slit-separation)
 slope
 source-speed ((source speed) source-speed)
 specific-heat ((specific heat) specific-heat)
 speed spring-constant ((spring constant) spring-constant) stretch
 subject-distance ((subject distance) subject-distance)
 subject-height ((subject height) subject-height)
 t1 t2 t1f t2f
 tangential-force ((tangential force) tangential-force)
 temperature
 temperature-cold ((heat reservoir temperature) temperature-cold)
 ((cold temperature) temperature-cold)
 temperature-hot ((heat source temperature) temperature-hot)
 ((hot temperature) temperature-hot)
 terminal-voltage ((terminal voltage) terminal-voltage)
 theta
 time top total-area ((total area) total-area)
 total-energy ((total energy) total-energy)
 total-mass ((total mass) total-mass)
 total-momentum ((total momentum) total-momentum)
 total-velocity ((total velocity) total-velocity)
 unit-cost ((unit cost) unit-cost)
 universal-gas-constant ((universal gas constant) universal-gas-constant)
 v v1 ((initial velocity) v1) ((first velocity) v1)
 v2 ((second velocity) v2)
 velocity voltage volume
 wavelength ((de Broglie wavelength) wavelength) weight
 weight-in-liquid ((weight in liquid) weight-in-liquid)
 width
 work work-absorbed ((work absorbed) work-absorbed)
 ((work done on it) work-absorbed)
 work-function ((work function) work-function)
 x x-velocity ((x velocity) x-velocity)
 y y-velocity ((y velocity) y-velocity)
; for biology:
 homozygous-recessive
 ((frequency of the homozygous recessive genotype) homozygous-recessive)
 heterozygous ((frequency of the heterozygous genotype) heterozygous)
 homozygous-dominant
 ((frequency of the homozygous dominant genotype) homozygous-dominant)
 ))
   (unit     (amu (atomic-mass-unit amu) ((atomic mass unit) amu)
              (milliliters milliliter) milliliter (liters liter) liter
	      second (seconds second) sec s minute min hour (hours hour)
	      day (days day) year (years year)
	      meter (meters meter) m kilometer (kilometers kilometer) km
              parsec (parsecs parsec)
              foot (feet foot) ft yard (yards yard) mile (miles mile)
              inch (inches inch) in
	      centimeter (cm centimeter) (centimeters centimeter)
              millimeter (millimeters millimeter) mm mm^2 (mm2 mm^2)
	      meter/second (m/s meter/second) (m/sec meter/second)
	      ((meter per second) meter/second)
	      ((meters per second) meter/second)
              m/s2 m/s/s (m/s^2 m/s2)
	      joule (joules joule)
	      degree-kelvin ((degree kelvin) degree-kelvin)
	      (degK degree-kelvin) (kelvin degree-kelvin)
	      degree (degrees degree)
	      kilogram (kg kilogram) gram (g gram) milligram (mg milligram)
	      nanogram (ng nanogram) ounce pound ton tonne (tons ton)
              (tonnes tonne)
              newton nt ((square meter) square-meter)
	      (newtons newton)
	      m^2 (m*m m^2) (m2 m^2) square-meter
	      ((square meters) square-meter)
	      cm^2 ((square centimeter) cm^2) (cm2 cm^2)
	      ((square centimeters) cm^2) (square-centimeter cm^2)
	      ((cubic meter) cubic-meter) ((cubic meters) cubic-meter) m^3
	      (m3 m^3)
	      ((cubic centimeter) cubic-centimeter) cc
	      ((cubic centimeters) cubic-centimeter)
              cubic-foot ((cubic foot) cubic-foot)
              ((cubic feet) cubic-foot)
              cubic-inch ((cubic inch) cubic-inch)
              ((cubic inches) cubic-inch)
	      dollar (dollars dollar) ($ dollar)
              cent (cents cent)
	      Hertz (hz hertz) ((cycles per second) hertz)
	      liter litre (liters liter) (litres liter) l
	      volt kilovolt megavolt millivolt microvolt (v volt)
	      (volts volt) (kilovolts kilovolt) (megavolts megavolt)
	      (millivolts millivolt) (microvolts microvolt)
	      ampere milliampere milliamp amp ma microamp
	      (amperes ampere) (milliamperes milliampere) (milliamps milliamp)
	      (amps amp) (microamps microamp)
	      watt watt-hour ((watt hour) watt-hour)
	      kwh ((kilowatt hour) kwh) (kilowatt-hour kwh)
	      coulomb (coulombs coulomb) millicoulomb microcoulomb coul
	      farad (farads farad) microfarad (microfarads microfarad)
	      micro*f (uf microfarad) ohm (ohms ohm)
	      tesla
	      electron-volt ((electron volt) electron-volt)
	      ((electron volts) electron-volt) (ev electron-volt)
      ))
   (chemical (HOCl NaOH NaCl H2SO4 HCl))
   (a/an     (a an))
   (of/on    (of on))
   (the/its  (the its))
   (as/if    (as if))
   (chg      (change vary increase decrease))
   (ntupled  ((constant 1) (doubled 2) (tripled 3) (quadrupled 4)
	      (quintupled 5) (sextupled 6) (halved 1/2)))
   (numberword ((zero 0) (one 1) (two 2) (three 3) (four 4) (five 5) (six 6)
	       (seven 7) (eight 8) (nine 9) (ten 10) (twenty 20) (thirty 30)
	       (forty 40) (fifty 50) (sixty 60) (seventy 70) (eighty 80)
	       (ninety 90) (hundred 100) (thousand 1000) (million 1000000)
	       (kilo 1000) (mega 1000000) (giga 1000000000)
	       (infinity 1.0e36) (pi 3.1415926535897931)))
   (timesword ((twice 2) (thrice 3) (half 1/2) (zero 0)
	      ((one half) one-half) ((one third) one-third)
	      ((one fourth) one-fourth) ((one fifth) one-fifth)
	      ((one sixth) one-sixth)
	      ((one seventh) one-seventh) ((one eighth) one-eighth)
	      ((one ninth) one-ninth) ((one tenth) one-tenth)
	      (one-half 1/2) (one-third 1/3)
	      (one-fourth 1/4) (one-fifth 1/5) (one-sixth 1/6)
	      (one-seventh 1/7) (one-eighth 1/8)
	      (one-ninth 1/9) (one-tenth 1/10)))
   (prevword  (previous former antediluvian original))
   (beforewd  (before previously ouat ((once upon a time) ouat)
		      ((it used to be) ouat) ((it was before) ouat)
		      ((when dinosaurs roamed the earth) ouat)
		      ((in antediluvian times) ouat)
		      ((in the good old days) ouat) ))
   (objname  (
 acceleration
 battery
 capacitor centrifugal-force ((centrifugal force) centrifugal-force)
 charge-magnetic
 ((charged particle moving in a magnetic field) charge-magnetic)
 charged-sphere ((charged sphere) charged-sphere)
 circle circular-motion ((circular motion) circular-motion) collide-and-stick
 concave-mirror ((concave mirror) concave-mirror)
 converging-lens ((converging lens) converging-lens)
 cone
 conglomerate diffraction
 electric-dipole ((electric dipole) electric-dipole)
 elementary-particle ((elementary particle) elementary-particle)
 fall falling float fluid-flow ((fluid flow) fluid-flow)
 friction friction-weight
 gravity gravity-kinetic gravitation
 harmonic-motion ((harmonic motion) harmonic-motion)
 heat-engine ((heat engine) heat-engine)
 heat-transfer ((heat transfer) heat-transfer)
 ideal-gas ((ideal gas) ideal-gas)
 inclined-plane ((inclined plane) inclined-plane)
 kinetic-energy ((kinetic energy) kinetic-energy)
 lift light line-segment ((line segment) line-segment)
 magnetic-field ((magnetic field) magnetic-field) mercator momentum
 nuclear-reaction ((nuclear reaction) nuclear-reaction)
 object-density
 parallel-capacitors ((parallel capacitors) parallel-capacitors)
 parallel-resistors ((parallel resistors) parallel-resistors)
 photoelectric physob ((physical object) physob)
 projectile
 radioactive-decay ((radioactive decay) radioactive-decay)
 rectangle region
 relativity resistor right-triangle ((right triangle) right-triangle)
 series-capacitors ((series capacitors) series-capacitors)
 series-resistors ((series resistors) series-resistors)
 sound sphere spring
 string-wave ((wave on a string) string-wave)
 symmetric-forces ((symmetric forces) symmetric-forces)
 thermo-system ((thermodynamic system) thermo-system) triangle
 uniform-motion ((uniform motion) uniform-motion) uniform-acceleration
 ((uniform acceleration) uniform-acceleration)
 vector
 wave weight
 weight-pulley ((weight-pulley system) weight-pulley)
 wire wire-magnetic ((wire moving in a magnetic field) wire-magnetic)
 work-energy
 population
 ))
   ))

; Define grammar after defining lexicon.

(defgrammar
  (s -> (calculate (property) of (substance)) (list 'calculate $2 $4))
  (s -> (what is (property) of (substance)) (list 'calculate $3 $5))
  (s -> (what is (property) of (object)) (list 'calculate $3 $5))
  (s -> (what is (property) in (object)) (list 'calculate $3 $5))
  (s -> (how does (property) of (objectb) (chg) (as/if) (changes))
           (list 'calc-change $3 $5 $8))
  (s -> (how does (property) of (objectb) (chg) with (property)
          (as/if) (changes))
           (list 'meta-change $3 $5 $8 $10))
  (s -> (how does (property) of (objectb) (chg) with (property))
           (list 'meta-change $3 $5 $8))
  (property -> ((the/its) (propname)) $2)
  (property -> ((propname)) $1)
  (substance -> (a solution made by combining (substance) and (substance))
	        (list 'mix $6 $8))
  (substance -> ((quantity) of (substance)) (addprop 'quantity $1 $3))
  (quantity  -> ((numberz) (units)) (list $1 $2))
  (quantity  -> ((numberword) (units)) (list $1 $2))
  (units     -> ((unit) (unit)) (list '* $1 $2))
  (units     -> ((unit) per (unit) per (unit)) (list '/ $1 (list '* $3 $5)))
  (units     -> ((unit) per (unit)) (list '/ $1 $3))
  (units     -> ((unit)) $1)
  (quantity  -> ((numberz) * (quantity)) (list (list '* $1 $3)))
  (quantity  -> ((numberword) * (quantity)) (list (list '* $1 $3)))
  (quantity  -> ((numberword) (numberword)) (* $1 $2))
  (quantity  -> ((numberword) / (numberword)) (/ $1 $3))
  (quantity  -> ((numberword) / (numberz)) (/ $1 $3))
  (quantity  -> ((numberz) / (numberz)) (/ $1 $3))
  (quantity  -> ((numberz) / (numberword)) (/ $1 $3))
  (quantity  -> ((numberword)) $1)
  (quantity  -> ((numberz)) $1)
  (quantity  -> ((stringz) / (numberz)) (list (list '/ (varfromstring $1) $3)))
  (quantity  -> ((stringz)) (varfromstring $1))
  (quantity  -> ((varz)) $1)
  (quantity  -> ((varz) / (numberz)) (list (list '/ $1 $3)))
  (substance -> ((numberz) molar (chemical))
	        (makelist 'solution 'solvent 'H2O 'solute $3
			  'molarity $1))
  (object    -> ((a/an) (objname) with (objprops))
	        (cons 'object (cons $2 $4)))
  (object    -> ((objname) with (objprops)) (cons 'object (cons $1 $3)))
  (objectb   -> ((object)) $1)
  (objectb   -> ((a/an) (objname)) (list 'object $2))
  (objectb   -> ((objname)) (list 'object $1))
  (objprops  -> ((objprop) and (objprops))  (cons $1 $3))
  (objprops  -> ((objprop))  (list $1))
  (objprop   -> ((a/an) (propname) of (quantity))  (list $2 $4))
  (objprop   -> ((propname) of (quantity))  (list $1 $3))
  (objprop   -> ((propname) (quantity))  (list $1 $2))
  (objprop   -> ((propname) = (quantity))  (list $1 $3))
  (changes   -> ((change) and (changes))  (cons $1 $3))
  (changes   -> ((change)) (list $1))
  (change    -> ((property) is (ntupled)) (list $1 $3))
  (change    -> ((property) is (timesword) (prev))
	           (list $1 $3))
  (change    -> ((property) is (numberz) times (prev))
	           (list $1 $3))
  (prev      -> (its (prevword) value) (list $2))
  (prev      -> (the (prevword) value) (list $2))
  (prev      -> (the value it had (beforewd)?) (list $2))
  (prev      -> (its value (beforewd)?) (list $2))
  (prev      -> (as much as (beforewd)?) (list $2))
  (prev      -> (as much as it was (beforewd)?) (list $2))
  (prev      -> (what it was (beforewd)?) (list $2))
  
  )

; add a property to a list
(defun addprop (propname val lst) (append lst (list (list propname val))))

; make a frame-like list structure
(defun makelist (type &rest lst)
  (let ((res (list type)))
    (while lst
      (push (list (car lst) (cadr lst)) res)
      (setq lst (cddr lst)))
    (nreverse res)))

; 13 Feb 04; 18 Feb 04; 05 Apr 04; 19 Apr 04; 20 Apr 04; 22 Apr 04; 23 Apr 04
; 16 May 06
; parse and answer physics questions
(defun phys (sent)
  (let (qst obj var ans origans)
    (setq qst (parse sent))
    (if (and qst (eq (car qst) 'calculate))
	(progn (setq obj (caddr qst))
	       (setq var (cadr qst))
	       (setq ans (solvobjvar (get (cadr obj) 'equations)
				     var (cddr obj) (cadr obj)))
	       (if (consp (car ans))
		   (progn (setq origans ans)
			  (setq ans
				(cons (gleqns-simplify (eqn-optprod (car ans)))
				      (cdr ans)))))
	       (if (equal (cadr ans) 1)
		   (car ans)
		   ans))
      (if (and qst (eq (car qst) 'calc-change))
	(progn (setq obj (caddr qst))
	       (setq var (cadr qst))
	       (setq ans (changeobjvar (cadr obj) (cddr obj) (cadddr qst) var))
	       (if (car ans) ans) )
	(if (and qst (eq (car qst) 'meta-change))
	    (progn (setq obj (caddr qst))
		   (setq var (cadr qst))
		   (meta-change (cadr obj) (fifth qst) (cadddr qst) var))) ) )
 ))

; 19 Apr 04
; Make a variable for internal use from a string
; Could save the correspondence on an alist for output generation
(defun varfromstring (str)
  (intern (concatenate 'string "VAR-" str)) )
