; clusters.lsp           Gordon S. Novak Jr.            ; 02 Jan 2000

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 04 Oct 93; 05 Jan 95; 02 Jan 97

; Lisp linked list
(gldefclusterspec 
  '(xlistof ((contents-type anything))

	    ((pointer (^ record))
             (record (cons (contents (transparent contents-type))
			   (link pointer))) )
	    (lisp-linked-list) ) )

; Linked list using nested lists
(gldefclusterspec 
  '(llistof ((contents-type anything))

	    ((pointer (^ record))
             (record (list (contents (transparent contents-type))
			   (link pointer))) )
	    (ext-linked-list) ) )

; Backward linked list
(gldefclusterspec 
  '(blistof ((contents-type anything))

	    ((pointer (^ record))
             (record (cons (link pointer)
			   (contents (transparent contents-type)) ) ) )
	    (ext-linked-list) ) )


; 26 Dec 89; 04 Jun 90
; Linked list with record containing the link
(gldefclusterspec 
  '(zlistof ((record-type anything)
	     (link-field anything)
	     (null-val anything))

	   ((pointer anything
		    prop    ((null-value (null-val))))

	    (record (transparent record-type)
		   prop    ((link ((link-field self)) result pointer))))
           (linked-list) ))


; 04 Jun 90
; "Backwards" Lisp linked list: link in the CAR, contents in CDR, NIL = 7.
(gldefclusterspec 
  '(backl ((contents-type anything))

	   ((pointer anything
		    prop    ((null-value (7))))

	    (record (cons (link pointer)
			  (contents contents-type))			 
		    msg     ((new ((cons (null-value link) nil))
				 result pointer))))
	   (linked-list)))

; 17 Sep 90; 02 Apr 91; 01 Oct 91; 04 Oct 93
(gldefclusterspec 
  '(arrayof ((contents-type anything))

	   ((arr (arrayof contents-type)
              prop   (size filled-size)
	      msg    ((aref aref result contents-type))
	      supers (array))
	    (item contents-type) )
	   ()))


; 25 Apr 90
(gldefclusterspec
  '(two-pointer-queue-of ((linked-list linked-list-pointer))
           ((record (cons  (qstart linked-list)
			   (qend   linked-list))))
	   (two-pointer-queue)))

; 04 Dec 89
(gldefclusterspec
  '(front-pointer-queue-of ((linked-list linked-list-pointer))
           ((record (qstart linked-list)))
           (front-pointer-queue)))

; 13 Jul 90; 16 Jul 90
(gldefclusterspec
  '(end-pointer-queue-of ((linked-list linked-list-pointer))
           ((record (list (qend linked-list))))
           (end-pointer-queue)))

; 28 Nov 89
(gldefclusterspec 
  '(array-priority-queue-of ((queue-type anything))
      ((record (arrayof queue-type)
	     msg ((index aref result queue-type))))
      (priority-queue)))

; 28 Nov 89; 03 Apr 90; 01 Jun 90
(gldefclusterspec 
  '(list-priority-queue-of ((queue-type anything))
      ((record (rep (xlistof queue-type))
          msg    ((index (glambda (self n) (nthcdr (rep self) n))
			 result (cons (transparent queue-type)
				      anything))) ) )
      (priority-queue)))

