; displaux.lsp                Gordon S. Novak Jr.          ; 03 Jan 2000

; Auxiliary functions for DISPL

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 27 Aug 91; 13 Jul 93; 05 Jan 95; 02 Jan 97

(defvar *displ-window*     nil)
(defvar *displ-activeflg*  nil)
(defvar *displ-menu*       nil)
(defvar *displ-item-menu*  nil)


; edited: 04 Aug 89; 17 Dec 90; 19 Dec 90
; Initialize an edit window for the DISPL structure editor. 
(defun displ-initeditwindow ()
  (let ((width 400) (height 400) (over 430) (down 15))
    (setq *displ-window* (window-create width height "DISPL" nil over down))
    (setq *displ-menu*
	  (a menu with items = '(quit redisplay add-item abstract)
	     parent-window = (parent *displ-window*)
	     parent-offset-x = 320
	     parent-offset-y = 10 ))
    (setq *displ-item-menu*
	  (a menu with items = '(delete move shape redisplay)
	     parent-window = (parent *displ-window*)
	     parent-offset-x = 320
	     parent-offset-y = 10 ))
    *displ-window*) )


; edited: 04 Aug 89; 17 Dec 90; 23 Aug 91
; Wait in a loop for mouse actions within the edit window. 
(defun displ-mouseloop ()
  (prog (event mousex mousey point)
lp  (setq point (window-get-click *displ-window*))
    (setq event  (car point))
    (setq mousex (caadr point))
    (setq mousey (cadadr point))
    (windispman-buttoneventfn *displ-window* event mousex mousey)
    (if *displ-activeflg* (go lp))
  ))

; 27 Aug 91
(setf (glfnresulttype 'displ-mouse-position) 'vector)
; Wait in a loop for mouse position selection
(defun displ-mouse-position (left bottom width height window string)
  (window-get-point window) )


(setf (glfnresulttype 'displ-getboxposition) 'vector)
(defun displ-getboxposition
       (width height orgx orgy window &optional promptmsg)
  (window-get-box-position window width height) )


(defmacro geone (x) `(if (< ,x 1) 1 ,x))

(setf (glfnresulttype 'displ-getregion) 'region)
(defun displ-getregion
       (width height orgx orgy window &optional promptmsg)
  (window-get-region window) )


; 25 July 89; 18 Dec 90; 13 Jul 93
(defun compile-displ ()
  (glcompfiles *gldirectory*
	       '("vector.lsp" "dwindow.lsp")   ; auxiliary files
               '("displaux.lsp"       ; translated files
	         "displ.lsp")
	       "displtrans.lsp") )   ; output file
