; equalg.lsp             Gordon S. Novak Jr.         ; 13 Aug 09

; Copyright (c) 2009 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; equality modulo gensyms
(defun equalg (x y)
  (if (consp x)
      (and (consp y)
           (equalg (car x) (car y))
           (equalg (cdr x) (cdr y)))
      (eqlg x y) ) )

(defun eqlg (x y)
  (or (eql x y)
      (and (symbolp x)
           (symbolp y)
           (eqlgn (symbol-name x) (symbol-name y))) ) )

(defun eqlgn (sx sy)
  (let (n (ok t))
    (setq n (max (length sx) (length sy)))
    (dotimes (i n)
      (if (and (< i (length sx))
               (< i (length sy)))
          (setq ok (and ok
                        (or (char= (char sx i) (char sy i))
                            (and (digit-char-p (char sx i))
                                 (digit-char-p (char sy i))))))
          (if (and (< i (length sx))
                   (not (digit-char-p (char sx i))))
              (setq ok nil)
              (if (and (< i (length sy))
                   (not (digit-char-p (char sy i))))
                  (setq ok nil)) ) ) )
    ok))

; compare args of cinsts
(defun cmpciargs (x y)
  (dolist (z (get x 'args))
   (if (not (equalg z (assoc (car z) (get y 'args))))
       (print (car z)))) )
