; gcdist.lsp          Gordon S. Novak Jr.            ; 18 Nov 09

; 29 Sep 94; 05 Jan 95; 04 Oct 06; 18 Sep 07; 10 Mar 08

; Copyright (c) 2009 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

(glispobjects

(lat-long (list (latitude number) (longitude number))
  msg ((distance    (glambda (self other)
                      (gcdist (latitude self) (longitude self)
                              (latitude other) (longitude other)))
                    argtypes (lat-long) ) ) )

) ; glispobjects

; (gcdist 30.4 -97.7 29.4 -98.5)  ; Austin - San Antonio
; (gcdist 30.4 -97.7 32.8 -96.8)  ; Austin - Dallas

; 10 Mar 08
; Great-circle distance between two points specified by (lat, long)
; derived from DIST program of CS 395T project, May 1970.
(gldefun gcdist ((lata (units real degrees)) (longa (units real degrees))
	         (latb (units real degrees)) (longb (units real degrees)))
  (result (units real kilometer))
  (let (clata clatb d psi (dist (units real kilometer)))
    (clata = (cos lata))
    (clatb = (cos latb))
    (d = (sqrt (+ (expt (- (* clata (sin longa))
                           (* clatb (sin longb)))
                        2)
                  (expt (- (* clata (cos longa))
                           (* clatb (cos longb)))
                        2)
                  (expt (- (sin lata) (sin latb)) 2) ) ) )
    (psi = (* 2.0 (asin (/ d 2.0))))
    (dist = (* psi (/ '(q 40040.47872 kilometer) (* 2.0 pi))))
    dist ))

; 29 Sep 94; 10 Mar 08
; Simplified distance: assume flat earth locally
(gldefun sgcdist ((lata (units real degrees)) (longa (units real degrees))
		  (latb (units real degrees)) (longb (units real degrees)))
  (result (units real kilometer))
  (let (midlat (psi (units real radians)) (dist (units real kilometer)))
    (midlat = (/ (+ lata latb) 2.0))
    (psi = (sqrt (+ (expt (- lata latb) 2)
                    (expt (* (- longa longb) (cos midlat)) 2))))
    (dist = (* psi (/ '(q 40040.47872 kilometer) (* 2.0 pi))))
    dist ))

; 18 Nov 09
; using formula from http://mathworld.wolfram.com/GreatCircle.html
(gldefun gcdistb ((lata (units real degrees)) (longa (units real degrees))
	         (latb (units real degrees)) (longb (units real degrees)))
  (result (units real kilometer))
  (let (psi)
    (psi = (acos (+ (* (cos lata) (cos latb) (cos (- longa longb)))
                    (* (sin lata) (sin latb)) ) ) )
   (* psi (/ '(q 40040.47872 kilometer) (* 2.0 pi))) ))
