; genlltest.lsp                Gordon S. Novak Jr.     ; 06 Nov 06

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 14 Dec 93; 05 Jan 95; 10 Jan 97; 15 Jan 99; 28 Feb 02; 08 Jan 04; 01 Jun 04


; Tests of generic linked-list functions in genll.lsp

(glispobjects

(listof-integer-pointer anything
prop    ((dereference (self) result listof-integer-record))
supers  (lisp-linked-list-pointer))

(listof-integer-record (cons (contents integer)
			     (link listof-integer-pointer))
prop    ((copy-contents-names ('(contents))))                   ; 07 Oct 91
msg     ((new ((cons 0 nil)) result listof-integer-pointer))
supers  (lisp-linked-list-record))

; 27 Apr 90; 17 May 90
(cir-llp integer
prop    ((null-value (-1) result cir-llp)
         (dereference (self) result cir-ll-record))
adj     ((null minusp))
supers  (linked-list-pointer) )

(cir-ll-record integer       ; ?? was cir-ll-record
prop ((link   ((aref *cirlinks* self)) result cir-llp)
      (start  ((aref *cirstarts* self)) result vector)
      (radius ((aref *cirrads* self)) result real)
      (copy-contents-names ('(start radius))))
msg  ((new make-cir-llp result cir-llp))		  
supers  (circle linked-list-record))

; Examples for use in insertion in sorted linked list 

#| bad stuff: commented out 19 Mar 91
; 25 Jan 90
; linked list record and pointer fused into one object:
(linked-list anything
 prop   ((dereference (self) ))
 supers (linked-list-pointer linked-list-record))    |#

; 19 Mar 91
(elf (atomobject (name atom)
		 (age integer)
		 (buddy (^ elf))
		 (friends elf-ll-pointer))  ; was (^ elf)
 default ((buddy 'nobody))
 msg     ((< elf-< open t)
          (lt elf-lt open t)
	  (equal elf-equal open t)
	  (+ (glambda (u v)
	      (an elf with age = ((age u) + (age v))))))
 views   ((sll elf-ll-pointer)
	  (linked-list elf-ll-pointer)) )


(persn (self integer)
prop    ((name ((aref namearr self)))
	 (age ((aref agearr self)))
	 (salary ((aref salaryarr self)))
	 (agechain ((aref agechainarr self)))
	 (salarychain ((aref salarychainarr self)))))


(persn-as-ll (z persn)
 prop   ((link ((agechain z)))
	 (null-value (-1)))
 adj    ((null (z < 0)))
 supers (linked-list))


(persn-linked-list (self (transparent persn))
prop    ((dereference (self) result persn-record)
	 (null-value (-1)))
adj     ((null (self < 0)))
supers  (linked-list-pointer))

(persn-record (self (transparent persn))
supers (linked-list-record))

(persn-as-sll-on-age (self (transparent persn))
prop    ((dereference (self) result persn-as-sll-on-age-record))
msg     ((sort-before (glambda (l y) (> (age (contents (^. l)))
				      (age y)))))
supers  (persn-linked-list sorted-linked-list))

(persn-as-sll-on-age-record (self (transparent persn))
prop    ((contents (self) result persn)
	 (link ((agechain self)))) )

(persn-as-sll-on-salary (self (transparent persn))
prop    ((dereference (self) result persn-as-sll-on-salary-record))
msg     ((sort-before (glambda (l y) (< (salary (contents (^. l)))
				      (salary y)))))
supers  (persn-linked-list sorted-linked-list) )

(persn-as-sll-on-salary-record (self (transparent persn))
prop    ((contents (self) result persn)
	 (link ((salarychain self)))) )

 ) ; glispobjects

; 24 Apr 90; 15 Mar 91         ; example of elf as linked-list
(gldefclusterc
  'elf-ll
  '((pointer  (elf-ll-pointer (^ elf-ll-record)
		prop ((null-value ('nobody)))))
    (record   (elf-ll-record (z elf)
		prop ((link ((buddy z)) result elf-ll-pointer)
		      (copy-contents-names ('(name age friends))))
	        msg  ((new ((an elf)) result elf-ll-pointer) ) )) )
  '(sll))

; 19 May 92; 25 May 92; 26 Oct 93
(gldefclusterc             ; Example of linked list in array
  'mylla
  '((pointer  (mylla-pointer integer))
    (record   (mylla-record  integer
		prop ((link-array     (*mylla-links*))
                      (contents-array (*mylla-contents*))))))
  '(linked-list-in-array))

(glispglobals (*mylla-contents* (arrayof integer)))

(defvar *mylla-links* (make-array 10))
(setf (aref *mylla-links* 7) 4)
(setf (aref *mylla-links* 4) 2)
(setf (aref *mylla-links* 2) -1)
(defvar *mylla-contents* (make-array 10))
(setf (aref *mylla-contents* 7) 1)
(setf (aref *mylla-contents* 4) 2)
(setf (aref *mylla-contents* 2) 3)

(gldefun nm  ((ld mylla-pointer)) (length l))               ; (nm 7)  ; = 3
(gldefun nm2 ((l mylla-pointer)) (for x in l (print x)))   ; (nm2 7) ; = 1 2 3
(gldefun nm3 ((l mylla-pointer)) (nreverse l))             ; (nm3 7) ; = 2

; Test functions to cause compilation of specializations of the generics:

(gldefun na ((l lisp-linked-list-pointer))  (first l))

(gldefun nai ((l listof-integer-pointer))  (first l))

(gldefun nac ((l cir-llp))  (first l))

(gldefun nacb ((l cir-llp))  (area (first l)))

(gldefun nacc ((l cir-llp))  (grow (first l)))

(gldefun nb ((l lisp-linked-list-pointer))  (length l))

(gldefun nbi ((l listof-integer-pointer))  (length l))

(gldefun nbc ((l cir-llp))  (length l))

(gldefun nbe ((l elf-ll-pointer))  (length l))

(gldefun nc ((l lisp-linked-list-pointer))  (nreverse l))

(gldefun nci ((l listof-integer-pointer))  (nreverse l))

(gldefun ncc ((l cir-llp))  (nreverse l))

(gldefun nce ((l elf-ll-pointer))  (nreverse l))

(gldefun nd ((l lisp-linked-list-pointer) (n integer))  (nth l n))

(gldefun ndi ((l listof-integer-pointer) (n integer))  (nth l n))

(gldefun ndc ((l cir-llp) (n integer))  (nth l n))

(gldefun nde ((l elf-ll-pointer) (n integer))  (nth l n))

(gldefun ndcb ((l cir-llp) (n integer))  (area (glsend l nth n)))

(gldefun ndcc ((l cir-llp) (n integer))  (glsend (glsend l nth n) grow))

(gldefun ndccb ((l cir-llp) (n integer))  (glsend (^. (glsend l nthcdr n)) grow))

(gldefun ndccc ((l cir-llp) (n integer))
  (let ((tmp (nthcdr l n))) (grow (^. tmp))))

(gldefun ndccd ((l cir-llp) (n integer)) (let ((tmp (nth l n))) (grow tmp)))

(gldefun ne ((l lisp-linked-list-pointer))  (glsend l pop))

(gldefun nei ((l listof-integer-pointer))  (pop l))

(gldefun nec ((l cir-llp))  (glsend l pop))

(gldefun nee ((l elf-ll-pointer))  (glsend l pop))

(gldefun necb ((l cir-llp))  (area (glsend l pop)))

(gldefun necbb ((p (cons (x integer) (l cir-llp))))
  (area (glsend (l p) pop)))

(gldefun necc ((l cir-llp))  (glsend (glsend l pop) grow))

(gldefun neccb ((p (cons (x integer) (l cir-llp))))
  (grow (pop (l p))))

(gldefun nf ((l lisp-linked-list-pointer))  (rest l))

(gldefun nfi ((l listof-integer-pointer))  (rest l))

(gldefun nfc ((l cir-llp))  (rest l))

(gldefun nfe ((l elf-ll-pointer))  (rest l))

(gldefun ng ((l lisp-linked-list-pointer))  (last l))

(gldefun ngc ((l cir-llp))  (last l))

(gldefun nge ((l elf-ll-pointer))  (last l))

(gldefun nh ((l lisp-linked-list-pointer))  (copy-list l))

(gldefun nhi ((l listof-integer-pointer))  (copy-list l))

(gldefun nhc ((l cir-llp))  (copy-list l))

(gldefun nhe ((l elf-ll-pointer))  (copy-list l))

; edited:  6-Feb-87; 11 Oct 89
(gldefun elf-< (x y) ((age x) < (age y)))
(gldefun elf-equal (x y) ((age x) == (age y)))
(gldefun elf-lt (x y) ((length (friends x)) < (length (friends y))))

; edited:  5-Feb-87; 20 Apr 90
(gldefun nk ((club elf-ll-pointer) new) (insert club new))

; edited: 13-Mar-87; 14 Dec 89
(gldefun nj ((b persn-as-sll-on-age) (c persn-as-sll-on-age-record))
  (insert b c))

; edited: 13-Mar-87; 14 Dec 89
(gldefun njb ((b persn-as-sll-on-salary) (c persn-as-sll-on-salary-record))
  (insert b c))

(gldefun nle ((l elf-ll-pointer) (n elf)) (delete l n))

(gldefun nli ((l listof-integer-pointer) (n integer))  (delete l n))

(gldefun nmi ((l listof-integer-pointer) (m listof-integer-pointer))
  (append l m))

(gldefun nme ((l elf-ll-pointer) (m elf-ll-pointer))  (append l m))   ; 26 Nov 90

; requires (glviewas 'linked-list 'box) ;  cf. viewas.lsp
(gldefun nmb ((ba box) (bb box)) (append (linked-list ba) (linked-list bb)))

(gldefun nne ((l elf-ll-pointer) (m elf-ll-pointer))  (push l m))

(gldefun nni ((l listof-integer-pointer) (m listof-integer-pointer)) (push l m))

(gldefun nnib ((l listof-integer-pointer) (i integer)) (push-item l i))

(setq nfns '(na nai nac nacb nacc nb nbi nbc nbe nc nci ncc nce
	 nd ndi ndc nde ndcb ndcc ndccb ndccc ne nei nec nee necb
	 necbb necc neccb nf nfi nfc nfe ng ngc nge nh nhi nhc nhe
	 nk nj njb nle nli nme nmi nmb nni nnib))


; Example: two-pointer queue, priority queue.


(glispobjects

(mytpqconn (i integer)
prop    ((qstart ((aref qs i))
		 result myqep)
	 (qend ((aref qe i))
	       result myqep))
supers  (two-pointer-queue-record))

#| (mytpqconn (list (qstart myqep)   ; alternative
		 (qend myqep))
supers  (two-pointer-queue)) |#

(myqep (i integer)
prop ((null-value (-1) result myqep)
      (dereference (self) result myqrec))
adj  ((null minusp))
supers (linked-list-pointer))

(myqrec (i integer)
prop    ((contents ((aref data-array i)))
	 (link ((aref link-array i)) result myqep))
supers  (linked-list))

(elf-tpq (list (qend elf-ll-pointer)
	       (qstart elf-ll-pointer))
supers  (two-pointer-queue-record))

(elf-fpq (qstart elf-ll-pointer)
supers (front-pointer-queue-record))

(listof-integer-fpq (qstart listof-integer-pointer)
supers (front-pointer-queue-record))

(listof-integer-tpq (cons (qstart listof-integer-pointer)
			  (qend listof-integer-pointer))
supers  (two-pointer-queue-record))

)


; edited: 11-Jun-87; 12 Mar 91
(gldefun rf ((q mytpqconn) (s myqep)) (insert q s))

(gldefun rfe ((q elf-tpq) (e elf-ll-pointer)) (insert q e))     ; 12 Mar 91

(gldefun rge ((q elf-ll-pointer) (e elf)) (member q e))

; edited: 15-Jun-87
(gldefun rh ((q mytpqconn)) (remove q))

(gldefun rhe ((q elf-tpq)) (remove q))

; 26 Nov 90
(gldefun rheb ((q elf-tpq)) (age (remove q)))

(gldefun ri ((l lisp-linked-list-pointer) (n integer) (new anything))
  (set-nth l n new))

(gldefun rie ((q elf-ll-pointer) (n integer) (new elf-ll-record))
  (set-nth q n new))

(gldefun rj ((l listof-integer-fpq) (new listof-integer-record)) (insert l new))

(gldefun rjb ((l listof-integer-fpq) (new integer)) (insert-item l new))

(gldefun rje ((q elf-fpq) (s elf-ll-record)) (insert q s))

(glispobjects

(elf-priority-queue anything
  msg    ((index aref result elf-tpq))
  supers (array priority-queue-record))

; 27 Nov 90
(listof-integer-pq-record (cons listof-integer-tpq
	                        (link listof-integer-pq-pointer))
  supers (lisp-linked-list-record))

(listof-integer-pq-pointer (^ listof-integer-pq-record)
  supers (lisp-linked-list-pointer priority-queue-record))

  ) ; glispobjects

(gldefun rke ((pq elf-priority-queue) (n integer))
  (remove pq n))

(gldefun rle ((pq elf-priority-queue) (n integer) (new elf-ll-pointer)) ; 12 Mar 91
  (insert pq n new))

; 27 Nov 90
(gldefun rkib ((pq listof-integer-pq-pointer) (n integer))
  (remove-item pq n))

; 27 Nov 90
(gldefun rlib ((pq listof-integer-pq-pointer) (n integer) (new integer))
  (insert-item pq n new))


(gldefun ja ((p person) (q person)) ((pasv p) - (pasv q)))

(gldefun jb ((p person) (q person)) (distance (pasv p) (pasv q)))

(gldefun jc ((p person) (q person)) ((age p) - (age q)))

(gldefun jd ((c circle)) (components (typeof c)))

(gldefun je ((ar (arrayof person)) (n integer)) (age (aref ar n)) )

(gldefun jf ((q (two-pointer-queue-of (xlistof integer))))
  (remove-item q))

(gldefun jg ((q (two-pointer-queue-of (xlistof integer))) (n integer))
  (insert-item q n))

; 13 Jul 90
(gldefun jh ((q (end-pointer-queue-of (xlistof integer))))
  (remove-item q))

(gldefun ji ((q (end-pointer-queue-of (xlistof integer))) (n integer))
  (insert-item q n))

; 28 Nov 89; 13 Jul 90
(gldefun sa
  ((q (array-priority-queue-of (two-pointer-queue-of (xlistof integer))))
   (pri integer))
  (remove-item q pri))

; 28 Nov 89
(gldefun sb
  ((q (array-priority-queue-of (two-pointer-queue-of (xlistof integer))))
   (pri integer) (n integer))
  (insert-item q pri n))


; 28 Nov 89; 13 Jul 90
(gldefun sal
  ((q (list-priority-queue-of (two-pointer-queue-of (xlistof integer))))
   (pri integer))
  (remove-item q pri))

; 28 Nov 89
(gldefun sbl
  ((q (list-priority-queue-of (two-pointer-queue-of (xlistof integer))))
   (pri integer) (n integer))
  (insert-item q pri n))

; 13 Jul 90
(gldefun sale
  ((q (list-priority-queue-of (end-pointer-queue-of (xlistof integer))))
   (pri integer))
  (remove-item q pri))

; 13 Jul 90
(gldefun sble
  ((q (list-priority-queue-of (end-pointer-queue-of (xlistof integer))))
   (pri integer) (n integer))
  (insert-item q pri n))

; 22 May 90
(gldefun salelf
  ((q (list-priority-queue-of (two-pointer-queue-of elf-ll-pointer)))
   (pri integer))
  (remove q pri))

; 22 May 90; 12 Mar 91
(gldefun sblelf
  ((q (list-priority-queue-of (two-pointer-queue-of elf-ll-pointer)))
   (pri integer) (new elf-ll-pointer))
  (insert q pri new))

(glispobjects
  (mypq (transparent (list-priority-queue-of
	               (two-pointer-queue-of (xlistof integer)))))
)

(gldefun salb ((q mypq) (pri integer)) (remove-item q pri))

(gldefun sblb ((q mypq) (pri integer) (n integer)) (insert-item q pri n))

; test data for above functions:
(setq tpq (let ((q0 '(1 2 3)) (q1 '(4 5)) (q2 '()) (q3 '(6 7)))
            (list (cons q0 (last q0)) (cons q1 (last q1))
	          (cons q2 (last q2)) (cons q3 (last q3)))))
; (salb tpq 1) ; = 4
; (sblb tpq 1 8)

; 28 Nov 89; 13 Jul 90
(gldefun salf
  ((q (list-priority-queue-of (front-pointer-queue-of (xlistof integer))))
   (pri integer))
  (remove-item q pri))

; 28 Nov 89
(gldefun sblf
  ((q (list-priority-queue-of (front-pointer-queue-of (xlistof integer))))
   (pri integer) (n integer))
  (insert-item q pri n))

; test data for above functions:
(setq myq '((1 2 3) (4 5) () (6 7)))

; 26 Dec 89
(gldefun nbp ((l (zlistof persn salarychain -1))) (length l))

(gldefun ncp ((l (zlistof persn salarychain -1))) (nreverse l))

; 08 Jan 90
(glispobjects
  (sint (transparent  (xlistof integer)) supers (sorted-linked-list))
  (sbint (transparent (xlistof integer))
     msg ((sort-before (glambda (l y) (> (contents (^. l)) y))))
     supers (sorted-linked-list))
  (sstr (transparent (xlistof string))  supers (sorted-linked-list))
 )

; 10 Jan 97
(gldefun zc  ((l sint) (n integer))  (insert-key l n)) ; (zc '(2 4 6 8) 5)
(gldefun zcs ((l sstr) (n string))   (insert-key l n))
;  (zcs '("dick" "harry" "tom") "fred")
(gldefun zcb ((l sbint) (n integer)) (insert-key l n)) ; (zcb '(8 6 4 2) 5)


; Chess board example     05 Apr 90; 14 Feb 91
(gldefclusterc
  'chess-board-linked-list
  '((pointer  (cboard-llp (cons (column integer) (row integer))
		prop    ((null-value ((a cboard-llp with row = -1)))
			 (dereference ((aref *cboard-array* row column))
				      result cboard-ll-record))
		adj     ((null (row is negative)))))
    (record   (cboard-ll-record (listobject (row integer)
					    (piece atom)
	                                    (value integer)
					    (column integer))
		prop ((link ((virtual cboard-llp with row = row
				      column = column)))
		      (copy-contents-names ('(piece value)))
		      (copy-contents ((tuple (piece self) (value self)))))
		msg  ((new ((make-cboard-llp)) result cboard-llp)))))
  '(linked-list))

; 09 Apr 90; 19 Jul 90
(gldefun make-cboard-llp ()
  (prog (ro col (n 0) ptr cont)
    (repeat (ro = (random 8))
	    (col = (random 8))
	    (n _+ 1)
	    (ptr = (a cboard-llp with row = ro column = col))
            (cont = (^. ptr))
      until ( ~ cont or (n > 64)))
    ((^. ptr) = (a cboard-ll-record))
    (return ptr)))



(gldefun kc ((r cboard-ll-record)) (link r))
(gldefun kd ((r cboard-ll-record)) (length (link r)))
(gldefun ke ((p cboard-llp)) (^. p))
(gldefun kf ((p cboard-llp)) (link (^. p)))
(gldefun kg ((p cboard-llp)) (length p))
(gldefun kh ((p cboard-llp)) (copy-list p))
(gldefun ki ((l cboard-llp)) (nreverse l))
(gldefun kj ((p cboard-llp)) (for z in p (print (piece z))))
(setf *cboard-array* (make-array '(8 8) :initial-element nil))
(setf (aref *cboard-array* 1 1) (a cboard-ll-record with row = 3
                                   column = 7 piece = 'king))
(setf (aref *cboard-array* 3 7) (a cboard-ll-record with row = 4
				   column = 5 piece = 'knight))
(setf (aref *cboard-array* 4 5) (a cboard-ll-record with row = -1
				   column = 0 piece = 'pawn))
; then try (kg '(1 . 1)) = 3, (ki '(1 . 1)) = (5 . 4), (kg '(5 . 4)) = 3
(gldefun km ((l cboard-llp) (m cboard-llp)) (nconc l m))


; 24 Apr 90         ; example of elf as sorted-linked-list, sorted on age
(gldefclusterc
  'elf-as-sll
  '((pointer  (elf-as-sll-ptr (^ elf-as-sll-record)))
    (record   (elf-as-sll-record (z elf)
		prop ((sort-value ((age z)))))))
  '(elf-ll sll))

(gldefun fa ((l elf-as-sll-ptr)) (length l))
(gldefun fbb ((l elf-as-sll-ptr)) (nreverse l))
(gldefun fc ((l elf-as-sll-ptr)) (copy-list l))
; fd doesn't work because it needs the view type for second arg, as in fe.
(gldefun fd ((l elf-as-sll-ptr) (new elf)) (insert l new))     ; problem
(gldefun fe ((l elf-as-sll-ptr) (new elf-as-sll-ptr)) (insert l new))

; 24 Apr 90         ; example of elf as sorted-linked-list, descending on age
(gldefclusterc
  'elf-as-sllb
  '((pointer  (elf-as-sllb-ptr (^ elf-as-sllb-record)))
    (record   (elf-as-sllb-record (z elf)
		prop ((sort-value ((age z)))
                      (sort-direction ('descending))))))
  '(elf-ll sll))

(gldefun feb ((l elf-as-sllb-ptr) (new elf-as-sllb-ptr)) (insert l new))


(gldefclusterc       ; 24 Apr 90
  'persn-sll-on-age
  '((pointer  (persn-sll-age-ptr integer
		prop ((null-value (-1)))))
    (record   (persn-sll-age-record (z persn)
		prop ((link ((agechain z)) result persn-sll-age-ptr)
                      (sort-value ((age z)))))) )
  '(sll))

(gldefun fep ((l persn-sll-age-ptr) (new persn-sll-age-ptr)) (insert l new))
(gldefun fap ((l persn-sll-age-ptr)) (length l))
(gldefun fbp ((l persn-sll-age-ptr)) (nreverse l))


(glispobjects

(persnb (atom (proplist (name string)
		        (age integer)
			(salary real)
			(agechain (^ persnb))
			(salarychain (^ persnb)))) )
  )

(gldefclusterc       ; 24 Apr 90
  'persnb-sll-on-age
  '((pointer  (persnb-sll-age-ptr (^ persnb-sll-age-record)))
    (record   (persnb-sll-age-record (z persnb)
		prop ((link ((agechain z)))
		      (copy-contents ((tuple (name z) (age z) (salary z))))
                      (sort-value ((age z)))) )) )
  '(sll))

(gldefun fepb ((l persnb-sll-age-ptr) (new persnb-sll-age-ptr)) (insert l new))
(gldefun fapb ((l persnb-sll-age-ptr)) (length l))
(gldefun fbpb ((l persnb-sll-age-ptr)) (nreverse l))
(gldefun fcpb ((l persnb-sll-age-ptr)) (copy-list l))

; Some 'elf' data for testing
(setq happy   (an elf with name 'happy   age 10))
(setq sneezy  (an elf with name 'sneezy  age 11))
(setq sleepy  (an elf with name 'sleepy  age 12))
(setq dopey   (an elf with name 'dopey   age 13))
(setq grumpy  (an elf with name 'grumpy  age 14))
(setq bashful (an elf with name 'bashful age 15))
(glsend happy   buddy\: 'nobody)
(glsend sneezy  buddy\: bashful)
(glsend bashful buddy\: 'nobody)
(glsend sleepy  buddy\: 'nobody)
(glsend dopey   buddy\: grumpy)
(glsend grumpy  buddy\: 'nobody)
(glsend happy   friends\: dopey)
(glsend sneezy  friends\: 'nobody)
(glsend sleepy  friends\: 'nobody)
(glsend dopey   friends\: sleepy)
(glsend grumpy  friends\: sneezy)
(glsend bashful friends\: 'nobody)

; 21 Sep 90; 01 Oct 90; 11 Oct 90; 12 Oct 90; 12 Mar 91
; print buffer example: print buffer as a linked list.
; A print buffer is an array of characters containing print lines.
; Each line consists of one byte that gives the number of characters
; in the line, followed by that number of characters.  The end of the
; buffer is indicated by a count of zero.
(gldefclusterc
  'prbuf
  '((pointer  (prbuf-pointer integer
		adj ((null ((size (^. self)) == 0))) ) )
    (record   (prbuf-record integer
		prop ((link (self + size + 1) result prbuf-pointer)
		      (size ((aref *buffer* self)) result integer)
                      (line ((viewas nil char-array array = *buffer*
                                     offset = self + 1  size = size)))
		      (implementation (self)))  ; 12 Mar 91

;      (chars ((for i in (size self) collect (char self i) )))

		msg  ((char (glambda (z (i integer))       ; i from 0 to size-1
                              (aref *buffer* (self + i + 1)))))
                views ((chars array (lower-bound (self)) (size (size))))  ; ??
                  )))
  '(linked-list))

(glispobjects

; 12 Oct 90
(char-array (tuple (array array) (offset integer) (size integer))
  msg    ((index (glambda (self n) (code-char (aref array (+ offset n)))))
          (new   error)
          (print char-array-print open t))
  supers (array))

  ) ; glispobjects

(gldefun char-array-print ((arr char-array))
  (let ((i 0))
    (while (i < (size arr)) do (princ (index arr i)) (i _+ 1))
    (terpri) ))

(gldefun wq ((p prbuf-pointer)) (length p))     ; length in number of lines
(gldefun wp ((p prbuf-pointer)) (for line in p (print (size line))))
(gldefun wo ((p prbuf-pointer))
  (for line in p do (for c in (chars line) do (princ c))))            ; ??
(gldefun wn ((p prbuf-pointer)) (nreverse p))   ; generates an error as it should

(defvar *buffer* (make-array 23 :element-type '(unsigned-byte 8)
      :initial-contents
      '(4 84 72 73 83 2 73 83 1 65 4 84 69 83 84 6 66 85 70 70 69 82 0)))
(gldefun wm ((p prbuf-pointer)) (for l in p (print (line l))))
; (wq 0)
; (wp 0)
; (wm 0)     ; ?? not working as of 12 Mar 91

(gldefun wwa ((ar (arrayof integer))) (sort ar))
(setq myarr (make-array 10 :initial-contents '(2 10 9 7 3 5 4 6 1 8)))
; (wwa myarr)

(glispobjects
 (arv (arrayof vector) prop ((sort-element-view ('magnitude)))
      supers (array))
 (pv (arrayof person)
      prop   ((sort-element-view ('age)))
      supers (array))
 (cboxv (arrayof cbox)
      prop   ((sort-element-view ('size))
	      (size              (10)))
      supers (array))
 (ars (arrayof string) supers (array))
 (lipb (listof integer)
      prop ((sort-direction ('descending)))
      supers (listof-integer-pointer))
 )

(gldefun wwb ((ar arv)) (sort ar))
(setq myarv (make-array 10 :initial-contents '((1 2) (1 1) (2 2) (3 4) (10 10)
(7 8) (4 6) (3 1) (0 0) (0 1))))
; (wwb myarv)

(gldefun wwc ((ar pv)) (sort ar))
(setq mypv (make-array 4 :initial-contents (list gsn jca mxe erw)))
; (wwc mypv)

(gldefun wwd ((ar cboxv)) (sort ar))      ; and translate to C
(gldefun wwe ((ar ars)) (sort ar))
(setq myars (make-array 8 :initial-contents '("tom" "dick" "harry" "fred"
				   "jane" "susan" "genny" "courtney")))
; (wwe myars)

; 24 Nov 93
(gldefun nnj ((l listof-integer-pointer)) (sort l))
; (nnj '(1 4 7 6 3 0 9 8 2 5))
(gldefun nnl ((l (xlistof integer))) (sort l))
; (nnl '(1 4 7 6 3 0 9 8 2 5))
(gldefun nnm ((l (xlistof string))) (sort l))
; (nnm '("tom" "dick" "harry" "fred" "jane" "susan" "genny" "courtney"))
