; gev.lsp              Gordon S. Novak Jr           ; 15 Jan 10

; Copyright (c) 2010 Gordon S. Novak Jr and The University of Texas at Austin.
; All rights reserved.

; GEV Structure Inspector
; derived from {DSK}<LISPFILES>GEV.CL;1  1-Mar-89 11:47:40 

; 23 Dec 94; 24 Dec 94; 27 Dec 94; 28 Dec 94; 03 Jan 95; 04 Jan 95; 04 May 95
; 12 Jan 96; 02 Jan 97; 13 Mar 97; 02 Jan 97; 05 Apr 99; 26 Feb 02; 05 Jan 04
; 19 Jan 04; 03 Mar 04; 27 May 04; 29 May 04; 01 Jun 04; 25 Mar 04; 07 Nov 06
; 29 Nov 07; 09 Jan 08; 27 Mar 08

(proclaim '(special *glnatom* *gevmatchresult*
		    *gllispdialect* *gluserstrnames* *gevactiveflg*
		    *geveditchain* *geveditflg* *gevlastitemnumber*
		    *gevmenuwindow* *gevmenuwindowheight* *gevmousearea*
		    *gevshortchars* *gevwindow* *gevwindowy* *gevglobaly*
		    *gevusertypenames*))

; The following files are required: VECTOR GEVAUX DWINDOW 

(defvar *gevglobaly* 0)

(glispglobals
(*gevactiveflg*        boolean)
(*geveditchain*        editchain)
(*geveditflg*          boolean)
(*gevlastitemnumber*   integer)
(*gevmenuwindow*       window)
(*gevmenuwindowheight* integer)
(*gevmousearea*        mousestate)
(*gevshortchars*       integer)
(*gevwindow*           window)
(*gevglobaly*          integer)
(*gevwindowy*          integer)
(*gevmatchresult*      anything)
(*gevusertypenames*    (listof symbol))
)

(glispconstants
(gevmousebutton  4 integer)
(gevnamechars   11 integer)
(gevvaluechars  27 integer)
(gevnamepos (+ gevnumberpos (cond ((> gevnumberchars 0)
				      (* (1+ gevnumberchars)
					     windowcharwidth))
				     (t 0))) integer)
(gevtildepos (+ gevnamepos (* (1+ gevnamechars)
				     windowcharwidth)) integer)
(gevvaluepos (+ gevtildepos (* 2 windowcharwidth)) integer)
)


(glispobjects

(editchain (listof editframe)
  prop    ((topframe ((car self)))
	   (topitem  ((car (prevs topframe))))))


(editframe (list (prevs (listof gseitem))
		 (subitems (listof gseitem))
		 (props (listof gseitem))))


(gseitem (list (name anything)
	       (value anything)
	       (type anything)
	       (shortvalue atom)
	       (nodetype atom)
	       (subvalues (listof gseitem))
	       (namepos vector)
	       (valuepos vector))
  prop  ((namearea ((virtual region with start = namepos width = 
			     windowcharwidth* (length (symbol-name name))
			     height = windowlineyspacing)))
	 (valuearea ((virtual region with start = valuepos width = 
			     windowcharwidth* (length (symbol-name name))
			      height = windowlineyspacing)))))

(mousestate (list (area region)
		  (item gseitem)
		  (flag boolean)
		  (group integer)))
)


; edited:  9-FEB-83 11:40 
; GLISP Edit Value function. Edit VAL according to structure 
;   description STR. 
(defmacro gev (&rest args) `(gev-expr ',args))
(defun gev-expr (args)
  (geva (car args)
        (eval (car args))
        (and (cdr args)
	     (if (or (not (atom (cadr args)))
		     (boundp (cadr args)))
	         (eval (cadr args))
	         (cadr args)))))


; 13-Dec-83; 27 Dec 94; 26 Feb 02; 19 Jan 04; 27 May 04
; GLISP Edit Value function. Edit VAL according to structure description STR. 
(gldefun geva (var val str)
  (let (*glnatom* header)
     (geventer)
     (if (or (not (boundp '*gevwindow*))
	     (null *gevwindow*))
	 (geviniteditwindow))
     (if *gevmenuwindow* (glsend *gevmenuwindow* open))
     (glsend *gevwindow* open)
     (*gevactiveflg* = t)
     (*geveditflg* = nil)
     (setq *glnatom* 0)
     (*gevshortchars* = gevvaluechars)
     (if var is a list and (car var) == 'quote
	 (var = (concat "'" (gevstringify (cadr var)))))
     (if ~str
	 (if val is atomic and (get val 'glstructure)
	     (str = 'gltype)
	     (or (str = (gevuserstr val))
		 (if (gevglispp)
		      (str = (glclass val))))))
     (header = (a gseitem with name = var value = val type = str))
     (*geveditchain* = (list (list (list header) nil nil)))
     (gevrefillwindow)
     (gevmouseloop)
     (gevexit)))


; 17-APR-83; 24 Dec 94; 19 Jan 04; 09 Jan 08
(gldefun gevcommandfn ((commandword atom))
(let (topitem)
  (if commandword
     (case commandword of
           (edit (gevedit))
	   (quit (if *gevmousearea*
                     (progn
		       (glsend *gevwindow* invertarea (area *gevmousearea*))
		       (*gevmousearea* = nil))
		     (gevquit)))
	   (pop (gevpop t 1))
	   (program (gevprogram))
	   ((prop adj isa msg)
	    (topitem = (topitem *geveditchain*))
	    (gevcommandprop topitem commandword nil))
	   else
	   (error "gevcommandf")))))


; 11-AUG-83; 24 Dec 94; 13 Mar 97; 26 Feb 02; 19 Jan 04; 27 May 04
(gldefun gevcommandprop ((item gseitem) (commandword atom) (propname atom))
  (prog (propnames flg)
      (if propname
	  (flg = t))
      (if (type item) is atomic
	  (propnames = (gevcommandpropnames (type item) 
					    commandword 
					    (topframe *geveditchain*))))
      (if (type item) is atomic or commandword == 'prop
	 (progn
	  (if commandword == 'prop
	      (if propnames and (cdr propnames)
		  (propnames +_ 'all))
	      (propnames +_ 'self))
	  (if ~propnames
	      (return nil))
	  (if ~propname
	      (propname = (glsend (a menu with items = propnames)
				  select)))
	  (if ~propname
	      (return nil)
	      (if propname == 'self
		  (progn (geventerprint)
			 (prin1 propname)
			 (princ " = ")
			 (prin1 (value item))
			 (terpri)
			 (gevexitprint))
		  (if commandword == 'prop and propname == 'all
		      (for x in (or (cddr propnames)
				    (cdr propnames))
			   do
			   (gevdoprop item x commandword flg))
		      (gevdoprop item propname commandword flg))))
	  (if commandword == 'msg
	      (progn (gevrefillwindow)
		     (*geveditflg* = t)))))))


; 9-Dec-83; 08 Jun 94; 03 Jan 95; 26 Feb 02; 19 Jan 04
; Get all property names of properties of type PROPTYPE for OBJ. 
;   Properties are filtered to remove system properties and those 
;   which are already displayed. 
(gldefun gevcommandpropnames ((obj gltype) (proptype atom)
					  (topframe editframe))
(prog (result)
      (if obj is not atomic
	  (return nil))
      (result = (for p in (case proptype of (prop (props obj))
				(adj (adjs obj))
				(isa (isas obj))
				(msg (msgs obj)))
		     when (and (not (proptype != 'msg and
			         (that prop of topframe with name =
						 (car p))))
		              (not (proptype == 'prop and (member (car p)
					         '(shortvalue 
						   displayprops))))
		     (not (proptype == 'msg
			   and (cadr p)
			   and (cadr p) is atomic
			   and (~ (fboundp (cadr p))
					or
					(length (gevarglist
						       (cadr p)))
					>1))))
		     collect (name p)))
      (for s in (supers obj) do
	   (result = (nconc result (gevcommandpropnames
						 s proptype topframe))))
      (for s in (gltransparenttypes obj)
	   do
	   (result = (nconc result (gevcommandpropnames (glxtrtype s)
						proptype topframe))))
      (return result)))


; 17 July 89; 19 Jan 04; 15 Jan 10
; Compile a property whose name is PROPNAME and whose property type 
;   (ADJ, ISA, PROP, MSG) is PROPTYPE for the object type STR. 
(gldefun gevcompprop ((str gltype) (propname atom) (proptype atom))
  (prog (propent)
      (if ~ (proptype <= '(adj isa prop msg))
	  or str is not atomic
	  (return 'geverror))
      
; if the property is implemented by a named function, return the 
;   function name. 

      (if (propent = (gevgetprop str propname proptype))
	  and
	  (cadr propent)
	  is atomic
	  (return (cadr propent)))
      
; compile code for this property and save it. first be sure the glisp 
;   compiler is loaded. 

      (return (or (and (gevglispp)
                       (not (glgenericstrp str))
                       (car (glcompprop str propname proptype nil)) )
                  'geverror) ) ))


; edited:  17 Aug 89; 07 Jan 91; 19 Jan 04
; Get a flattened list of names and types from a given structure description. 
(gldefun gevdatanames ((obj gltype) (filter atom))
  (result (listof glnametype))
  (nreverse (gevdatanamesb (if (symbolp obj) (strdes obj) obj)
			   filter nil)) )


; 17 Aug 89; 23 May 90; 08 Jan 91; 19 Mar 91; 01 Oct 92; 13 Oct 92; 09 Nov 92
; 19 Jan 04
; Get a flattened list of names and types from a given structure 
;   description. 
(gldefun gevdatanamesb ((str anything) (filter atom) result)
  (if (consp str)
      (case (car str) of
	    (cons (gevdatanamesb (caddr str) filter
			         (gevdatanamesb (cadr str)
						filter result)))
	    ((alist proplist list object atomobject listobject tuple)
	      (for x in (cdr str) do
		   (setq result (gevdatanamesb x filter result)))
	      result)
	    ((record crecord) (for x in (cddr str) do
		   (setq result (gevdatanamesb x filter result)))
		    result)
	    (atom (gevdatanamesb (caddr str) filter
			         (gevdatanamesb (cadr str) filter result)))
	    (binding (gevdatanamesb (cadr str) filter result))
	    ((listof ^ units) result)
	    else
	    (if (gevfilter (cadr str) filter)
		(if (and (consp (cadr str))
			 (member (caadr str) '(a an)))
		    (gevdatanamesb (cadadr str) filter
				   (cons (list (car str) (cadadr str))
					 result))
		    (gevdatanamesb (cadr str) filter
				   (cons (list (car str) (cadr str))
					 result)))
	        result) )
      result) )


; 25-MAR-83; 24 Dec 94; 28 Dec 94
; Display a newly added property in the window.
; y is a global used by gevpps.
(gldefun gevdisplaynewprop nil
  (let ((newone gseitem))
    (*gevglobaly* = *gevwindowy*)
    (newone = (car (last (props (topframe *geveditchain*)))))
    (gevpps newone 0 *gevwindow*)
    (*gevwindowy* = *gevglobaly*)))


; edited:  4-FEB-83; 05 Jan 04; 19 Jan 04; 09 Jan 08
; Add the property PROPNAME of type COMMANDWORD to the display for ITEM. 
(gldefun gevdoprop ((item gseitem) (propname atom)
				  (commandword atom) (flg boolean))
  (let (val)
     (val = (gevexprop (value item) (type item) propname commandword nil))
     ((props (topframe *geveditchain*)) _+
         (a gseitem with name = propname type =
	    (gevproptype (type item) commandword propname)
	    value = val nodetype = commandword))
     (if ~flg (gevdisplaynewprop))))


; edited:  6-Oct-86; 26 Feb 02; 19 Jan 04
; Edit the currently displayed item. 
(gldefun gevedit nil
  (prog (changedflg gevtopitem geveditvar)
      (gevtopitem = (topitem *geveditchain*))
      (if (type gevtopitem) is atomic and (gevexprop (value gevtopitem) 
						   (type gevtopitem)
						   'edit
						   'msg
						   nil)
	  != 'geverror
	  (changedflg = t)
	  (if (value gevtopitem) is a list
	      (progn (setq geveditvar (value gevtopitem))
		     (eval (list 'editv 'geveditvar))
		     (changedflg = t))
	      (if (value gevtopitem) is atomic and
	           (glclass (value gevtopitem))
		   (progn (eval (list 'editv (list 'symbol-plist (value gevtopitem))))
			  (changedflg = t))
		   (return nil))))
      (if changedflg
	  (progn (glsend *gevwindow* open)
		 (gevrefillwindow)))
      (*geveditflg* = changedflg)))


; edited: 26-JUL-83; 26 Feb 02; 05 Jan 04; 19 Jan 04
; Execute a property whose name is PROPNAME and whose property type 
;   (ADJ, ISA, PROP, MSG) is PROPTYPE on the object OBJ whose type is 
;   STR. 
(gldefun gevexprop (obj str (propname atom) (proptype atom) args)
  (prog (fn tmp)
      (if ~ (member proptype '(adj isa prop msg))
	  or
	  (args and proptype != 'msg)
	  (return 'geverror))
      (if (fn = (gevcompprop str propname proptype))
	  == 'geverror
	  (return fn)
	  (if fn == nil
	      (if str is atomic
		  and (tmp = (get (caar (get str 'glstructure))
					    'gevinterface))
		  (return (funcall (cadr tmp)
			       obj str propname proptype args))
		  (return 'geverror))
	      (return (glapply fn (cons obj args)))))))


; 25-JUL-83; 24 Dec 94; 25 Mar 05
; Fill the GEV editor window with the item which is at the top of 
;   *GEVEDITCHAIN*. 
(gldefun gevfillwindow nil
  (let (top)
     (clear *gevwindow*)
     
; compute an initial y value for printing titles in the window. 

     (*gevglobaly* = (height *gevwindow*) - gevwindowtopmargin)
     
; print the titles from the edit chain first. 

     (*gevlastitemnumber* = 0)
     (top = (topframe *geveditchain*))
     (for x in (reverse (prevs top)) do
	  (gevpps x 0 *gevwindow*))
     (gevhorizline *gevwindow*)
     (for x in (subitems top) do (gevpps x 0 *gevwindow*))
     (gevhorizline *gevwindow*)
     (for x in (props top) do (gevpps x 0 *gevwindow*))
     (*gevwindowy* = *gevglobaly*)))


; 29-APR-83; 07 Feb 92; 26 Feb 02
; Filter types according to a specified FILTER. 
(gldefun gevfilter (type filter)
  (let (xtype)
    (xtype = (gevxtrtype type))
    (case filter of
      ((number integer real)
        (not (or (member xtype '(boolean anything))
		 (and (consp xtype)
		      ((car xtype) == 'listof))
		 (and (consp type)
		      ((car type) == '^)))))
      (list (consp xtype) and (car xtype) == 'listof)
      (^    (glpointerp type))
      else t) ))


; edited: 14-OCT-82; 26 Feb 02; 05 Jan 04
(gldefun gevfinditempos ((pos vector) (item gseitem) (n integer))
(result mousestate)
; Test whether ITEM contains the mouse position POS. The result is NIL 
;   if not found, else a list of the sub-item and a flag which is NIL 
;   if the NAME part is identified, T if the VALUE part is identified. 
(or (gevpostest pos (namepos item) (name item) item nil n)
    (gevpostest pos (valuepos item) (shortvalue item) item t n)
    (((nodetype item) == 'structure or (nodetype item) == 'subtree or 
			       (nodetype item) == 'listof)
     and
     (gevfindlistpos pos (subvalues item) n))))

; 26 Feb 02; 05 Jan 04; 19 Jan 04
; Try to find the type of an item if its declared type is unknown. 
(gldefun gevfinditemtype ((item gseitem))
  (let (val)
     (if (type item) == nil or (type item) == 'anything
	 (progn
	   (val = (value item))
	   ((type item) = (if val is real
			     'real
			     (if val is integer
				 'integer
				 (if val is a string
				     'string
				     (or (gevuserstr val)
					 (if val is atomic
					     'atom
					     (type item)))))))))))


; edited: 13-OCT-82; 05 Jan 04; 19 Jan 04
(gldefun gevfindlistpos ((pos vector) (items  (listof gseitem)) n)
(result mousestate)
; Find some ITEM corresponding to the mouse position POS. 
(if items
    (or (gevfinditempos pos (car items) n)
	(gevfindlistpos pos (cdr items) n))))


; 13-OCT-82; 03 Aug 93; 05 Jan 04
(gldefun gevfindpos ((pos vector) (frame editframe))
(result mousestate)
; Find the sub-item of FRAME corresponding to the mouse position POS. 
;   The result is NIL if not found, else a list of the sub-item and a 
;   flag which is NIL if the NAME part is identified, T if the VALUE 
;   part is identified. 
  (let (tmp n (items (listof gseitem)))
    (n = 0)
    (while frame and ~tmp do
	   (n _+ 1)
	   (items -_ frame)
	   (tmp = (gevfindlistpos pos items n)))
    tmp))


; edited: 22-DEC-82; 05 Jan 04; 19 Jan 04
; Get all names of properties and stored data from a GLISP object 
;   type. 
(gldefun gevgetnames ((obj gltype) (filter atom))
  (result (listof glnametype))
(let (datanames propnames)
  (if obj is atomic
      (progn
	(setq datanames (gevdatanames obj filter))
	(setq propnames (gevpropnames obj 'prop filter))
	(nconc datanames propnames)))))


; edited:  9-Dec-83; 05 Jan 04; 09 Jan 08
; Retrieve a GLISP property whose name is PROPNAME and whose property 
;   type (ADJ, ISA, PROP, MSG) is PROPTYPE for the object type STR. 
(gldefun gevgetprop (str (propname atom) (proptype atom))
(let (pl subpl propent)
     (if ~ (member proptype '(adj isa prop msg))
	 (error "gevgetprop"))
     (and (atom str)
	  (pl = (get str 'glstructure))
	  (subpl = (getf (cdr pl)
			proptype))
	  (propent = (assoc propname subpl)))))


; edited: 17 July 89
(defun gevglispp nil (boundp '*glbasictypes*))


; 6-APR-83; 24 Dec 94; 27 Dec 94; 05 Apr 99; 05 Jan 04
(gldefun gevhorizline ((w window))
; Draw a horizontal line across window W at Y and decrease Y.
  (if (*gevglobaly* > windowlineyspacing)
      (glsend w drawline
	      (a vector with x = (leftmargin w)
		             y = *gevglobaly* + windowlineyspacing / 2)
	      (a vector with x = (rightmargin w)
	                     y = *gevglobaly* + windowlineyspacing / 2))
      (*gevglobaly* _- windowlineyspacing) ) )


; edited: 17 July 89
(defun gevinit nil
  (setq *glnatom* 0)
  (unless (boundp '*gllispdialect*)
	  (setq *gllispdialect* 'commonlisp))
  (setq *gevwindow* nil))

; edited: 25-JUL-83 17:32 
; Simple interface to GEV for an objects package. 
; STROP is a structuring operator used to form a GLISP object 
;   description. For example, FRAME. 
; GETFN, with args <object>, <structure>, <slotname>, is a function to 
;   get slot values from an object. 
; PROPFN, with args <object>, <structure>, <propname>, <proptype>, 
;   <arglist>, is a function to compute properties of an object. 
;   <proptype> is one of PROP, ADJ, ISA, MSG. 
; CLASSFN is a safe function that takes an object and returns its 
;   class name or NIL. 
(defun gevinterface (strop getfn propfn classfn)
  (unless (member strop *gevusertypenames*)
	  (setq *gevusertypenames* (cons strop *gevusertypenames*)))
  (setf (get strop 'gevinterface) (list getfn propfn classfn)))


; 9-Dec-83; 03 Aug 93; 24 Dec 94; 26 Feb 02; 05 Jan 04; 19 Jan 04; 03 Mar 04
; Respond to an event that selects an item. GROUP gives the group in 
;   which the item occurs. 1 = edit path. FLAG is T if the type of the 
;   item is selected, NIL if the value is selected. 
(gldefun gevitemeventfn ((item gseitem) (group integer) (flag boolean))
  (let (tmp top n)
    (if flag
	(if group == 1
	    (progn (tmp = (prevs (topframe *geveditchain*)))
	         (n = 0)
		 (while tmp and (top -_ tmp) <> item do n_+1)
		 (gevpop nil n))
	    (progn (gevfinditemtype item)
		   (gevpush item)))
      (progn (gevfinditemtype item)
           (geventerprint)
	   (prin1 (name item))
	   (princ " is ")
	   (prin1 (type item))
	   (terpri)
	   (gevexitprint)))))


; 26-JUL-83; 03 Mar 04
; Bound the length of VAL to NCHARS. 
(gldefun gevlengthbound (val nchars)
  (setq val (gevstringify val))
  (if (> (length val) nchars)
      (concat (subseq val 0 (nchars - 1)) "-")
      val))


; 6-APR-83; 07 May 91; 03 Aug 93; 05 Jan 04; 03 Mar 04; 25 Mar 05; 09 Jan 08
; Make a function to perform OPERATION on set SETNAME from INPUTTYPE 
; following PATH to get to the data. 
(gldefun gevmakenewfn ((operation atom) (inputtype atom)
		       (set glnametype) (path (listof glnametype)))
  (prog (lastpath (viewspec anything))
    (setq lastpath (car (last path)))
    (return
      (list
        (list 'glambda
	  (list (list 'gevnewfntop inputtype))
	  (list 'prog
	    (cons 'gevnewfnvalue
		  (case operation
		    (collect '(gevnewfnresult))
		    ((maximum minimum)
		     '(gevnewfntestval gevnewfninstance))
		    (total '((gevnewfnsum 0)))
		    (average '((gevnewfnsum 0.0) (gevnewfncount 0)))
		    else (error "gevmakenewfn")))
	    (nconc (list 'for 'gevnewfnloopvar 'in
			 (list (name set) 'gevnewfntop)
			 'do
			 (list 'gevnewfnvalue '=
			       (progn (viewspec = 'gevnewfnloopvar)
				      (for x in path do
					   (viewspec =
						     (list (name x)
							   viewspec)))
  ; was  (viewspec +_ 'of) (viewspec +_ (name x)) (viewspec +_ 'the)
				      viewspec)))
		   (copy-tree (case operation
				(collect '((gevnewfnresult +_ 
						  gevnewfnvalue)))
				(maximum
				 '((if ~ gevnewfninstance
				     or (gevnewfnvalue > 
						   gevnewfntestval)
				     (progn (gevnewfntestval =
					              gevnewfnvalue)
					    (gevnewfninstance
					        = gevnewfnloopvar)))))
				(minimum
				 '((if ~ gevnewfninstance
				     or (gevnewfnvalue
					   < gevnewfntestval)
					(progn (gevnewfntestval = 
					             gevnewfnvalue)
					       (gevnewfninstance
					         = gevnewfnloopvar)))))
				(average '((gevnewfnsum _+
						       gevnewfnvalue)
					   (gevnewfncount _+ 1)))
					(total '((gevnewfnsum _+
						       gevnewfnvalue))
						 ))))
	    (list 'return
		  (case operation
		    (collect '(nreverse gevnewfnresult))
		    ((maximum minimum)
		      '(list gevnewfntestval gevnewfninstance))
		    (average '(/ gevnewfnsum (float gevnewfncount)))
		    (total 'gevnewfnsum)))))
	(case operation
	  (collect (list 'listof (cadr lastpath)))
	  ((maximum minimum)
	    (list 'list (copy-tree lastpath)
		  (list 'winner (cadr (type set))) ))
	  (average 'real)
	  (total (cadr lastpath)))))))


; edited:  8-OCT-82 10:43 
; Match a structure description, STR, and a value VAL which matches 
;   that description, to form a structure editor tree structure. 
(gldefun gevmatch (str val flg)
  (result (listof gseitem))
  (let (*gevmatchresult*)
     (gevmatchb str val nil flg)
     (nreverse *gevmatchresult*)))


; 8-OCT-82; 24 Dec 94; 03 Mar 04
; Make a single item which matches structure STR and value VAL. 
(gldefun gevmatcha (str val flg)
  (let (res)
    (res = (gevmatch str val flg))
    (if ~ (cdr res)
	 (car res)
	 (a gseitem with value = val type = str subvalues = res 
		               nodetype = 'subtree))))


; edited:  7-OCT-82; 26 Feb 02; 03 Mar 04
; Match an ATOM structure to a given value. 
(gldefun gevmatchatom (str val name)
(prog (l strb tmp)
      (if val is not atomic or val is null
	  (return nil))
      (strb = (cadr str))
      (if (car strb) != 'proplist
	  (return nil))
      (l = (cdr strb))
      (for x in l do (if (tmp = (get val (car x)))
			 (gevmatchb x tmp nil nil)))))


; 7-OCT-82; 03 Mar 04
; Match an ALIST structure to a given value. 
(gldefun gevmatchalist (str val name)
  (let (l tmp)
    (l = (cdr str))
    (for x in l do
	 (if (tmp = (assoc (car x) val))
	     (gevmatchb x (cdr tmp) nil nil)))))


; 26-JUL-83 17:05 ; 13 Mar 97; 05 Jan 04; 03 Mar 04; 01 Jun 04
; Match a structure description, STR, and a value VAL which matches 
; that description, to form a structure editor tree structure. If 
; FLG is set, the match will descend inside an atomic type name. 
; Results are added to the free variable *GEVMATCHRESULT*. 
(gldefun gevmatchb ((str  (listof anything)) val (name atom) (flg boolean))
  (global *gevmatchresult*)
  (prog (strb xstr top tmp)
	(xstr = (gevxtrtype str))
	(if str is atomic
	    (progn (if flg and (strb = (car (get str 'glstructure)))
		       (*gevmatchresult* +_ (a gseitem with name = name
					value = val 
					subvalues =
					(gevmatch strb val nil)
					type = str
					nodetype = 'structure))
		       (*gevmatchresult* +_ (a gseitem with name = name
					value = val 
					type = str)))
		   (return nil))
	    (case (car str)
	      (cons (gevmatchb (cadr str) (car val) nil nil)
		    (gevmatchb (caddr str)	(cdr val) nil nil))
		   (list (for x in (cdr str) do
			      (if val (gevmatchb x (car val) nil nil)
				(val = (cdr val)))))
		   (atom (gevmatchatom str val name))
		   (alist (gevmatchalist str val name))
		   (proplist (gevmatchproplist str val name))
		   (listof (gevmatchlistof str val name))
		   (record (gevmatchrecord str val name))
		   ((object atomobject listobject)
		    (gevmatchobject str val name))
		   (transparent (gevmatchb (cadr str) val nil t))
		   else (if (get (car str) 'gevinterface)
			    (gevmatchuobj str val name)
			    (if name
				(progn
				   (tmp = (gevmatch str val nil))
				   (top = (car tmp))
				   (*gevmatchresult* +_ 
				      (if ~ (cdr tmp) and ~ (name top)
					 (progn ((name top) = name)
						top)
					 (a gseitem with
						  name = name 
						  value = val
						  subvalues = tmp 
						  type = xstr nodetype =
						  'subtree))))
			        (if
				   (strb = (gevxtrtype (cadr str)))
				   is atomic
				   (gevmatchb strb val (car str) nil)
				   (if (tmp = (gevmatch (cadr str)
						   val nil))
				    (progn
				     (top = (car tmp))
				     (*gevmatchresult* +_ 
					   (if ~ (cdr tmp)
					       and ~ (name top)
					       (progn
					         ((name top) = (car str))
						 top)
					       (a gseitem with name =
						  (car str)
						  value = val
						  subvalues = tmp 
						  type = (cadr str)
						  nodetype = 'subtree))))
				    (progn (prin1 "GEVMATCHB Failed")
					(terpri))))))))))

			    


; 8-OCT-82
; Match a LISTOF structure. 
(gldefun gevmatchlistof (str val name)
  (global *gevmatchresult*)
  (let ()           ; prevents next item from looking like result declaration
  (*gevmatchresult* +_ (a gseitem with name = name value = val
			  type = str))))


; 26-JUL-83; 03 Mar 04
; Match the OBJECT structures. 
(gldefun gevmatchobject (str val name)
  (global *gevmatchresult*)
  (let ((objecttype (car str)) tmp n)
    (*gevmatchresult* _+ (a gseitem with name = 'class
			    value = (case objecttype
				      (object (tmp -_ val))
				      (listobject (tmp -_ val))
				      (atomobject (get val 'class)))
			    type = 'gltype))
    (n = 0)
    (for x in (cdr str) do
	 (n _+ 1)
	 (case objecttype
	   (object (if val (gevmatchb x (tmp -_ val) nil nil)))
	   (listobject (if val (gevmatchb x (tmp -_ val) nil nil)))
	   (atomobject (if tmp = (get val (car x))
			   (gevmatchb x tmp nil nil)))))))


; 24-NOV-82; 03 Mar 04
; Match an PROPLIST structure to a given value. 
(gldefun gevmatchproplist (str val name)
  (let (l tmp)
    (l = (cdr str))
    (for x in l do
	 (if (tmp = (getf val (car x)))
	     (gevmatchb x tmp nil nil)))))


; 11-MAR-83; 09 Jan 08
; Match a RECORD structure. 
(gldefun gevmatchrecord (str val name)
  (let (strname fields n)
    (if (cadr str) is atomic
	(progn (strname = (cadr str))
	       (fields = (cddr str)))
        (fields = (cdr str)))
    (n = 0)
    (for x in fields do
	 (n_+1)
	  (gevmatchb x (error "gevmatchrecord") ; = code to get the field from record
		     (car x)
		     nil))))


; edited: 26-JUL-83; 05 Jan 04
; Match an object in a user representation language. 
(gldefun gevmatchuobj ((str (cons atom (listof anything)))
			    val name)
(for x in (cdr str)
     do
     (gevmatchb x (funcall (car (get (car str)
				     'gevinterface))
			   val str (car x))
		nil nil)))

; 27 Dec 94
; dummy function to avoid error msg
(defun gevnewfn (x) nil)

; 25 July 89; 24 Dec 94; 26 Feb 02; 05 Jan 04; 03 Mar 04
; Pop up from the current item to the previous one. If FLG is set, 
;   popping continues through extended LISTOF elements. 
(gldefun gevpop ((flg boolean) (n integer))
  (prog (tmp (top gseitem) tmpitem)
    (if n < 1 (return nil))
 lp
    (tmp -_ *geveditchain*)
    (if ~ *geveditchain* (return (gevquit)))
    (top = (caaar *geveditchain*))
      
; test for repeated listof elements. 

    (tmpitem = (car (prevs tmp)))
    (if flg and (nodetype tmpitem) == 'forward (go lp))
      (if (n _- 1) > 0 (go lp))
      (if (type top) is a list and (car (type top))
	  == 'listof and ~ (cdr (value top))
	  (go lp))
      (if *geveditflg* and ~ (member (shortvalue tmpitem)
				     '("(...)" "---")
				   :test #'equal)
	  (gevrefillwindow)
	  (progn (*geveditflg* = nil)
		 (gevfillwindow)))))


; 11-MAR-83; 05 Jan 04; 03 Mar 04
; Test whether TPOS contains the mouse position POS. The result is NIL 
;   if not found, else a list of the sub-item and a flag which is NIL 
;   if the NAME part is identified, T if the VALUE part is identified. 
(gldefun gevpostest ((pos vector) (tpos vector) (name string)
				 (item gseitem) flg 
				(n integer))
  (result mousestate)
  (if (y pos) >= (y tpos) and (y pos) <= (y tpos) + windowlineyspacing
    and (x pos) >= (x tpos) and 
    (x pos) < (x tpos) + gevnamechars * windowcharwidth
    (a mousestate with area =
       (a region with start =
	  (a vector with x = (x tpos) y = (y tpos) - 1)
	  size = (a vector with
		    x = (windowcharwidth *
			       (length (gevstringify name)))
		    y = windowlineyspacing))
       item = item flag = flg group = n)))


; 17-APR-83; 13 Dec 90; 05 Aug 93; 24 Dec 94; 27 Dec 94; 05 Apr 99; 26 Feb 02
; 05 Jan 04; 03 Mar 04; 29 May 04; 01 Jun 04; 25 Mar 05
; Pretty-print a structure defined by ITEM in the window WINDOW, 
; beginning at horizontal column COL and vertical position Y. The 
; positions in ITEM are modified to match the positions in the 
; window. 
(gldefun gevpps ((item gseitem) (col integer) (window window))
  (prog (namex)
; make sure there is room in window. 
    (if (*gevglobaly* < windowlineyspacing) (return nil))
    (gevfinditemtype item)
    (if (> gevnumberchars 0)
	(progn (*gevlastitemnumber* _+ 1)
	       (glsend window printat-xy (gevstringify *gevlastitemnumber*)
		     gevnumberpos  *gevglobaly*)))
; position in window for slot name. 
    (namex = gevnamepos + col * windowcharwidth)
    ((x (namepos item)) = namex)
    ((y (namepos item)) = *gevglobaly*)
    (if (nodetype item) == 'fullvalue
	(progn (glsend window printat-xy "(expanded)" namex *gevglobaly*)
	       (*gevglobaly* = *gevglobaly* - windowlineyspacing))  ; 13 Dec 90
	(if (name item)
	    (progn (if (name item) is numeric
		       (progn (glsend window printat-xy "#" namex *gevglobaly*)
			      (namex _+ windowcharwidth)))
		   (glsend window printat-xy (gevlengthbound (name item)
							     gevnamechars)
			   namex *gevglobaly*))))
; see if there is a value to print for this name. 
    (if ~ (nodetype item) or (member (nodetype item)
				   '(forward backup prop adj msg isa))
      (progn ((x (valuepos item)) = gevvaluepos)
	     ((y (valuepos item)) = *gevglobaly*)
	     (glsend window printat-xy ((shortvalue item) or
					 ((shortvalue item) = 
					  (gevshortvalue (value item) 
							 (type item)
							 (*gevshortchars* - col))))
		     gevvaluepos *gevglobaly*)
	     (if ~ (string= (shortvalue item)
			    (gevstringify (value item)))
	         (glsend window printat-xy "~" gevtildepos *gevglobaly*))
	     (*gevglobaly* _- windowlineyspacing))
      (if ((nodetype item) == 'fullvalue)
	  (progn (glsend window prettyprintat-xy (value item)
			 windowcharwidth *gevglobaly*)
	; **** old *** (*gevglobaly* = (yposition window) - windowlineyspacing)
		 (*gevglobaly* = *gevglobaly* - 2 * windowlineyspacing))  ; 05 Aug 93
	  (if (nodetype item) == 'display
	      (gevexprop (value item) (type item) 'gevdisplay 'msg
			 (list window *gevglobaly*))
	      (progn       ; this is a subtree 
		(*gevglobaly* _- windowlineyspacing)
		(for vsub in (subvalues item) do
		     (gevpps vsub col+2 window)))))) ))


; 9-Dec-83; 03 Aug 93; 13 Mar 97; 26 Feb 02; 03 Mar 04
; Write an interactive program involving the current item. 
(gldefun gevprogram ()
  (prog (topitem command set path done (next anything) nxt z
		 type newfn result last abortflg)
    (topitem = (topitem *geveditchain*))
    (if (command = (glsend (a menu with items
			      '(quit collect total average maximum minimum))
			     select))
	  == 'quit or ~ command
	  (return nil))
    (if (set = (gevpropmenu (type topitem) 'list nil))
	  == 'quit or set == 'pop or ~ set
	  (return nil))
    (path = (list set (list (name topitem) (type topitem))))
    (next = set)
    (type = (cadadr set))
    (while ~ done and ~ abortflg do
      (next = (gevpropmenu type (command != 'collect and 'number)
			     command == 'collect))
      (if next is atomic
	  (case next
	    ((nil) (if command == 'collect
		       (done = t)
		       (abortflg = t)))
	    (quit (abortflg = t))
	    (pop (if ~ (cddr path)
		     (abortflg = t)
				 (progn (z -_ path)
				      (nxt = (car path))
				      (type = (cadr nxt))
				      (if type is a list
					  (type = (cadr type)))
				      (last = (car nxt)))))
	    (done (done = t)))
	  (progn (path +_ next)
		 (type = (cadr next))
		 (last = (car next))))
      (if ~type or (command <> 'collect
			    and (member type '(integer real number)))
	  (done = t)))
    (if abortflg (return nil))
    (path = (nreverse path))
    (newfn = (gevmakenewfn command (type topitem) set (cddr path)))
    (gevputd 'gevnewfn (car newfn))
    (glcc 'gevnewfn)
    (result = (gevnewfn (value topitem)))

; print result as well as displaying it. 

    (geventerprint)
    (prin1 command)
    (spaces 1)
    (for x in (cddr path) do (prin1 (car x)) (spaces 1))
    (princ "of ")
    (prin1 (caar path))
    (spaces 1)
    (prin1 (caadr path))
    (princ " = ")
    (prin1 result)
    (terpri)
    (gevexitprint)
    ((props (topframe *geveditchain*))
      _+ (a gseitem with name = (concat (gevstringify command)
					(concat " " (gevstringify last)))
	                 type = (cadr newfn)
			 value = result
			 nodetype = 'msg))
    (gevdisplaynewprop)))


; 17-APR-83; 05 Jan 04; 03 Mar 04
; Make a menu to get properties of object OBJ with filter FILTER. FLG 
;   is T if it is okay to stop before reaching a basic type. 
(gldefun gevpropmenu ((obj gltype) (filter atom) (flg boolean))
  (prog (props sel pnames)
    (props = (gevgetnames obj filter))
      (if ~ props
	  (return nil)
	  (progn (pnames = (mapcar (function car) props))
		 (sel = (glsend (a menu with items =
				   (cons 'quit
					 (cons 'pop
					       (if flg
						   (cons 'done pnames)
						 pnames))))
				select))
		 (return (case sel
			   ((quit pop done nil) sel)
			   else (assoc sel props)))))))


; 4-FEB-83; 17 Mar 94; 04 May 95; 05 Jan 04; 03 Mar 04; 09 Jan 08
; Get all property names and types of properties of type PROPTYPE for 
; OBJ when they satisfy FILTER. 
(gldefun gevpropnames ((obj gltype) (proptype symbol) (filter symbol))
  (result (listof glnametype))
  (let (result type)
    (if (symbolp obj)
	(progn
	  (result = (for p in (case proptype of
				(prop (props obj))
				(adj (adjs obj))
				(isa (isas obj))
				(msg (msgs obj)))
			 when (and (type = (gevproptypes obj proptype
                                                         (name p)  ))
				   (gevfilter type filter))
		         collect (list (name p) type)))
	  (for s in (supers obj) do
	     (result = (nconc result (gevpropnames s proptype filter))))
	  result) )))


; 4-FEB-83; 12 Jan 96; 05 Jan 04; 03 Mar 04; 29 Nov 07; 09 Jan 08; 27 Mar 08
; Find the type of a computed property. 
(gldefun gevproptype ((str symbol) (proptype symbol) (propname symbol))
  (let (pl subpl propent tmp)
    (if (symbolp str)
	(progn (propent = (gevgetprop str propname proptype))
	     (or (and (consp propent)
		      (getf (cddr propent) 'result))
		 (and (consp propent)
		      (symbolp (cadr propent))
		      (glresulttype (cadr propent) nil))
                 (and (consp propent)
                      (consp (cadr propent))
                      (consp (caadr propent))
                      (eq (caaadr propent) 'virtual)
                      (cadr (caadr propent)))
		 (and (pl = (get str 'glpropfns))
		      (subpl = (assoc proptype pl))
		      (propent = (assoc propname (cdr subpl)))
		      (glextractvirttype (caddr propent)))
		 (and (glcompprop str propname proptype nil)
		      (pl = (get str 'glpropfns))
		      (subpl = (assoc proptype pl))
		      (propent = (assoc propname (cdr subpl)))
		      (glextractvirttype (caddr propent)))
		 (and (eq proptype 'adj)
		      'boolean) ) ) )))


; edited:  4-NOV-82 15:39 ; 09 Jan 08
(defun gevproptypes (obj proptype name)
  (or (gevproptype obj proptype name)
      (and (gevcompprop obj name proptype)
	   (gevproptype obj proptype name))))


; 2-Oct-86; 24 Dec 94; 26 Feb 02; 05 Jan 04; 03 Mar 04
; Push down to look at an item referenced from the current item. 
(gldefun gevpush ((item gseitem))
  (prog (newitems topitem (lstitem gseitem) actualtype)
      (if (nodetype item) == 'backup
	  (progn (gevpop nil 1)
		 (return)))
      (topitem = (topitem *geveditchain*))
      (actualtype = (gevtype nil (value item)))
      (if (nodetype item) == 'forward
	  (newitems = (gevpushlistof item t))
	  (if (type item) is atomic and
	      (member (type item) '(atom number real integer
					   string anything))
	      and ~ actualtype
	      (newitems = (list (a gseitem with name = (name item)
				  value = (value item) 
				  shortvalue = (shortvalue item)
				  type = (type item) 
				  nodetype = 'fullvalue)))
	      (if (type item) is atomic and
		  ~ (get (type item) 'glstructure)
		  and ~ actualtype
		  (return nil)
		  (if (type item) is a list and
		      (car (type item)) == 'listof
		      (newitems = (gevpushlistof item nil))))))
      (*geveditchain* +_ (an editframe with
			  prevs = (cons item (prevs (topframe *geveditchain*)))
			  subitems = newitems))
      (gevrefillwindow)
      
; do another push automatically for a list of only one item. 

      (if (type item) is a list and (car (type item)) == 'listof
	  and (value item) is a list and ~ (cdr (value item))
	  (progn (lstitem = (caadar *geveditchain*))
		 (gevpush (car (subvalues lstitem)))
		 (return nil)))))


; 30-APR-83; 04 Aug 93; 24 Dec 94; 26 Feb 02; 05 Jan 04; 03 Mar 04
; Push into a datum of type LISTOF, expanding it into the individual 
;   elements. If FLG is set, ITEM is a FORWARD item to be continued. 
(gldefun gevpushlistof ((item gseitem) (flg boolean))
  (prog (itemtype listtype topframe (n integer) nroom lst
		(vals (listof anything)) tmp)
      
; compute the vertical room available in the window. 

    (if ~ (value item) and (nodetype item) <> 'forward
	(return nil))
    (topframe = (topframe *geveditchain*))
    (listtype = (type item))
    (itemtype = (cadr listtype))
    (nroom = (height *gevwindow*) / windowlineyspacing - 4
	         - (length (prevs topframe)))
      
; if there was a previous display of this list, insert an ellipsis 
;   header. 

    (if flg
	(progn
	  (lst +_ (a gseitem with shortvalue = "(..."
		    type = listtype nodetype = 'backup))
	  (n = (name item))
	  (nroom _- 1)
	  (vals = (subvalues item)))
      (progn
        (n = 1)
	(vals = (value item))))
      
; now make entries for each value on the list. 

    (while vals and (nroom > 1 or (nroom == 1 and ~ (cdr vals))) do
      (lst +_ (a gseitem with value = (tmp -_ vals)
		       type = itemtype name = n))
      (nroom _- 1)
      (n _+ 1))
    (if vals
	(lst +_ (a gseitem with shortvalue = "...)"
			      nodetype = 'forward
			      type = listtype name = n
			      subvalues = vals)))
    (return (list (a gseitem with name = "expanded"
		       type = listtype nodetype = 'listof
		       subvalues = (nreverse lst))))))


; 14-MAR-83; 03 Mar 04
(gldefun gevquit nil
  (setq *gevactiveflg* nil)
  (glsend *gevwindow* close)
  (if *gevmenuwindow* (glsend *gevmenuwindow* close)))


; 19-OCT-82; 08 Jun 94; 26 Feb 02; 05 Jan 04; 03 Mar 04
; Recompute property values for the item. 
(gldefun gevredoprops ((top editframe))
  (let (item l)
    (item = (car (prevs top)))
    (if ~ (props top) and
	(l = (gevexprop (value item) (type item) 'displayprops 'prop nil))
           != 'geverror
        (if l is atomic
	    (gevcommandprop item 'prop 'all)
	    (if l is a list
	        (for x in l (gevcommandprop item 'prop x))))
	(for x in (props top) when ((nodetype x) != 'msg) do
		 ((value x) = (gevexprop (value item) (type item)
					  (name x) (nodetype x) nil) )
		 ((shortvalue x) = nil)))))


; 2-Oct-86; 26 Feb 02; 03 Mar 04
; Re-expand the top item of *GEVEDITCHAIN*, which may have been changed 
;   due to editing. 
(gldefun gevrefillwindow nil
  (let (top topitem subs topsub)
     (top = (topframe *geveditchain*))
     (topitem = (topitem *geveditchain*))
     (if (subitems top)
	 (topsub = (car (subitems top))))
     (if ~ topsub or ((nodetype topsub) != 'fullvalue and
				       (nodetype topsub) != 'listof)
	 (if (gevgetprop (type topitem) 'gevdisplay 'msg)
	     ((subitems top) = (list (a gseitem with
				      value = (value topitem)
				      type = (type topitem)
				      nodetype = 'display)))
	    (progn
	     (subs = (gevmatch (gevtype (type topitem) (value topitem))
			      (value topitem) t))
	     (topsub = (car subs))
	     ((subitems top) = (if ~ (cdr subs)
				and (nodetype topsub) == 'structure and 
				(value topsub) == (value topitem) and 
				(type topsub) == (type topitem)
				(subvalues topsub) 
				subs)))))
     (gevredoprops top)
     (gevfillwindow)))


; edited:  6-APR-83 16:05 ; 05 Apr 99
(defun gevshortatomval (atm nchars)
  (if (symbolp atm)
    (if (> (length (symbol-name atm)) nchars)
	(concat (subseq (symbol-name atm) 0 (1- nchars)) "-")
        (gevstringify atm))
    (gevshortstringval (gevstringify atm) nchars) ) )


; 4-APR-83; 05 Jan 04; 03 Mar 04
; Compute a short value for printing a CONS of two items. 
(gldefun gevshortconsval (val str (nchars integer))
  (let (nleft res tmp nc)
     (res +_ "(")
     (nleft = nchars - 5)
     (tmp = (gevshortvalue (car val) (cadr str) (nleft - 3)))
     (nc = (length (symbol-name tmp)))
     (if nc > nleft - 3
	 (progn (tmp = "---") (nc = 3)))
     (res +_ (gevstringify tmp))
     (res +_ " . ")
     (nleft _- nc)
     (tmp = (gevshortvalue (cdr val) (caddr str) nleft))
     (nc = (length (symbol-name tmp)))
     (if nc>nleft (progn (tmp = "---") (nc = 3)))
     (res +_ (gevstringify tmp))
     (res +_ ")")
     (gevconcat (nreverse res))))


; 11-AUG-83; 01 Nov 91; 26 Feb 02; 05 Jan 04; 03 Mar 04
; Compute a short value for printing a list of items. 
(gldefun gevshortlistval (val str (nchars integer))
  (let (nleft res tmp quit nc nci rest rstr)
    (res +_ "(")
    (rest = 4)
    (nleft = nchars - 2)
    (rstr = (cdr str))
    (while val and (consp val) and ~quit
	       and ((nci = (if (cdr val) (nleft - rest) nleft)) > 2)
       do (tmp = (gevshortvalue (car val)
			       (if (car str) == 'listof
				   (cadr str)
				   (if (car str) == 'list
				       (car rstr)))
			       nci))
          (quit = (member tmp '(geverror "(...)" "---" "???")
			  :test #'equal))
	  (nc = (length (gevstringify tmp)))
	  (if nc > nci and (cdr res)
	      (quit = t)
	    (progn (if nc > nci
		     (progn (tmp = "---")
		          (nc = 3) (quit = t)))
	         (res +_ (gevstringify tmp))
		 (nleft _- nc)
		 (val = (cdr val))
		 (if (car str) ==  'list (rstr = (cdr rstr)))
		 (if val
		     (progn (res +_ " ")
			    (nleft _- 1))))))
    (if val (res +_ "..."))
    (res +_ ")")
    (gevconcat (nreverse res)) ))


; edited: 12-OCT-82 12:14 
; Compute the short value of a string VAL. The result is a string 
;   which can be printed within NCHARS. 
(defun gevshortstringval (val nchars)
  (if (stringp val)
      (gevlengthbound val nchars)
      "???"))


; edited: 11-MAR-83 15:34 
; Compute the short value of a given value VAL whose type is STR. The 
;   result is an atom, string, or list structure which can be printed 
;   within NCHARS. 
(defun gevshortvalue (val str nchars)
  (let (tmp)
     (setq str (gevxtrtype str))
     (cond ((and (atom str)
		 (member str '(atom integer real)))
	    (gevshortatomval val nchars))
	   ((eq str 'string)
	    (gevshortstringval val nchars))
	   ((and (atom str)
		 (setq tmp (gevexprop val str 'shortvalue
				      'prop
				      nil))
		 (not (eq tmp 'geverror)))
	    (gevlengthbound tmp nchars))
	   ((or (atom val)
		(numberp val))
	    (gevshortatomval val nchars))
	   ((stringp val)
	    (gevshortstringval val nchars))
	   ((consp str)
	    (case (car str)
		  ((listof list)
		   (if (consp val)
		       (gevshortlistval val str nchars)
		       "???"))
		  (cons (if (consp val)
			    (gevshortconsval val str nchars)
			    "???"))
		  (t "---")))
	   ((consp val)
	    (gevshortlistval val '(listof anything)
			     nchars))
	   (t "---"))))


; edited:  2-Oct-86 10:55 
; Find the type of an item whose stated type is TYPE and whose value 
;   is VALUE. 
(defun gevtype (type value)
  (or (glclass value)
      type))

; 26-JUL-83; 27 Dec 94
; Determine the type of a user object if possible. 
(defun gevuserstr (obj)
  (some #'(lambda (x) (funcall (caddr (get x 'gevinterface)) obj))
	*gevusertypenames*) )

; 21-OCT-82; 24 Dec 94
; Extract an atomic type name from a type spec which may be either 
;   <type> or (A <type>) . 
(defun gevxtrtype (type)
  (cond ((atom type) type)
	((not (consp type)) nil)
	((and (member (car type) '(a an transparent))
	      (cdr type)
	      (atom (cadr type)))
	  (cadr type))
	((member (car type) *gltypenames*)
          type)
	((and (boundp *gluserstrnames*)
	      (assoc (car type) *gluserstrnames*))
	  type)
	((and (atom (car type))
	      (cdr type))
	  (gevxtrtype (cadr type)))
	(t (error " ~S is an illegal type specification. ~S " type 'gevxtrtype)
	   nil)))

(setq *gevusertypenames* nil)
