; gevaux.lsp            Gordon S. Novak Jr.               ; 01 Jun 04

; Copyright (c) 2002 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 09 Oct 91; 13 Jul 93; 03 May 94; 23 Dec 94; 24 Dec 94; 27 Dec 94; 05 Jan 95
; 20 Feb 95; 17 Mar 95; 05 Mar 02
; derived from {DSK}<LISPFILES>GEVAUX.CL;1  1-Mar-89 13:14:44 

; Auxiliary functions for GEV
; xgcl version

(proclaim '(special *gevmousearea* *gevwindow* *gevactiveflg* *gevmenu*
		    *gevmenuwindow* *geveditchain*))

(setq *gevmenuwindow* nil)
(setq *gevwindow* nil)
(defvar windowcharwidth 9)
(defvar gevnamepos 3)

(glispconstants
  (gevnumberchars      0 integer)
  (gevnumberpos        3 integer)
  (gevwindowtopmargin 12 integer) )

(glispglobals
  (*gevwindow* window) )

; edited: 25-MAR-83
; Apply a function or LAMBDA form. In some Lisps, it may be necessary 
;   to GLISP-compile the function first. 
(defun gevapply (fn args)  (apply fn args))


; edited: 18 July 89; 26 Sep 90; 19 Aug 91; 27 Dec 94; 01 Jun 04
; Respond to a button event within the editing window. 
(gldefun gevbuttoneventfn ((w window) mouseevent mousex mousey)
  (prog (pos selection)
      (if (mousex < 12 and mousey < ((height w) - 12))
	  (return (dowindowcom w)))
      (pos = (a vector with x = mousex y = mousey))
      (if selection = (gevfindpos pos (topframe *geveditchain*))
	  (gevitemeventfn (item selection) (group selection)
			  (flag selection))) ))

; edited:  4-APR-83
(defun gevconcat (l)
  (reduce #'(lambda (x y) (concatenate 'string x y))  l) )

; edited: 14-MAR-83; 21 Aug 91; 23 Aug 91
(defun geventer () )

; edited: 14-MAR-83; 23 Aug 91; 03 Oct 91
(defun gevexit ()  (window-close *gevwindow*) )

; 15-MAR-83; 09 April 90; 06 Jun 90; 26 Sep 90; 13 Dec 90; 19 Aug 91; 21 Aug 91
; Initialize an edit window for the GLISP structure editor. 
(gldefun geviniteditwindow ()
  (let ((width 350) (height 500) (over 0) (down 0))
     (setq *gevwindow* (window-create width height "GEV" nil over down))
     (setq *gevmousearea* nil)
     (setq *gevmenu*
	   (menu-create '(quit pop edit program prop adj isa msg)
			"GEV" *gevwindow* 270 10))
     *gevwindow*))


; edited: 27-SEP-82; 26 Sep 90; 19 Aug 91; 20 Aug 91
; Wait in a loop for mouse actions within the edit window. 
(defun gevmouseloop ()
  (prog (event mousex mousey point)
lp  (setq point (gev-get-point *gevwindow*))
    (setq event (caddr point))
    (setq mousex (car point))
    (setq mousey (cadr point))
    (if (eq event 3)                 ; right button
        (gevcommandfn (glsend *gevmenu* select))
        (gevbuttoneventfn *gevwindow* event mousex mousey))
    (if *gevactiveflg* (go lp))  ))

; edited: 25-MAR-83
(defun gevputd (fn def)  (setf (gloriginalexpr fn) def) )

(defun geventerprint () nil)
(defun gevexitprint  () nil)

; A quick-and-dirty function to get arg list of a function
(defun gevarglist (fn)
  (let ( (def (source-code fn)) )
    (if (eq (car def) 'lambda)
	(cadr def)
        (progn (glcc fn) (cadr (source-code fn)))) ))

; 19 Aug 91
(defun gev-get-point (w)
  (let (orgx orgy button)
    (window-track-mouse w                  ; get one point
	    #'(lambda (x y code)
		(when (not (zerop code))
	          (setq button code)
		  (setq orgx x)
		  (setq orgy y))))
    (list orgx orgy button) ))

; 20 Aug 91; 09 Oct 91; 13 Jul 93; 03 May 94
(defun compile-gev ()
  (glcompfiles *directory*
	       '("glisp/vector.lsp"       ; auxiliary files
	         "X/dwindow.lsp")
               '("glisp/gevaux.lsp"      ; translated files
	         "glisp/gevtype.lsp"
	         "glisp/gev.lsp")
	       "glisp/gevtrans.lsp")      ; output file
  (cf gevtrans)
 )
