; glfindgoal.lsp             Gordon S. Novak Jr.         ; 22 Jan 08

; 04 Dec 07; 31 Dec 07; 07 Jan 08; 08 Jan 08; 09 Jan 08

; Copyright (c) 2008 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 27 Nov 07; 04 Dec 07
; Find a way to make a goal type given arg types
(defun glfindgoal (goal &optional argtypes)
  (let (res )
    (dolist (source argtypes)
      (if (and (symbolp source)
               (not (glbasictypep source)))
          (setq res (union res
                           (union (glfindpropgoal source goal 'prop)
                                  (glfindpropgoal source goal 'msg)
                                  :test #'equal) :test #'equal) )))
    (dolist (fn (glresultof goal))
      (push (list 'fn fn) res) )
    res
))

; 27 Nov 07; 29 Nov 07; 09 Jan 08
; Find props of source whose result is goal
; Result is a list ((proptype source propname) ...)
(defun glfindpropgoal (source goal proptype)
  (let (props res restp)
    (dolist (prop (getf (cdr (glstr source)) proptype))
      (setq restp (glproptype source proptype (car prop)))
      (if (and restp (gltypematch goal restp))
          (push (list proptype source (car prop)) res)) )
    (dolist (super (glsupers source))
      (setq res (union (glfindpropgoal super goal proptype) res
                       :test #'equal)) )
    res))

; 29 Nov 07; 31 Dec 07; 22 Jan 08
; get argument types of a prop/msg
(defun glpropargtypes (str proptype propname)
  (let (proplst arglist)
    (if (setq proplst (glgetprop str proptype propname))
        (if (and (symbolp (cadr proplst))
                 (fboundp (cadr proplst)))
            (glargumenttypes (cadr proplst))
            (if (and (consp (cadr proplst))
                     (member (caadr proplst) '(lambda glambda)))
                (progn (setq arglist (cadadr proplst))
                       (if (symbolp (car arglist))
                           (cons (list (car arglist) str)
                                 (cdr arglist))
                         arglist))
                (list (list 'self str)) ) ) ) ))


; 29 Nov 07
; get argument name/types of a function
(defun glargumenttypes (fn)
  (let (fndef)
    (or (glarguments fn)
        (and (setq fndef (glgetd fn))
             (mapcar #'(lambda (triple) (list (car triple) (caddr triple)))
                     (glarglist (cadr fndef) nil)))) ))


; 07 Jan 08; 08 Jan 08; 09 Jan 08
; make a function to build a type from parts
(defun glmakebuildfn (type &optional fnname)
  (let (parts)
    (or fnname
        (setq fnname (intern (concatenate 'string "MAKE-"
                                          (symbol-name type)))))
    (setq parts (gldatanames type))
    (setf (symbol-function fnname)
          (list 'lambda
                (mapcar #'car parts)
                (glbuildstr type
                            (mapcar #'(lambda (nametype)
                                        (cons (car nametype) nametype))
                                     parts)
                            nil)))
    (setf (glarguments fnname) parts)
    (setf (glfnresulttype fnname) type)
    (setf (glmakefn type) fnname) ))
