; glmacros.lsp                Gordon S. Novak Jr.            ; 05 Apr 11

; Copyright (c) 2011 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 08 May 96; 18 Mar 98; 29 Dec 98; 30 Dec 98; 04 Feb 99; 20 May 99; 09 Mar 00
; 14 Feb 02; 17 Oct 02; 22 Oct 02; 09 Dec 03; 19 Feb 04; 27 Sep 06; 29 Nov 07
; 06 Dec 07; 08 Jan 08; 01 Dec 10
(defmacro gltypesused         (x) `(get ,x 'gltypesused))
(defmacro gltypesdefined      (x) `(get ,x 'gltypesdefined))
(defmacro globjclass          (x) `(get ,x 'class))
(defmacro glargsnumberp       (x) `(get ,x 'glargsnumberp))
(defmacro glarguments         (x) `(get ,x 'glarguments))
(defmacro glargssame          (x) `(get ,x 'glargssame))
(defmacro glnargs             (x) `(get ,x 'glnargs))
(defmacro glcompiled          (x) `(get ,x 'glcompiled))
(defmacro gldisplays          (x) `(get ,x 'gldisplays))
(defmacro glevalwhenconst     (x) `(get ,x 'glevalwhenconst))
(defmacro glfnresulttype      (x) `(get ,x 'glfnresulttype))
(defmacro glfnsusedin         (x) `(get ,x 'glfnsusedin))
(defmacro glgetplural         (x) `(get ,x 'glgetplural))
(defmacro glglobals           (x) `(get ,x 'glglobals))
(defmacro glinfo              (x) `(get ,x 'glinfo))
(defmacro glinline            (x) `(get ,x 'glinline))
(defmacro glinstancename      (x) `(get ,x 'glinstancename))
(defmacro glinstancefns       (x) `(get ,x 'glinstancefns))
(defmacro glinstanceof        (x) `(get ,x 'glinstanceof))
(defmacro glinverse           (x) `(get ,x 'glinverse))
(defmacro glispatomnumber     (x) `(get ,x 'glispatomnumber))
(defmacro glispconstantflg    (x) `(get ,x 'glispconstantflg))
(defmacro glispconstanttype   (x) `(get ,x 'glispconstanttype))
(defmacro glispconstantval    (x) `(get ,x 'glispconstantval))
(defmacro glispglobalvar      (x) `(get ,x 'glispglobalvar))
(defmacro glispglobalvartype  (x) `(get ,x 'glispglobalvartype))
(defmacro glisporigconstval   (x) `(get ,x 'glisporigconstval))
(defmacro glitemtype          (x) `(get ,x 'glitemtype))
(defmacro glmacro             (x) `(get ,x 'glmacro))
(defmacro glmacrodef          (x) `(get ,x 'glmacrodef))
(defmacro glmacrodefs         (x) `(get ,x 'glmacrodefs))
(defmacro glmacroparts        (x) `(get ,x 'glmacroparts))
(defmacro glmakefn            (x) `(get ,x 'glmakefn))
(defmacro glmodifiedargs      (x) `(get ,x 'glmodifiedargs))
(defmacro glnevernull         (x) `(get ,x 'glnevernull))
(defmacro gloriginalexpr      (x) `(get ,x 'gloriginalexpr))
(defmacro glpatterns          (x) `(get ,x 'glpatterns))
(defmacro glpropfns           (x) `(get ,x 'glpropfns))
(defmacro glpropmenu          (x) `(get ,x 'glpropmenu))
(defmacro glpure              (x) `(get ,x 'glpure))
(defmacro glresulttypefn      (x) `(get ,x 'glresulttypefn))
(defmacro glresultof          (x) `(get ,x 'glresultof))
(defmacro glspecialization    (x) `(get ,x 'glspecialization))
(defmacro glspecializep       (x) `(get ,x 'glspecializep))
(defmacro glstructure         (x) `(get ,x 'glstructure))
(defmacro glcluster           (x) `(get ,x 'glcluster))
(defmacro glclusters          (x) `(get ,x 'glclusters))
(defmacro glclusterinst       (x) `(get ,x 'glclusterinst))
(defmacro glclusterdef        (x) `(get ,x 'glclusterdef))
(defmacro glclusterspec       (x) `(get ,x 'glclusterspec))
(defmacro glsubclusters       (x) `(get ,x 'glsubclusters))
(defmacro glclusterviewspec   (x) `(get ,x 'glclusterviewspec))
(defmacro glclusterviews      (x) `(get ,x 'glclusterviews))
(defmacro glclusterviewsupers (x) `(get ,x 'glclusterviewsupers))
(defmacro glcarrier           (x) `(get ,x 'glcarrier))
(defmacro glcarriers          (x) `(get ,x 'glcarriers))
(defmacro glclustersupers     (x) `(getf (glclusterdef ,x) 'supers) )
(defmacro glclusterroles      (x) `(getf (glclusterdef ,x) 'roles) )
(defmacro gldefaults         (str) `(getf (cdr (glstr ,str)) 'default))
(defmacro glsupers           (str) `(getf (cdr (glstr ,str)) 'supers) )
(defmacro glviews            (str) `(getf (cdr (glstr ,str)) 'views) )
(defmacro glviewspecs        (str) `(getf (cdr (glstr ,str)) 'viewspecs) )
(defmacro glpointer          (str) `(getf (cdr (glstr ,str)) 'pointer))
(defmacro glfnpatterns        (x) `(get ,x 'glfnpatterns))
(defmacro cigroup             (x) `(get ,x 'cigroup))
(defmacro glget         (str parm) `(getf (cdr (glstr ,str)) ,parm))
(defmacro glgetprop (str parm prop)     ; e.g. (glgetprop 'vector 'msg '+)
  `(assoc ,prop (getf (cdr (glstr ,str)) ,parm)))    ; cf. gladdprop

(defmacro glmethod (class selector)
  `(cadr (assoc ,selector (getf (cdr (get ,class 'glstructure)) 'msg))) )

(defmacro quotep (x) `(and (consp ,x) (eq (car ,x) 'quote)))
(defmacro unquote (x) `(and (consp ,x) (eq (car ,x) 'quote) (consp (cdr ,x))
			    (cadr ,x)))
(defmacro while (test &rest forms)
  `(loop (unless ,test (return)) ,@forms) )

(defmacro subset (fn lst)
  (let ((x (gensym)))
    `(mapcan #'(lambda (,x) (if (funcall ,fn ,x) (cons ,x nil))) ,lst)))

(defmacro listify (x) `(if (consp ,x) ,x (if ,x (list ,x))))

(setf (glfnresulttype 'glarguments) '(listof glnametype))

(defmacro vmspec           (x) `(get ,x 'vmspec))

(defmacro op  (x) `(car ,x))
(defmacro lhs (x) `(cadr ,x))
(defmacro rhs (x) `(caddr ,x))
(defmacro eqop (x y) `(and (consp ,x) (eq (car ,x) ,y)))
(defmacro basis-vars (x) `(get ,x 'basis-vars))
(defmacro equations  (x) `(get ,x 'equations))
