; glpat.lsp               Gordon S. Novak Jr.              ; 29 Feb 12

; Copyright (c) 2012 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; Optimization patterns for GLISP

; 16 Feb 95; 23 Apr 96; 31 Oct 96; 05 Nov 96; 02 Jan 97; 14 Mar 97; 21 Oct 97
; 18 Mar 98; 29 May 98; 07 Aug 98; 07 Jan 00; 01 Feb 01; 22 Feb 01; 29 Oct 02
; 24 May 04; 24 May 04; 24 Feb 05; 03 Mar 05; 11 May 05; 29 Jun 06; 13 Sep 06
; 19 Sep 06; 20 Sep 06; 21 Sep 06; 25 Sep 06; 07 Nov 06; 07 Feb 07; 05 Feb 08
; 19 Feb 08; 30 Dec 08; 23 Apr 09; 21 Dec 10; 22 Dec 10; 09 Nov 11; 11 Nov 11

(proclaim '(special glptmatchbindings))

; Note that variable ?ll is tested using logical values in glpattest.

(gldefpatterns 'glpatterns '(

((identity ?x)             ?x)
((car (nthcdr ?a ?b))      (nth ?a ?b))
((if ?x ?y ?x)             (if ?x ?y))     ; okay for Lisp, but for C ???
((if ?x ?y nil)            (if ?x ?y))    ; okay for Lisp, but for C ???
((if ?x ?y ?y)             ?y)
((if ?x (progn . ?z))      (when ?x . ?z))
((if (and ?p t) ?x)        (if ?p ?x))
((if (and ?p t) ?x ?y)     (if ?p ?x ?y))
((if ?p (if ?p ?x))        (if ?p ?x))
((if ?p (if ?p ?x) ?y)     (if ?p ?x ?y))
((if ?p (if ?p ?x ?y))     (if ?p ?x))
((if ?p (if ?p ?x ?y) ?z)  (if ?p ?x ?z))
((if (>= ?x ?y) ?z
     (if (>= ?y ?x) ?w ?u))   (if (>= ?x ?y) ?z ?w))
((if ?p t)                 ?p     (glboolean ?p))
((if t ?p)                 ?p)
((if t ?p ?q)              ?p)
((if *gltrue* ?p)          ?p)
((if *gltrue* ?p ?q)       ?p)
((if nil ?p)               nil)
((if nil ?p ?q)            ?q)
((if *glfalse* ?p)         nil)
((if *glfalse* ?p ?q)      ?q)
((and ?p t)                ?p     (glboolean ?p))
((and ?p ?q t) (and ?p ?q) (glboolean ?q))
((dolist ?x (progn . ?z))  (dolist ?x . ?z))
((dolist ?x ?y nil)        (dolist ?x ?y))
((dolist ?x ?y ?z nil)     (dolist ?x ?y ?z))
((dotimes (?w ?c) (incf ?y ?z))
                           (incf ?y (* ?c ?z))
                           (not (or (gloccurs ?w ?y) (gloccurs ?w ?z))))
((when (and ?p t) . ?x)    (when ?p . ?x))
((unless (null ?x) . ?y)   (when ?x . ?y))
((unless (not ?x) . ?y)    (when ?x . ?y))
((when ?x ?y)              (if ?x ?y))
((when t . ?y)             (progn . ?y))
((when nil . ?y)           nil)
((when *gltrue* . ?y)             (progn . ?y))
((when *glfalse* . ?y)           nil)
((while (not (null ?p)) . ?s)  (while ?p . ?s))
((while ?x (setq ?y (pop ?x)) . ?s)
                           (dolist (?y ?x) . ?s)
                           (not (gloccurs ?x ?s)))
((not (> ?x ?y))           (<= ?x ?y))
((not (<= ?x ?y))          (> ?x ?y))
((not (/= ?x ?y))          (= ?x ?y))
((not (= ?x ?y))           (/= ?x ?y))
((not (< ?x ?y))           (>= ?x ?y))
((not (>= ?x ?y))          (< ?x ?y))
((not *gltrue*)            *glfalse*)
((not *glfalse*)           *gltrue*)
((null *glnull*)           *gltrue*)
((xor ?x nil)              ?x)                 ; useful for sort-direction
((xor nil ?x)              ?x)
((xor t ?x)                (not ?x))
((xor ?x t)                (not ?x))
((+ 0 ?x)                  ?x)
((+ 0 ?x ?y)               (+ ?x ?y))
((+ 0 ?x ?y ?z)            (+ ?x ?y ?z))
((- 0 ?x)                  (- ?x))
((+ 0.0 ?x)                ?x)
((+ 0.0 ?x ?y)             (+ ?x ?y))
((+ 0.0 ?x ?y ?z)          (+ ?x ?y ?z))
((+ 1 ?x)                  (1+ ?x))
((- ?x 1)                  (1- ?x))
((+ -1 ?x)                 (1- ?x))
((1+ (1- ?x))              ?x)
((1- (1+ ?x))              ?x)
((- ?x ?x)                 0)
((- (- ?x)) ?x)
((1+ (+ ?n ?x))            (+ (1+ ?n) ?x)            (numberp ?n))
((1+ (- ?n ?x))            (- (1+ ?n) ?x)            (numberp ?n))
((1+ (- ?x ?n))            (- ?x (1- ?n))            (numberp ?n))
((1- (+ ?n ?x))            (+ (1- ?n) ?x)            (numberp ?n))
((1- (- ?n ?x))            (- (1- ?n) ?x)            (numberp ?n))
((1- (- ?x ?n))            (- ?x (1+ ?n))            (numberp ?n))
((+ ?n (1+ ?x))            (+ (1+ ?n) ?x)            (numberp ?n))
((- ?n (1+ ?x))            (- (1- ?n) ?x)            (numberp ?n))
((- (1+ ?x) ?n)            (- ?x (1- ?n))            (numberp ?n))
((+ ?n (1- ?x))            (+ (1- ?n) ?x)            (numberp ?n))
((- ?n (1- ?x))            (- (1+ ?n) ?x)            (numberp ?n))
((- (1- ?x) ?n)            (- ?x (1+ ?n))            (numberp ?n))
((+ (- ?n ?x) (- ?m ?y))   (- (+ ?n ?m) (+ ?x ?y))
                                             (and (numberp ?n) (numberp ?m)))
((- ?n (- ?m ?x))          (+ (- ?n ?m) ?x)  (and (numberp ?n) (numberp ?m)))
((+ ?n (- ?m ?x))          (- (+ ?n ?m) ?x)  (and (numberp ?n) (numberp ?m)))
((- ?x ?n)                 (+ (- ?n) ?x) (numberp ?n))
((+ (+ ?n ?x) (+ ?m ?y))   (+ (+ ?n ?m) (+ ?x ?y))
                                             (and (numberp ?n) (numberp ?m)))
((- ?n (+ ?m ?x))          (- (- ?n ?m) ?x)  (and (numberp ?n) (numberp ?m)))
((- (- ?x ?y))             (- ?y ?x))
((- (/ (- ?x ?y) ?z))      (/ (- ?y ?x) ?z))
((- (* (- ?x ?y) ?z))      (* (- ?y ?x) ?z))
((- (* (/ (- ?x ?y) ?z) ?w)) (* (/ (- ?y ?x) ?z) ?w))
((- (* ?n ?x))             (* (- ?n) ?x)          (numberp ?n))
((- (/ ?n ?x))             (/ (- ?n) ?x)          (numberp ?n))
((+ (- ?n ?x) ?y)          (+ ?n (- ?y ?x))       (numberp ?n))
((- ?x (- ?n ?y))          (+ (- ?n) (+ ?x ?y))   (numberp ?n))
((- (- ?n ?x) ?y)          (- ?n (+ ?x ?y))       (numberp ?n))
((- (* ?n ?x) (* ?n ?y))   (* ?n (- ?x ?y))       (numberp ?n))
((+ (* ?n ?x) (* ?n ?y))   (* ?n (+ ?x ?y))       (numberp ?n))
((- (* ?x ?y) (* ?x ?z))   (* ?x (- ?y ?z)))
((+ (* ?x ?y) (* ?x ?z))   (* ?x (+ ?y ?z)))
((- (* (* ?x ?y) ?z) (* (* ?x ?u) ?v))    (* ?x (- (* ?y ?z) (* ?u ?v))))
((+ (* (* ?x ?y) ?z) (* (* ?x ?u) ?v))    (* ?x (+ (* ?y ?z) (* ?u ?v))))
((+ (- ?x) ?y) (- ?y ?x))  ((+ ?x (- ?y)) (- ?x ?y))
((- (+ ?x ?y) ?x)          ?y)
((- (+ ?x ?y) ?y)          ?x)
((- ?x (- ?x ?y))          ?y)
((- ?x (+ ?x ?y))          (- ?y))
((- ?x (* ?n ?x))          (* (- 1 ?n) ?x)          (numberp ?n))
((+ ?x ?x)                 (* 2 ?x))
((+ ?x (- ?y ?x))           ?y)
((min ?x (+ ?x ?y))        (+ ?x (min 0 ?y)))
((min ?x (+ ?y ?x))        (+ ?x (min 0 ?y)))
((max ?x (+ ?x ?y))        (+ ?x (max 0 ?y)))
((max ?x (+ ?y ?x))        (+ ?x (max 0 ?y)))
((- ?x ?n)                 (+ (- ?n) ?x)            (numberp ?n))
((- (+ ?x ?y) ?x)          ?y)
((- (+ ?y ?x) ?x)          ?y)
((- ?x (+ ?n ?y))          (+ (- ?n) (- ?x ?y))     (numberp ?n))
((- ?x (+ ?y ?n))          (+ (- ?n) (- ?x ?y))     (numberp ?n))
((* ?n (+ ?m ?x))          (+ (* ?m ?n) (* ?n ?x))
                                          (and (numberp ?n) (numberp ?m)))
((* ?n (- ?m ?x))          (- (* ?m ?n) (* ?n ?x))
                                          (and (numberp ?n) (numberp ?m)))
((* ?x (* ?n ?y))          (* ?n (* ?x ?y))          (numberp ?n))
((* (* ?n ?x) ?y)          (* ?n (* ?x ?y))          (numberp ?n))
((* ?n (/ ?m ?y))          (/ (* ?n ?m) ?y)  (and (numberp ?n) (numberp ?m)))
((* ?n (/ ?y ?m))          (* (/ ?n ?m) ?y)  (and (numberp ?n) (numberp ?m)))
((* ?x (/ ?n ?y))          (* ?n (/ ?x ?y))  (numberp ?n))
((* (/ 1 ?y) ?x)           (/ ?x ?y))
((* ?x (/ 1 ?y))           (/ ?x ?y))
((* (/ 1.0 ?y) ?x)         (/ ?x ?y))
((* ?x (/ 1.0 ?y))         (/ ?x ?y))
((* ?x (- ?y))             (- (* ?x ?y)))
((* (- ?x) ?y)             (- (* ?x ?y)))
((setq ?x ?x)              ?x)
((setf ?x ?x)              ?x)
((setq ?x (1+ ?x))         (incf ?x))
((setf ?x (1+ ?x))         (incf ?x))
((setq ?x (+ ?x ?y))       (incf ?x ?y))
((setf ?x (+ ?x ?y))       (incf ?x ?y))
((setq ?x (+ ?y ?x))       (incf ?x ?y))
((setf ?x (+ ?y ?x))       (incf ?x ?y))
((setq ?x (1- ?x))         (decf ?x))
((setf ?x (1- ?x))         (decf ?x))
((setq ?x (- ?x ?y))       (decf ?x ?y))
((setf ?x (- ?x ?y))       (decf ?x ?y))
((setq ?x (cons ?y ?x))    (push ?y ?x))
((setf ?x (cons ?y ?x))    (push ?y ?x))
((progn (incf ?x ?y) ?x)   (incf ?x ?y))
((setq ?x (incf ?x ?y))    (incf ?x ?y))
((find-if #'(lambda (?x) (eq (car ?x) ?y)) ?lst)
                           (assoc ?y ?lst))
((some #'(lambda (?x) (if (eq (car ?x) ?y) ?x)) ?lst)
                           (assoc ?y ?lst))
((nconc1 ?x ?y)            (nconc ?x (cons ?y nil)))
((truncate ?x 1)           (truncate ?x))
((/ ?x 1)                  ?x)
((/ ?x 1.0)                ?x)
((/ ?x ?n)                 (* (/ 1 ?n) ?x)   (and (numberp ?n) (not (zerop ?n))))
((/ (* ?n ?x) ?m)          (* (/ ?n ?m) ?x)  (and (numberp ?n) (numberp ?m)))
((/ (+ ?n ?x) ?m) (+ (/ ?n ?m)   (/ ?x ?m))
                                             (and (numberp ?n) (numberp ?m)))
((/ (- ?n ?x) ?m) (- (/ ?n ?m)   (/ ?x ?m))
                                             (and (numberp ?n) (numberp ?m)))
((/ (* ?n ?x) (* ?m ?y))   (* (/ ?n ?m) (/ ?x ?y))
                                             (and (numberp ?n) (numberp ?m)))
((/ (/ ?x ?n) (* ?m ?y))   (* (/ 1 (* ?n ?m)) (/ ?x ?y))
                                             (and (numberp ?n) (numberp ?m)))
((/ (* ?x ?y) ?x) ?y)      ((/ (* ?x ?y) ?y) ?x)
((/ ?x (* ?x ?y))          (/ 1 ?y))
((/ ?y (* ?x ?y))          (/ 1 ?x))
((truncate (/ ?x ?y))      (truncate ?x ?y))
((sqrt (* ?n ?x))          (* (sqrt ?n) (sqrt ?x))
                                             (and (numberp ?n) (> ?n 0)))
((sqrt (/ ?x ?n))          (* (/ 1.0 (sqrt ?n)) (sqrt ?x))
                                             (and (numberp ?n) (> ?n 0)))
((sqrt (/ ?n ?x))          (/ (sqrt ?n) (sqrt ?x))
                                             (and (numberp ?n) (> ?n 0)
                                                  (not (numberp ?x))))
((sqrt (expt ?x 2))        (abs ?x))
((cbrt (* ?n ?x))          (* (cbrt ?n) (cbrt ?x))         (numberp ?n))
((cbrt (/ ?x ?n))          (* (/ 1.0 (cbrt ?n)) (cbrt ?x)) (numberp ?n))
((cbrt (/ ?n ?x))          (/ (cbrt ?n) (cbrt ?x))         (numberp ?n))
((cbrt (expt ?x 3)) ?x)    ((expt (cbrt ?x) 3) ?x)
((expt (* ?n ?x) ?m)       (* (expt ?n ?m) (expt ?x ?m))
                                (and (numberp ?n) (numberp ?m) (>= ?n 0)))
((expt (* ?x ?n) ?m)       (* (expt ?n ?m) (expt ?x ?m))
                                (and (numberp ?n) (numberp ?m) (>= ?n 0)))
((expt (/ ?n ?x) ?m)       (/ (expt ?n ?m) (expt ?x ?m))
                                (and (numberp ?n) (numberp ?m) (>= ?n 0)))
((expt (/ ?x ?n) ?m) (/ (expt ?x ?m) (expt ?n ?m))
                                (and (numberp ?n) (numberp ?m) (> ?n 0)))
((atan (* ?x ?y) (* ?x ?z)) (atan ?y ?z))
((atan (sin ?x) (cos ?x))  ?x)
((atan (cos ?x) (sin ?x))  (- (/ pi 2.0) ?x))
((cos (- (/ pi 2.0) ?x))   (sin ?x))
((sin (- (/ pi 2.0) ?x))   (cos ?x))
((cos (- 1.5707963267948966 ?x)) (sin ?x))
((sin (- 1.5707963267948966 ?x)) (cos ?x))
((/ (sin ?x) (cos ?x))     (tan ?x))
((/ (cos ?x) (sin ?x))     (/ 1 (tan ?x)))
((* (/ ?x (cos ?y)) (sin ?y)) (* ?x (tan ?y)))
((* (sin ?y) (/ ?x (cos ?y))) (* ?x (tan ?y)))
((/ (* (sin ?y) ?x) (cos ?y)) (* ?x (tan ?y)))
((/ (* ?x (sin ?y)) (cos ?y)) (* ?x (tan ?y)))
((- (* ?n ?x) (* ?m ?y)) (* ?n (- ?x (* (/ ?m ?n) ?y)))
           (and (numberp ?n) (numberp ?m)
                (or (floatp ?n) (floatp ?m) (= (mod ?m ?n) 0))))
((+ (* ?n ?x) (* ?m ?y)) (* ?n (+ ?x (* (/ ?m ?n) ?y)))
          (and (numberp ?n) (numberp ?m)
               (or (floatp ?n) (floatp ?m) (= (mod ?m ?n) 0))))
((list)                    'nil)
((= 0 ?x)                  (zerop ?x))
((= ?x 0)                  (zerop ?x))
((> ?x 0)                  (plusp ?x))
((> 0 ?x)                  (minusp ?x))
((< ?x 0)                  (minusp ?x))
((< 0 ?x)                  (plusp ?x))
((plusp (- ?x ?y))         (> ?x ?y))
((minusp (- ?x ?y))        (< ?x ?y))
((> (- ?x) (- ?y))         (< ?x ?y))
((>= (- ?x) (- ?y))        (<= ?x ?y))
((< (- ?x) (- ?y))         (> ?x ?y))
((<= (- ?x) (- ?y))        (>= ?x ?y))
((> (- ?x) (- ?y ?z))      (< ?x (- ?z ?y)))
((>= (- ?x) (- ?y ?z))     (<= ?x (- ?z ?y)))
((< (- ?x) (- ?y ?z))      (> ?x (- ?z ?y)))
((<= (- ?x) (- ?y ?z))     (>= ?x (- ?z ?y)))
((> (- ?x ?y) (- ?z))      (< (- ?y ?x) ?z))
((>= (- ?x ?y) (- ?z))     (<= (- ?y ?x) ?z))
((< (- ?x ?y) (- ?z))      (> (- ?y ?x) ?z))
((<= (- ?x ?y) (- ?z)) (>= (- ?y ?x) ?z))
((< (- ?x ?y) (- ?z ?y)) (< ?x ?z))
((< (- ?x ?y) (- ?x ?z)) (< ?z ?y))
((> (- ?x ?y) (- ?z ?y)) (> ?x ?z))
((> (- ?x ?y) (- ?x ?z)) (> ?z ?y))
((= (+ ?x ?y) ?x) (= ?y 0))
((= (+ ?x ?y) ?y) (= ?x 0))
((= (- ?x ?y) ?x) (= ?y 0))
((eql (+ ?x ?y) ?x) (= ?y 0))
((eql (+ ?x ?y) ?y) (= ?x 0))
((eql (- ?x ?y) ?x) (= ?y 0))
((= ?x (+ ?x ?y)) (= ?y 0))
((= ?y (+ ?x ?y)) (= ?x 0))
((= ?x (- ?x ?y)) (= ?y 0))
((eql ?x (+ ?x ?y)) (= ?y 0))
((eql ?y (+ ?x ?y)) (= ?x 0))
((eql ?x (- ?x ?y)) (= ?y 0))
((= (* ?n ?x) (* ?n ?y)) (= ?x ?y) (and (numberp ?n) (/= ?n 0)))
((= (* ?x ?n) (* ?y ?n)) (= ?x ?y) (and (numberp ?n) (/= ?n 0)))
((= (* ?n ?x) (* ?y ?n)) (= ?x ?y) (and (numberp ?n) (/= ?n 0)))
((= (/ ?n ?x) (/ ?n ?y)) (= ?x ?y) (and (numberp ?n) (/= ?n 0)))
((= (/ ?x ?n) (/ ?y ?n)) (= ?x ?y) (and (numberp ?n) (/= ?n 0)))
((equal ?x ?x)             t        (glnosideeffects ?x))
((eq ?x ?x)                t        (glnosideeffects ?x))
((eql ?x ?x)               t        (glnosideeffects ?x))
((equal (* ?n ?x) (* ?n ?y)) (equal ?x ?y)
                                (and (numberp ?n) (/= ?n 0)))
((equal (* ?x ?n) (* ?y ?n)) (equal ?x ?y)
                                (and (numberp ?n) (/= ?n 0)))
((equal (* ?n ?x) (* ?y ?n)) (equal ?x ?y)
                                (and (numberp ?n) (/= ?n 0)))
((equal (/ ?n ?x) (/ ?n ?y)) (equal ?x ?y)
                                (and (numberp ?n) (/= ?n 0)))
((equal (/ ?x ?n) (/ ?y ?n)) (equal ?x ?y)
                             (and (numberp ?n) (/= ?n 0)))
((eql (* ?n ?x) (* ?n ?y)) (eql ?x ?y) (and (numberp ?n) (/= ?n 0)))
((eql (* ?x ?n) (* ?y ?n)) (eql ?x ?y) (and (numberp ?n) (/= ?n 0)))
((eql (* ?n ?x) (* ?y ?n)) (eql ?x ?y) (and (numberp ?n) (/= ?n 0)))
((eql (/ ?n ?x) (/ ?n ?y)) (eql ?x ?y) (and (numberp ?n) (/= ?n 0)))
((eql (/ ?x ?n) (/ ?y ?n)) (eql ?x ?y) (and (numberp ?n) (/= ?n 0)))
((if ?p (if ?q ?w)) (if (and ?p ?q) ?w))
((expt (if ?p ?n ?m) ?k) (if ?p (expt ?n ?k) (expt ?m ?k))
                          (and (numberp ?n) (numberp ?m) (numberp ?k)))
((* ?k (if ?p ?n ?m)) (if ?p (* ?k ?n) (* ?k ?m))
                          (and (numberp ?k) (numberp ?n) (numberp ?m)))
((/ ?k (if ?p ?n ?m)) (if ?p (/ ?k ?n) (/ ?k ?m))
                          (and (numberp ?k) (numberp ?n) (numberp ?m)))
((- (if ?p ?n ?m)) (if ?p (- ?n) (- ?m))
                          (and (numberp ?n) (numberp ?m)))
((= (if ?ll ?qu ?v) ?qu) ?ll                     ; ***** ll must be boolean
 (and (glconstantp ?qu) (not (equal ?qu ?v))))
((= (if ?ll ?u ?qv) ?qv) (not ?ll)
 (and (glconstantp ?qv) (not (equal ?u ?qv))))
((eql (if ?ll ?qu ?v) ?qu) ?ll
 (and (glconstantp ?qu) (not (equal ?qu ?v))))
((eql (if ?ll ?u ?qv) ?qv) (not ?ll)
 (and (glconstantp ?qv) (not (equal ?u ?qv))))
((eq (if ?ll ?qu ?v) ?qu) ?ll
 (and (glconstantp ?qu) (not (equal ?qu ?v))))
((eq (if ?ll ?u ?qv) ?qv) (not ?ll)
 (and (glconstantp ?qv) (not (equal ?u ?qv))))
((let (?v) (setq ?v ?x) ?v) ?x)
((let ((?v t)) (setq ?v (and ?v ?x)) ?v) ?x)
((let ((?v ?x)) (incf ?v ?y)) (+ ?x ?y))
((let ((?v t)) (setq ?v (and ?v ?x)) (setq ?v (and ?v ?y)) ?v)
 (and ?x ?y))
((let ((?v t))
   (setq ?v (and ?v ?x))
   (setq ?v (and ?v ?y))
   (setq ?v (and ?v ?z))
   ?v)
 (and ?x ?y ?z))
((let ((?v t))
   (setq ?v (and ?v ?x))
   (setq ?v (and ?v ?y))
   (setq ?v (and ?v ?z))
   (setq ?v (and ?v ?w))
   ?v)
 (and ?x ?y ?z ?w))
((let ((?v t))
   (setq ?v (and ?v ?x))
   (setq ?v (and ?v ?y))
   (setq ?v (and ?v ?z))
   (setq ?v (and ?v ?w))
   (setq ?v (and ?v ?u))
   ?v)
 (and ?x ?y ?z ?w ?u))
((let ((?v t))
   (setq ?v (and ?v ?x))
   (setq ?v (and ?v ?y))
   (setq ?v (and ?v ?z))
   (setq ?v (and ?v ?w))
   (setq ?v (and ?v ?u))
   (setq ?v (and ?v ?v))
   ?v)
 (and ?x ?y ?z ?w ?u ?v))
((let (?v)
   (setq ?v ?w)
   (incf ?v ?x)
   (incf ?v ?y)
   ?v)
 (+ ?w ?x ?y))
((let ((?v ?w))
   (incf ?v ?x)
   (incf ?v ?y)
   ?v)
 (+ ?w ?x ?y))
((let (?v)
   (setq ?v ?w)
   (incf ?v ?x)
   (incf ?v ?y)
   (incf ?v ?z)
   ?v)
 (+ ?w ?x ?y ?z))
((let (?v)
   (setq ?v (copy-list (quote (?xx ?yy))))
   (setf (car ?v) ?w)
   (setf (cadr ?v) ?y)
   ?v)
 (list ?w ?y))
((let (?v)
   (setq ?v (copy-list (quote (?xx ?yy ?zz))))
   (setf (car ?v) ?w)
   (setf (cadr ?v) ?y)
   (setf (caddr ?v) ?z)
   ?v)
 (list ?w ?y ?z))
((let (?v)
   (setq ?v (copy-tree (quote (?xx . ?yy))))
   (setf (car ?v) ?w)
   (setf (cdr ?v) ?y)
   ?v)
 (cons ?w ?y))
((car (let ?z (cons ?x ?y))) (let ?z ?x))
((cdr (let ?z (cons ?x ?y))) (let ?z ?y))
((car (let ?z (list ?x ?y))) (let ?z ?x))
((cadr (let ?z (list ?x ?y))) (let ?z ?y))
((car (cons ?x ?y)) ?x)
((car (list ?x . ?s)) ?x)
((cdr (cons ?x ?y)) ?y)
((cdr (list ?x . ?s)) (list . ?s))
((first (cons ?x ?y)) ?x)
((first (list ?x . ?s)) ?x)
((rest (cons ?x ?y)) ?y)
((rest (list ?x . ?s)) (list . ?s))
((caar (cons ?x ?y)) (car ?x))
((caar (list ?x . ?s)) (car ?x))
((cadr (cons ?x ?y)) (car ?y))
((cadr (list ?x . ?s)) (car (list . ?s)))
((cdar (cons ?x ?y)) (cdr ?x))
((cdar (list ?x . ?s)) (cdr ?x))
((cddr (cons ?x ?y)) (cdr ?y))
((cddr (list ?x . ?s)) (cdr (list . ?s)))
((caaar (cons ?x ?y)) (caar ?x))
((caaar (list ?x . ?s)) (caar ?x))
((caadr (cons ?x ?y)) (caar ?y))
((caadr (list ?x . ?s)) (caar (list . ?s)))
((cadar (cons ?x ?y)) (cadr ?x))
((cadar (list ?x . ?s)) (cadr ?x))
((caddr (cons ?x ?y)) (cadr ?y))
((caddr (list ?x . ?s)) (cadr (list . ?s)))
((cdaar (cons ?x ?y)) (cdar ?x))
((cdaar (list ?x . ?s)) (cdar ?x))
((cdadr (cons ?x ?y)) (cdar ?y))
((cdadr (list ?x . ?s)) (cdar (list . ?s)))
((cddar (cons ?x ?y)) (cddr ?x))
((cddar (list ?x . ?s)) (cddr ?x))
((cdddr (cons ?x ?y)) (cddr ?y))
((cdddr (list ?x . ?s)) (cddr (list . ?s)))
((caaaar (cons ?x ?y)) (caaar ?x))
((caaaar (list ?x . ?s)) (caaar ?x))
((caaadr (cons ?x ?y)) (caaar ?y))
((caaadr (list ?x . ?s)) (caaar (list . ?s)))
((caadar (cons ?x ?y)) (caadr ?x))
((caadar (list ?x . ?s)) (caadr ?x))
((caaddr (cons ?x ?y)) (caadr ?y))
((caaddr (list ?x . ?s)) (caadr (list . ?s)))
((cadaar (cons ?x ?y)) (cadar ?x))
((cadaar (list ?x . ?s)) (cadar ?x))
((cadadr (cons ?x ?y)) (cadar ?y))
((cadadr (list ?x . ?s)) (cadar (list . ?s)))
((caddar (cons ?x ?y)) (caddr ?x))
((caddar (list ?x . ?s)) (caddr ?x))
((cadddr (cons ?x ?y)) (caddr ?y))
((cadddr (list ?x . ?s)) (caddr (list . ?s)))
((cdaaar (cons ?x ?y)) (cdaar ?x))
((cdaaar (list ?x . ?s)) (cdaar ?x))
((cdaadr (cons ?x ?y)) (cdaar ?y))
((cdaadr (list ?x . ?s)) (cdaar (list . ?s)))
((cdadar (cons ?x ?y)) (cdadr ?x))
((cdadar (list ?x . ?s)) (cdadr ?x))
((cdaddr (cons ?x ?y)) (cdadr ?y))
((cdaddr (list ?x . ?s)) (cdadr (list . ?s)))
((cddaar (cons ?x ?y)) (cddar ?x))
((cddaar (list ?x . ?s)) (cddar ?x))
((cddadr (cons ?x ?y)) (cddar ?y))
((cddadr (list ?x . ?s)) (cddar (list . ?s)))
((cdddar (cons ?x ?y)) (cdddr ?x))
((cdddar (list ?x . ?s)) (cdddr ?x))
((cddddr (cons ?x ?y)) (cdddr ?y))
((cddddr (list ?x . ?s)) (cdddr (list . ?s)))
((car (if ?p (list ?x . ?s) (list ?a . ?h)))
                            (if ?p ?x ?a))
((cadr (if ?p (list ?x ?y . ?s) (list ?a ?b . ?h)))
                            (if ?p ?y ?b))
((caddr (if ?p (list ?x ?y ?z . ?s) (list ?a ?b ?c . ?h)))
                            (if ?p ?z ?c))
((cadddr (if ?p (list ?x ?y ?z ?w . ?s) (list ?a ?b ?c ?d . ?h)))
                            (if ?p ?w ?d))
((glcfield (glmakecrecord ?tp ?how) ?fld)
                      (glgetmakefield ?tp ?fld ?how)
                      (glfindmakefield ?tp ?fld ?how))
; ((let ?z (sqrt ?x))    (sqrt (let ?z ?x)))    ; ??? bad for trans to C

( (dolist (?v (subset (function (lambda (?u) ?p)) ?s)) . ?z)
  (dolist (?v ?s) (if ?pp (progn . ?z)))
  t  ((?pp (subst ?v ?u ?p))) )

( (dolist (?v (mapcan (function (lambda (?u) (and ?p (cons ?u nil))))
		      ?s))
	  . ?z)
  (dolist (?v ?s) (if ?pp (progn . ?z)))
  t  ((?pp (subst ?v ?u ?p))) )

( (dolist (?v (mapcar (function ?fn) ?lst)) . ?stuff)
  (dolist (?vv ?lst) . ?stuffb)
  t ((?vv (glgensym 'glvar)) (?stuffb (subst (list ?fn ?vv) ?v ?stuff))) )

( (dolist (?v (nreverse
                (let (?res)
                  (dotimes (?i ?n ?res)
                    (push ?code ?res))))) . ?stuff)
  (dotimes (?i ?n) . ?stuffb)
  (<= (glnoccurs ?v ?stuff) 1)
  ((?stuffb (subst ?code ?v ?stuff))) )

( (dolist (?v (nreverse
                (let (?res)
                  (dotimes (?i ?n ?res)
                    (push ?code ?res))))) . ?stuff)
  (let (?vv) (dotimes (?i ?n) (setq ?vv ?code) . ?stuffb))
  (> (glnoccurs ?v ?stuff) 1) 
  ((?vv (glgensym 'glvar)) (?stuffb (subst ?vv ?v ?stuff))) )

))  ; gldefpatterns

(defun gltestanglepat (pat)
  (let (lhsval rhsval xval)
    (dotimes (i 64)
      (setq xval (+ 0.05 (/ i 10.0)))
      (setq lhsval (eval (subst xval '?x (first pat))))
      (setq rhsval (eval (subst xval '?x (second pat))))
      (unless (or (< (abs (- lhsval rhsval)) 0.00001)
		  (< (abs (- (abs (- lhsval rhsval)) (* 2 pi))) 0.00001))
	(format t "~A   ~A   for x = ~A~%" lhsval rhsval xval)))))

; 21 Sep 06
; Define equality patterns
(defun gldefeqpatterns (patwd l)
  (dolist (pat l)
    (dolist (op '(> >= = <= < /=))
      (let ((patb (cons (subst op '> (car pat))
			(cons (subst op '> (cadr pat)) (cddr pat)))))
	(pushnew patb (get (caar patb) patwd) :test #'equal)))))

(gldefeqpatterns 'glpatterns '(

((> (* ?n ?a) ?m) (> ?a (/ ?m ?n))
 (and (numberp ?n) (numberp ?m) (> ?n 0)))
((> ?m (* ?n ?a)) (> (/ ?m ?n) ?a)
 (and (numberp ?m) (numberp ?n) (> ?n 0)))
((> (/ ?a ?n) ?m) (> ?a (* ?n ?m))
 (and (numberp ?n) (numberp ?m) (> ?n 0)))
((> ?m (/ ?a ?n)) (> (* ?n ?m) ?a)
 (and (numberp ?m) (numberp ?n) (> ?n 0)))
((> (/ ?n ?a) ?m) (> (/ ?n ?m) ?a)
 (and (numberp ?n) (numberp ?m) (and (> ?n 0) (> ?m 0))))
((> (+ ?n ?a) ?m) (> ?a (- ?m ?n)) (and (numberp ?n) (numberp ?m)))
((> (- ?n ?a) ?m) (> (- ?n ?m) ?a) (and (numberp ?n) (numberp ?m)))
((> (- ?a ?n) ?m) (> ?a (+ ?n ?m)) (and (numberp ?n) (numberp ?m)))
((> (expt ?a 2) ?m) (> ?a (sqrt ?m)) (and (numberp ?m) (>= ?m 0)))
((> (expt ?a 3) ?m) (> ?a (cbrt ?m)) (numberp ?m))
((> (sqrt ?a) ?m) (> ?a (expt ?m 2)) (and (numberp ?m) (>= ?m 0)))
((> (sqrt ?x) (sqrt ?y)) (> (abs ?x) (abs ?y)))
((> (cbrt ?a) ?m) (> ?a (expt ?m 3)) (numberp ?m))
((> (+ ?n ?x) (+ ?m ?y)) (> (+ (- ?n ?m) ?x) ?y)
 (and (numberp ?n) (numberp ?m)))
((> (+ ?n ?x) (- ?y ?m)) (> (+ (+ ?n ?m) ?x) ?y)
 (and (numberp ?n) (numberp ?m)))
((> (- ?x ?n) (+ ?m ?y)) (> ?x (+ (+ ?n ?m) ?y))
 (and (numberp ?n) (numberp ?m)))
((> (- ?n ?x) (- ?m ?y)) (> (- (- ?n ?m) ?x) (- ?y))
 (and (numberp ?n) (numberp ?m)))
((> (- ?x) (- ?a ?b)) (> (- ?b ?a) ?x))
((> (- ?a ?b) (- ?x)) (> ?x (- ?b ?a))) ((> (+ ?x ?y) ?x) (> ?y 0))
((> (+ ?x ?y) ?y) (> ?x 0)) ((> ?x (+ ?x ?y)) (> 0 ?y))
((> ?y (+ ?x ?y)) (> 0 ?x)) ((> (- ?x ?y) ?x) (> 0 ?y))
((> ?x (- ?x ?y)) (> ?y 0))
((> (* ?n ?x) (* ?m ?y)) (> (* (/ ?n ?m) ?x) ?y)
 (and (numberp ?n) (numberp ?m) (and (> ?n 0) (> ?m 0))))

))

; (pushnew '((expt (sqrt ?x) 2)  ?x) (get 'expt 'glpatterns)) ; fails testing


; 23 Nov 93
(defun xor (x y) (if x (if y nil x) y))

; Make a new array, applying a function to elements of a constant array
(setf (get 'map 'glevalwhenconst) t)
