; gltrans.lsp              Gordon S. Novak Jr.           ; 09 Jan 08

; Copyright (c) 2008 Gordon S. Novak Jr. and The University of Texas at Austin.
; All Rights Reserved.

; Functions to acquire a translation from one data type to another

; 11 Feb 92; 05 Jan 95; 02 Jan 97; 28 Feb 02; 08 Jan 04; 03 Mar 04

(defvar *gltrans-fnname*)

(defmacro gltransfns         (x) `(get ,x 'gltransfns))

; 03 Jan 91; 05 Feb 92; 07 Feb 92
; Generate a function to translate from source type to goal type.
(defun gltransfn (goal-type source-type)
  (let (argname code)
    (setq *gltrans-fnname*
	  (intern
	    (if (symbolp goal-type)
		(concatenate 'string (gevstringify source-type)
			      "-TO-" (gevstringify goal-type))
		(symbol-name (gensym
			      (concatenate 'string (gevstringify source-type)
					   "-TRANS-"))))))
    (pushnew (list goal-type *gltrans-fnname*)
	     (gltransfns source-type) :test #'equal)
    (setq argname (glmkatom source-type))
    (setq code (gltransdata goal-type goal-type source-type argname
			    goal-type t))
    (eval (list 'gldefun *gltrans-fnname*
		(list (gltargtype argname source-type)) code))
    *gltrans-fnname*))

(defun gltargtype (arg type)
  (intern (concatenate 'string (gevstringify arg) ":" (gevstringify type))) )


; 03 Jan 91; 07 Jan 91; 08 Jan 91; 19 Mar 91; 05 Feb 92; 07 Feb 92
; Generate code to translate from source type to goal type.
(defun gltransdata (goal-name goal-type source-type source-code
			      top-goal topflg)
  (let (choices mchoices partcode res sel pair
		looptype loopitem whenp coll transfn ptrtog ptrtos)
    (if (glbasictypep goal-type)
	(gltchoose goal-name goal-type source-type source-code top-goal)
	(if (and (consp goal-type)
		 (eq (first goal-type) 'listof))
	    (progn (setq choices (gltchoices source-type 'list t))
		   (setq mchoices (mapcar #'car choices))
		   (format t "Specify list~%")
		   (setq sel (menu (cons '|Quit| mchoices)))
		   (setq pair (assoc sel choices))
		   (setq looptype
			 (if (and (consp (cadr pair))
				  (eq (caadr pair) 'listof))
			     (cadadr pair)
			     (cadr pair)))
		   (setq loopitem (glmkatom (if (symbolp looptype)
						looptype 'foo)))
		   (setq whenp (gltransdata 'loop-predicate 'boolean
					    looptype loopitem top-goal nil))
		   (setq coll (gltransdata 'item (cadr goal-type)
					   looptype loopitem top-goal nil))
		   (if (and whenp (not (eq whenp t)))
		       `(for ,loopitem in (,sel ,source-code) when ,whenp
			     collect ,coll)
		       `(for ,loopitem in (,sel ,source-code) collect ,coll)))
; Not a basic type, not a listof
	    (if (symbolp goal-type)
		(if topflg
		    (gltransparts goal-name goal-type source-type source-code
			     top-goal)
		    (if (setq transfn
			      (gltfindtransfn goal-type source-type
					      top-goal topflg))
			`(if (not (null ,source-code)) (,transfn ,source-code))
			(gltchoose goal-name goal-type source-type source-code
				   top-goal)))
		(if (and (consp goal-type)
			 (setq ptrtog (glpointsto goal-type)))  ; pointer
		    (progn (setq choices (gltchoices source-type '^ nil))
			   (setq mchoices (mapcar #'car choices))
			   (format t "Specify pointer~%")
			   (setq sel (menu (cons '|Quit| mchoices) "Pointer"))
			   (setq pair (assoc sel choices))
			   (setq ptrtos (glpointsto (cadr pair)))
			   (if (setq transfn
				     (gltfindtransfn ptrtog ptrtos
						     top-goal nil))
			       `(if (not (null (,(car pair) ,source-code)))
				    (,transfn (,(car pair) ,source-code)))
			       `(error "not implemented")))
		    (gltransparts goal-name goal-type source-type
				  source-code top-goal))) )) ))

; 07 Feb 92
; Get a choice of specified goal type from given source type
(defun gltchoose (goal-name goal-type source-type source-code top-goal)
  (let (choices mchoices sel pair res)
    (setq choices (gltchoices source-type goal-type nil))
    (setq mchoices (mapcar #'car choices))
    (if (member goal-type '(number real integer boolean))
	      (push '|<op>| mchoices))
    (unless (member goal-type '(boolean)) (push '|If| mchoices))
    (unless (glbasictypep goal-type) (push '|Parts| mchoices))
    (push '|Type-in| mchoices)
    (setq sel (menu (cons '|Quit| mchoices)
		    (concatenate 'string (stringify goal-name)
				 ": " (stringify goal-type))))
    (case sel
      (|Quit| nil)
      (|<op>| (gltrans-exp goal-type source-type source-code top-goal))
      (|Type-in| (gltaskuser "specify value: "))
      (|Parts| (gltransparts goal-name goal-type source-type source-code
			     top-goal))
      (|If| (gltgetif goal-type source-type source-code top-goal))
      (t (if (setq pair (assoc sel choices))
	     (if (setq res (gltmatchc goal-type (cadr pair)
				      (list sel source-code)))
		 res
		 (gltransdata goal-name goal-type
			      (cadr pair) (list sel source-code)
			      top-goal nil)))) ) ))

; 07 Feb 92; 28 Feb 02
; Get an expression of specified goal type from given source type
(defun gltrans-exp (goal-type source-type source-code top-goal)
  (let (op opnd-type opnd1 opnd2)
    (setq op (menu (if (eq goal-type 'boolean)
		       '(< <= == /= => > and or not)
		       '(+ - * / x^2 abs sqrt sin cos tan expt))
		   "Op"))
    (setq opnd-type (if (eq goal-type 'boolean)
			(if (member op '(and or not)) 'boolean 'number)
			goal-type))
 ; could make a let if source-code is not atomic
    (setq opnd1 (gltransdata "lhs" opnd-type source-type source-code
			     top-goal nil))
    (unless (gltunaryp op)
      (setq opnd2 (gltransdata "rhs" opnd-type source-type source-code
			       top-goal nil)))
    (if (gltunaryp op)
	(case op
	  (x^2 (list 'expt opnd1 2))
	  (t (list op opnd1)))
	(case op
	  (/ (list (if (eq goal-type 'integer) 'truncate op)
		   opnd1 opnd2) )
	  (t (list op opnd1 opnd2)) ) ) ))

; 07 Feb 92
(defun gltunaryp (op) (member op '(not x^2 abs sqrt sin cos tan)))

; 07 Feb 92; 03 Mar 04
; Get a conditional
(defun gltgetif (goal-type source-type source-code top-goal)
  (let (cond-expr truepart falsepart)
    (setq cond-expr (gltransdata "test" 'boolean source-type source-code
				 top-goal nil))
    (setq truepart (gltransdata "if-true" goal-type source-type source-code
			       top-goal nil))
    (setq falsepart (gltransdata "if-false" goal-type source-type source-code
				 top-goal nil))
    `(if ,cond-expr ,truepart ,falsepart) ))

; 05 Feb 92
(defun gltransparts (goal-name goal-type source-type source-code top-goal)
  (let (res)
    (format t "Specify parts of ~A of type ~A~%" goal-name goal-type)
    (mapc #'(lambda (part)
	      (setq partcode
		    (gltransdata (car part) (cadr part)
				 source-type source-code top-goal nil))
	      (push (car part) res)
	      (push partcode res))
	  (gevdatanames goal-type t))
    (cons 'a (cons goal-type (cons 'with (nreverse res)))) ))


; from gevpropnames 4-FEB-83; 07 Jan 91; 09 Jan 08
; Get all property names and types of properties of type PROPTYPE for 
;   OBJ when they satisfy FILTER. 
(gldefun gltpropnames ((obj gltype) (proptype atom) (filter atom) (fussy boolean))
  (result (listof glnametype))
  (let (result type)
     (result = (for p in (case proptype of (prop (props obj))
			                     (adj  (adjs obj))
					     (isa  (isas obj))
					     (msg  (msgs obj)))
		    when (type = (gevproptypes obj proptype (name p)))
		         and (gltfilter type filter fussy)
		    collect (a glnametype with name = (name p) type = type)))
     (for s in (supers obj) do
	  (result = (nconc result (gltpropnames s proptype filter fussy))))
     result))


; from gevfilter; 07 Jan 91; 08 Jan 91
(defun gltfilter (type filter fussyflg)
  (setq type (gevxtrtype type))
  (if fussyflg
      (gldescendantp type filter)
      (case filter
	(number (and (not (member type '(boolean anything)))
		     (not (and (consp type)
			       (eq (car type) 'listof)))))
	(list (and (consp type) (eq (car type) 'listof)))
	(t t)) ) )

(defun gltmatchc (goal-type type code)
  (if (gltypematch type goal-type)
      code
      (case goal-type
	(integer (if (eq type 'real) (list 'truncate code)))
	(real    (if (eq type 'integer) (list 'float code)))
	(string  (if (member type '(atom symbol))
		     (list 'symbol-name code)))
	(t nil))) )

(defun gltaskuser (str)
  (princ str)
  (kwote (read)))

(defun gltchoices (source-type goal-type fussy)
  (let (choices)
    (setq choices (gltdatanames source-type goal-type fussy))
    (when (eq goal-type 'boolean)
      (nconc choices (gltpropnames source-type 'adj goal-type fussy))
      (nconc choices (gltpropnames source-type 'isa goal-type fussy)))
    (nconc choices (gltpropnames source-type 'prop goal-type fussy))
    choices))

; 11 Feb 92
(defun gltdatanames (source-type goal-type fussy)
  (if (and fussy (not (eq goal-type 'list)))
      (subset #'(lambda (pair) (gldescendantp (second pair) goal-type))
	      (gevdatanames source-type goal-type))
      (gevdatanames source-type goal-type)) )

; 07 Feb 92
(defun gltfindtransfn (goal-type source-type top-goal topflg)
  (let (transfns sel)
    (and (not topflg)
	      (if (and top-goal (eq goal-type top-goal))
		  *gltrans-fnname*
		  (progn (setq transfns
			       (subset #'(lambda (pair)
					   (eq (car pair) goal-type))
				       (gltransfns source-type)))
			 (if (null (cdr transfns))
			     (cadar transfns)
			     (progn (setq sel (menu (mapcar #'car transfns)
						    "Transfer fn:"))
				    (cadr (assoc sel transfns))))))) ))
