; hs8p.lsp             Gordon S. Novak Jr.         ; 13 May 09

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 05 Apr07; 10 Apr 07; 12 Apr 07; 19 Apr 07; 24 Apr 07; 15 May 07; 16 May 07
; 05 May 09

; Example of heuristic search using 8-puzzle

(glispobjects

(board8p (arrayof integer)
  prop ((size    (9) result integer)
        (blank   ((pos self 0)) result indx8p)
        (ops     ('(up down left right)) result (listof symbol)) )
;        (successors ((for op in (ops self) when (applicable? self op)
;                       collect (move self op))) result (listof board8p))
  msg  ((new     (glambda (self (init (listof integer)))
                   (make-array size :initial-contents init))
                 result (typeof self))
        (copy    (glambda (self)
                   (let (cpy)
                     (cpy = (make-array size))
                     (for i in size ((aref cpy i) = (aref self i)))
                     cpy))
                 result board8p)
        (pos     (glambda (self (n integer))        ; find where number n is
                   (let ((res -1) (i 0))
                     (while (and (< i size) (< res 0))
                       (if (= n (aref self i)) (res = i))
                       (incf i))
                     res))   result indx8p)
        (applicable? (glambda (self (op symbol))
                       (legal (destination (blank self) op)))
                       result boolean)
        (move    (glambda (self (op symbol))
                   (let (cpy bl dest tmp)
                     (cpy = (copy self))
                     (bl = (blank self))
                     (dest = (destination bl op))
                     (tmp = (aref cpy dest))
                     ((aref cpy dest) = (aref cpy bl))
                     ((aref cpy bl) = tmp)
                     cpy))
                 result board8p)
        (manhat  board8p-manhat)
        (misplace (glambda (self (goal board8p))
                   (for i in 9
                        when (not (zerop (aref goal i)))
                         sum (if (= (aref self i) (aref goal i)) 0 1)))
                  result integer)
        (boardequal (glambda (self (goal board8p))
                      (for i in 9 every (= (aref self i) (aref goal i))))
                  result boolean)
        (cost     (glambda (self (successor anything)) 1) result integer)
        ) )

; index, range 0..8
(indx8p  integer
  prop ((column ((mod self 3)))
        (row    ((truncate self 3))) )
  adj  ((legal  ((and (>= self 0) (< self 9)))))
  msg  ((manhat (glambda (self other)
                  (+ (abs (- (column self) (column other)))
                     (abs (- (row self) (row other))))))
        (destination (glambda (self op)
                       (case op
                         (down (if (> self 2) (- self 3) -1))
                         (up   (if (< self 6) (+ self 3) -1))
                         (left (if (< (column self) 2) (1+ self) -1))
                         (right (if (> (column self) 0)  (1- self) -1))))
                     result indx8p)
        ) )

) ; glispobjects

(gldefun board-from-list ((l (listof integer))) (new (a board8p) l))

(gldefun board8p-manhat ((self board8p) (goal board8p)) (result integer)
  (for i in 9
       when (not (zerop (aref self i)))
       sum  (manhat (cast i 'indx8p)
                    (pos goal (aref self i))) ) )

(defvar *goal*   (board-from-list '(1 2 3 8 0 4 7 6 5)))
(defvar *easy*   (board-from-list '(1 3 4 8 6 2 7 0 5)))
(defvar *medium* (board-from-list '(2 8 1 0 4 3 7 6 5)))
(defvar *harder* (board-from-list '(2 8 1 4 6 3 0 7 5)))
(defvar *worst*  (board-from-list '(5 6 7 4 0 8 3 2 1)))

(gldefun t7101 ((l (listof integer))) (new (a board8p) l))
(gldefun t7102 ((b board8p) (move symbol)) (applicable? b move))
(gldefun t7103 ((b board8p)) (blank b))
(gldefun t7104 ((b board8p) (move symbol)) (move b move))
(gldefun t7105 ((b board8p)) (successors b))
(gldefun t7106 ((b board8p) (g board8p)) (manhat b g))
(gldefun t7107 ((b board8p) (g board8p)) (misplace b g))
(gldefun t7108 ((b board8p) (g board8p)) (goalp b g))
