; ifa.lsp                  Gordon S. Novak Jr.          ; 03 Mar 04

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 10 Dec 96; 04 Mar 97; 06 Mar 97; 11 Mar 97; 12 Mar 97; 23 Sep 97; 29 Sep 97
; 07 Oct 97; 14 Oct 97; 16 Oct 97; 26 Mar 98; 31 Mar 98; 02 Apr 98; 09 Apr 98
; 30 Apr 98; 05 May 98; 11 May 98; 26 May 98; 27 May 98; 28 May 98; 03 Jun 98
; 04 Jun 98; 30 Jul 98; 07 Aug 98; 15 Sep 98; 03 Nov 98; 30 Dec 98; 07 Jan 99
; 11 Jan 99; 13 Jan 99; 14 Jan 99; 15 Jan 99; 21 Jan 99; 26 Jan 99; 28 Jan 99
; 02 Feb 99; 19 May 99; 20 May 99; 23 Aug 99; 26 Aug 99; 01 Sep 99; 23 Sep 99
; 28 Sep 99; 30 Sep 99; 07 Oct 99; 12 Oct 99; 14 Oct 99; 19 Oct 99; 21 Oct 99
; 28 Oct 99; 02 Nov 99; 04 Nov 99; 09 Nov 99; 23 Dec 99; 19 Jan 04

; Iterate-Filter-Accumulate program framework

(setq ifapatb
      '(ifanew (input inputtype)
         prop ((accumulator (nil) result acctype)
	       (seqview  seqview)
	       (filterfn filterfn)
	       (itemview itemview))
	 supers (ifa-framework)) )

(glispobjects

(ifa-framework (input anything)
  prop   ((seqview      ('identity))             ; defaults to given input
	  (sequence     ((funcall (seqview self) (input self))))
	  (filterfn     ('true))                 ; t if item is to be collected
          (itemview     ('identity))             ; defaults to item itself
	  (accumulator  (0))
	  (initialize   (glambda (self) 0))      ; default for summation
	  )
  msg    ((filter       (glambda (self itm) (funcall (filterfn self) itm)))
	  (sum          ifa-sum        specialize t)
	  (add          (glambda (self acc val) (add acc val))      ; 5/19/99
			  result (typeof (accumulator self)))
	  (update       (glambda (self acc item)
			  (if (update-assign acc)
			      (acc = (add self acc item))
			      (add self acc item))))
	  (value        (glambda (self itm) (funcall (itemview self) itm))) ) )

(sum-ifa (input (listof integer))
  prop   ((accumulator  (0) result integer-accumulator))
  supers (ifa-framework))

(accumulator anything
  prop   ((initial-value  ((a (typeof self))))
	  (value          (self))    ; was  result (strof (typeof self))
	  (accview        ('identity))
	  (accval         ((funcall (accview self) (value self))))
	  (sumfn          ('+))
	  (update-assign  (t))
	  (final-value    (value)) )
  msg    ((initialize     (initial-value))
	  (add            (glambda (self val)                    ; 5/19/99
			    (funcall (sumfn self) (accval self) val)))
	  ) )

(double-accumulator anything
  msg  ((add             (glambda (self item)
			   ((acc1 self) = (add (acc1 self) item))
			   ((acc2 self) = (add (acc2 self) item))
			   self)))
  prop  ((value          (self))
         (initial-value  ((a (typeof self) with
			     acc1 (initial-value (acc1 self))
			     acc2 (initial-value (acc2 self))))
			 result (typeof self)) )
  supers (accumulator))

; 23 Sep 99; 09 Nov 99; 19 Jan 04
(find-update-accumulator anything
  prop   ((initial-value  ((a (typeof self))))
	  (value          (self))    ; was  result (strof (typeof self))
	  (accview        ('identity))
	  (accval         ((funcall (accview self) (value self))))
	  (update-assign  (t))
	  (final-value    (value))
	  (entry          (self))  ; for type of result of lookup
	  (autoinsert     (t))
	  (keyvaluefn     ('identity)) )
  msg    ((initialize     (initial-value))
	  (add            (glambda (self val)
			    (let ((ptr (typeof (entry self))))
			      (ptr = (member (accval self)
					    (funcall (keyvaluefn self) val)))
			      (if (and (null ptr)
				       (autoinsert self))
				  (progn (if (update-assign self)
					     (self =
						   (insert-key (accval self)
							       (funcall (keyvaluefn self)
									val)))
					     (insert-key (accval self)
						  (funcall (keyvaluefn self)
							   val)))
				       (ptr = (member (accval self)
						  (funcall (keyvaluefn self)
							   val)))
                                       ; ought to init the record here
				       ))
			      (if (not (null ptr))
				  (update self ptr val))
			      self)) ) )
  supers (accumulator))


(sum-and-count (list (acc1 real-accumulator) (acc2 count-accumulator))
  supers (double-accumulator))

(words-and-count (list (acc1 avl-string-accumulator) (acc2 count-accumulator))
  supers (double-accumulator))

(integer-accumulator integer
  prop   ((value          (self) result integer))
  supers (accumulator))

(count-accumulator integer
  prop   ((value          (self) result integer)
	  (sumfn          ('countem)))
  supers (accumulator))

(real-accumulator    real
  prop   ((value          (self) result real))
  supers (accumulator))

(string-accumulator  string
  prop   ((value          (self) result string))
  supers (accumulator))

(boolean-accumulator boolean
  prop   ((value          (self) result boolean))
  supers (accumulator))

(or-accumulator boolean
  prop   ((value          (self) result boolean)
	  (sumfn         ('or)))
  supers (accumulator))

(and-accumulator boolean
  prop   ((value          (self) result boolean)
	  (sumfn         ('and)))
  supers (accumulator))

(xor-accumulator boolean
  prop   ((value          (self) result boolean)
	  (sumfn         ('xor)))
  supers (accumulator))

(list-accumulator    (listof anything)
  prop   ((initial-value (nil) result (typeof self))
	  (final-value   ((nreverse self)) result (typeof self))
	  (sumfn         ('bcons)) )
  supers (accumulator))

; 12 Oct 99; 14 Oct 99; 28 Oct 99
(alist-accumulator (listof (cons (key symbol) (data anything)))
  prop   ((initial-value (nil) result (typeof self))
	  (entry         car) )     ; for element type
  msg    ((member        (glambda (self key) (assoc key self))
			       result (typeof (car self)))
	  (insert-key    (glambda (self key)
			   (cons (a (typeof (car self)) with key = key)
				 self)) ) )
  supers (find-update-accumulator))


(listof-string-accumulator (listof string) supers (list-accumulator))

; 19 Jan 04
(histogram-accumulator (arrayof integer)
  prop   ((initial-value ((make-array (nbins self) :initial-element 0))
			   result (typeof self))
	  (bins          (self))
	  (update-assign (nil))
	  (low-value     (0))
	  (high-value    (1))
	  (step          (1))
	  (nbinsest      ((/ (- high-value low-value) step)))
	  (nbins         ((if (integerp nbinsest)
			      (1+ nbinsest)
			      (ceiling nbinsest))))
	  (sumfn         ('count))
	  (value         (self)) )
  msg    ((count         (glambda (self val)
			   ((aref (bins self)
				  (truncate (- val (low-value self))
					    (step self)))
			       _+ 1)) ) )
  supers (accumulator))

(sat-accumulator (arrayof integer)
  prop   ((low-value     (400))
	  (high-value    (1600))
	  (step          (20)))
  supers (histogram-accumulator))

(histogram-ifa anything
  supers (ifa-framework))

(list-histogram-ifa (sequence (listof integer))
  prop   ((accumulator  (nil) result sat-accumulator))
  supers (histogram-ifa))

(odd-sum-ifa (sequence (listof integer))
  prop   ((filterfn     ('oddp)))  ; add odd items only
  supers (sum-ifa))

(odd-sum-squares-ifa (sequence (listof integer))
  prop   ((filterfn     ('oddp)))  ; add odd items only
  msg    ((value        (glambda (self itm) (* itm itm))))
  supers (sum-ifa))

(strings-ifa (sequence (listof string))
  prop  ((accumulator  ("") result string-accumulator))
  supers (ifa-framework))

(integral-ifa anything
  prop   ((accumulator  (0.0) result real-accumulator)
	  (fn           ('identity))
	  (low          (0.0))
	  (high         (1.0))
	  (step         (0.01))
          (sequence     ( (truncate (- high low) step)) ) )
  msg    ((fofx         (glambda (self x) (funcall (fn self) x)) )
	  (xvalue       (glambda (self n) (+ (low self) (* (+ n 0.5)
							   (step self)))))
	  (yvalue       (glambda (self n) (fofx self (xvalue self n))))
	  (value        (glambda (self n) (* (step self) (yvalue self n)))) )
  supers (sum-ifa))

(param-integral-ifa (list (fn symbol) (low number) (high number) (step number))
  supers (integral-ifa))

(sin-integral-ifa anything
  prop   ((fn           (#'sin))
	  (low          (0.0))
	  (high         ((/ pi 2.0)))
	  (step         (0.01)) )
  supers (integral-ifa))

(list-integral-ifa (listof number)
  prop   ((sequence     (self)))
  msg    ((yvalue       (glambda (self item) item)))
  supers (integral-ifa))

; integration where the function is constant: illustrates optimization.
(constant-integral-ifa anything
  msg    ((fofx         (glambda (self x) 5)))
  supers (integral-ifa))

(box-size-ifa (input box)
  prop   ((seqview      ('linked-list))
	  (itemview     ('size)) )
  supers (sum-ifa))

(box-name-list-ifa (input box)
  prop   ((seqview      ('linked-list))
	  (itemview     ('name))
	  (accumulator  (nil) result listof-string-accumulator) )
  supers (sum-ifa))


(avl-string-accumulator avl-tree-of-string
  prop   ((initial-value (nil) result avl-tree-of-string)
	  (value         (self) result avl-tree-of-string)
	  (accview       ('avl-tree))
	  (sumfn         ('insert-key)) )
  supers (accumulator))

(avl-string-count-accumulator avl-string-count
  prop   ((initial-value (nil) result avl-string-count)
	  (value         (self) result avl-string-count)
	  (accview       ('avl-tree))
	  (sumfn         ('insert-count)) )
  supers (accumulator))


; 23 Aug 99; 26 Aug 99; 01 Sep 99
(find-update  anything
  prop   ((sumfn           ('find-update-sum))
	  (collection-view ('identity))
	  (collection      ((funcall (collection-view self) self)))
	  (key-view        ('identity)) )
  msg    ((key             (glambda (self item)
				    (funcall (key-view self) item)))
	  (find            (glambda (self item)
				    (member (collection self)
					    (key self item)))
			   result (typeof (collection-item self)))
	  (insert          (glambda (self item)
				    (insert (collection self)
					    (key self item)))
			   result (typeof (collection-item self)))
	  (add             find-update-add specialize t) )
  supers (accumulator))

(fu-avl-count avl-string-count
  prop   ((collection-item (nil) result avl-string-count)
	  (collection-view ('avl-tree)) )
  supers (find-update))

(avl-count-accumulator avl-count
  prop   ((initial-value (nil) result avl-count)
	  (value         (self) result avl-count)
	  (accview       ('avl-tree)) )
  supers (find-update))

(avl-count (z avl-string-count)
  prop   ((data          ((count z)) result integer-accumulator))
  msg    ((find          (glambda (self item)
				  (member (avl-tree (z self)) item)))
	  (insert        (glambda (self item)
				  (insert (avl-tree (z self)) item)))
	  ) )

; (gldefun ta ((ac avl-count)) (data ac))
; initialize isn't done right for ifa -- it returns initial value
; (gldefun tc ((ac avl-count) (s string)) (find ac s))


(word-list-ifa (sequence string-of-words)
  prop   ((accumulator  (nil) result avl-string-accumulator))
  supers (ifa-framework))

(word-file-ifa (sequence file-of-words-generator)
  prop   ((itemview     ('string-downcase)))
  supers (word-list-ifa))

(update-ifa anything
  msg    ((add          update-ifa-sum        specialize t))
  supers (ifa-framework))

(word-count-ifa (sequence string-of-words)
  prop   ((accumulator  (nil) result avl-string-count-accumulator)
	  (sumfn        ('insert-count)) )
  supers (ifa-framework))

(file-count-ifa (sequence file-of-words-generator)
  prop   ((accumulator  (nil) result avl-string-count-accumulator)
	  (itemview     ('string-downcase))
	  (sumfn        ('insert-count)) )
  supers (ifa-framework))

(kwic-ifa (sequence (listof bibentry))
  prop   ((initval      (nil) result kwic-avl)
	  (initialize   ((avl-tree initval)))
	  (sumfn        ('insert-kwic)) )
  supers (ifa-framework))

; Find-Min-Update
(fminu-framework (tuple (input anything) (goal anything))
  prop   ((seqview      ('identity))             ; defaults to given input
	  (sequence     ((funcall (seqview self) (input self))))
	  (filterfn     ('true))                 ; t if item is to be examined
          (itemview     ('identity))             ; defaults to item itself
	  (updatefn     ('identity))
	  )
  msg    ((filter       (glambda (self itm) (funcall (filterfn self) itm)))
	  (find         fminu-find        specialize t)
	  (distance     (glambda (self item goal) (distance item goal)))
	  (update       (glambda (self item goal)
				 (funcall (updatefn self) self item goal)) )
	  (value        (glambda (self itm) (funcall (itemview self) itm))) ) )

(li-fmin (input (listof integer))
 supers  (fminu-framework))

(lv-fmin (input (listof vector))
  supers (fminu-framework))

(mo-fmin (input (listof movobj))
  prop   ((updatefn     ('movobj-update)))
  supers (fminu-framework))

; moving object
(movobj (list (id symbol)
	      (position vector)
	      (velocity vector)
	      (lasttime number))
  prop   ((lowpassfactor (0.25)) )
  msg    ((estpos       (glambda (self time)
			  (+ position (* velocity (- time (lasttime self))))))
	  (distance     (glambda (self goal)
                          (distance (estpos self (time goal))
				    (position goal)))) ) )

(observation (list (position vector) (time number)) )

(sum-count-ifa (sequence (listof real))
  prop   ((accumulator  ((list 0 0)) result sum-and-count)
	  (initial-value  ((list 0 0)) result sum-and-count))
  supers (ifa-framework))

(words-count-ifa (sequence (listof string))
  prop   ((accumulator    ((list nil 0)) result words-and-count)
	  (initial-value  ((list nil 0)) result words-and-count))
  supers (ifa-framework))

; 28 Sep 99; see also ctr.lsp and addprop.lsp for myavl1
(mystringcount-ifa (sequence (listof string))
  prop   ((accumulator    (nil) result myavl1)
	  (initial-value  (nil) result myavl1))
  supers (ifa-framework))

(myfilecount-ifa (sequence file-of-words-generator)
  prop   ((accumulator  (nil) result myavl1)
	  (itemview     ('string-downcase)) )
  supers (ifa-framework))

; 07 Oct 99; 12 Oct 99
(mystringsum-ifa (sequence (listof (list (name string) (n integer))))
  prop   ((accumulator    (nil) result myavl2) )
  supers (ifa-framework))

; 21 Oct 99
(mystringsumcount-ifa (sequence (listof (list (name string) (n integer))))
  prop   ((accumulator    (nil) result myavl3) )
  supers (ifa-framework))

(myalist-ifa (sequence (listof (list (name symbol) (n integer))))
  prop   ((accumulator    (nil) result alist1))
  supers (ifa-framework))

  ) ; glispobjects

; 04 Mar 97; 06 Mar 97; 31 Mar 98; 02 Apr 98; 09 Apr 98; 30 Apr 98; 27 May 98
; 15 Sep 98
; Generic Input-Filter-Accumulate program
(gldefun ifa-sum ((ifa ifa-framework))
  (let ((acc (typeof (accumulator ifa))))
    (acc = (initialize acc))
    (for item in (sequence ifa)
	 when (filter ifa item)
	 do   (update ifa acc (value ifa item)))
    (final-value acc)))

; 14 Jan 99; 15 Jan 99; 26 Aug 99
; Generic Find-Update program
(gldefun fminu-find ((fu fminu-framework) goal)
  (let (target)
    (target =
      (for item in (sequence fu)
	 when (filter fu item)
	 min  (distance fu item goal)))
    (update fu (value fu target) goal)
    target))

; 26 Aug 99
(gldefun find-update-add ((self find-update) item)
  (let (record)
    (record = (find self item))
    (update record item) ))

; (gldefun td ((z fu-avl-count) (s string)) (add z s))

; 30 Sep 97
; Need to make this more generic:
; 1. Find (insert if necessary) needed record
; 2. Update the record
(gldefun avl-string-count-insert-count
         ((tr AVL-STRING-COUNT-AS-AVLTR-POINTER) (word string))
  (let (elt)
    (tr = (insert-key tr word))
    (elt = (member tr word))
    ((count (implementation (^. elt))) _+ 1)
    tr))

; backward cons, with list argument first.
(gldefun bcons ((lst (listof anything)) (item anything))
  (result (typeof lst))
  (cons item lst))

; optimization pattern to change bcons back into cons
(gldefpatterns 'glpatterns '(((bcons x y)           (cons y x)) ))

(gldefun countem (n thing) (1+ n))
(setf (glinline 'countem) t)

(gldefun update-ifa-sum ((ifa update-ifa) acc item)
  (let (entry)
    (acc = (insert-key acc item))    ; insert the new item into accumulator
    (entry = (member acc item))      ; find the item's entry
    (update entry item)                ; update the entry: need a view here
    acc))                              ; return the accumulator

; 28 Jan 99
(gldefun movobj-update ((fu anything) (self movobj) (newpos observation))
  (let ((oldpos (position self)))
    ((position self) = (position newpos))
    ((velocity self) = (lowpassv (velocity self)
				   (- (position newpos) oldpos)
				   (lowpassfactor self)))
    ((lasttime self) = (time newpos))
    self))

; ***** rounds since vector is integers
(gldefun lowpassv ((old vector) (new vector) (f real)) (result real)
  (+ (* old (- 1.0 f)) (* new f)))


; (t1 '(2 13 77))
(gldefun t1 ((l sum-ifa)) (sum l))
; (t1b '(2 13 77))
(gldefun t1b ((l odd-sum-ifa)) (sum l))
; (t1c '(2 13 77))
(gldefun t1c ((l odd-sum-squares-ifa)) (sum l))
; (t2 (list #'sin 0 (/ pi 2) 0.01))
(gldefun t2 ((i param-integral-ifa)) (sum i))
; (t2b nil)
(gldefun t2b ((i integral-ifa)) (sum i))
; (t2c (let (l) (dotimes (i 157 l) (push (sin (+ 0.005 (* 0.01 i))) l))))
(gldefun t2c ((l list-integral-ifa)) (sum l))
; (t3 nil)
(gldefun t3 ((i sin-integral-ifa)) (sum i))
; (t3b nil)
(gldefun t3b ((i constant-integral-ifa)) (sum i))
; (viewas 'linked-list 'box)
; (t4 mybox)
(gldefun t4 ((b box-size-ifa)) (sum b))
; (t4b mybox)
(gldefun t4b ((b box-name-list-ifa)) (sum b))
; (ld kwic)
; (ap-make-carrier-type 'avl-tree '((contents string)) 'lisp
;                       'avl-tree-of-string)
; (t5 "now is the time for all good men to come to the aid of their party")
(gldefun t5 ((l word-list-ifa))
  (let ((acc (sum l))) (for item in acc (print (contents item)))))
; (ap-make-carrier-type 'avl-tree '((contents string) (count integer)) 'lisp
;                       'avl-string-count '((sort-value contents)))
; (viewas 'avl-tree 'AVL-STRING-COUNT)
; (gladdprop 'AVL-STRING-COUNT-AS-AVLTR-POINTER 'msg
;            '(insert-count avl-string-count-insert-count))
; (t6 "to be or not to be: that is the question")
(gldefun t6 ((l word-count-ifa))
  (let ((acc (sum l)))
    (for item in acc
	 (format t "~A ~D~%" (contents item) (count item)) ) ))
; (t7 '("Quoth" "the" "raven"))
(gldefun t7 ((l strings-ifa)) (sum l))
; (t8 "/u/novak/foo.del")
(gldefun t8 ((l word-file-ifa))
  (let ((acc (sum l))) (for item in acc (print (contents item)))))
; (t9 "/u/novak/foo.del")
(gldefun t9 ((l file-count-ifa))
  (let ((acc (sum l)))
    (for item in acc
	 (format t "~A ~D~%" (contents item) (count item)) ) ))
; (t10 '(400 440 440 440 400))
(gldefun t10 ((l list-histogram-ifa)) (sum l))
; Print items from an avl-tree-of-string
(gldefun avlpr ((tr avl-tree-of-string)) (for x in tr (print (contents x))))
; (t11 '(1 3 6 9 22) 8)  ; find item closest to 8
(gldefun t11 ((l li-fmin) (n integer)) (find l n))
; (t12 '((1 1) (2 2) (3 4) (4 3)) '(2.1 1.9))  ; find item closest to (2.1 1.9)
(gldefun t12 ((l lv-fmin) (v vector)) (find l v))
; (t13 '((a (1 1)(-1 -1) 3) (b (2 2)(1 1) 3) (c (4 3)(1 1) 3)) '((2.9 3.1) 4))
(gldefun t13 ((l mo-fmin) (v observation)) (find l v))
; (t14 '(3.5 1.2 2.7))
(gldefun t14 ((l sum-count-ifa)) (sum l))
; (t15 '("now" "is" "the" "time"))
(gldefun t15 ((l words-count-ifa)) (sum l))
; (glclonetype 'myavl) ; see ctr.lsp
; (gladdtype 'myavl1 'counter)
; (setf (getf (cdr (glstr 'myavl1)) 'msg)
; '((update (glambda (self ptr val) (update (counter1 ptr))))) )
; (t16 '("a" "b" "c" "a" "b" "b" "d" "e" "f" "e" "f" "f" "f"))
(gldefun t16 ((l mystringcount-ifa)) (sum l))
; (t17 "/u/novak/papers/dict/aiessay.tex")
(gldefun t17 ((l myfilecount-ifa))
  (let ((acc (sum l)))
    (for item in acc (format t "~A ~D~%" (s item) (n1 item))) ))
; (glclonetype 'myavl)
; (gladdtype 'myavl2 'adder)
; (setf (getf (cdr (glstr 'myavl2)) 'msg)
; '((update (glambda (self ptr val) (update (adder1 ptr) (n val))))) )
; (setf (getf (cdr (glstr 'myavl2)) 'prop) '((keyvaluefn ('name))))
; (t18 '(("a" 3)("b" 7) ("a" 2)))
(gldefun t18 ((l mystringsum-ifa))
  (let ((acc (sum l)))
    (for item in acc (format t "~A ~D~%" (s item) (sum1 item))) ))
; (glclonetype 'myavl)
; (gladdtype 'myavl3 'adder)
; (gladdtype 'myavl3 'counter)
; (setf (getf (cdr (glstr 'myavl3)) 'msg)
; '((update (glambda (self ptr val) (update (adder3 ptr) (n val))
; 		                    (update (counter2 ptr))))))
; (setf (getf (cdr (glstr 'myavl3)) 'prop) '((keyvaluefn ('name))))
; (t19 '(("a" 3)("b" 7) ("a" 2)))
(gldefun t19 ((l mystringsumcount-ifa))
  (let ((acc (sum l)))
    (for item in acc (format t "~A ~D ~D~%" (s item) (sum3 item) (n2 item)))))
; (glclonetypes '((keytype)
;    ((alistentry (list (key keytype)))
;     (alist (listof alistentry) supers (alist-accumulator))))
;    '(symbol))
; (gladdtype 'ALISTENTRY1 'adder)
; (setf (getf (cdr (glstr 'ALIST1)) 'msg)
; '((update (glambda (self ptr val) (update (adder4 ptr) (n val))))))
; (setf (getf (cdr (glstr 'ALIST1)) 'prop) '((keyvaluefn ('name))))
(gldefun t42 ((l myalist-ifa))
 (let ((acc (sum l)))
  (for item in acc (format t "~A ~D~%" (key item) (sum4 item)))))
; (t42 '((a 3) (b 2) (c 4) (a 4) (c 1)))
