; ifaspec.lsp              Gordon S. Novak Jr.            ; 19 Jan 04

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 07 May 98; 11 May 98; 22 May 98; 02 Jun 98; 03 Jun 98; 28 Jul 98; 13 Oct 98
; 15 Oct 98; 19 Oct 98

; (instpat 'ifa1 ifapat)  ; instantiate a pattern based on a frame

; Example from ifa.lsp:
;
;(sum-ifa (input (listof integer))
;  prop   ((accumulator  (0) result integer-accumulator))
;  supers (ifa-framework))
;
;(gldefun t1 ((l sum-ifa)) (sum l))

; 11 May 98
; Define a program spec using a frame representation
; Each property has optional value facet, then proplist format: facet value ...
(defun defspeca (lst)
  (let ((name (pop lst)))
    (dolist (propval lst)
      (setf (get name (car propval))
	    (if (oddp (length (cdr propval)))
		(cons 'value (cdr propval))
	        (cdr propval))) ) ))

; ??? not used anywhere.
(defspeca 
  '(ifa-top
     (input-type   abstract-type (sequence anything))
     (item-type    (typeof (sequence-item (input-type self))))
     (output-type  (typeof (accumulator self)))
     (localvars    (union-subs self localvars))
     (accumulator  hints (sum (item-type self)))
     ))

(defspeca
  '(ifa1
     (input-type        (listof integer))
     (accumulator-type  integer-accumulator)
     ))

(defspeca
  '(ifa2
     (input-type        (listof integer))
     (accumulator-type  integer-accumulator)
     (initial-value     7)
     ))

(defspeca
  '(ifa3
     (input-type        (listof integer))
     (accumulator-type  integer-accumulator)
     (filterfn          oddp)
     ))

(defspeca
  '(ifa4
     (input-type        (listof integer))
     (accumulator-type  integer-accumulator)
     (filterfn          oddp)
     (valuefn           square)
     ))

(defspeca
  '(ifa5
     (input-type        (arrayof integer))
     (accumulator-type  integer-accumulator)
     (filterfn          oddp)
     (valuefn           square)
     ))

(defspeca
  '(ifa6
     (input-type        (listof person))
     (accumulator-type  real-accumulator)
     (valuefn           salary)
     ))

(defspeca
  '(ifa7
     (input-type        (listof integer))
     (accumulator-type  sat-accumulator)
     ))


(gldefun square ((x integer)) (result integer) (* x x))

; Program patterns: (args item ... item)
; args produce bindings: name to frame.  self arg is automatic.
; items are: (type name pattern)
;            (function name pattern)
; New names are gensym'ed and the original names are bound to them.
; The new types and functions are instantiated by evaluating the patterns.
; patterns use the conventions:
;   (? form)           Look up value of form
;   (?? form pattern)  If form evaluates non-nil, do pattern.
; 26 May 98
(setq ifapat
  '(()
    (type ifa-instance
	  (input (? (input-type self)))
	  prop ((accumulator (nil) result (? accum))
		(?? (filterfn self)
		    (filterfn ('(? (filterfn self))))))
	;;;	    (filter (glambda (self itm) ((? (filterfn self)) itm)))
          msg  ((?? (valuefn self)
		    (value (glambda (self itm) ((? (valuefn self)) itm)))))
	  supers (ifa-framework))
    (type accum (? (strof (accumulator-type self)))
	  prop ((?? (initial-value self)
		    (initial-value  ((? (initial-value self)))
				    result (? accum))))
	  supers ((? (accumulator-type self))))
    (function ifasum (inp\: (? ifa-instance)) (sum inp)) ))

; 11 May 98
; Instantiate types and functions from a pattern.
(defun instpat (frame pattern &optional args)
  (let (bindings inst name lst fns types)
    (setq bindings
	  (cons (cons 'self frame)
		(mapcar #'cons (car pattern) args)))
; Make gensyms for types and functions in pattern
    (dolist (item (cdr pattern))
      (push (cons (cadr item) (gentemp (symbol-name (cadr item))))
	    bindings))
    (dolist (item (cdr pattern))
      (setq name (cdr (assoc (cadr item) bindings)))
      (setq lst (cons name (fsublis (cddr item) bindings)))
      (case (car item)
	(type (eval (list 'glispobjects lst))
	      (push name types))
	(function (eval (cons 'gldefun lst))
		  (push name fns)) ) )
    (list types fns) ))

; 07 May 98; 11 May 98
; Pattern substitution function
; Pattern notation:
;   (? form)           Look up value of form, with inheritance
;   (?? form pattern)  If form is non-nil, without inheritance, do pattern.
(defun fsublis (form bindings)
  (let (pair)
    (if (atom form)
	form
        (if (and (eq (car form) '?) (cdr form))
	    (fsubliseval (cadr form) bindings)
	    (if (and (eq (car form) '??) (cddr form))
		(and (fsubliseval (cadr form) bindings)
		     (fsublis (caddr form) bindings))
	        (cons (fsublis (car form) bindings)
		      (fsublis (cdr form) bindings))) ) ) ))

; 07 May 98; 11 May 98; 04 Jun 98; 28 Jul 98
; Evaluate a form for substitution
; arg            looked up in bindings
; (prop arg)     looked up from arg using fget
; (fn arg1 ...)  fn called on values of args
(defun fsubliseval (form bindings)
  (let (pair args)
    (if (atom form)
	(if (setq pair (assoc form bindings))
	    (cdr pair)
	    nil)
        (progn
	  (setq args (mapcar #'(lambda (x) (fsubliseval x bindings))
			     (cdr form)))
	  (if (car args)
	      (or (fget (car args) (car form))
		  (and (fboundp (car form))
		       (apply (car form) args)) ) ) ) ) ))

; 11 May 98
; Get a frame feature
(defun fget (frame slot &optional (facet 'value))
  (getf (get frame slot) facet))

(defun strof (type) (car (glstr type)))

; 13 Oct 98; 15 Oct 98; 03 Nov 98
; Instantiate a type based on substitutions
; pattern  = Glisp type form with places for type substitution
;            prop's have the name of the prop sub as 2nd element symbol
; typesubs = alist of type and structure substitutions
; propsubs = prop substitutions
; (glinsttype ifapatb '((inputtype . (listof integer))
;                       (acctype . integer-accumulator))
;	              '((filterfn ('oddp)) (itemview ('square))) )
(defun glinsttype (pattern typesubs propsubs)
  (let (newpat newprops pr supersflg tmp newtype)
    (setq newpat (sublis typesubs pattern))
    (setq newprops
      (mapcar
        #'(lambda (x)
	    (if (atom x)
		(progn (setq supersflg (eq x 'supers))
		       x)
	        (if supersflg
		    x
	            (mapcan
		      #'(lambda (prop)
			 (if (symbolp (cadr prop))
			     (if (setq pr (assoc (cadr prop) propsubs))
				 (progn
				   (setq newprops (cdr pr))
				   (setq tmp (cddr prop))
				   (while tmp
				     (unless (getf (cdr newprops) (car tmp))
				       (setq newprops
					     (append newprops
						     (list (car tmp)
							   (cadr tmp)))))
				     (setq tmp (cddr tmp)) )
				   (list (cons (car prop) newprops)) )
			         nil)  ; omit unspecified props
			     (list prop)))
		      x))))
	(cddr newpat)))
    (setq newtype (gentemp (symbol-name (car newpat))))
    (gldefstr (cons newtype (cons (cadr newpat) newprops) ) nil)
    newtype))
