;   mathpat.lsp              Gordon S. Novak Jr.           ; 29 Feb 12

; Copyright (c) 2012 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; Math simplification patterns

; 19 Oct 94; 05 Jan 95; 02 Jan 97; 03 Jan 00; 03 Mar 04; 11 Mar 04; 20 Apr 04
; 23 Apr 04; 27 Apr 04; 07 Jun 04; 08 Jun 04; 14 Dec 05; 28 Dec 05; 28 Dec 05
; 07 Feb 07; 30 Oct 09

(gldefpatterns 'math
'(
((* (sin ?x) (cos ?x))     (* 1/2 (sin (* 2 ?x))))
((* (cos ?x) (sin ?x))     (* 1/2 (sin (* 2 ?x))))

((- ?x ?x)                 0)
((+ ?x ?n)                 (+ ?n ?x)     (numberp ?n))
((+ 0 ?x)                  ?x)
((+ 0 ?x ?y)               (+ ?x ?y))
((+ 0 ?x ?y ?z)            (+ ?x ?y ?z))
((- 0 ?x)                  (- ?x))
((+ 0.0 ?x)                ?x)
((+ 0.0 ?x ?y)             (+ ?x ?y))
((+ 0.0 ?x ?y ?z)          (+ ?x ?y ?z))
((1+ (+ ?n ?x))            (+ (1+ ?n) ?x)     (numberp ?n))
((1+ (- ?n ?x))            (- (1+ ?n) ?x)     (numberp ?n))
((1+ (- ?x ?n))            (- ?x (1- ?n))     (numberp ?n))
((1- (+ ?n ?x))            (+ (1- ?n) ?x)     (numberp ?n))
((1- (- ?n ?x))            (- (1- ?n) ?x)     (numberp ?n))
((1- (- ?x ?n))            (- ?x (1+ ?n))     (numberp ?n))
((+ ?n (1+ ?x))            (+ (1+ ?n) ?x)     (numberp ?n))
((- ?n (1+ ?x))            (- (1- ?n) ?x)     (numberp ?n))
((- (1+ ?x) ?n)            (- ?x (1- ?n))     (numberp ?n))
((+ ?n (1- ?x))            (+ (1- ?n) ?x)     (numberp ?n))
((- ?n (1- ?x))            (- (1+ ?n) ?x)     (numberp ?n))
((- (1- ?x) ?n)            (- ?x (1+ ?n))     (numberp ?n))
((+ (- ?n ?x) (- ?m ?y))     (- (+ ?n ?m) (+ ?x ?y)) (and (numberp ?n) (numberp ?m)))
((- ?n (- ?m ?x))           (+ (- ?n ?m) ?x) (and (numberp ?n) (numberp ?m)) )
((+ ?n (- ?m ?x))           (- (+ ?n ?m) ?x) (and (numberp ?n) (numberp ?m)))
((+ ?n (+ ?m ?x))           (+ (+ ?n ?m) ?x) (and (numberp ?n) (numberp ?m)))
((- ?x ?n)                 (+ (- ?n) ?x)     (numberp ?n))
((+ (+ ?n ?x) (+ ?m ?y))     (+ (+ ?n ?m) (+ ?x ?y)) (and (numberp ?n) (numberp ?m)))
((- ?n (+ ?m ?x))           (- (- ?n ?m) ?x) (and (numberp ?n) (numberp ?m)))
((- (- ?x ?y))             (- ?y ?x))
((- (- ?x ?y) ?y)           (- ?x (* 2 ?y)))
((- (- ?x ?y) ?z)           (- ?x (+ ?y ?z)))              ; 19 Oct 94 ?
((- (* ?n ?x))             (* (- ?n) ?x)     (numberp ?n))
((- (/ ?n ?x))             (/ (- ?n) ?x)     (numberp ?n))
((+ (- ?n ?x) ?y)           (+ ?n (- ?y ?x))     (numberp ?n))
((- ?x (- ?n ?y))           (+ (- ?n) (+ ?x ?y))     (numberp ?n))
((- (- ?n ?x) ?y)           (- ?n (+ ?x ?y))     (numberp ?n))
((- (* ?n ?x) (* ?n ?y))     (* ?n (- ?x ?y))     (numberp ?n))
((+ (* ?n ?x) (* ?n ?y))     (* ?n (+ ?x ?y))     (numberp ?n))
((- (+ ?x ?y) ?x)           ?y)
((- (+ ?x ?y) ?y)           ?x)
((- (+ ?x ?y) (+ ?y ?x))    0)
((- ?x (- ?x ?y))           ?y)
((- ?x (+ ?x ?y))           (- ?y))
((- (* ?n ?x) (+ ?x ?y))     (- (* (- ?n 1) ?x) ?y)     (numberp ?n))
((- (* ?n ?x) (- ?x ?y))     (+ (* (- ?n 1) ?x) ?y)     (numberp ?n))
((- ?x (* ?n (- ?x ?y)))     (+ (* (- 1 ?n) ?x) (* ?n ?y))     (numberp ?n))
((min ?x (+ ?x ?y))         (+ ?x (min 0 ?y)))     
((min ?x (+ ?y ?x))         (+ ?x (min 0 ?y)))
((max ?x (+ ?x ?y))         (+ ?x (max 0 ?y)))
((max ?x (+ ?y ?x))         (+ ?x (max 0 ?y)))
((- ?x ?n)                 (+ (- ?n) ?x)     (numberp ?n))
((- (+ ?x ?y) ?x)           ?y)
((- (+ ?y ?x) ?x)           ?y)
((+ ?x (- ?y ?x))           ?y)
((- ?x (+ ?n ?y))           (+ (- ?n) (- ?x ?y))     (numberp ?n))
((- ?x (+ ?y ?n))           (+ (- ?n) (- ?x ?y))     (numberp ?n))
((* ?x ?n)                 (* ?n ?x)     (numberp ?n))
((* ?n (+ ?m ?x))           (+ (* ?m ?n) (* ?n ?x))(and (numberp ?n) (numberp ?m)) )
((* ?n (- ?m ?x))           (- (* ?m ?n) (* ?n ?x))(and (numberp ?n) (numberp ?m)) )
((* ?n (/ ?x ?m))           (* (/ ?n ?m) ?x)(and (numberp ?n) (numberp ?m)) )
((* ?n (/ ?m ?x))           (/ (* ?n ?m) ?x)(and (numberp ?n) (numberp ?m)) )
((* ?n (* ?m ?y))           (* (* ?n ?m) ?y)(and (numberp ?n) (numberp ?m)) )
((* ?n (+ (* ?m ?x) (* ?k ?y))) (+ (* (* ?n ?m) ?x) (* (* ?n ?k) ?y))(and (numberp ?n) (numberp ?m)) )
((* ?n (- (* ?m ?x) (* ?k ?y))) (- (* (* ?n ?m) ?x) (* (* ?n ?k) ?y))(and (numberp ?n) (numberp ?m)) )
((* 1 ?x)                 ?x)
((* 1.0 ?x)               ?x)
((* -1 ?x)                (- ?x))
((* -1.0 ?x)              (- ?x))
((* 0 ?x)                 0)
((* 0.0 ?x)               0)
((* (- ?x) ?y)             (- (* ?x ?y)))
((* ?x (- ?y))             (- (* ?x ?y)))
((- (- ?x))               ?x)
((* ?x (* ?n ?y))           (* ?n (* ?x ?y))     (numberp ?n))
((* (* ?n ?x) ?y)           (* ?n (* ?x ?y))     (numberp ?n))
((* ?x (/ ?n ?y))           (* ?n (/ ?x ?y))     (numberp ?n))
((* (/ 1 ?y) ?x)           (/ ?x ?y))
((* ?x (/ 1 ?y))           (/ ?x ?y))
((* (/ 1.0 ?y) ?x)         (/ ?x ?y))
((* ?x (/ 1.0 ?y))         (/ ?x ?y))
((* ?x ?x)                 (expt ?x 2))
((* (/ ?n ?y) ?x)           (* ?n (/ ?x ?y))
                              (and (numberp ?n) (not (numberp ?y))) )
((* ?x (/ ?n ?y))           (* ?n (/ ?x ?y))     (numberp ?n))
((* ?x (/ ?y ?x))           ?y)
((* (/ ?y ?x) ?x)           ?y)
((* ?x (+ (/ ?y ?x) (/ ?z ?x))) (+ ?y ?z))
((* ?x (- (/ ?y ?x) (/ ?z ?x))) (- ?y ?z))
((* (+ (/ ?y ?x) (/ ?z ?x)) ?x) (+ ?y ?z))
((* (- (/ ?y ?x) (/ ?z ?x)) ?x) (- ?y ?z))
((/ 0 ?x)                   0)
((/ ?x ?x)                  1)
((/ ?n (* ?m ?x))           (/ (/ ?n ?m) ?x)
                              (and (numberp ?n) (numberp ?m) (not (zerop ?m))))
((/ (* ?n ?x) ?m)           (* (/ ?n ?m) ?x)
                              (and (numberp ?n) (numberp ?m) (not (zerop ?m))))
((/ (* ?n ?x) ?y)           (* ?n (/ ?x ?y))     (numberp ?n))
((/ (/ ?n ?x) ?m)           (/ (/ ?n ?m) ?x)
                              (and (numberp ?n) (numberp ?m) (not (zerop ?m))))
((/ (+ ?n ?x) ?m)           (+ (/ ?n ?m) (/ ?x ?m))
                              (and (numberp ?n) (numberp ?m) (not (zerop ?m))))
((/ (- ?n ?x) ?m)           (- (/ ?n ?m) (/ ?x ?m))
                              (and (numberp ?n) (numberp ?m) (not (zerop ?m))))
((/ ?x ?n)                  (* (/ 1 ?n) ?x)
                              (and (numberp ?n) (not (zerop ?n))))
((/ ?x (expt ?x 2))         (/ 1 ?x))
((/ (expt ?x 2) ?x)         ?x)
((/ (* ?x ?y) ?x)           ?y)
((/ (* ?x ?y) ?y)           ?x)
((/ ?x (* ?x ?y))           (/ 1 ?y))
((/ ?x (* ?y ?x))           (/ 1 ?y))
((/ (* ?x ?y) (* ?z ?x))     (/ ?y ?z))
((/ (* ?x ?y) (* ?x ?z))     (/ ?y ?z))
((/ (* ?y ?x) (* ?z ?x))     (/ ?y ?z))
((/ (* ?y ?x) (* ?x ?z))     (/ ?y ?z))
((/ (- ?x (* ?y ?z)) ?y)     (- (/ ?x ?y) ?z))
((/ (- ?x (* ?y ?z)) ?z)     (- (/ ?x ?z) ?y))
((/ (- (* ?y ?z) ?x) ?y)     (- ?z (/ ?x ?y)))
((/ (- (* ?y ?z) ?x) ?z)     (- ?y (/ ?x ?z)))
((/ (+ ?x (* ?y ?z)) ?y)     (+ (/ ?x ?y) ?z))
((/ (+ ?x (* ?y ?z)) ?z)     (+ (/ ?x ?z) ?y))
((/ (+ (* ?y ?z) ?x) ?y)     (+ ?z (/ ?x ?y)))
((/ (+ (* ?y ?z) ?x) ?z)     (+ ?y (/ ?x ?z)))
((/ (+ (/ ?x ?y) (/ ?x ?z)) ?x) (+ (/ 1 ?y) (/ 1 ?z)))
((/ (- (/ ?x ?y) (/ ?x ?z)) ?x) (- (/ 1 ?y) (/ 1 ?z)))
((/ 1 (/ ?x ?y))             (/ ?y ?x))
((/ ?x (/ ?y ?z))            (/ (* ?x ?z) ?y))
((/ ?x (* ?n ?y))            (* (/ 1 ?n) (/ ?x ?y))
                                 (and (numberp ?n) (not (zerop ?n))))
((+ ?x (* ?n ?x))            (* (1+ ?n) ?x)      (numberp ?n))
((+ (* ?n ?x) ?x)            (* (1+ ?n) ?x)      (numberp ?n))
((- ?x (* ?n ?x))            (* (- 1 ?n) ?x)     (numberp ?n))
((- (* ?n ?x) ?x)            (* (1- ?n) ?x)      (numberp ?n))
((+ (* ?x ?y) (* ?z ?y))     (* (+ ?x ?z) ?y))
((- (* ?x ?y) (* ?z ?y))     (* (- ?x ?z) ?y))
((+ (* ?y ?x) (* ?z ?y))     (* (+ ?x ?z) ?y))
((- (* ?y ?x) (* ?z ?y))     (* (- ?x ?z) ?y))
((+ (* ?x ?y) (* ?y ?z))     (* (+ ?x ?z) ?y))
((- (* ?x ?y) (* ?y ?z))     (* (- ?x ?z) ?y))
((+ (* ?y ?x) (* ?y ?z))     (* (+ ?x ?z) ?y))
((- (* ?y ?x) (* ?y ?z))     (* (- ?x ?z) ?y))
((+ ?x (- ?y))               (- ?x ?y))
((* (expt ?x 2) (/ ?y ?x))   (* ?x ?y))
((* (/ ?y ?x) (expt ?x 2))   (* ?x ?y))
((truncate (/ ?x ?y))        (truncate ?x ?y))
((sqrt (* ?n ?x))            (* (sqrt ?n) (sqrt ?x))
                             (and (numberp ?n) (glsqrtable ?n)) )
((sqrt (/ ?x ?n))            (* (/ 1.0 (sqrt ?n)) (sqrt ?x))
                             (and (numberp ?n) (glsqrtable ?n)) )
((sqrt (/ ?n ?x))            (/ (sqrt ?n) (sqrt ?x))
                             (and (numberp ?n) (glsqrtable ?n)) )
((sqrt (expt ?x 2))          ?x)   ; (abs ?x) ? but causes trouble for physics
((sqrt (/ (expt ?x 2) (expt ?y 2)))    (/ ?x ?y))
((* (sqrt (/ ?x (* ?y ?z))) ?z) (sqrt (/ (* ?x ?z) ?y)) )
((* (sqrt (/ ?x (* ?y ?z))) ?y) (sqrt (/ (* ?x ?y) ?z)) )
((* (sqrt (/ ?x ?y)) ?y)     (sqrt (* ?x ?y)))
((/ (sqrt ?x) (sqrt ?y))     (sqrt (/ ?x ?y)))
((/ (sqrt (* ?x ?y)) ?x)     (sqrt (/ ?y ?x)))
((/ (sqrt (* ?x ?y)) ?y)     (sqrt (/ ?x ?y)))
((/ ?x (sqrt (* ?x ?y)))     (sqrt (/ ?x ?y)))
((/ ?y (sqrt (* ?x ?y)))     (sqrt (/ ?y ?x)))
((expt (sqrt ?x) 2)          ?x)   ; (abs ?x) ?
((cbrt (* ?n ?x))            (* (cbrt ?n) (cbrt ?x))
                             (and (numberp ?n) (glcbrtable ?n)) )
((cbrt (/ ?x ?n))            (* (/ 1.0 (cbrt ?n)) (cbrt ?x))
                             (and (numberp ?n) (glcbrtable ?n)) )
((cbrt (/ ?n ?x))            (/ (cbrt ?n) (cbrt ?x))
                             (and (numberp ?n) (glcbrtable ?n)) )
((cbrt (expt ?x 3))          ?x)
((expt (cbrt ?x) 3)          ?x)
((expt ?x 1)                 ?x)
((expt ?x 0)                 1)
((expt ?x -1)                (/ 1 ?x))
((expt (- ?x) 2)             (expt ?x 2))
((expt (* ?n ?x) ?m)         (* (expt ?n ?m) (expt ?x ?m))
                             (and (numberp ?n) (numberp ?m) (glq>=0 ?n)) )
((expt (* ?x ?n) ?m)         (* (expt ?n ?m) (expt ?x ?m))
                             (and (numberp ?n) (numberp ?m) (glq>=0 ?n)) )
((expt (/ ?n ?x) ?m)         (/ (expt ?n ?m) (expt ?x ?m))
                             (and (numberp ?n) (numberp ?m) (glq>=0 ?n)) )
((expt (/ ?x ?n) ?m)         (/ (expt ?x ?m) (expt ?n ?m))
                             (and (numberp ?n) (numberp ?m) (glq>0 ?n)) )
((expt (/ ?x ?y) ?m)         (/ (expt ?x ?m) (expt ?y ?m))    (numberp ?m))
((* ?x (expt ?x ?n))         (expt ?x (1+ ?n))     (numberp ?n))
((* (expt ?x ?n) ?x)         (expt ?x (1+ ?n))     (numberp ?n))
((/ (expt ?x ?n) ?x)         (expt ?x (1- ?n))     (numberp ?n))
((* (expt ?x ?n) (/ 1 ?x))   (expt ?x (1- ?n))     (numberp ?n))
((* (/ 1 ?x) (expt ?x ?n))   (expt ?x (1- ?n))     (numberp ?n))
((* (expt ?x ?m) (expt ?x ?n))       (expt ?x (+ ?m ?n))
                             (and (numberp ?n) (numberp ?m)) )
((expt (* ?x ?y) 2)          (* (expt ?x 2) (expt ?y 2)))
((expt (/ ?x ?y) 2)          (/ (expt ?x 2) (expt ?y 2)))
((atan (* ?n ?y) (* ?n ?z))  (atan ?y ?z) (and (numberp ?n) (glq/=0 ?n)) ) 
((atan (sin ?x) (cos ?x))    ?x)
((atan (cos ?x) (sin ?x))    (- (/ pi 2.0) ?x))
((cos (- (/ pi 2.0) ?x))         (sin ?x))
((sin (- (/ pi 2.0) ?x))         (cos ?x))
((cos (- 1.5707963267948966 ?x)) (sin ?x))
((sin (- 1.5707963267948966 ?x)) (cos ?x))
((/ (sin ?x) (cos ?x))           (tan ?x))
((/ (cos ?x) (sin ?x))           (/ 1 (tan ?x)))
((* (/ ?x (cos ?y)) (sin ?y))    (* ?x (tan ?y)))
((* (sin ?y) (/ ?x (cos ?y)))    (* ?x (tan ?y)))
((/ (* (sin ?y) ?x) (cos ?y))    (* ?x (tan ?y)))
((/ (* ?x (sin ?y)) (cos ?y))    (* ?x (tan ?y)))
; Commented out: these can lead to loop; do not decrease size  08 Jun 04
;((- (* ?n ?x) (* ?m ?y))         (* ?n (- ?x (* (/ ?m ?n) ?y)))
;                                 (and (numberp ?n) (numberp ?m)
;				      (or (floatp ?n) (floatp ?m)
;					  (= (mod ?m ?n) 0)))  )
;((- (* ?n ?x) (* ?m ?y))         (* ?m (- (* (/ ?n ?m) ?x) ?y))
;			         (and (numberp ?n) (numberp ?m)
;				      (= (mod ?n ?m) 0)) )
;((+ (* ?n ?x) (* ?m ?y))         (* ?n (+ ?x (* (/ ?m ?n) ?y)))
;			         (and (numberp ?n) (numberp ?m)
;				      (or (floatp ?n) (floatp ?m)
;					  (= (mod ?m ?n) 0))) )
;((+ (* ?n ?x) (* ?m ?y))         (* ?m (+ (* (/ ?n ?m) ?x) ?y))
;			         (and (numberp ?n) (numberp ?m)
;				      (= (mod ?n ?m) 0)) )
((- (* ?n ?x) (* ?m ?x))         (* (- ?n ?m) ?x)
                                   (and (numberp ?n) (numberp ?m)) )
((+ (* ?n ?x) (* ?m ?x))         (* (+ ?n ?m) ?x)
                                   (and (numberp ?n) (numberp ?m)) )


((= (+ ?x ?y) ?x)          (= ?y 0))     ; 14 Oct 92
((= (+ ?x ?y) ?y)          (= ?x 0))
((= (- ?x ?y) ?x)          (= ?y 0))
((= ?x (+ ?x ?y))          (= ?y 0))
((= ?y (+ ?x ?y))          (= ?x 0))
((= ?x (- ?x ?y))          (= ?y 0))

((= (* ?n ?x) (* ?m ?y))   (= ?x (* (/ ?m ?n) ?y))   ; 28 Apr 94
                           (and (numberp ?n) (numberp ?m)
				(glq/=0 ?n)) )
((= (/ ?n ?x) ?y)          (= ?n (* ?x ?y))     (numberp ?n))
((= ?y (/ ?n ?x))          (= ?n (* ?x ?y))     (numberp ?n))
((= (/ ?n ?x) (/ ?m ?y))   (= (* ?m ?x) (* ?n ?y))
                           (and (numberp ?n) (numberp ?m)) )
((= ?n (* ?m ?x))          (= ?x (/ ?n ?m))
                           (and (numberp ?n) (numberp ?m) (glq/=0 ?m)) )

))
