; mkvtest.lsp            Gordon S. Novak Jr.       ; 19 Jan 04

; Copyright (c) 2009 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; Declarations, programs, and data for testing MKV

;17 Nov 94; 05 Jan 95

(glispobjects

(cone (listobject (radius number)
		  (height number))
  prop ((side        ((sqrt radius ^ 2 + height ^ 2)))
	(volume      (pi * radius ^ 2 * height / 3.0))
	(side-area   (pi * radius * side))
	(bottom-area (pi * radius ^ 2))
	(total-area  (pi * radius * (radius + side))) ) )

(xmas-tree (listobject (total-height real)
		       (branches-height real)
		       (kind symbol)
		       (base-radius real))
  prop ((trunk-height (total-height - branches-height))))

(cmas-tree (crecord cmas-tree
		    (total-height real)
		    (branches-height real)
		    (kind integer)
		    (base-radius real))
  prop ((trunk-height (total-height - branches-height))))

(ls1 (listobject (low real)  (size real)   (angle real) (right real)))
(ls2 (listobject (left real) (right real)  (angle real) (up real)))
(ls3 (listobject (left  (units integer foot))
		 (right (units real    foot))
		 (angle (units real    degrees))
		 (up    (units integer foot))))
(ls4 (listobject (pt consv) (del integer) (slope real)))
(ls5 (listobject (start vector) (angle real) (length real)))
(twopts (list (from consv) (to consv)))

(tworth    (list (from rthvector) (to rthvector)))  ; two r-theta vectors
(cls1 (crecord cls1 (low real) (size real) (angle real) (right real)))

(halfpenny (listobject (halfradius real))
  prop ((r (halfradius * 2))))

(meterv (list (x (units real meter)) (y (units real meter)) )
  supers (vector))

(footrth (list (r (units real foot)) (theta real)))

) ; glispobjects


(setq myxt (an xmas-tree with total-height 7.0 branches-height 6.0
                              kind 'scotch-pine base-radius 2.0))
; (mkv 'cone 'xmas-tree)
(gldefun tcone ((x xmas-tree)) (side-area (cone x)))
; (tcone myxt)  ; = 39.73835

(setq myls1 (a ls1 with low 150 size 100.0 angle (/ pi 6)
                        right (+ 100 (* 100 (cos (/ pi 6))))))

(setq myls2 (a ls2 with left 100       right (+ 100 (* 100 (cos (/ pi 6))))
	                angle (/ pi 3) up 200))

(setq myls5 (a ls5 start (a vector x 100 y 150) angle (/ pi 6) length 100.0))

; (mkv 'line-segment 'ls1)
; Choose p1y = low, length = size, theta = angle, p2x = right
(gldefun tls1 ((l ls1) (p consv)) (leftof-distance (line-segment l) p))
; (tls1 myls1 '(100 . 200))  ; = 43.301
(gldefun tls1m ((l ls1)) (materialize (line-segment l)))
; (tls1m myls1)  ; = ((100 150) (187 200))

; (mkv 'line-segment 'ls2)
; Choose p1x = left, p2x = right, phi = angle, p2y = up
(gldefun tls2 ((l ls2) (p vector)) (leftof-distance (line-segment l) p))
; (tls2 myls2 '(100 200))    ; = 43.301

; (mkv 'line-segment 'ls5)
; Choose p1 = start, theta = angle, length = length
(gldefun tls3 ((l ls5) (p vector)) (leftof-distance (line-segment l) p))
; (tls3 myls5 '(100 200))    ; = 43.301

; (gleqns-transfer-by-view 'ls2 'ls1)

(defun torth (x y) (list (sqrt (+ (* x x) (* y y))) (atan y x)))
(setq mytwo (list (torth 100 150) (torth (+ 100 (* 100 (cos (/ pi 6)))) 200)))
(gldefun tvect1 ((l tworth) (p rthvector))
  (leftof-distance (line-segment l) (vector p)))
; (mkv 'vector 'rthvector)
; (mkv 'line-segment 'tworth)
; (tvect1 mytwo (torth 100 200))    ; = 43.301

; (mkv 'line-segment 'cls1)
(gldefun tls4 ((l cls1) (p cvector)) (leftof-distance (line-segment l) p))
; (gltoc 'tls4)

; a roundabout way to transfer data through views.
(gldefun tls5 ((l ls1))
  (let ((ll (line-segment l)))
    (a (typeof (line-segment (a ls2)))
       with p1x (p1x ll) p1y (p1y ll) p2x (p2x ll) p2y (p2y ll))))

(gldefun tls6 ()
  (a (typeof (line-segment (a ls5))) with p1x = 3 p1y = 4  p2x = 30  p2y = 40))

; (mkv 'circle 'halfpenny) ; and select r = r
(gldefun thp1 ((h halfpenny)) (area (circle h)))
(gldefun thp2 ((h halfpenny)) (glsend (circle h) (radius  1)))
(gldefun thp3 ((h halfpenny)) (a (typeof (circle h)) with radius 2.0))
; = (LAMBDA (H) (COPY-LIST '(HALFPENNY 0.0))) ; lost the radius *************

; Create a new vector twice as big
(gldefun vector-double ((v vector))
  (a (typeof v) with x = ((x v) * 2)  y = ((y v) * 2)) )

(gladdprop 'vector 'msg '(double vector-double open t))

; Create a new line-segment with same first point, double in size.
(gldefun line-segment-double ((l line-segment))
  (a (typeof l) with p1x = (p1x l) p1y = (p1y l)
     p2x = ((p2x l) + (deltax l))
     p2y = ((p2y l) + (deltay l)) ))

(gladdprop 'line-segment 'msg '(double line-segment-double open t))
(gldefun tls7 ((l line-segment)) (double l))
(gldefun tls8 ((l ls1)) (double (line-segment l)))
(gldefun tls9 ((l tworth)) (double (line-segment l)))
; = (LAMBDA (L) (LIST (COPY-LIST '(0.0 0.0)) (COPY-LIST '(0.0 0.0)))) ; ******
(gldefun tls10 ((v vector)) (double v))
(gldefun tls11 ((v rthvector)) (double (vector v))) ; long but works

; (mkv 'vector 'footrth)
; (mkv 'vector 'meterv)
; (gleqns-transfer-by-view 'footrth 'meterv)
; (glfn * 'tls12)
; (gleqns-transfer-by-view 'meterv 'footrth)
; (glfn * 'tls13)
