; physan.lsp          Gordon S. Novak Jr.               ; 08 Jun 04

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.

; Analysis of diagrams and tasks of Physics AP problems

; 24 Feb 04; 10 Mar 04; 15 Mar 04; 16 Mar 04; 18 Mar 04; 19 Mar 04; 22 Mar 04
; 24 Mar 04; 29 Mar 04; 30 Mar 04; 31 Mar 04; 01 Apr 04; 02 Apr 04; 05 Apr 04
; 06 Apr 04; 07 Apr 04; 08 Apr 04; 09 Apr 04; 10 Apr 04; 11 Apr 04; 12 Apr 04
; 13 Apr 04; 14 Apr 04; 20 Apr 04; 22 Apr 04; 23 Apr 04; 29 Apr 04; 03 May 04
; 03 Jun 04; 04 Jun 04; 07 Jun 04

; Solved 93   Green 110   Yellow 48   Red 6   Total 257    as of 6/04/04

(defvar *probdata* )

(defun apd1 (lst)
  (let ( (sums '((- 0 0) (c 0 0) (n 0 0) (m 0 0) (r 0 0) (x 0 0))) )
    (dolist (item lst)
      (setq tmp (assoc (cadr item) sums))
      (if tmp
	  (if (caddr item)
	      (incf (cadr tmp))
	      (incf (caddr tmp)) ) ) )
    (list (length lst) sums)))

; problem number, diagram code, is diagram necessary, solution status,
; list of: physics principles, math/procedural tasks, diagram tasks
; list of comments
; diagram codes: - none, n network, c components, m metric, r hard, x very hard
; solution codes: nil = not solved, t = solved, c = covered

(setq *probdata* '(
; prob  diag nec solv tasks
(physap01  - nil t (solve fall))
(physap02  c t   g (spline deriv)
	             ("definition of accelaration as d2/dt2"))
(physap03  c nil t (solve inclined-plane))
(physap04  c nil t (solve fall))
(physap05  c nil g (weight friction sum-forces))
(physap06  c nil t (collide-and-stick simplify))
(physap07  m t   y (sum-torques simplify metric)
                     ("Symbolic quantities."
		      "Yellow: must be able to iterate over forces"))
(physap08  - nil t (ideal-gas change))
(physap09  c t   g (ideal-gas)
                     ("Work is integral under the PV curve."
		      "Must have diagram pre-specified or input it."))
(physap10  c t   g (charge-dir metric))
(physap11  n t   g (network series-resistors resistor))
(physap12  n t   g (network series-resistors resistor capacitor))
(physap13  c nil t (fluid-flow inequality)
	             ("bogo-bernoulli; diagram"))
(physap14  c nil g (right-hand-rule superposition simplify))
(physap15  c nil g (sound tryit))
(physap16  - nil t (solve light))
(physap17  r t   r (lens-ray)
	             ("Hard to input and understand ray diagrams."
		      "It's doable, but is it worth the effort?"
		      "Could be a combination of component/metric diagrams."))
(physap18  - nil g (light sum-energy change))
(physap19  - nil g (photoelectric change)
	             ("This is a case where we need a good assumed value"
		      "for the frequency / wavelength of the light."))
(physap20  - nil g (km atom))
(physap21  r nil y (free-body projectile)
                     ("Draw free-body diagram."
		      "Yellow: linked situations with changing configuration"))
(physap22  m t   y (spline harmonic-motion interpolate back-interpolate
                      projectile)
                     ("Relate graph to pendulum/harmonic motion."
		      "Yellow: linked situations, relate representations."))
(physap23  - nil g (resistor series-resistors sum)
                     ("brightness vs. power"))
(physap24  m t   g (lens-ray metric)
                     ("Draw ray diagram."))
(physap25  c t   y (electric-field magnetic-field metric)
                     ("Draw path of charged particle."
		      "Yellow: linked situations."))
(physap26  r nil y (buoyancy spring)
                     ("Yellow: experiment design, linked situations."))
(physap27  c nil y (light compton-scatter)
                     ("energy conservation?"
		      "Yellow: linked situations."))
(phys93b01 - nil g (uniform-motion circular-motion projectile))
(phys93b02 - nil g (sum-forces acceleration weight))
(phys93b03 - nil t (solve spring))
(phys93b04 c nil g (gravity-kinetic)
	             ("Rough -> energy loss due to friction."
		      "gravity-kinetic gives max height on other side."))
(phys93b05 - nil t (solve fall))
(phys93b06 - nil t (change weight circular-motion))
(phys93b07 c nil g (force-symmetry momentum))
(phys93b08 c nil g (sphere force-symmetry gravitation)
                     ("Different sizes of spheres imply different masses."))
(phys93b09 - nil g (harmonic-motion pendulum))
(phys93b10 - nil g (collide-and-stick)
                     ("Could generate numeric values for the masses."))
(phys93b11 - nil y (collision sum-momentum)
                     ("This is a hard problem, both in the way the question"
		      "is stated and in the physical situation, which is"
		      "unusual.  Answer (C) contradicts the given facts."))
(phys93b12 c nil g (km curved-motion))
(phys93b13 - nil g (km superconductor))
(phys93b14 - nil y (km electronics)
                     ("Few humans got this one (21%)."
		      "Even with some KM knowledge about Kirchoff's laws,"
		      "it isn't likely that this would be represented."))
(phys93b15 n t   g (network parallel-capacitors series-capacitors))
(phys93b16 n t   t (solve capacitor))
(phys93b17 c t   g (parallel-plates)
                     ("Diagram requires understanding the differences"
		      "among the 3 points -- perhaps a metric diagram."))
(phys93b18 c t   g (right-hand-rule))
(phys93b19 c nil y (right-hand-rule wire-magnetic superposition)
	             ("Hard because it requires looking at all points in"
		      "the plane.  Could choose a few test points."))
(phys93b20 n t   g (solve network series-resistors resistor))
(phys93b21 n t   t (solve resistor))
(phys93b22 n t   t (solve resistor))
(phys93b23 - nil t (solve thermo-system))
(phys93b24 - nil t (solve heat-transfer))
(phys93b25 - nil t (solve heat-transfer))
(phys93b26 c t   g (km lens))
(phys93b27 c nil t (solve wave))
(phys93b28 c nil t (solve wave)
                     ("wave vs. string-wave"))
(phys93b29 - nil g (km light-km solve light)
	             ("Need approximate wavelength of kinds of radiation."
		      "Top-to-bottom order (could just do end points)."))
(phys93b30 - nil g (km soundkm))
(phys93b31 m nil g (lens-ray))
(phys93b32 - nil g (nuclear-equations))
(phys93b33 - nil g (km atom))
(phys93b34 m t   t (energybands))
(phys93b35 m t   g (energybands light)
	             ("Must relate band numbers to energy change."
		      "Find max of answers."))
(phys93b36 - nil t (solve radioactive-decay))
(phys93b37 - nil g (km experiments))
(phys93b38 - nil g (km experiments))
(phys93b39 - nil t   (solve relativity)
                     ("Out of scope for current syllabus?"))
(phys93b40 - nil g (km relativity))
(phys93b41 c t   t (meta-change wire-magnetic)
                     ("Need to relate change to the graph provided."))
(phys93b42 - nil g (gravitation electric-dipole meta-change)
	             ("We can answer directly for gravitation and dipole,"
		      "either by manipulating equations or by trying changes."
		      "For nuclear force, we don't know; assume NO."))
(phys93b43 c t   g (pendulum harmonic-motion deriv)
	             ("This might be done from knowledge base (in which"
		      "case it would be necessary to relate the graph to it)"
		      "or on a purely math basis using deriv."
		      "Diagram might be metric."))
(phys93b44 - nil t (lift))
(phys93b45 c nil t (weight-pulley))
(phys93b46 - nil y (curved-motion)
                     ("This is a hard problem because it involves"
		      "an accelerating reference frame and an object"
		      "sliding (with friction inferred) in that frame."
		      "Lots of world knowledge."))
(phys93b47 - nil g (multi-solve spring kinetic-energy sum-energy))
(phys93b48 - nil t (solve gravitation))
(phys93b49 c t   g (relativity)
	             ("Out of scope for current syllabus?"))
(phys93b50 n nil g (network resistor series-resistors parallel-resistors
			      tryit)
	             ("Could be solved by trying values."))
(phys93b51 - nil t (units))
(phys93b52 - nil t (light)
	             ("Need to know that radar is electromagnetic wave."))
(phys93b53 - nil g (photoelectric))
(phys93b54 - nil g (km atom))
(phys93b55 - nil t   (heat-engine))
(phys93b56 - nil y (km atom)
                     ("Few humans got this one (19%)."
		      "Interpretation A was introduced later by de Broglie."))
(phys93b57 m t   g (sum-torques)
	             ("Could solve for point of equilibrium as in ISAAC."))
(phys93b58 - nil t (change sound)
	             ("Loudness is not a known variable here."))
(phys93b59 m t   g (superposition piecewise-linear))
(phys93b60 - nil y (km light)
                     ("Hard to relate question/answers to stored knowledge."))
(phys93b61 c nil t (solve weight))
(phys93b62 c nil t (solve inclined-plane))
(phys93b63 c nil t (solve lift))
(phys93b64 c nil g (km projectile)
	             ("These 3 problems could be analyzed by km or"
		      "by equations, or some combination."))
(phys93b65 c nil g (km projectile))
(phys93b66 c nil g (km projectile))
(phys93b67 c nil g (multi-solve square resistor magnetic-field))
(phys93b68 c nil t (change electric-field))
(phys93b69 - nil g (km lens converging-lens)
	             ("Combines equational and symbolic reasoning"))
(phys93b70 c nil g (km electrostatics change charged-sphere)
	             ("Need to know that charge flows from high potential"
		      "to low"))
(phys93b71 m t   g (piecewise-linear weight acceleration free-body plot
		      uniform-acceleration))
(phys93b72 m t   g (solve charged-sphere superposition vector-sum plot
                      electric-dipole))
(phys93b73 r t   y (parallel-plates capacitor charge-magnetic solve
                      magnetic-km multi-situation)
                      ("Spatial reasoning; indirect questions."))
(phys93b74 c t   y (solve light refraction light-km plot)
                      ("Draw ray diagrams, different for red and blue."
		       "Second vacuum prism is unusual."))
(phys93b75 m t   y (piecewise-linear ideal-gas thermo-system heat-engine)
	             ("Curve could be approximated by piecewise linear,"
		      "but exact shape of curve isn't needed."
		      "Yellow: linked situations, indirect questions."))
(phys93b76 r nil y (multi-solve light battery compton-scatter)
	             ("Might be a component diagram."
		      "Yellow: linked situations."))
(phys98b01 - nil g (change fall gravity-kinetic momentum))
(phys98b02 - nil t (solve lift))
(phys98b03 - nil t (solve collide-and-stick))
(phys98b04 r nil y (change momentum)
                     ("Easy if modeled as collide-and-stick; need world"
		      "knowledge to know how to model it."))
(phys98b05 - nil t (units))
(phys98b06 - nil t (solve circular-motion))
(phys98b07 - nil y (km mechanics)
                     ("Could be KM, could perhaps use an equation."
		      "Weak solution: no knowledge that II and III are true."
		      "Stronger: visualize a situation that is in equilibrium"
                      "but where II and III are false."))
(phys98b08 c t   y (spline km pendulum)
                     ("One way to do it is just to have knowledge of what"
		      "the PE and KE graphs look like for harmonic motion."
		      "This would use 'component' diagrams."
		      "(Problem: we might not have some 'distractor' diagrams)"
		      "Another way is to use an equation Total = KE + PE,"
		      "make a function for the input curve, derive a function"
		      "for the output curve, compare with answers."
		      "The latter is better but more work."))
(phys98b09 - nil t (solve friction-weight)
                     ("match g vs. numeric value or use symbolic g"))
(phys98b10 - nil y (km atom)
                     ("May be hard to match question against KM knowledge."))
(phys98b11 - nil g (km experiments))
(phys98b12 - nil g (km atom))
(phys98b13 - nil g (solve electric-field))
(phys98b14 - nil t (change capacitor))
(phys98b15 n t   g (network series-resistors parallel-resistors))
(phys98b16 n t   g (network series-resistors resistor))
(phys98b17 c t   g (electric-dipole square superposition vector-sum))
(phys98b18 c t   g (electric-dipole square superposition))
(phys98b19 c nil g (rectangle magnetic-field))
(phys98b20 - nil t (solve resistor))
(phys98b21 c t   g (charge-dir))
(phys98b22 c t   y (gas-work)
                     ("This could be a metric diagram or finessed with a"
		      "component diagram."
		      "Work = area under PV curve, so this is easy for"
		      "a human to see; how to represent curves on computer?"))
(phys98b23 c t   g (ideal-gas))
(phys98b24 - nil t (solve thermo-system))
(phys98b25 - nil g (thermo-state-change))
(phys98b26 - nil t (solve concave-mirror))
(phys98b27 - nil t (change light)
                     ("Need to know that water has higher index of refraction"
		      "than air."))
(phys98b28 - nil t (solve converging-lens))
(phys98b29 c nil y (km waves)
                     ("Yellow: question form, untrue statements."))
(phys98b30 c nil t (solve converging-lens)
                     ("Also need a rule for real vs. virtual image."
		      "Assumed numeric values for multiples of f."))
(phys98b31 c t   y (refraction)
	             ("Could use refraction equations and assume numeric"
		      "values, or perhaps have KM rules."))
(phys98b32 - nil t (solve radioactive-decay))
(phys98b33 - nil g (nuclear-equations))
(phys98b34 - nil t (change elementary-particle))
(phys98b35 - nil y (km experiments))
(phys98b36 m t   g (spline interpolate radioactive-decay))
(phys98b37 - nil t (change light))
(phys98b38 c nil g (multi-solve spring sum-energy))
(phys98b39 - nil t (change gravitation))
(phys98b40 - nil t (solve gravitation))
(phys98b41 c nil g (collision momentum sum-momentum))
(phys98b42 c nil y (refraction)
                     ("This is a fairly difficult problem."
		      "Diagram might be component but might be metric."))
(phys98b43 c t   g (spline deriv momentum)
	             ("Must interpret distance vs. time graph as velocity,"
		      "relate velocity to momentum"))
(phys98b44 c t   g (spline deriv acceleration)
	             ("Must interpret distance vs. time graph as"
		      "acceleration, relate to force"))
(phys98b45 r nil y (magnetic-field circle)
                     ("Difficult diagram and also some one-off concepts:"
		      "stretching spring, rotating spring."
		      "Basic idea: relate induced current to flux change."))
(phys98b46 - nil g (charge-magnetic))
(phys98b47 - nil t (solve charge-magnetic)
	             ("Must look up and use charge and mass of proton."
		      "Current given is irrelevant."))
(phys98b48 c nil g (right-hand-rule))
(phys98b49 m t   y (solve sound)
                     ("Diagram is hard, but could be solved using only"
		      "location of points and without curved waves."))
(phys98b50 c t   y (lens-ray))
(phys98b51 c nil t   (solve diffraction))
(phys98b52 c t   g (change ideal-gas)
	             ("This problem requires some inequality reasoning."
		      "It could be done by assuming some change,"
		      "e.g. factor of 2 in P and V."))
(phys98b53 - nil t (change ideal-gas))
(phys98b54 - nil g (solve conglomerate circle km atom)
                     ("Need to have estimated size of an atom."))
(phys98b55 - nil t (change photoelectric)
	             ("Need to call change to try the various options."))
(phys98b56 - nil t (solve harmonic-motion)
                     ("The problem is recognizing this as harmonic motion"
		      "from the information given.  Need to match up the"
		      "parameters in the given formula a = A*sin(omega*t)"))
(phys98b57 - nil t (solve momentum)
                     ("Direction information is irrelevant."))
(phys98b58 m t   y (sum-torques)
                     ("Metric diagram, symbolic solution."))
(phys98b59 c nil t (solve fall))
(phys98b60 c nil t (gravity-kinetic kinetic-energy sum-energy)
                     ("For an expert human, this is obvious by inspection,"
		      "without actually doing any math."))
(phys98b61 - nil y (km ideal-gas-km)
                     ("Hard to match up answers with stored knowledge"))
(phys98b62 - nil t (change ideal-gas))
(phys98b63 - nil g (force-symmetry momentum)
	             ("Have to try the various answers."
		      "It is likely that the system will fail to verify"
		      "the wrong answers rather than falsifying them."))
(phys98b64 - nil t (change capacitor)
                     ("Have to say what is constant to get the right answer."))
(phys98b65 c nil t (multi-solve circle wire))
(phys98b66 m t   g (magnetic-field containment)
	             ("Problem is easy based on the fact that EMF depends"
		      "only on flux contained, which is equal."
		      "How to represent this?"))
(phys98b67 c t   g (vector-sum force-symmetry momentum))
(phys98b68 c nil y (vector-components sum-torques))
(phys98b69 - nil y (km atom)
	             ("Hard to match question to stored knowledge."))
(phys98b70 - nil t (solve capacitor))
(phys98b71 m t   y (multi-situation rope acceleration uniform-acceleration
				      projectile)
                     ("Might want a connected-bodies method."))
(phys98b72 m t   y (rope electric-field weight free-body sum-forces
			   vector-components acceleration plot))
(phys98b73 x t   r (gravity-kinetic heat-transfer)
                     ("Hard problem."))
(phys98b74 n t   g (resistor series-resistors parallel-resistors)
                     ("Assume diagram is entered as a network."
		      "Task 4a is trivial and should be ignored."
		      "Relate brightness to power."
		      "Lightbulb removed = open or infinite resistance."))
(phys98b75 m t   g (string-wave))
(phys98b76 m t   y (pendulum projectile plot))
(phys98b77 r t   y (diffraction bohr-model change))
(phys98b78 c t   y (wire-magnetic magnetic-field electric-field multi-solve))
(prin01    - nil y (km mechanics)
                     ("A tricky question - one almost has to imagine"
		      "circular motion at constant speed but with"
		      "nonzero acceleration."
		      "The way the problem is stated is also tricky."))
(prin02    - nil g (multi-solve fall))
(prin03    - nil t (solve circular-motion)
                     ("Had to assume a value for mass to get it to work."))
(prin04    - nil g (km mechanics)
                     ("Each of the first 4 could have a notation that it is"
		      "a vector quantity."))
(prin05    c t   t (solve inclined-plane))
(prin06    c t   t (solve fall inclined-plane))
(prin07    c t   g (km mechanics)
                     ("A trick question: asks for work by the NORMAL force."))
(prin08    - nil t (meta-change gravitation))
(prin09    - nil t (change capacitor)
                     ("Have to know what things to keep constant."))
(prin10    - nil t (solve wave))
(prin11    - nil t (change concave-mirror)
                     ("Note that we had to specify a focal length assumption"
		      "to keep from dividing by zero in change."
		      "The method used by change is the same one shown in"
		      "the suggested answer in the Princeton book."))
(prin12    c t   t (energybands))
(prin13    - nil t (solve thermo-system)
	             ("Had to say that energy change is 0.  Need to put"
		      "that in equations or infer from 'isothermal'."))
(prin14    - nil t (solve sound)
                     ("Could be done using solve or change."))
(prin15    c t   t (solve weight-pulley))
(prin16    - nil g (force-symmetry symmetric-forces)
                     ("This could be solved by KM and/or equations."))
(prin17    - nil t (solve float))
(prin18    c t   g (meta-change electric-dipole acceleration))
(prin19    - nil t (solve spring))
(prin20    - nil t (solve lift))
(prin21    - nil g (km atom change charge-magnetic))
(prin22    - nil t (change gravitation))
(prin23    - nil y (solve acceleration)
                     ("This is a problem that is easy but only if approached"
		      "in the right way.  There are infinitely many ways"
		      "to combine 4 forces; the question is which could NOT"
		      "be the answer.  One of the answers exceeds the maximum"
		      "possible sum, so it is easy to rule out."))
(prin24    - nil t (solve heat-engine))
(prin25    - nil t (change string-wave))
(prin26    - nil t (solve resistor))
(prin27    m t   g (multi-solve electric-dipole)
	             ("Need to know that this is solved as the difference of"
		      "the works of bringing the charge in from infinity."))
(prin28    m t   t (change electric-dipole))
(prin29    - nil t (solve heat-transfer))
(prin30    - nil t (change light))
(prin31    c nil g (change magnetic-field right-hand-rule))
(prin32    - nil g (meta-change elementary-particle)
	             ("Need a method for answer matching."))
(prin33    c t   y (sum-torques triangle))
(prin34    - nil g (km state-change))
(prin35    - nil g (change diffraction))
(prin36    - nil g (nuclear-equations))
(prin37    n t   g (network resistor series-resistors parallel-resistors))
(prin38    n t   g (network resistor))
(prin39    - nil g (solve sound soundkm)
	             ("This can be done from equations if one knows what"
		      "questions to ask, but perhaps it is better done"
		      "with KM by specifying no relative motion as the"
		      "condition for no doppler shift."))
(prin40    - nil t (units)
	             ("Need to be able to convert L, M, T to units."))
(prin41    - nil g (km light-km))
(prin42    - nil g (multi-solve kinetic-energy gravitation))
(prin43    - nil g (km magnetic-km)
	             ("A trick question: numerical values given, but the"
		      "answer is trivial because the proton's speed is"
		      "not changed by the magnetic field."))
(prin44    - nil g (multi-solve sound)
                     ("Have to solve in 2 steps; can't just use"
		      "<TT>change</TT> with decibels."))
(prin45    - nil g (solve electric-dipole superposition)
	             ("Need to double the value for one charge."))
(prin46    - nil g (km collision momentum acceleration)
                     ("Could be done by KM or by equations."))
(prin47    - nil t (solve projectile))
(prin48    c nil g (km pendulum))
(prin49    - nil t (solve gravitation))
(prin50    - nil g (km experiments)
                     ("Answers are difficult to understand."))
(prin51    c t   g (wire-magnetic right-hand-rule))
(prin52    - nil g (lens-ray)
                     ("This problem could be solved by a trivial equation."))
(prin53    - nil t (change ideal-gas)
                     ("Answer encoding is different."))
(prin54    - nil y (nuclear-equations)
                     ("This problem defines a new, procedural term."
		      "If we have the term pre-defined, it is easy."
		      "If we have to acquire and use definitions, that is"
		      "harder."))
(prin55    - nil t (solve capacitor))
(prin56    - nil t (solve work-energy))
(prin57    - nil g (km ideal-gas-km)
	             ("isochoric = constant volume; word is not in Serway."
		      "The question is easy but answers hard to understand."))
(prin58    - nil t (solve lift))
(prin59    - nil r (momentum km collision)
                     ("Nearly impossible for the computer to solve this."
		      "Too much world knowledge required."))
(prin60    - nil t (solve fluid-flow))
(prin61    - nil g (solve converging-lens lens-ray))
(prin62    - nil y (km experiments)
                     ("Probably the answer has to be stored to get this."))
(prin63    c nil y (charge-dir)
                     ("Possibly should be a KM task."))
(prin64    - nil t (solve nuclear-reaction))
(prin65    - nil t (solve capacitor))
(prin66    c nil g (km heat)
                     ("Easy problem but hard to know how to solve it."))
(prin67    r nil r (magnetic-km resistor)
                     ("very hard problem: geometry, world knowledge"))
(prin68    - nil g (km light-km)
                     ("Easy lookup if data is stored."))
(prin69    - nil g (superposition))
(prin70    - nil y (sum-torques)
                     ("Difficult to imagine locations of the forces."
		      "Answer matching somewhat difficult."))
(prin71    r nil y (solve spring projectile harmonic-motion))
(prin72    r nil y (resistor series-resistors heat-transfer
			       thermo-state-change plot km heat))
(prin73    r t   r (lens-ray sphere refraction uniform-motion)
                     ("Difficult diagram, difficult output diagram."))
(prin74    r t   r (charge-magnetic electric-field right-hand-rule
		      circular-motion kinetic-energy)
                     ("Difficult diagram, difficult problem since a new"
		      "experimental apparatus is described."))
(prin75    c t   y (inclined-plane weight-pulley)
                     ("These tasks don't quite have the combination"
		      "that is needed for this problem."
		      "Good example of setting up a physics problem."
		      "We should try to do this one."))
(prin76    m t   y (collision sum-momentum heat)
                     ("Diagram is somewhat difficult."))
)) 

(defvar *probanswers* nil)
(setq *probanswers* '(
(physap01  b (num (3 s) (5 s) (6 s) (12 s) (25 s)))
(physap02  c (labels (A) (B) (C) (D) (E)))
(physap03  e (num (0.1 N) (0.4 N) (2.5 N) (5.0 N) (10.0 N)))
(physap04  c (num (7 m/s) (10 m/s) (14 m/s) (20 m/s) (100 m/s)))
(physap05  e (num (1 N) (3 N) (4 N) (5 N) (7 N)))
(physap06  a (expr 0
		   (/ |v| 2)
		   (/ (* (sqrt 2) |v|) 2)
		   (/ (* (sqrt 3) |v|) 2)
		   (/ (* 3 |v|) 2) ))
(physap07  c (nil () () () () ()))
(physap08  c (nil () () () () ()))
(physap09  b (nil () () () () ()))
(physap10  e (nil () () () () ()))
(physap11  b (num (0 A) (0.6 A) (1.2 A) (2.0 A) (3.0 A)))
(physap12  b (num (0 V) (6 V) (12 V) (60 V) (120 V)))
(physap13  b (nil () () () () ()))
(physap14  a (nil () () () () ()))
(physap15  d (nil () () () () ()))
(physap16  c (num (4e-7 m/s) (9e-7 m/s) (2e8 m/s) (3e8 m/s) (4e8 m/s)))
(physap17  d (nil () () () () ()))
(physap18  d (nil () () () () ()))
(physap19  b (nil () () () () ()))
(physap20  e (nil () () () () ()))

(phys93b01 d (nil () () () () ()))
(phys93b02 b (expr (- |g| |b|)
		   (- |g| (/ (* |b| |v|) |m|))
		   (+ |g| (/ (* |b| |v|) |m|))
		   (/ |g| |b|)
		   (/ (* |b| |v|)) ))
(phys93b03 e (num (0.33 N/m) (0.66 N/m) (6.6 N/m) (33 N/m) (66 N/m)))
(phys93b04 e (nil () () () () ()))
(phys93b05 c (num (1.5 m/s2) (3.0 m/s2) (6.0 m/s2) (10.0 m/s2) (12.0 m/s2)))
(phys93b06 c (nil () () () () ()))
(phys93b07 e (terms (Speed) (Velocity) (Acceleration) (Kinetic energy)
		    (Magnitude of momentum)))
(phys93b08 e (terms (Acceleration) (Velocity) (Kinetic energy)
		    (Displacement from the center of mass)
		    (Gravitational force)))
(phys93b09 a (nil () () () () ()))
(phys93b10 d (nil () () () () ()))
(phys93b11 b (nil () () () () ()))
(phys93b12 b (nil () () () () ()))
(phys93b13 c (nil () () () () ()))
(phys93b14 b (terms (Conservation of charge) (Conservation of energy)
		    (Ampere's law) (Faraday's law) (Ohm's law)))
(phys93b15 d (num (10/7 uF) (3/2 uF) (7/3 uF) (7 uF) (14 uF)))
(phys93b16 b (num (350 uC) (500 uC) (710 uC) (1100 uC) (1800 uC)))
(phys93b17 b (nil () () () () ()))
(phys93b18 e (terms (to the left) (to the right) (toward the wire)
		    (into the page) (out of the page)))
(phys93b19 e (nil () () () () ()))
(phys93b20 d (num (1.2 v) (6.0 v) (10.8 v) (12.0 v) (13.2 v)))
(phys93b21 c (num (1.2 v) (6.0 v) (10.8 v) (12.0 v) (13.2 v)))
(phys93b22 a (num (0.36 W) (1.2 W) (3.2 W) (3.6 W) (4.8 W)))
(phys93b23 c (num (100 J) (200 J) (350 J) (400 J) (450 J)))
(phys93b24 c (num (0 degC) (4 degC) (8 degC) (10 degC) (20 degC)))
(phys93b25 b (num (4000 J/s) (4800 J/s) (6000 J/s) (9600 J/s) (16000 J/s)))
(phys93b26 b (nil () () () () ()))
(phys93b27 d (num (0.4 m/s) (2.5 m/s) (5 m/s) (10 m/s) (20 m/s)))
(phys93b28 b (num (1 Hz) (2.5 Hz) (5 Hz) (7.5 Hz) (10 Hz)))
(phys93b29 b (nil () () () () ()))
(phys93b30 a (terms (Longitudinal) (Transverse) (Torsional) (Electromagnetic)
		    (Polarized)))
(phys93b31 e (labels (A) (B) (C) (D) (E)))
(phys93b32 b (num (2) (3) (4) (5) (6)))
(phys93b33 a (nil () () () () ()))
(phys93b34 d (notmem (1 eV) (2 eV) (3 eV) (4 eV) (5 eV)))
(phys93b35 e (nil () () () () ()))
(phys93b36 d (num (2.5 years) (5 years) (10 years) (15 years)
		  (It depends on the original amount of cobalt 60)))
(phys93b37 c (terms (Interference of light in thin films)
		    (Electromagnetic radiation) (Photoelectric effect)
		    (Electron diffraction) (X-ray diffraction)))
(phys93b38 c (nil () () () () ()))
(phys93b39 d (num (3e-2 s) (3e-3 s) (3e-4 s) (3e-5 s) (3e-6 s)))
(phys93b40 c (expr (+ |c| |v|)
		   (- |c| |v|)
		   |c|
		   (/ |v| (sqrt (- 1 (/ (expt |v| 2) (expt |c| 2)))))
		   (* |c| (sqrt (- 1 (/ (expt |v| 2) (expt |c| 2))))) ))
(phys93b41 a (nil () () () () ()))
(phys93b42 c (nil () () () () ()))
(phys93b43 a (num (1 s) (2 s) (3 s) (4 s)
		  (None of the above \, because acceleration is constant)))
(phys93b44 e (expr (* |m| |g|)
		   (* |m| |h|)
		   (* |m| (* |g| |h|))
		   (* |m| (* |g| (* |h| |t|)))
		   (/ (* |m| (* |g| |h|)) |t|) ))
(phys93b45 b (expr Zero (/ |g| 4) (/ |g| 3) (* 2/3 |g|) |g|))
(phys93b46 e (nil () () () () ()))
(phys93b47 d (expr (/ (expt |v0| 2) (* 2 |g|))
		   (* (/ (* |m| |g|) |k|) |v0|)
		   (* (/ |m| |k|) |v0|)
		   (* (sqrt (/ |m| |k|)) |v0|)
		   (* (sqrt (/ |k| |m|)) |v0|) ))
(phys93b48 d (num (zero) (1.0 m/s2) (1.9 m/s2) (3.7 m/s2) (9.8 m/s2)))
(phys93b49 b (nil () () () () ()))
(phys93b50 b (nil () () () () ()))
(phys93b51 c (num (8 coulombs) (8 newtons) (8 joules) (8 calories)
		  (8 (* newton amperes))))
(phys93b52 e (num (1e-10 Hz) (1e6 Hz) (1e8 Hz) (3e8 Hz) (1e10 Hz)))
(phys93b53 d (nil () () () () ()))
(phys93b54 a (nil () () () () ()))
(phys93b55 a (num (40 %) (60 %) (67 %) (150 %) (167 %)))
(phys93b56 a (nil () () () () ()))
(phys93b57 d (labels (A) (B) (C) (D) (E)))
(phys93b58 c (nil () () () () ()))
(phys93b59 a (nil () () () () ()))
(phys93b60 c (nil () () () () ()))
(phys93b61 d (num (1.0 kg) (1.2 kg) (1.6 kg) (2.0 kg) (2.5 kg)))
(phys93b62 c (num (10 N) (12 N) (16 N) (20 N) (33 N)))
(phys93b63 b (num (20 J) (60 J) (80 J) (100 J) (130 J)))
(phys93b64 d (nil () () () () ()))
(phys93b65 e (nil () () () () ()))
(phys93b66 a (nil () () () () ()))
(phys93b67 a (expr (/ (* I R) (expt |a| 2))
		   (/ (* I (expt |a| 2)) R)
		   (/ (* I |a|) R)
		   (/ (* R |a|) I)
		   (* (* I R) |a|) ))
(phys93b68 b (times (8) (4) (2) (1) (1/2)))
(phys93b69 d (nil () () () () ()))
(phys93b70 e (nil () () () () ()))

(phys98b01 b (terms (inertia) (speed) (momentum) (kinetic energy)
		    (change in potential energy)))
(phys98b02 c (num (1.1 W) (87.5 W) (560 W) (875 W) (5600 W)))
(phys98b03 e (expr (/ |v| 2)
		   (/ (* |m| |v|) M)
		   (/ (* M |v|) |m|)
		   (/ (* (+ |m| M) |v|) |m|)
		   (/ (* |m| |v|) (+ |m| M)) ))
(phys98b04 c (nil () () () () ()))
(phys98b05 c (nil () () () () ()))
(phys98b06 e (num (9 (/ (* N m) kg)) (12 (/ m2 s)) (13.5 (/ (* kg m2) s2))
		  (18 (/ (* N m) kg)) (24 (/ (* kg m2) s))))
(phys98b07 a (nil () () () () ()))
(phys98b08 d (nil () () () () ()))
(phys98b09 a (expr (* (* (* |mu| |m|) |g|) |v|)
		   (* (* |m| |g|) |v|)
		   (/ |v| (* (* |mu| |m|) |g|))
		   (/ (* (* |mu| |m|) |g|) |v|)
		   (* (* |mu| |m|) (expt |v| 2)) ))
(phys98b10 a (nil () () () () ()))
(phys98b11 b (nil () () () () ()))
(phys98b12 a (nil () () () () ()))
(phys98b13 a (nil () () () () ()))
(phys98b14 e (num (800 N/C) (1600 N/C) (2400 N/C) (5000 N/C) (20000 N/C)))
(phys98b15 a (num (4/3 ohm) (2 ohm) (11/4 ohm) (4 ohm) (6 ohm)))
(phys98b16 e (nil () () () () ()))
(phys98b17 c (nil () () () () ()))
(phys98b18 d (expr Zero
		   (* (/ (sqrt 2) (* (* 4 pi) |epsilon0|)) (/ (* |q| Q) |d|))
		   (* (/ 1 (* (* 4 pi) |epsilon0|)) (/ (* |q| Q) |d|))
		   (* (/ 2 (* (* 4 pi) |epsilon0|)) (/ (* |q| Q) |d|))
		   (* (/ (* 2 (sqrt 2)) (* (* 4 pi) |epsilon0|))
		      (/ (* |q| Q) |d|)) ))
(phys98b19 c (num (zero) (2e-3 (* T m2)) (8e-3 (* T m2)) (2e-1 (* T m2))
		  (8e-1 (* T m2))))
(phys98b20 d (num (2.4 cents) (4.8 cents) (8.0 cents) (9.6 cents) (16 cents)))
(phys98b21 a (nil () () () () ()))
(phys98b22 a (nil () () () () ()))
(phys98b23 a (nil () () () () ()))
(phys98b24 c (num (500 J) (400 J) (300 J) (-100 J) (-300 J)))
(phys98b25 b (expr (* |m| (+ (+ (* |ci| (- 273 T1)) L) (* |cw| (- 373 T2))))
		   (* |m| (+ (+ (* |ci| (- 273 T1)) L) (* |cw| (- T2 273))))
		   (+ (* |ci| (- 273 T1)) (* |cw| (- T2 273)))
		   (+ (* |m| L) (* |cw| (- T2 T1)))
		   (+ (* |m| L) (* (/ (+ |cw| |ci|) 2) (- T2 T1))) ))
(phys98b26 b (num (0.25 m) (0.50 m) (0.75 m) (1.0 m) (2.0 m)))
(phys98b27 e (nil () () () () ()))
(phys98b28 d (num (0.6) (1.5) (2.0) (3.0) (3.6)))
(phys98b29 b (nil () () () () ()))
(phys98b30 d (nil () () () () ()))
(phys98b31 a (nil () () () () ()))
(phys98b32 b (num (0 Hz) (500 Hz) (667 Hz) (1000 Hz) (1333 Hz))) ;***counts/min
(phys98b33 d (nil () () () () ()))
(phys98b34 b (times (1/4) (1/2) (1) (2) (4)))
(phys98b35 a (nil () () () () ()))
(phys98b36 a (labels (A) (B) (C) (D) (E)))
(phys98b37 a (times (2) (1.414) (1) (0.707) (0.5))) ; *** 2p, sqrt(2)p, ...
(phys98b38 d (num (9 cm) (18 cm) (24 cm) (32 cm) (48 cm)))
(phys98b39 e (times (16) (4) (1) (1/4) (1/16)))     ; 16W etc.
(phys98b40 b (expr Zero
		   (* 1/2 (/ (* (* G M) |m|) R))
		   (* 1/4 (/ (* (* G M) |m|) R))
		   (* 1/2 (/ (* (* G M) |m|) (expt R 2)))
		   (/ (* (* G M) |m|) (expt R 2)) ))
(phys98b41 a (nil () () () () ()))
(phys98b42 e (nil () () () () ()))
(phys98b43 b (nil () () () () ()))
(phys98b44 c (nil () () () () ()))
(phys98b45 d (nil () () () () ()))
(phys98b46 a (num (0 J) (1e-22 J) (1e-5 J) (1e2 J) (1e20 J)))
(phys98b47 c (num (1e-2 m/s) (1e3 m/s) (1e6 m/s) (1e8 m/s) (1e15 m/s)))
(phys98b48 d (nil () () () () ()))
(phys98b49 c (nil () () () () ()))
(phys98b50 d (nil () () () () ()))
(phys98b51 d (num (0.07 m) (0.09 m) (0.16 m) (0.20 m) (0.24 m)))
(phys98b52 b (nil () () () () ()))
(phys98b53 c (nil () () () () ()))
(phys98b54 b (num (1e4) (1e14) (1e24) (1e34) (1e50)))
(phys98b55 b (nil () () () () ()))
(phys98b56 d (expr |omega|
		   (* (* 2 pi) |omega|)
		   (* (expt |omega| 2) A)
		   (/ (* 2 pi) |omega|)
		   (/ |omega| (* 2 pi)) ))
(phys98b57 c (num (1 (* N s)) (1.732 (* N s)) (2 (* N s)) (1.1547 (* N s))
		  (4 (* N s))))              ; *** sqrt(3) etc.
(phys98b58 c (expr (/ M 2) M (* 3/2 M) (* 2 M) (* 5/2 M) ))
(phys98b59 e (expr (sqrt (* |h| |v0|))
		   (/ |h| |v0|)
		   (/ (* |h| |v0|) |g|)
		   (/ (* 2 |h|) |g|)
		   (sqrt (/ (* 2 |h|) |g|)) ))
(phys98b60 d (expr (* (* |m| |g|) |h|)
		   (* (* 1/2 |m|) (expt |v0| 2))
		   (- (* (* 1/2 |m|) (expt |v0| 2)) (* (* |m| |g|) |h|))
		   (+ (* (* 1/2 |m|) (expt |v0| 2)) (* (* |m| |g|) |h|))
		   (- (* (* |m| |g|) |h|) (* (* 1/2 |m|) (expt |v0| 2))) ))
(phys98b61 d (nil () () () () ()))
(phys98b62 c (times (1/2) (1) (1.414) (2) (4)))   ; *** sqrt(2)
(phys98b63 c (nil () () () () ()))
(phys98b64 b (nil () () () () ()))
(phys98b65 d (times (1/4) (1/2) (1) (2) (4)))  ; *** R/4 etc.
(phys98b66 c (times (0) (1/2) (1) (2) (4)))    ; *** E/2 etc.
(phys98b67 d (nil () () () () ()))
(phys98b68 a (expr (* L (sin |theta|))
		   (* L (cos |theta|))
		   L
		   (* L (tan |theta|))
		   (* (sqrt 2) L) ))
(phys98b69 b (nil () () () () ()))
(phys98b70 e (num (2e-10 J) (2e-8 J) (2e-6 J) (2e-4 J) (2e-2 J)))

(prin01    d (nil () () () () ()))
(prin02    a (num (0.8 s) (1.0 s) (1.4 s) (2.0 s) (2.4 s)))
(prin03    d (num (4 N) (16 N) (20 N) (40 N) cant))
(prin04    e (terms (displacement) (velocity) (acceleration)
		    (linear momentum) (potential energy)))
(prin05    d (num (0.7 s) (1.4 s) (2.0 s) (2.8 s) (4.0 s)))
(prin06    c (num (8 m/s) (10 m/s) (14 m/s) (18 m/s) (20 m/s)))
(prin07    a (num (0 J) (2.0 J) (4.0 J) (4.9 J) (9.8 J)))
(prin08    b (expr (* |v1| (sqrt (/ |r2| |r1|)))
		   (* |v1| (sqrt (/ |r1| |r2|)))
		   (* |v1| (/ |r2| |r1|))
		   (* |v1| (expt (/ |r2| |r1|) 2))
		   (* |v1| (expt (/ |r1| |r2|) 2)) ))
(prin09    c (nil () () () () ()))
(prin10    a (num (0.4 s) (0.2 s) (8 s) (20 s) (50 s)))
(prin11    b (nil () () () () ()))
(prin12    b (num (17 eV) (42 eV) (64 eV) (255 eV) (302 eV)))
(prin13    a (nil () () () () ()))
(prin14    c (times (1/20) (1/10) (10) (20) (1)))   ; coded
(prin15    c (expr (* 0.5 |g|) (* 0.6 |g|) (* 0.7 |g|)
		   (* 0.8 |g|) (* 0.9 |g|) ))
(prin16    d (nil () () () () ()))
(prin17    e (num (3 %) (12 %) (30 %) (60 %) (70 %)))
(prin18    a (graphs (hyperb-decr) (lin-decr) (S-decr) (parab) (hyperb-incr)))
(prin19    d (num (0.49 cm) (0.98 cm) (3.2 cm) (4.9 cm) (9.8 cm)))
(prin20    e (num (1250 W) (2000 W) (4000 W) (10000 W) (20000 W)))
(prin21    c (terms (proton) (beta particle) (alpha particle) (electron)
		    (positron)))
(prin22    b (num (200 N) (400 N) (800 N) (1600 N) (3200 N)))
(prin23    e (num (0 m/s2) (2 m/s2) (4 m/s2) (8 m/s2) (10 m/s2)))
(prin24    a (num (25 %) (33 %) (50 %) (67 %) (79 %)))
(prin25    c (num (1/2) ((/ 1 (sqrt 2))) (2) ((* 2 (sqrt 2))) (4)))
(prin26    b (num (0.25 A) (0.5 A) (2 A) (4 A) (30 A)))
(prin27    a (num (150 J) (300 J) (560 J) (1000 J) (3000 J)))
(prin28    e (num ((sqrt 3/4)) ((sqrt 4/3)) (4/3) (9/16) (16/9)))
(prin29    a (num (26 degC) (41 degC) (58 degC) (77 degC) (94 degC)))
(prin30    c (combo (terms (frequency) (wavelength) (speed))
		    (and 1 2) (and 1 3) (and 3 2) (only 3) (only 2)))
(prin31    d (nterm ((clockwise) (decreasing))
		    ((clockwise) (increasing))
		    ((counterclockwise) (decreasing))
		    ((counterclockwise) (constant))
		    ((counterclockwise) (increasing))))
(prin32    a (expr (* |lambdap| (sqrt (/ |mp| |me|)))
		   (* |lambdap| (sqrt (/ |me| |mp|)))
		   (* |lambdap| (expt (/ |mp| |me|) 2))
		   (* |lambdap| (expt (/ |me| |mp|) 2))
		   |lambdap| ))
(prin33    d (expr (* (* (* 1/2 |m|) |g|) (sin |theta|))
		   (* (* |m| |g|) (sin |theta|))
		   (* (* (* 1/2 |m|) |g|) (cos |theta|))
		   (* (* 1/2 |m|) |g|)
		   (* |m| |g|) ))
(prin34    a (nil () () () () ()))
(prin35    c (nil () () () () ()))
(prin36    b (terms (electron) (proton) (deuteron) (positron)
		    (gamma-ray photon)))
(prin37    d (num (3/10 V) (10/3 V) (10 V) (30 V) (54 V)))
(prin38    e (nil () () () () ()))        ; ***** unusual form of times
(prin39    c (nil () () () () ()))
(prin40    d (nil () () () () ()))
(prin41    a (nil () () () () ()))
(prin42    a (expr (sqrt (/ (* G M) R))
		   (sqrt (/ (* G M) (* 2 R)))
		   (sqrt (/ (* 2 (* G M)) R))
		   (sqrt (/ (* (* (* 2 G) M) |m|) R))
		   (sqrt (/ (* (* G M) |m|) (* 2 R)))  ))
(prin43    c (num (5.0e5 m/s) (7.5e5 m/s) (1.5e6 m/s) (3.0e6 m/s) (6.0e6 m/s)))
(prin44    e (num (10 dB) (14 dB) (20 dB) (28 dB) (34 dB)))
(prin45    e (num (0) (9.0e4 N/C) (1.8e5 N/C) (3.6e5 N/C) (7.2e5 N/C)))
(prin46    c (nil () () () () ()))
(prin47    b (expr (/ (* (expt |a| 2) (sin (* 2 |beta|))) (* 2 |g|))
		   (/ (* (expt |a| 2) (expt (sin |beta|) 2)) (* 2 |g|))
		   (/ (* (expt |a| 2) (sin (* 2 |beta|))) |g|)
		   (/ (* (expt |a| 2) (expt (sin |beta|) 2)) |g|)
		   (/ (* (* |a| (sin |beta|)) (cos |beta|)) |g|)  ))
(prin48    a (nil () () () () ()))
(prin49    d (expr (sqrt (/ (* (* G |m|) M) R))
		   (sqrt (* (* (* G |m|) M) R))
		   (* |m| (sqrt (/ (* G M) R)))
		   (* |m| (sqrt (* (* G M) R)))
		   (* |m| (sqrt (/ (* G M) (expt R 2)))) ))
(prin50    e (nil () () () () ()))
(prin51    d (nil () () () () ()))
(prin52    d (num (50 cm) (100 cm) (150 cm) (200 cm) (300 cm)))
(prin53    b (times (1/16) (1/4) (1/2) (4) (16)))
(prin54    e (nil () () () () ()))
(prin55    b (num (0.005 C) (0.01 C) (0.02 C) (0.5 C) (0.1 C)))
(prin56    c (num (4 J) (6 J) (12 J) (36 J) cant))
(prin57    e (nil () () () () ()))
(prin58    c (num (9.8 N) (49 N) (98 N) (147 N) (196 N)))
(prin59    d (nil () () () () ()))
(prin60    c (num (4 m/s) (6 m/s) (8 m/s) (12 m/s) (27 m/s)))
(prin61    a (nil () () () () ()))
(prin62    e (nil () () () () ()))
(prin63    d (nil () () () () ()))
(prin64    d (nil () () () () ()))
(prin65    c (num (0.005 J) (0.01 J) (0.05 J) (0.1 J) (0.5 J)))
(prin66    d (nil () () () () ()))
(prin67    a (nil () () () () ()))
(prin68    e (terms (gamma rays) (ultraviolet) (blue light) (X-rays)
		    (orange light)))
(prin69    a (nil () () () () ()))
(prin70    c (nil () () () () ()))
))

; Causes of problems rated Yellow/Red: (name description problems)
(setq *yellow* '(
(qform   "Difficult posing of question"
	 (physap07 physap26 phys93b11 phys93b19 phys93b46 phys93b56 phys93b60
		   phys98b07 phys98b08 phys98b22 phys98b29 phys98b31
		   phys98b35 phys98b42 phys98b45 phys98b69 phys98b73
		   phys98b77 phys98b78 prin01 prin23 prin54 prin62 prin63
		   prin67 prin70 prin71 prin72 prin73 prin74 prin75))
(linked  "Linked situations with changing configuration"
	 (physap21 physap22 physap25 physap26 physap27 phys93b73 phys93b75
		   phys93b76 phys98b71 phys98b72 phys98b73 phys98b76
		   phys98b77 phys98b78 prin67 prin71 prin72 prin73 prin74
		   prin75 prin76))
(unusual "Unusual knowledge or facts required."
	 (phys93b14 phys93b46 phys93b56 phys93b60 phys93b74 phys98b04
		    phys98b10 phys98b45 phys98b73 prin59 prin62 prin63 prin67
		    prin71 prin72 prin73 prin74))
(spatial "Spatial reasoning, often with qualitative diagrams"
	 (phys98b22 phys98b31 phys98b42 phys98b45 phys98b49 phys98b58
		    phys98b68 phys98b72 phys98b73 phys98b76 phys98b77
		    phys98b78 prin33 prin63 prin67 prin71 prin73 prin74
		    prin75 prin76))
(lensray "Understanding lens/mirror ray diagrams" (physap17 phys98b50 prin73))
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
( "" ())
))
