; physprobs.lsp             Gordon S. Novak Jr.            ; 21 Nov 08

; Copyright (c) 2008 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.

; 01 Mar 04; 02 Mar 04; 15 Mar 04; 16 Mar 04; 18 Mar 04; 19 Mar 04; 22 Mar 04
; 23 Mar 04; 25 Mar 04; 26 Mar 04; 29 Mar 04; 30 Mar 04; 01 Apr 04; 02 Apr 04
; 05 Apr 04; 06 Apr 04; 07 Apr 04; 08 Apr 04; 09 Apr 04; 12 Apr 04; 13 Apr 04
; 15 Apr 04; 16 Apr 04; 19 Apr 04; 20 Apr 04; 22 Apr 04; 23 Apr 04; 08 Jun 04
; 20 Jan 05; 28 Feb 07; 03 Oct 07

(defvar *allprobs* nil)
(defvar *probcode* nil)
(defvar *probsents* nil)
(defvar *probsolutions* nil)

(defun defprobs (lst)
  (dolist (item lst)
    (set (car item) (cadr item))
    (pushnew (car item) *allprobs*) ) )

; 28 Feb 07
; Test all the problems
; (testprobs *probsents*)
(defun testprobs (lst &optional store)
  (let (res tmp)
    (dolist (prob lst)
      (print (car prob))
      (dolist (sent (cdr prob))
        (print sent) (terpri)
        (setq res (phys sent))
        (prin1 res)
        (if (and (setq tmp (assoc (car prob) *probsolutions*))
                 (not (ansequal res (cadr tmp))))
            (princ " *****"))
        (terpri)
        (if store (push (list (car prob) res) *probsolutions*)) ) ) ))

(defun ansequal (x y)
  (or (equal x y)
      (and (consp x) (consp y)
           (approx= (car x) (car y))
           (equal (cadr x) (cadr y)))
      (approx= x y)
      (and (consp y) (approx= x (car y)))
      (and (consp x) (approx= y (car x)))
      (and (consp x) (consp y) (cdr x) (cdr y)
           (numberp (car x)) (glunitp (cadr x))
           (numberp (car y)) (glunitp (cadr y))
           (approx= (glconvertunit (cons '* x) (cons '* y)) 1.0))
      (and (stringp x) (stringp y)
           (let ((xn (safe-read-from-string x))
                 (yn (safe-read-from-string y)))
             (and (numberp xn) (approx= xn yn)))) ) )

; 25 Apr 95; 14 Mar 01
(defun safe-read-from-string (str)
  (if (and (stringp str) (> (length str) 0))
      (read-from-string str nil 'read-error)))

(setq *probsents* '(
(physap01  (what is the time of a fall with height = 125 m))
(physap01b (what is the height of a fall with time = 5 sec))
(physap03  (what is the tangential force of an inclined plane with
            a r of 20 m and a y of 10 m and a mass of 2 kg))
(physap04  (what is the velocity of a fall with a height of 10 m))
(physap06  (what is the final velocity of a collide-and-stick with m1 = "M"
            and v1 = "v" and m2 = 2 * "M" and v2 = -1/2 * "v"))
(physap08  (how does the internal energy of an ideal gas change as pressure
            is doubled and temperature is constant))
(physap09  (what is the work of an ideal gas with change in volume of zero))
            ; *** (* pressure delta-vol) but pressure is unknown
(physap11  (what is the current in a resistor with resistance = 20 ohms and
            voltage = 12 volts))
(physap12  (what is the voltage of a resistor with resistance = 10 ohms and
            current = 3/5 AMPERE))
(physap13  (how does the pressure of a fluid flow change if area is halved
            and flow rate is constant and bogo-bernoulli is constant) )
(physap13b (how does the velocity of a fluid flow change if area is halved
            and flow rate is constant))
(physap16  (what is the speed of a light with index of refraction = 1.5
            and wavelength = 5.89E-7 m))
(physap18  (how does the speed of light vary if energy is halved))
(physap18b (how does the frequency of light vary if energy is halved))
(physap19  (how does the current of a photoelectric vary if intensity is
            doubled))
(physap19b (how does the kinetic energy of a photoelectric vary if
            wavelength is doubled))
(phys93b03 (what is the spring constant of a spring with mass 0.5 kg
            and stretch 0.075 m))
(phys93b05 (what is the gravity of a fall with time 1 sec and height 3 m))
(phys93b06 (how does the weight of a weight vary if mass is doubled))
(phys93b06b (how does the centripetal acceleration of a circular motion
            vary if mass is doubled))
(phys93b15 (what is the capacitance of parallel capacitors with c1 = 4 uf
	    and c2 = 2 uf))
(phys93b15b (what is the capacitance of series capacitors with c1 = 6 uf
            and c2 = 3 uf))
(phys93b15c (what is the capacitance of parallel capacitors with c1 = 2 uf
            and c2 = 5 uf))
(phys93b16 (what is the charge of a capacitor with capacitance = 5 uf and
            voltage = 100 volts))
(phys93b20 (what is the resistance of series resistors with r1 = 16 ohms and
            r2 = 20 ohms))
(phys93b20b (what is the resistance of series resistors with r1 = 36 ohms and
            r2 = 4 ohms))
(phys93b20c (what is the voltage of a resistor with current = 0.3 amp and
            resistance = 40 ohms))
(phys93b21 (what is the terminal voltage of a battery with a current of
            0.3 amp and internal resistance of 4 ohms and voltage of 12 volts))
(phys93b22 (what is the power of a resistor with current = 0.3 amp and
            resistance = 4 ohms))
(phys93b23 (what is the energy change of a thermodynamic system with
            heat = 275 joules and work done on it = 125 joules and
            work = 50 joules))
(phys93b24 (what is the t2f of a heat transfer with m1 = 1.5 kg and
            c1 = 200 joules per kg per degK and t1 = 373 kelvin and
	    m2 = 3 kg and c2 = 1000 joules per kg per degK
	    and t2 = 273 kelvin and t1f = 293 kelvin))  ; **** degree C
(phys93b25 (what is the rate of a heat transfer with m1 = 1.5 kg and
            c1 = 200 joules per kg per degK and t1 = 373 kelvin and
	    m2 = 3 kg and c2 = 1000 joules per kg per degK and t2 = 273 kelvin
	    and t1f = 293 kelvin and time = 5 seconds))  ; **** degree C
(phys93b27 (what is the speed of a wave with freq 5 hz and wavelength 2 m))
(phys93b28 (what is the fundamental frequency of a wave with freq 5 hz
            and wavelength 2 m))
(phys93b35 (what is the wavelength of light with energy = 1 ev))
(phys93b35b (what is the wavelength of light with energy = 6 ev))
(phys93b36 (what is the time of a radioactive decay with half life = 5 years
            and initial rate = 1 and final rate = 1/8))
(phys93b39 (what is the observed time of a relativity with time = 2e-6 sec
            and speed relative to light = 0.998))
(phys93b41 (how does the emf of a wire moving in a magnetic field vary
            as velocity is doubled))
(phys93b42 (how does the force of a gravitation vary with radius))
(phys93b42b (how does the force of an electric dipole vary with radius))
(phys93b44 (what is the power of a lift with mass = "m" and height = "h"
            and time = "t" and gravity = "g"))
(phys93b45 (what is the acceleration of a weight-pulley with m1 = 3 * "m"
            and m2 = "m" and gravity = "g"))
(phys93b48 (what is the gravity of a gravitation with m1 = 6.4e23 kg
            and radius = 3.4e6 m))
(phys93b48z (what is the gravity of a gravitation with m1 5.98e24 kg and
            radius 6.38e6 m))   ; earth, as a test
(phys93b50 (what is the resistance of series resistors with r1 = 1 ohm
            and r2 = 2 ohm))
(phys93b50b (what is the resistance of parallel resistors with r1 = 1 ohm and
            r2 = 2 ohm))
(phys93b50c (what is the power of a resistor with resistance = 3 ohm and
            voltage = 1 volt))
(phys93b50d (what is the power of a resistor with resistance = 2/3 ohm and
            voltage = 1 volt))
(phys93b52 (what is the frequency of a light with wavelength = 3 cm))
(phys93b53z (how does the velocity of a photoelectric vary if intensity
            is doubled))
(phys93b53zb (how does the velocity of a photoelectric vary if frequency
            is doubled))
(phys93b53zc (how does the velocity of a photoelectric vary if work-function
            is doubled))
(phys93b55 (what is the efficiency of a heat engine with heat = 100 joules
            and heat exhausted = 60 joules))
(phys93b58 (how does the doppler frequency of a sound vary if source speed
            is doubled and observer speed is constant))
(phys93b58b (how does the doppler frequency of a sound vary if observer speed
            is doubled and source speed is constant))
(phys93b61 (what is the mass of a weight with weight 20 nt))
(phys93b62 (what is the normal force of an inclined plane with weight = 20 nt
            and theta = 37 degrees))
(phys93b63 (what is the work of a lift with weight 20 nt and height 3 m))
(phys93b68 (how does the electric field of an electric dipole vary
            if radius is doubled))
(phys93b70 (how does the potential of a charged sphere vary if radius is
            doubled))
(phys98b02 (what is the power of a lift with weight 700 nt and height 8 m
            and time 10 sec))
(phys98b03 (what is the final velocity of a collide-and-stick with
            m1 = "m" and m2 = "M" and v1 = "v" and v2 = 0))
(phys98b06 (what is the angular momentum of a circular motion with radius 4 m
            and mass 2 kg and velocity 3 m/s))
(phys98b09 (what is the power of a friction-weight with mass = "m" and 
            speed = "v" and mu = "mu" and gravity = "g"))
(phys98b14 (how does the electric field of a capacitor vary if the voltage
            is doubled and the distance is 1/5 times its previous value))
(phys98b19 (what is the area of a rectangle with width = 8 cm and
            height = 5 cm))
(phys98b19b (what is the flux of a magnetic field with field = 2 tesla
            and area = 40 square-centimeter))
(phys98b20 (what is the cost of a resistor with voltage 120 volts and
            current 4 amps and time 2 hours and unit cost 10 cents per kwh))
(phys98b24 (what is the energy change of a thermodynamic system with
            heat = 400 joules and work = 100 joules))
(phys98b26 (what is the image distance of a concave mirror with radius = 1.0 m
            and subject distance = infinity m))
(phys98b27 (how does the speed of light vary if index of refraction is
            doubled))
(phys98b27b (how does the wavelength of light vary if index of refraction is
            doubled))
(phys98b28 (what is the magnification of a converging lens with
            subject distance = 6 cm and focal length = 9 cm))
(phys98b30 (what is the magnification of a converging lens with
            focal length = 1 and subject distance = 1.5))
(phys98b32 (what is the half-life of a radioactive decay with
            initial rate = 4000 and final rate = 2000 and time = 30 min))
(phys98b32b (what is the final rate of a radioactive decay with
            half-life = 30 min and initial rate = 4000 and time = 90 min))
(phys98b34 (how does the de Broglie wavelength of an elementary particle
            vary if its momentum is doubled))
(phys98b37 (how does the momentum of light vary if frequency is doubled))
(phys98b39 (how does the force of a gravitation vary if the radius
            is quadrupled))
(phys98b40 (what is the kinetic energy of a gravitation with m1 = "M" and
            m2 = "m" and radius = "R" and gravitation constant = "G"))
(phys98b43 (how does the momentum of a momentum vary if velocity is constant))
(phys98b47 (what is the velocity of a charged particle moving in a
            magnetic field with a field of 0.1 tesla and a radius of 0.1 m
            and a charge of 1.60e-19 coulomb and a mass of 1.67275e-27 kg))
(phys98b51 (what is the slit separation of a diffraction with radius = 5 m
            and distance from central maximum = 3 m and wavelength = 0.12 m))
(phys98b53 (how does the pressure of an ideal gas vary if temperature is
            doubled and volume is constant))
(phys98b53b (how does the density of an ideal gas vary if temperature is
            doubled and volume is constant and molar mass is constant))
(phys98b54 (what is the area of a circle with diameter = 1 mm))
(phys98b54b (what is the area of a circle with diameter = 1.0e-10 m))
(phys98b54c (what is the number of a conglomerate with container volume
            = 7.85E-7 square-meter and item volume = 7.85E-21 square-meter))
(phys98b55 (how does the current of a photoelectric vary if intensity is
            doubled))
(phys98b55b (how does the energy of a photoelectric vary if wavelength is
            doubled))
(phys98b56 (what is the period of a harmonic motion with
            angular speed = "omega"))
(phys98b57 (what is the impulse of a momentum with mass 0.4 kg
            and velocity 5.0 m/s))
(phys98b59 (what is the time of a fall with mass = "m" and height = "h"
            and horizontal velocity = "v0" and gravity = "g"))
(phys98b60 (what is the kinetic energy of a fall with mass = "m" and
            height = "h" and horizontal velocity = "v0" and gravity = "g"))
(phys98b62 (how does the average speed of an ideal gas vary if temperature
            is doubled and molar mass is constant))
(phys98b64 (how does the charge of a capacitor vary if the voltage is constant
            and the distance is doubled and area is constant))
(phys98b65 (how does the circumference of a circle vary if radius is doubled))
(phys98b65b (how does the resistance of a wire vary if length is doubled))
(phys98b70 (what is the energy of a capacitor with capacitance 4 uf
            and voltage 100 volts))
(prin02    (what is the height of a fall with time = 2 sec))
(prin02b   (what is the time of a fall with a height of 39.2266 meter))
(prin03    (what is the force of a circular motion with kinetic
            energy = 4 joule and radius = 0.2 m and mass = 1 kg))
(prin05    (what is the time of an inclined plane with mass = 0.5 kg and
            y = 10 m and theta = 30 degrees))
(prin06b   (what is the velocity of a fall with a height of 10 m))
(prin06    (what is the velocity of an inclined plane with mass = 0.5 kg and
            y = 10 m and theta = 30 degrees))
(prin08    (how does the satellite velocity of a gravitation vary with radius))
(prin09    (how does the capacitance of a capacitor vary if area is halved
            and distance is constant))
(prin09b   (how does the capacitance of a capacitor vary if dielectric constant
            is halved and area is constant and distance is constant))
(prin09c   (how does the capacitance of a capacitor vary if distance is halved
            and dielectric constant is constant and area is constant))
(prin09d   (how does the capacitance of a capacitor vary if voltage is halved
            and dielectric constant is constant and area is constant
            and distance is constant))
(prin10    (what is the period of a wave with a frequency of 2.5 hz))
(prin11    (how does the image distance of a concave mirror vary as
            subject distance is halved))
(prin11b   (how does the magnification of a concave mirror vary as
            subject distance is halved))
(prin13    (how does the internal energy of an ideal gas vary if temperature
            is constant))
(prin13b   (what is the heat of a thermodynamic system with work = -150 joules
            and energy change = 0))
(prin14    (how does the wavelength of a sound vary if speed is 10 times its
            previous value))
(prin14b   (what is the wavelength of a sound with speed = 350 m/s and
            frequency 700 hz))
(prin14c   (what is the wavelength of a sound with speed = 3500 m/s and
            frequency 700 hz))
(prin15    (what is the acceleration of a weight-pulley with m1 = "m"
            and m2 = 3 * "m" and mu = 0.2 and gravity = "g"))
(prin16    (what is the a1 of symmetric forces with m1 = 100 kg and m2 = 50 kg
            and force = "F"))
(prin16b   (what is the a2 of symmetric forces with m1 = 100 kg and m2 = 50 kg
            and force = "F"))
(prin17    (what is the proportion floating of a float with weight 6 nt
            and volume 2e-3 m3))
(prin18    (how does the force of an electric dipole vary as radius is
            doubled))
(prin19    (what is the stretch of a spring with spring constant 800 nt per m
            and mass = 4 kg))
(prin20    (what is the power of a lift with weight 5000 nt and speed 4 m/s))
(prin21    (how does the radius of a charged particle moving in a magnetic
            field vary if mass is quadrupled and charge is doubled))
(prin22    (how does the force of a gravitation vary if m1 is doubled and
            radius is doubled))
(prin23    (what is the force of an acceleration with mass = 5 kg and
            acceleration = 10 m/s2))
(prin24    (what is the maximum efficiency of a heat engine with heat source
            temperature = 400 kelvin and heat reservoir temperature =
            300 kelvin))
(prin25    (how does the harmonic frequency of a wave on a string vary
            if the harmonic number is doubled))
(prin26    (what is the current of a resistor with power = 60 watt
            and voltage = 120 volts))
(prin27    (what is the work of an electric dipole with q1 = 2 coulomb and
            q2 = 1.0e-9 coulomb and radius = 3 cm))
(prin27b   (what is the work of an electric dipole with q1 = 2 coulomb and
            q2 = 1.0e-9 coulomb and radius = 4 cm))
(prin28    (how does the electric field of an electric dipole vary if
            the radius is 3/4 times its previous value))
(prin29    (what is the equilibrium temperature of a heat transfer with
            m1 = 50 g and c1 = 900 joules per kg per degK and t1 = 423 kelvin
            and m2 = 200 g and c2 = 4700 joules per kg per degK and t2 = 293
            kelvin))
(prin30    (how does the speed of a light change if index of refraction is
            doubled))
(prin30b   (how does the frequency of a light change if index of refraction
            is doubled))
(prin30c   (how does the wavelength of a light change if index of refraction
            is doubled))
(prin31    (how does the current of a magnetic field change if the
            change in magnetic flux per unit time is constant))
(prin32    (how does the de broglie wavelength of an elementary particle
            vary with mass if kinetic energy is constant))
; (prin35z   (how does the distance from central maximum of a diffraction vary
;             if wavelength is halved and radius is constant))   ; *** /0
(prin38    (what is the power of a resistor with resistance = 3 ohms and
            current = 3 amps))
(prin38b   (what is the power of a resistor with resistance = 3 ohms and
            current = 1 amp))
(prin39    (what is the doppler frequency of a sound with frequency = 1000 hz
            and source speed = 10 meters per second and observer speed = 0 m/s))
(prin39b   (what is the doppler frequency of a sound with frequency = 1000 hz
            and source speed = 10 meters per second and
            observer speed = -10 m/s))
(prin44    (what is the power of a sound with radius = 20 m and decibel = 40))
(prin44b   (what is the decibel of a sound with radius = 40 and power = 
            5.0265482457436693E-5 WATT))
(prin45    (what is the electric field of an electric dipole with
            q1 = 4.0e-9 coulomb and radius = 1 cm))
(prin47    (what is the height of a projectile with initial velocity = "a"
            and angle = "beta" and gravity = "g"))
(prin49    (what is the angular momentum of a gravitation with m1 = "M"
            and m2 = "m" and radius = "R" and gravitation constant = "G"))
(prin51    (what is the force per unit length of a wire-magnetic with
            current = "I" and radius = "a"))
(prin53    (how does the pressure of an ideal gas vary if temperature is
            doubled and volume is 8 times its previous value))
(prin55    (what is the charge of a capacitor with capacitance = 2000 uf
            and voltage 5 volts))
(prin56    (what is the work of a work-energy with mass = 2 kg and v1 = 2 m/s
            and v2 = 4 m/s and time = 3 sec))   ; time irrelevant
(prin58    (what is the force of a lift with weight = 49 nt and
            acceleration = 9.8 m/s2))
(prin60    (what is the second velocity of a fluid flow with diameter = 2 cm
            and velocity = 18 m/s and second diameter = 3 cm))
(prin61    (what is the image height of a converging lens with radius = 20 cm
            and subject distance = 30 cm and subject height = 2 cm))
(prin64    (what is the energy of a nuclear reaction with initial mass = 
            9.028 amu and final mass = 9.012 amu))
(prin65    (what is the energy of a capacitor with capacitance = 10 uf
            and voltage = 100 volts))
(z101      (what is the flow rate of a fluid flow with radius = 1 m
            and speed = 2 m/s))
; biology
(bio1a     (what is the frequency of the heterozygous genotype in a population
            with a frequency of the homozygous recessive genotype of 0.2))
(bio1b     (what is the frequency of the homozygous dominant genotype
            in a population with a frequency of the homozygous recessive
            genotype of 0.2))
(bio1c     (what is the frequency of the homozygous recessive genotype
            in a population with a frequency of the homozygous dominant
            genotype of 0.3))
; chemistry
; (chem1     (Calculate the pH of a solution made by combining
; 	    40.0 milliliters of 0.14 molar HOCl and
; 	    10.0 milliliters of 0.56 molar NaOH))
(chem2     (what is the initial amount of a radioactive decay with
            half-life = 2 hours and time = 12 hours and final amount = 1 mg))
))

(defprobs *probsents*)

(setq *probcode* '(
(phys98b05 (glstandardunit 'power)
	   (glconvertunit 'watt 'watt)
	   (glconvertunit '(/ joule second) 'watt)
	   (glconvertunit 'kilowatt-hour 'watt))
(phys93b34 (energybands '(-1 -2 -4 -7)) )
(phys93b51 (glconvertunit '(* (* 2 amperes) (* 2 volts) (* 2 seconds))
			  '(* 8 joules)) )
(prin12    (energybands '(-21 -38 -85 -340)) )
(prin16    (gleqns-simplify '(/ (* -1/50 VAR-F) (* 1/100 VAR-F))) )
(prin40    (glstandardunit 'power)
	   (glconvertunit 'watt '(/ (* kg m m) (* sec sec sec))) )
))
