; plot.lsp    translated from cs307/asg/asg08.scm           ; 03 Feb 10

; Copyright (c) 2010 Gordon S. Novak Jr. and The University of Texas at Austin

; 07 Oct 09

; Plotting

; (plot-with-axes myw #'sin -6.28 6.28 -1 1)
; (plot-with-axes myw #'tan 0 12 -10 10)
; (plot-with-axes myw #'f3 0 5 -1 1)
; (plot-with-axes myw #'f4 0 12 -2 2)

(defvar *plotxmin*)
(defvar *plotxmax*)
(defvar *plotymin*)
(defvar *plotymax*)

(setq *plotxmin* 40)
(setq *plotxmax* 400)
(setq *plotymin* 30)
(setq *plotymax* 400)

; scale from domain d to range r using a list (m b): r = m * d + b
(defun scale (d mblist) (+ (* (car mblist) d) (cadr mblist)))

; scale from range r to domain d using a list (m b): r = m * d + b
(defun invscale (r mblist) (/ (- r (cadr mblist)) (car mblist)))

; find an mblist to scale from d to r
(defun findmblist (dmin dmax rmin rmax)
  (let ((m (/ (- rmax rmin) (- dmax dmin))))
    (list m (- rmin (* m dmin)))))

; set up the plot region
(defun plotregion (plotxmin plotxmax plotymin plotymax)
  (setq *plotxmin* plotxmin)
  (setq *plotxmax* plotxmax)
  (setq *plotymin* plotymin)
  (setq *plotymax* plotymax))

; Plot a function (f x).
(defun plotfn (w f xmin xmax ymin ymax)
  (let* ((xmb (findmblist xmin xmax *plotxmin* *plotxmax*))
         (ymb (findmblist ymin ymax *plotymin* *plotymax*))
         (dx (/ 2 (car xmb))) (x xmin) xnew ynew xlast ylast)
    (while (<= x xmax)
      (setq xnew (scale x xmb))
      (setq ynew (scale (funcall f x) ymb))
      (if (/= x xmin)
          (window-draw-line-xy w xlast ylast xnew ynew) )
      (setq xlast xnew)
      (setq ylast ynew)
      (setq x (+ x dx)) ) ))

(defun f3 (x) (* (sin (* 8 x)) (exp (- x))))
(defun f4 (x) (- (sin (* 20 x)) (sin (* 19 x))))

(defun ordermag (v) (floor (log10 v)))

; Calculate cross-mark positions.  Returns (firstmark stepsize).
(defun steps (vmin vmax)
  (let* ((range (- vmax vmin)) (omag (ordermag range))
         (stepsize (expt 10 omag))
         (eststeps (truncate (/ range stepsize))))
    (if (< eststeps 1)
        (progn
          (setq stepsize (/ stepsize 10))
          (setq eststeps (truncate (/ range stepsize)))))
    (if (< eststeps 2) (setq stepsize (/ stepsize 5))
        (if (< eststeps 4) (setq stepsize (/ stepsize 2))
            (if (> eststeps 8) (setq stepsize (* stepsize 2)))))
    (if (< stepsize 1.0) (setq stepsize (* stepsize 1.0)))   ; float
    (list (* stepsize (truncate (/ vmin stepsize)))  ; position of 1st mark
          stepsize)))

; Draw an axis from xmin to xmax.
(defun xaxis (w xmin xmax ymin ymax)
  (let* ((steps (steps xmin xmax)) (stepsize (cadr steps)) str
         (x (car steps)) (y *plotymin*)
         (xmb (findmblist xmin xmax *plotxmin* *plotxmax*))
         (ymb (findmblist ymin ymax *plotymin* *plotymax*)))
    (if (and (>= 0 ymin) (<= 0 ymax)) (setq y (scale 0 ymb)))
    (window-draw-line-xy w *plotxmin* y *plotxmax* y)
    (while (<= x xmax)
      (window-draw-line-xy w (scale x xmb) (+ y 8) (scale x xmb) (- y 8))
      (setq str (plotstring x stepsize))
      (window-printat-xy w str (+ (scale x xmb) (* -4 (length str)))
                         (- y 20))
      (setq x (+ x stepsize)) ) ))

(defun yaxis (w xmin xmax ymin ymax)
  (let* ((steps (steps ymin ymax)) (stepsize (cadr steps))
         (y (car steps)) (x *plotxmin*)
         (xmb (findmblist xmin xmax *plotxmin* *plotxmax*))
         (ymb (findmblist ymin ymax *plotymin* *plotymax*)))
    (if (and (>= 0 xmin) (<= 0 xmax)) (setq x (scale 0 xmb)))
    (window-draw-line-xy w x *plotymin* x *plotymax*)
    (while (<= y ymax)
      (window-draw-line-xy w (+ x 8) (scale y ymb) (- x 8) (scale y ymb))
      (window-printat-xy w (plotstring y stepsize)
                         (- x 30) (- (scale y ymb) 4))
      (setq y (+ y stepsize)) ) ))

(defun plotstring (x stepsize)
  (if (integerp x)
      (princ-to-string x)
      (format nil "~4F" 
              (if (< (abs x) (/ stepsize 1000))
                  0.0
                  (* x 1.00001))) ) )

(defun plot-with-axes (w f xmin xmax ymin ymax)
  (window-reset-geometry w)
  (window-clear w)
  (plotfn w f xmin xmax ymin ymax)
  (xaxis w xmin xmax ymin ymax)
  (yaxis w xmin xmax ymin ymax)
  (window-force-output w) )

(defun plot-geometry (w)
  (let (geom)
    (window-reset-geometry w)
    (setq geom (window-geometry w))  ; (x y width height border-width)
    (setq *plotxmax* (- (third geom) 30))
    (setq *plotymax* (- (fourth geom) 30)) ))

; 07 Oct 09
; Automatically scale and plot a set of data (list or array)
; xfn, yfn are access functions for x and y
; dx is step in x if xfn is unspecified
(defun plot (w data &optional xfn yfn dx)
  (let (xmin xmax ymin ymax xnew xlast ynew ylast item done ptr
             (n 0) xmb ymb i x)
    (plot-geometry w)
    (window-clear w)
    (or yfn (setq yfn #'identity))
    (setq item (if (consp data) (car data) (aref data 0)))
    (setq xmin (if xfn (funcall xfn item) 0))
    (setq xmax (if xfn
                   (funcall xfn item)
                   (* (or dx 1)
                      (if (consp data)
                          (length data)
                          (array-dimension data 0)) ) ) )
    (setq ymin (funcall yfn item))
    (setq ymax ymin)
    (setq ptr data)
    (while (not done)
      (setq item (if (consp data) (car ptr) (aref data n)))
      (when xfn
        (setq xnew (funcall xfn item))
        (setq xmin (min xmin xnew))
        (setq xmax (max xmax xnew)) )
      (setq ynew (funcall yfn item))
      (setq ymin (min ymin ynew))
      (setq ymax (max ymax ynew))
      (incf n)
      (if (consp data)
          (if (null (setq ptr (cdr ptr))) (setq done t))
          (if (>= n (array-dimension data 0)) (setq done t))) )
    (xaxis w xmin xmax ymin ymax)
    (yaxis w xmin xmax ymin ymax)
    (setq xmb (findmblist xmin xmax *plotxmin* *plotxmax*))
    (setq ymb (findmblist ymin ymax *plotymin* *plotymax*))
    (setq ptr data)
    (setq done nil)
    (setq i 0)
    (while (not done)
      (setq item (if (consp data) (car ptr) (aref data n)))
      (setq x (if xfn
                  (funcall xfn item)
                  (* (or dx 1) i)))
      (setq xnew (scale x xmb))
      (setq ynew (scale (funcall yfn item) ymb))
      (if xlast
          (window-draw-line-xy w xlast ylast xnew ynew) )
      (setq xlast xnew)
      (setq ylast ynew)
      (incf i)
      (if (consp data)
          (if (null (setq ptr (cdr ptr))) (setq done t))
          (if (>= n (array-dimension data 0)) (setq done t))) )
    (window-force-output w)
    ))
