; radar.lsp             Gordon S. Novak Jr.            ; 03 Jan 2000

; Copyright (c) 2007 Gordon S. Novak Jr. andThe University of Texas at Austin.
; All rights reserved.

; 07 May 93; 05 Jan 95; 21 Mar 97; 18 Feb 99

(glispobjects

(utm-vector (list (north (units real meter))
		  (east  (units real meter)))
  prop  ((x (east)) (y (north)))
  supers (vector))

(utm-cvector (crecord cutm (north (units real meter))
		           (east  (units real meter)))
  prop  ((x (east)) (y (north)))
  supers (vector))
) ; glispobjects


; Example using VIP:
(defvar radar)
(setq radar '((time-diff         (units integer (* 100 nanosecond)))
	      (aircraft-altitude (units integer (* 10 foot)))
	      (radar-altitude    (units integer (* 10 foot)))
	      (radar-angle       (units integer (/ (* 2 pi radians) 4096)))
	      (radar-utm         utm-vector) ) )

; (vip radar nil 'tq)
; time-diff         = 90 microseconds
; aircraft-altitude = 8000 ft
; radar-altitude    = 5000 ft
; radar-angle       = 30 degrees (1/12 circle)
; radar-utm         = (300000.0 400000.0) in meters
; (tq 900 800 500 (truncate 4096 12) '(300000.0 400000.0)) ; = (306723. 411659.)

; (vip radarc '((output utm-cvector)) 'tqc)
; (gltolang 'tqc 'c)
(defvar radarc)
(setq radarc '((time-diff         (units integer (* 100 nanosecond)))
	       (aircraft-altitude (units integer (* 10 foot)))
	       (radar-altitude    (units integer (* 10 foot)))
	       (radar-angle       (units integer (/ (* 2 pi radians) 4096)))
	       (radar-utm         utm-cvector) ) )

; Cannonball problem:
; "A cannonball is fired with velocity v at elevation theta.
;  How far away does it hit the ground?"
; (vip '((velocity (units real (/ m sec))) (theta (units real degrees))) 'cb)
; (cb 500 30)  ; = 22069.964418561161

; Second Cannonball problem:  (not working yet)
; "A cannonball is fired with velocity v at a target d meters away.
;  At what elevation theta should it be fired?"
; (vip '((velocity (units real (/ m sec))) (dist (units real m))) 'cbb)

; car-truck problem cf. Larkin
; (vip '((vel (units real (/ m sec))) (acc (units real (/ m (* sec sec))))))
