; train.lsp                  Gordon S. Novak Jr.       ; 03 Jan 2000

; Copyright (c) 2007 The University of Texas at Austin.  All rights reserved.

; 03 Nov 92; 05 Jan 95

; Example: calculate position of piston on steam train engine

(setq train-inp '((piston-height real)
		  (pushrod-length real)
		  (crank-length real)
		  (wheel-radius real)
		  (crank-radius real)
		  (theta real)))

(setq *vip-save-sources*
      '((PISTON-HEIGHT REAL) (PUSHROD-LENGTH REAL) (CRANK-LENGTH REAL)
	(WHEEL-RADIUS REAL) (CRANK-RADIUS REAL) (THETA REAL)) )

(setq *vip-save-boxes*
'((PISTON-HEIGHT VARIABLE INPUT REAL
     ((PISTON-HEIGHT PISTON-HEIGHT REAL)) (NIL NIL NIL NIL NIL NIL))
 (PUSHROD-LENGTH VARIABLE INPUT REAL
     ((PUSHROD-LENGTH PUSHROD-LENGTH REAL)) (NIL NIL NIL NIL NIL NIL))
 (CRANK-LENGTH VARIABLE INPUT REAL ((CRANK-LENGTH CRANK-LENGTH REAL))
     (NIL NIL NIL NIL NIL NIL))
 (WHEEL-RADIUS VARIABLE INPUT REAL ((WHEEL-RADIUS WHEEL-RADIUS REAL))
     (NIL NIL NIL NIL NIL NIL))
 (CRANK-RADIUS VARIABLE INPUT REAL ((CRANK-RADIUS CRANK-RADIUS REAL))
     (NIL NIL NIL NIL NIL NIL))
 (THETA VARIABLE INPUT REAL ((THETA THETA REAL))
        (NIL NIL NIL NIL NIL NIL))
 (OUTPUT VARIABLE OUTPUT NIL NIL (NIL NIL NIL NIL NIL NIL))
 (LINE-SEGMENT1 LAW LINE-SEGMENT NIL NIL (NIL NIL NIL NIL NIL NIL))
 (CONSTANT18 CONSTANT NIL INTEGER ((CONSTANT 0 INTEGER))
     (NIL NIL NIL NIL NIL NIL))
 (LINE-SEGMENT2 LAW LINE-SEGMENT NIL NIL (NIL NIL NIL NIL NIL NIL))
 (LINE-SEGMENT3 LAW LINE-SEGMENT NIL NIL (NIL NIL NIL NIL NIL NIL))) )

(setq *vip-save-conns*
'(((P1X LINE-SEGMENT3) (OUTPUT OUTPUT))
 ((LENGTH LINE-SEGMENT3) (PUSHROD-LENGTH PUSHROD-LENGTH))
 ((LENGTH LINE-SEGMENT2) (CRANK-LENGTH CRANK-LENGTH))
 ((P2Y LINE-SEGMENT3) (PISTON-HEIGHT PISTON-HEIGHT))
 ((P1Y LINE-SEGMENT3) (PISTON-HEIGHT PISTON-HEIGHT))
 ((P1 LINE-SEGMENT2) (P2 LINE-SEGMENT3))
 ((P2 LINE-SEGMENT1) (P2 LINE-SEGMENT2))
 ((THETA LINE-SEGMENT1) (THETA THETA))
 ((LENGTH LINE-SEGMENT1) (CRANK-RADIUS CRANK-RADIUS))
 ((P1Y LINE-SEGMENT1) (WHEEL-RADIUS WHEEL-RADIUS))
 ((P1X LINE-SEGMENT1) (CONSTANT CONSTANT18))) )
