; typecon.lsp            Gordon S. Novak Jr.              ; 03 Jan 2000

; Copyright (c) 2007 Gordon S. Novak Jr. and The University of Texas at Austin.
; All rights reserved.



; 16 Jul 90; 05 Jan 95; 02 Jan 97

; 09 Jul 90; 16 Jul 90
; Make a data structure description for a list of items
(defun glmakeds (lst &optional symbolflg objectflg)
  (if lst
      (if objectflg
	  (cons (if symbolflg 'atomobject 'listobject) lst)
	  (if (cdr lst)
	      (if (cddr lst)
		  (if symbolflg
		      (list 'symbol (cons 'proplist lst))
		      (cons 'list lst))
		  (cons 'cons lst))
	      (cons 'list lst))) ))         ; was (car lst))) ) )

; 09 Jul 90
; Get the cluster of cl, which may be either a cluster or a type from one
(defun glclusterof (cl)
  (if cl (if (glclusterdef cl)
	     cl
	     (glclusterof (glcluster cl)))) )

; 09 Jul 90
; Get the specified role type from the cluster specified by cl.
(defun glclrole (cl role-name)
  (glclusterrole (glclusterof cl) role-name) )

; 12 Jul 90
(defun glsubclusterp (subcl cl)
  (and cl
       (or (member cl (getf (glclusterdef subcl) 'supers))
	   (some #'(lambda (x) (glsubclusterp x cl))
		 (getf (glclusterdef subcl) 'supers)) )) )

; 12 Jul 90
(defun glclusterp (cl) (if (glclusterdef cl) t) )
